package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.RewardLeaveApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveApplyDetailVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QRewardLeaveApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.entity.RewardLeaveApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.repo.RewardLeaveApplyDetailRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

@Repository
@RequiredArgsConstructor
public class RewardLeaveApplyDetailDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final RewardLeaveApplyDetailRepo repo;
    private final QRewardLeaveApplyDetailDO qdo = QRewardLeaveApplyDetailDO.rewardLeaveApplyDetailDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<RewardLeaveApplyDetailVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(RewardLeaveApplyDetailVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 申请单id
                qdo.applyId,
                // 资源userId
                qdo.userId,
                // 职级
                qdo.jobGrade,
                // 资源组织Id
                qdo.orgId,
                // 工作日期
                qdo.workDate,
                // 工作类型
                qdo.workType,
                // 奖励假天数
                qdo.days,
                // 理论当量
                qdo.eqva,
                // 已申请天数
                qdo.appliedDays
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<RewardLeaveApplyDetailVO> getJpaQueryWhere(RewardLeaveApplyDetailQuery query) {
        JPAQuery<RewardLeaveApplyDetailVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(RewardLeaveApplyDetailQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(RewardLeaveApplyDetailQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 申请单id 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyId())) {
            list.add(qdo.applyId.eq(query.getApplyId()));
        }
        /** 资源userId 精确 */
        if (!ObjectUtils.isEmpty(query.getUserId())) {
            list.add(qdo.userId.eq(query.getUserId()));
        }
        /** 职级 精确 */
        if (!ObjectUtils.isEmpty(query.getJobGrade())) {
            list.add(qdo.jobGrade.eq(query.getJobGrade()));
        }
        /** 资源组织Id 精确 */
        if (!ObjectUtils.isEmpty(query.getOrgId())) {
            list.add(qdo.orgId.eq(query.getOrgId()));
        }
        /** 工作日期 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkDate())) {
            list.add(qdo.workDate.eq(query.getWorkDate()));
        }
        /** 工作类型 精确 */
        if (!ObjectUtils.isEmpty(query.getWorkType())) {
            list.add(qdo.workType.eq(query.getWorkType()));
        }
        /** 奖励假天数 精确 */
        if (!ObjectUtils.isEmpty(query.getDays())) {
            list.add(qdo.days.eq(query.getDays()));
        }
        /** 理论当量 精确 */
        if (!ObjectUtils.isEmpty(query.getEqva())) {
            list.add(qdo.eqva.eq(query.getEqva()));
        }
        /** 已申请天数 精确 */
        if (!ObjectUtils.isEmpty(query.getAppliedDays())) {
            list.add(qdo.appliedDays.eq(query.getAppliedDays()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public RewardLeaveApplyDetailVO queryByKey(Long id) {
        JPAQuery<RewardLeaveApplyDetailVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<RewardLeaveApplyDetailVO> queryListDynamic(RewardLeaveApplyDetailQuery query) {
        JPAQuery<RewardLeaveApplyDetailVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<RewardLeaveApplyDetailVO> queryPaging(RewardLeaveApplyDetailQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<RewardLeaveApplyDetailVO> jpaQuery = getJpaQueryWhere(query);
        List<RewardLeaveApplyDetailVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<RewardLeaveApplyDetailVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public RewardLeaveApplyDetailDO save(RewardLeaveApplyDetailDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<RewardLeaveApplyDetailDO> saveAll(List<RewardLeaveApplyDetailDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(RewardLeaveApplyDetailPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 申请单id
        if (payload.getApplyId() != null) {
            update.set(qdo.applyId, payload.getApplyId());
        }
        // 资源userId
        if (payload.getUserId() != null) {
            update.set(qdo.userId, payload.getUserId());
        }
        // 职级
        if (payload.getJobGrade() != null) {
            update.set(qdo.jobGrade, payload.getJobGrade());
        }
        // 资源组织Id
        if (payload.getOrgId() != null) {
            update.set(qdo.orgId, payload.getOrgId());
        }
        // 工作日期
        if (payload.getWorkDate() != null) {
            update.set(qdo.workDate, payload.getWorkDate());
        }
        // 工作类型
        if (payload.getWorkType() != null) {
            update.set(qdo.workType, payload.getWorkType());
        }
        // 奖励假天数
        if (payload.getDays() != null) {
            update.set(qdo.days, payload.getDays());
        }
        // 理论当量
        if (payload.getEqva() != null) {
            update.set(qdo.eqva, payload.getEqva());
        }
        // 已申请天数
        if (payload.getAppliedDays() != null) {
            update.set(qdo.appliedDays, payload.getAppliedDays());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 申请单id
            if (nullFields.contains("applyId")) {
                update.setNull(qdo.applyId);
            }
            // 资源userId
            if (nullFields.contains("userId")) {
                update.setNull(qdo.userId);
            }
            // 职级
            if (nullFields.contains("jobGrade")) {
                update.setNull(qdo.jobGrade);
            }
            // 资源组织Id
            if (nullFields.contains("orgId")) {
                update.setNull(qdo.orgId);
            }
            // 工作日期
            if (nullFields.contains("workDate")) {
                update.setNull(qdo.workDate);
            }
            // 工作类型
            if (nullFields.contains("workType")) {
                update.setNull(qdo.workType);
            }
            // 奖励假天数
            if (nullFields.contains("days")) {
                update.setNull(qdo.days);
            }
            // 理论当量
            if (nullFields.contains("eqva")) {
                update.setNull(qdo.eqva);
            }
            // 已申请天数
            if (nullFields.contains("appliedDays")) {
                update.setNull(qdo.appliedDays);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }
    
}

