package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 项目成员
 *
 * @author duh
 * @date 2022-12-16
 */
@Entity
@Table(name = "t_proj_sh", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_proj_sh", comment = "项目成员")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ProjShDO extends BaseModel {

    /**
     * 4.0项目成员id
     */
    @Comment("4.0项目成员id")
    @Column()
    private Long projShIdV4;

    /**
     * 项目id
     */
    @Comment("项目id")
    @Column()
    private Long projId;
    /**
     * 项目id v5
     */
    @Comment("项目id v5")
    @Column()
    private Long projIdV5;
    /**
     * 角色
     */
    @Comment("角色")
    @Column()
    private String role;
    /**
     * 复合能力id
     */
    @Comment("复合能力id")
    @Column()
    private Long capasetLevelId;
    /**
     * 资源id
     */
    @Comment("资源id")
    @Column()
    private Long resId;
    /**
     * 用户id v5
     */
    @Comment("用户id v5")
    @Column()
    private Long userId;
    /**
     * 预计开始日期
     */
    @Comment("预计开始日期")
    @Column()
    private LocalDate planStartDate;
    /**
     * 预计结束日期
     */
    @Comment("预计结束日期")
    @Column()
    private LocalDate planEndDate;
    /**
     * 规划当量
     */
    @Comment("规划当量")
    @Column()
    private BigDecimal planEqva;
    /**
     * 工作台默认显示
     */
    @Comment("工作台默认显示")
    @Column()
    private Integer workbenchFlag;
    /**
     * 客户结算价
     */
    @Comment("客户结算价")
    @Column()
    private BigDecimal customerPrice;

    public void copy(ProjShDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
