package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name = "t_attendance_rule", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_attendance_rule", comment = "打卡规则表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TAttendanceRuleDO extends BaseModel {

    @Comment("规则名称")
    @Column()
    private String ruleName;

    @Comment("规则描述")
    @Column()
    private String ruleDesc;

    @Comment("汇报对象")
    @Column()
    private String reportToRes;

    @Comment("规则类型 UDC（COM:ATTENDANCE_RULE_TYPE）")
    @Column()
    private String ruleType;

    @Comment("规则状态，预留")
    @Column()
    private String ruleStatus;

    @Comment("超出范围外打卡方式，UDC（COM:ATTENDANCE_OUT_RANGE_RULE）")
    @Column()
    private String outRangeRuleWay;

    @Comment("员工打卡时是否必须拍照，UDC（YESNO）")
    @Column()
    private String needPhotoAttendance;

    @Comment("员工异常打卡时可提交申请，审批通过后修正异常，每月最多补卡，UDC（COM:ATTENDANCE_PATCH_APPLY_LIMIT_COUNT）")
    @Column()
    private Integer attendancePatchApplyLimitCount;

    @Comment("规则生效时间，UDC（COM: ATTENDANCE_RULE_EFFECTIVE_TIME ）")
    @Column()
    private String ruleEffectiveTime;

    @Comment("强制打卡")
    @Column()
    private String forceAttendance;

    public void copy(TAttendanceRuleDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
