package com.elitesland.tw.tw5.server.prd.my.repo;

import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetBiweeklyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetBiweeklyReadFlagDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2023/3/20 - 16:40
 */
@Transactional
public interface TimesheetBiweeklyReadFlagRepo extends JpaRepository<TimesheetBiweeklyReadFlagDO, Long>, JpaSpecificationExecutor<TimesheetBiweeklyReadFlagDO> {
    @Query("update TimesheetBiweeklyReadFlagDO set readFlag=?2 where userId=?1")
    @Modifying
    void updateReadFlag(Long tsUserId,Integer readFlag);

    @Query("update TimesheetBiweeklyReadFlagDO set readFlag=?2 where id=?1")
    @Modifying
    void updateReadFlagById(Long id,Integer readFlag);


    TimesheetBiweeklyReadFlagDO findByUserIdAndReadUserId(Long userId,Long readUserId);
}
