package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.core.bean.BeanUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetBiweeklyQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetPlanQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetPlanService;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjectAndTaskVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetPlanVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.service.TaskPackageService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetPlanConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.QTimesheetPlanDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetPlanDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetBiweeklyReadFlagRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetBiweeklyRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetPlanRepo;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * 工时-工作计划
 *
 * @author duwh
 * @date 2022-12-09
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsTimesheetPlanServiceImpl implements PmsTimesheetPlanService {

    private final TimesheetPlanRepo timesheetPlanRepo;
    private final PmsProjectService pmsProjectService;
    private final TaskPackageService taskPackageService;
    private final TaskInfoService taskInfoService;
    private final PmsProjectActivityService pmsProjectActivityService;
    private final JPAQueryFactory jpaQueryFactory;
    private final TimesheetBiweeklyRepo timesheetBiweeklyRepo;
    private final TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo;


    @Override
    public PagingVO<TimesheetPlanVO> paging(TimesheetPlanQuery query) {
        Page<TimesheetPlanDO> page = timesheetPlanRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(TimesheetPlanConvert.INSTANCE::toVo));
    }

    @Override
    public List<TimesheetPlanVO> queryList(TimesheetPlanQuery query) {
        return TimesheetPlanConvert.INSTANCE.toVoList(timesheetPlanRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    private List<TimesheetPlanDO> queryDoList(TimesheetPlanQuery query) {
        return timesheetPlanRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
    }

    @Override
    public TimesheetPlanVO queryByKey(Long key) {
        TimesheetPlanDO entity = timesheetPlanRepo.findById(key).orElseGet(TimesheetPlanDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TimesheetPlanVO vo = TimesheetPlanConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TimesheetPlanVO insert(TimesheetPlanPayload payload) {
        // 设置填写人为当前登录人
        payload.setTsUserId(GlobalUtil.getLoginUserId());
        // 参数校验
        check(payload);
        // 数据处理
        dataProcess(payload);
        // 更新本周及上周周报读取状态
        // LocalDate workDate = payload.getWorkDate();
        // int yearWeek = Integer.parseInt(DateUtil.getYearWeek(workDate));
        // int lastYearWeek = Integer.parseInt(DateUtil.getYearWeek(workDate.minusWeeks(1)));
        biweeklyReadFlagRepo.updateReadFlag(payload.getTsUserId(), 0);
        TimesheetPlanDO entityDo = TimesheetPlanConvert.INSTANCE.toDo(payload);
        return TimesheetPlanConvert.INSTANCE.toVo(timesheetPlanRepo.save(entityDo));
    }

    /**
     * 参数校验
     *
     * @param payload 有效载荷
     */
    private void check(TimesheetPlanPayload payload) {
//        final int yearWeek = Integer.parseInt(DateUtil.getYearWeek(payload.getWorkDate()));
//        final int lastyearWeek = Integer.parseInt(DateUtil.getYearWeek(payload.getWorkDate().minusWeeks(1)));
//        // 校验已提交周报的 不允许再编辑新增
//        TimesheetBiweeklyQuery timesheetBiweeklyQuery = new TimesheetBiweeklyQuery();
//        timesheetBiweeklyQuery.setYearWeekIn(Arrays.asList(yearWeek,lastyearWeek));
//        timesheetBiweeklyQuery.setTsUserId(GlobalUtil.getLoginUserId());
//        final Long count = timesheetBiweeklyRepo
//                .count((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, timesheetBiweeklyQuery, criteriaBuilder));
//        if (count > 0) {
//            throw TwException.error("", "审批中的数据不可以操作");
//        }
        // 前一天的计划不允许提交
        LocalDate workDate = payload.getWorkDate();
        if (workDate.isBefore(LocalDate.now()) && !workDate.isEqual(LocalDate.now()) && (payload.getExt5() == null || !payload.getExt5().equals("EMPTY"))) {
            throw TwException.error("", "只允许提交今天及以后的计划！");
        }
        if (null == payload.getProjId()) {
            throw TwException.error("", "参数异常：projId");
        }
        if (null == payload.getTaskPackageId()) {
            throw TwException.error("", "参数异常：taskPackageId");
        }
        // if (null == payload.getTaskId()) {
        //     throw TwException.error("", "参数异常：taskId");
        // }
    }

    /**
     * 数据处理
     *
     * @param payload 有效载荷
     */
    private void dataProcess(TimesheetPlanPayload payload) {
        if (payload.getWorkDate() != null) {
            // 设置当前年周
            payload.setYearWeek(Integer.parseInt(DateUtil.getYearWeek(payload.getWorkDate())));
            payload.setWeekStartDate(DateUtil.getStartWeekDay(payload.getWorkDate()));
        }
        //if (null == payload.getEqva()) {
        //    payload.setEqva(BigDecimal.ZERO);
        //}
        if (null != payload.getProjId()) {
            final PmsProjectVO projectVO = pmsProjectService.queryByKeySimple(payload.getProjId());
            if (!StringUtils.hasText(payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjNo() : "");
            }
            if (!StringUtils.hasText(payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjName() : "");
            }
        }
        if (payload.getTaskPackageId() != null) {
            final TaskPackageVO taskPackageVO = taskPackageService.queryByKey(payload.getTaskPackageId(), false);
            if (!StringUtils.hasText(payload.getTaskPackageNo())) {
                payload.setTaskPackageNo(null != taskPackageVO ? taskPackageVO.getTaskPackageNo() : "");
            }
            if (!StringUtils.hasText(payload.getTaskPackageName())) {
                payload.setTaskPackageName(null != taskPackageVO ? taskPackageVO.getTaskPackageName() : "");
            }
            if (ObjectUtils.isEmpty(payload.getReasonId())) {
                payload.setReasonId(null != taskPackageVO ? taskPackageVO.getReasonId() : null);
            }
            if (!StringUtils.hasText(payload.getReasonType())) {
                payload.setReasonType(null != taskPackageVO ? taskPackageVO.getReasonType() : "");
            }
            if (!StringUtils.hasText(payload.getReasonName())) {
                payload.setReasonName(null != taskPackageVO ? taskPackageVO.getReasonName() : "");
            }
        }

        if (null != payload.getTaskId()) {
            final TaskInfoVO taskVO = taskInfoService.queryByKey(payload.getTaskId(), false);
            if (!StringUtils.hasText(payload.getTaskNo())) {
                payload.setTaskNo(null != taskVO ? taskVO.getTaskNo() : "");
            }
            if (!StringUtils.hasText(payload.getTaskName())) {
                payload.setTaskName(null != taskVO ? taskVO.getTaskName() : "");
            }
            if (null == payload.getEqva()) {
                payload.setEqva(null != taskVO ? taskVO.getValidEqva() : BigDecimal.ZERO);
            }
        }
        // if (null != payload.getActId()) {
        //     final PmsProjectActivityVO resActivityVO = pmsProjectActivityService.queryByKey(payload.getActId());
        //     if (!StringUtils.hasText(payload.getActNo())) {
        //         payload.setActNo(null != resActivityVO ? resActivityVO.getActNo() : "");
        //     }
        //     if (!StringUtils.hasText(payload.getActName())) {
        //         payload.setActName(null != resActivityVO ? resActivityVO.getActName() : "");
        //     }
        // }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TimesheetPlanVO update(TimesheetPlanPayload payload) {
        TimesheetPlanDO entity = timesheetPlanRepo.findById(payload.getId()).orElseGet(TimesheetPlanDO::new);
        Assert.notNull(entity.getId(), "不存在");
        // 数据处理
        dataProcess(payload);
        TimesheetPlanDO entityDo = TimesheetPlanConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TimesheetPlanConvert.INSTANCE.toVo(timesheetPlanRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<TimesheetPlanDO> optional = timesheetPlanRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetPlanDO entity = optional.get();

                    // 校验已提交周报的 不允许再编辑新增
                    TimesheetBiweeklyQuery timesheetBiweeklyQuery = new TimesheetBiweeklyQuery();
                    timesheetBiweeklyQuery.setYearWeek(entity.getYearWeek());
                    timesheetBiweeklyQuery.setTsUserId(entity.getTsUserId());
                    final Long count = timesheetBiweeklyRepo
                            .count((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, timesheetBiweeklyQuery, criteriaBuilder));
                    if (count > 0) {
                        throw TwException.error("", "审批中的数据不可以删除");
                    }
                    timesheetPlanRepo.deleteSoft(Collections.singletonList(id));
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftByYearWeek(Integer yeerWeek, Long loginUserId) {
        if (null != yeerWeek) {
            LocalDateTime now = LocalDateTime.now();
            QTimesheetPlanDO qTimesheetPlanDO = QTimesheetPlanDO.timesheetPlanDO;
            JPAUpdateClause update = jpaQueryFactory.update(qTimesheetPlanDO)
                    .set(qTimesheetPlanDO.deleteFlag, 1)
                    .set(qTimesheetPlanDO.updater, GlobalUtil.getLoginUserName())
                    .set(qTimesheetPlanDO.modifyTime, now)
                    .where(qTimesheetPlanDO.yearWeek.eq(yeerWeek))
                    .where(qTimesheetPlanDO.tsUserId.eq(loginUserId));
            update.execute();
        }
    }

    /**
     * 项目和任务列表
     *
     * @param keyword 关键字
     * @param type
     * @param test
     * @return {@link List}<{@link ProjectAndTaskVO}>
     */
    @Override
    public List<ProjectAndTaskVO> listProjAndTask(String keyword, String type, boolean test) {
        List<ProjectAndTaskVO> list = new ArrayList<>();
        return list;
    }

    @Override
    public List<TimesheetPlanVO> batchInsert(TimesheetPlanListPayload payload) {
        List<TimesheetPlanVO> list = new ArrayList<>();
        final List<TimesheetPlanPayload> timesheetPlanList = payload.getTimesheetPlanList();
        if (!CollectionUtils.isEmpty(timesheetPlanList)) {
            timesheetPlanList.forEach(timesheetPlanPayload ->
                    list.add(insert(timesheetPlanPayload)));
        }
        return list;
    }

    /**
     * 复制上周计划
     *
     * @param date 日期
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<TimesheetPlanVO> copyLastWeek(String date) {
        LocalDate localDate = LocalDate.now();
        if (StringUtils.hasText(date)) {
            localDate = LocalDate.parse(date);
        }
        // 上周日期
        final LocalDate lastWeekDate = localDate.plusDays(-7);
        final int yearWeek = Integer.parseInt(DateUtil.getYearWeek(localDate));
        // 上周周数
        final String lastYearWeek = DateUtil.getYearWeek(lastWeekDate);
        // 查出上周的数据 遍历插入本周
        TimesheetPlanQuery timesheetPlanQuery = new TimesheetPlanQuery();
        timesheetPlanQuery.setYearWeek(Integer.parseInt(lastYearWeek));
        final Long loginUserId = GlobalUtil.getLoginUserId();
        timesheetPlanQuery.setTsUserId(loginUserId);
        final List<TimesheetPlanDO> timesheetPlanDOS = queryDoList(timesheetPlanQuery);

        // 清空之前 校验是否提交周报
        // 校验已提交周报的 不允许再编辑新增
        TimesheetBiweeklyQuery timesheetBiweeklyQuery = new TimesheetBiweeklyQuery();
        timesheetBiweeklyQuery.setYearWeek(yearWeek);
        timesheetBiweeklyQuery.setTsUserId(loginUserId);
        final Long count = timesheetBiweeklyRepo
                .count((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, timesheetBiweeklyQuery, criteriaBuilder));
        if (count > 0) {
            throw TwException.error("", "工作计划提交后不可修改");
        }
        // 先清空本周
        deleteSoftByYearWeek(yearWeek, loginUserId);
        List<TimesheetPlanVO> result = new ArrayList<>();
        if (!CollectionUtils.isEmpty(timesheetPlanDOS)) {
            timesheetPlanDOS.forEach(timesheetPlanDO -> {
                TimesheetPlanDO entity = new TimesheetPlanDO();
                BeanUtil.copyProperties(timesheetPlanDO, entity);
                entity.setId(null);
                entity.setCreateTime(LocalDateTime.now());
                entity.setCreator(GlobalUtil.getLoginUserName());
                entity.setCreateUserId(loginUserId);
                entity.setModifyTime(LocalDateTime.now());
                entity.setModifyUserId(loginUserId);
                entity.setUpdater(GlobalUtil.getLoginUserName());
                final LocalDate workDate = timesheetPlanDO.getWorkDate();
                if (null != workDate) {
                    final LocalDate nextWeekWorkDate = workDate.plusDays(7);
                    entity.setWorkDate(nextWeekWorkDate);
                    // 设置当前年周
                    entity.setYearWeek(Integer.parseInt(DateUtil.getYearWeek(nextWeekWorkDate)));
                    entity.setWeekStartDate(DateUtil.getStartWeekDay(nextWeekWorkDate));
                    entity.setExt1("复制上周");
                }
                final TimesheetPlanDO save = timesheetPlanRepo.save(entity);
                result.add(TimesheetPlanConvert.INSTANCE.toVo(save));
            });
        }
        return result;
    }

    @Override
    public void syncWorkPlanTo4(String param) {
        log.warn("工作计划同步已废弃...");
    }


}
