package com.elitesland.tw.tw5.server.prd.org.service;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.ContentType;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.param.SysUserUpdateParam;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5.api.prd.my.service.*;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgSyncDataService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.dao.TransferUtilDAO;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.AddressBookEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.BatchStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityRepo;
import com.elitesland.tw.tw5.server.prd.my.entity.*;
import com.elitesland.tw.tw5.server.prd.my.repo.*;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncDataDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.*;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgEmployeeEqvaRatioRepo;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.product.entity.PrdProductClassDO;
import com.elitesland.tw.tw5.server.prd.product.entity.PrdProductDO;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductClassRepo;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductRepo;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseContractDetailsDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseContractManagerDO;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseContractDetailsRepo;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseContractManagerRepo;
import com.elitesland.tw.tw5.server.prd.salecon.entity.*;
import com.elitesland.tw.tw5.server.prd.salecon.repo.*;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFinPeriodDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFinYearDO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemUserRoleDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemFinPeriodRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemFinYearRepo;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * org模块数据同步service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
// 配置文件动态刷新
@RefreshScope
public class PrdOrgSyncDataImpl implements PrdOrgSyncDataService {
    private final PrdOrgSyncLogDAO daoLog;
    private final PrdOrgEmployeeDAO daoEmployee;
    private final PrdOrgSyncDataDAO dao;
    private final TransferUtilDAO transferUtilDAO;
    private final PrdOrgOrganizationDAO orgDao;
    private final ProjectRepo projectRepo;
    private final CrmOpportunityRepo opportunityRepo;
    private final PrdOrgOrganizationDAO orgOrganizationDAO;
    private final TaskRepo taskRepo;
    private final TaskService taskService;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdOrgEmployeeService employeeService;
    private final ProjectService projectService;
    private final ResActivityService resActivityService;
    private final ResActivityRepo resActivityRepo;
    private final PrdOrgOrganizationService orgService;
    private final CrmOpportunityService oppoService;
    private final TaskAuthorizedRepo taskAuthorizedRepo;
    private final TaskAuthorizedService taskAuthorizedService;
    private final TaskAuthorizedDetailsRepo taskAuthorizedDetailsRepo;
    private final ProjShRepo projShRepo;
    private final TimesheetService timesheetService;
    private final PmsTimesheetService pmsTimesheetService;
    private final TimesheetRepo timesheetRepo;
    private final TimesheetPlanRepo timesheetPlanRepo;
    private final TimesheetPlanTempRepo timesheetPlanTempRepo;
    private final ProjectBangwo8Repo projectBangwo8Repo;
    private final PrdSystemRoleDAO roleDAO;
    private final UserRpcService userRpcService;
    private final PrdOrgEmployeeEqvaRatioRepo employeeEqvaRatioRepo;
    private final PurchaseContractManagerRepo purchaseContractManagerRepo;
    private final PurchaseContractDetailsRepo purchaseContractDetailsRepo;
    private final PrdProductClassRepo productClassRepo;
    private final PrdProductRepo prdProductRepo;
    private final PrdSystemFinPeriodRepo finPeriodRepo;
    private final PrdSystemFinYearRepo finYearRepo;
    // private final PrdAbRepo prdAbRepo;
    private final ConAchieveRepo conAchieveRepo;
    private final ConAchieveDRepo conAchieveDRepo;
    private final ConReceivablePlanRepo receivablePlanRepo;
    private final ConInvBatchRepo conInvBatchRepo;
    private final ConInvBatchInvdtlRepo invBatchInvdtlRepo;
    private final ConPurchaseDemandRepo purchaseDemandRepo;
    private final ConPurchaseDemandDRepo purchaseDemandDRepo;
    private final ConEpibolyCostConRepo epibolyCostConRepo;
    private final ConEpibolyCostConDRepo epibolyCostConDRepo;
    private final PmsProjectService pmsProjectService; ;


    private final HttpUtil httpUtil;
    private final QyWxCommunicationService qyWxCommunicationService;
    // @DubboReference
//    @Autowired
//    private SysUserRpcService sysUserRpcService;

    @Autowired
    private SysUserRpcService sysUserService;

    @Value("${tw5.shortcut.size}")
    private Integer shortcutSize = 5;

    @Value("${tw5.sys_default.dimensionId}")
    private Long default_dimension_id;

    @Value("${tw5.user_default.password}")
    private String default_password = "111111";

    @Value("${tw5.user_default.role_id}")
    private Long default_role_id;

    @Value("${tw4.sync.crmUser}")
    private String sync_crmUser;

    @Value("${tw4.sync.eqvaRatio}")
    private String sync_eqvaRatio;

    @Value("${tw4.sync.crmOrg}")
    private String sync_crmOrg;

    @Value("${tw4.sync.crmBuRes}")
    private String sync_crmBuRes;

    @Value("${tw4.sync.project}")
    private String sync_project;

    @Value("${tw4.sync.projectBangwo8}")
    private String sync_project_bangwo8;


    @Value("${tw4.sync.task}")
    private String sync_task;

    @Value("${tw4.sync.taskAuthorized}")
    private String sync_taskAuthorized;

    @Value("${tw4.sync.taskAuthorizedDetail}")
    private String sync_taskAuthorizedDetail;

    @Value("${tw4.sync.projSh}")
    private String sync_projSh;

    @Value("${tw4.sync.activity:api/openReport/v1/sync/activity}")
    private String sync_activity;

    @Value("${tw4.sync.timesheeet_to4:api/openReport/v1/sync/timesheet_to4}")
    private String sync_timesheet_to4;

    @Value("${tw4.sync.timesheeet_to4:api/openReport/v1/sync/timesheet_to4_single}")
    private String sync_timesheet_to4_single;

    @Value("${tw4.sync.timesheet_vacation_to5:api/openReport/v1/sync/timesheet_vacation_to5}")
    private String timesheet_vacation_to5;

    @Value("${tw4.sync.purchase_contract_to5:api/openReport/v1/sync/purchase_contract_to5}")
    private String purchase_contract_to5;

    @Value("${tw4.sync.purchase_contract_to5:api/openReport/v1/sync/purchase_contract_detail_to5}")
    private String purchase_contract_detail_to5;

    @Value("${tw4.sync.purchase_contract_to5:api/openReport/v1/sync/fin_year_to5}")
    private String fin_year_to5;

    @Value("${tw4.sync.purchase_contract_to5:api/openReport/v1/sync/fin_period_to5}")
    private String fin_period_to5;

    @Value("${tw4.sync.purchase_contract_to5:api/openReport/v1/sync/product_class_to5}")
    private String product_class_to5;

    @Value("${tw4.sync.purchase_contract_to5:api/openReport/v1/sync/product_to5}")
    private String product_to5;

    @Value("${tw4.sync.purchase_contract_to5:api/openReport/v1/sync/ab_to5}")
    private String ab_to5;

    @Value("${tw4.sync.purchase_contract_to5:api/openReport/v1/sync/contract_achieve_to5}")
    private String contract_achieve_to5;


    @Value("${tw4.sync.purchase_contract_to5:api/openReport/v1/sync/receive_plan_to5}")
    private String receive_plan_to5;

    @Value("${tw4.sync.purchase_contract_to5:api/openReport/v1/sync/inv_batch_to5}")
    private String inv_batch_to5;

    @Value("${tw4.sync.purchase_contract_to5:api/openReport/v1/sync/inv_batch_invdtl_to5}")
    private String inv_batch_invdtl_to5;

    @Value("${tw4.sync.purchase_contract_to5:api/openReport/v1/sync/purchase_demand_to5}")
    private String purchase_demand_to5;

    @Value("${tw4.sync.purchase_contract_to5:api/openReport/v1/sync/purchase_demand_detail_to5}")
    private String purchase_demand_detail_to5;

    @Value("${tw4.sync.purchase_contract_to5:api/openReport/v1/sync/channel_cost_con_to5}")
    private String channel_cost_con_to5;

    @Value("${tw4.sync.purchase_contract_to5:api/openReport/v1/sync/channel_cost_con_d_to5}")
    private String channel_cost_con_d_to5;

    @Value("${tw4.sync.purchase_contract_to5:api/openReport/v1/sync/update_purchase_demand_detail_to5}")
    private String update_purchase_demand_detail_to5;

    @Value("${tw4.sync.purchase_contract_to5:api/openReport/v1/sync/update_receive_plan_to5}")
    private String update_receive_plan_to5;

    @Value("${tw4.sync.purchase_contract_to5:api/openReport/v1/sync/update_channel_cost_con_d_to5}")
    private String update_channel_cost_con_d_to5;


    final String default_role_Code = "ORG-LEADER";

//    @Value("${tw4.url}")
//    private String tw4_url;
    //todo: 后面改成类配置，单独写一个帮我吧的service
    @Value("${bangwo8.secretId:xxx}")
    private String bangwo8SecretId;

    @Value("${bangwo8.secret:xxx}")
    private String bangwo8Secret;

    @Value("${bangwo8.url:xxx}")
    private String bangwo8Url;

    @Value("${bangwo8.api.token:xxx}")
    private String bangwo8TokenUrl;

    @Value("${bangwo8.api.company:xxx}")
    private String bangwo8CompanyUrl;

    @Value("${bangwo8.api.advisers:xxx}")
    private String bangwo8AdvisersUrl;

    @Value("${bangwo8.api.tickets:xxx}")
    private String bangwo8TicketsUrl;

    @Value("${bangwo8.api.ticketsCallback:xxx}")
    private String bangwo8TicketsCallbackUrl;


    @Value("${bangwo8.api.users:xxx}")
    private String bangwo8UsersUrl;

    /**
     * 同步用户
     *///    //@GlobalTransactional
    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public void syncUsers() {
        String syncType = "user";
        LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        if (localDateTime == null) {
            localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            localDateTime = localDateTime.minusSeconds(180);
        }
        XxlJobLogger.log("同步用户开始...");
        XxlJobLogger.log("syncUsers localDateTime：" + localDateTime);
        //同步到4.0
        Map<String, Long> map = new HashMap<>();
        final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        map.put("asyncTime", asyncTimeLong);
        XxlJobLogger.log("syncUsers asyncTime：" + asyncTimeLong);
//        String result = httpUtil.sendSyncGet(sync_crmUser, map);
//        Map<String, Object> data = (Map) JSON.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if ((data.get("ok") + "").equals("true")) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                List<Map<String, Object>> userDatas = (List<Map<String, Object>>) data.get("datum");
                // 调试单个资源  测试完注释
                //userDatas  = userDatas.stream().filter(userData ->( userData.get("id").toString().equals("1039"))).collect(Collectors.toList());
                //XxlJobLogger.log("syncUsers userDatas："+userDatas);
                List<Map<String, Long>> bookDatas = transferUtilDAO.queryInterCompanyTw5Maps(SystemDefaultEnum.DefaultAbType.getCode(), AddressBookEnum.RelateIntercompany.getCode());
                //通过mam存储公司id
                Map<Long, Long> bookDataMap = new HashMap<>();
                for (Map<String, Long> bookMap : bookDatas) {
                    bookDataMap.put(Long.valueOf(bookMap.get("bookIdV4") + ""), Long.valueOf(bookMap.get("id") + ""));
                }
                String shortcutIds = getDefultShortcut();
                List<Long> tw4UserIds = userDatas.stream().map(userData -> ((Integer) (userData.get("userId") == null ? 0 : userData.get("userId"))).longValue()).collect(Collectors.toList());
                List<Map<String, Object>> oldUserDatas = transferUtilDAO.queryEmployeeTw5Maps(tw4UserIds);


                boolean isHave = true;
                if (oldUserDatas == null || oldUserDatas.size() <= 0) {
                    isHave = false;
                }
                List<PrdOrgEmployeeDO> employeeDOS = new ArrayList<>();
                List<PrdSystemUserRoleDO> userRoleDOS = new ArrayList<>();
                List<PrdOrgPersonDO> personDOS = new ArrayList<>();
                for (Map<String, Object> userData : userDatas) {
                    Map<String, Object> old = null;
                    if (isHave) {
                        List<Map<String, Object>> olds = oldUserDatas.stream().filter(oldUser -> Long.valueOf(oldUser.get("userIdV4") + "").longValue() == ((Integer) userData.get("userId")).longValue()).collect(Collectors.toList());
                        if (olds != null && olds.size() > 0) {
                            old = olds.get(0);
                        }
                    }
                    XxlJobLogger.log("保存用户..." + userData);
                    saveUser(userData, old, shortcutIds, employeeDOS, userRoleDOS, personDOS, bookDataMap);
                }
                XxlJobLogger.log("保存员工..." + employeeDOS.stream().map(e -> e.getEmployeeName()).collect(Collectors.toList()));
                dao.saveEmployeeAll(employeeDOS);
                dao.saveUserRoleAll(userRoleDOS);
                if (personDOS.size() > 0) {
                    dao.savePersonAll(personDOS);
                }
                syncData = "更新了" + userDatas.size() + "数据";
            } else {
                syncData = "员工数据未变化";
            }

        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        daoLog.save(logDO);
        log.info("【人员同步，同步日志：{}】", logDO);
        XxlJobLogger.log("同步用户结束..." + logDO);
    }


    /**
     * 当量系数用户
     */
    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public void syncEqvaRatio() {
        String syncType = "eqvaRatio";
        LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        if (localDateTime == null) {
            localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            localDateTime = localDateTime.minusSeconds(180);
        }
        XxlJobLogger.log("同步当量系数开始...");
        XxlJobLogger.log("syncUsers localDateTime：" + localDateTime);
        //同步到4.0
        Map<String, Long> map = new HashMap<>();
        final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        map.put("asyncTime", asyncTimeLong);
        XxlJobLogger.log("syncUsers asyncTime：" + asyncTimeLong);
//        String result = httpUtil.sendSyncGet(sync_eqvaRatio, map);
//        Map<String, Object> data = (Map) JSON.parse(result);
        Map<String, Object> data = new HashMap<>();
        Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
        Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if ((data.get("ok") + "").equals("true")) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                List<Map<String, Object>> eqvaRatioDatas = (List<Map<String, Object>>) data.get("datum");
                //查询5.0已有的数据，进行更新操作
                List<PrdOrgEmployeeEqvaRatioDO> oldEqvaRatioDos = new ArrayList<>();
                List<Long> eqvaRatioIdV4List = eqvaRatioDatas.stream().map(eqvaRationData -> ((Integer) (eqvaRationData.get("id") == null ? 0 : eqvaRationData.get("id"))).longValue()).collect(Collectors.toList());
                List<PrdOrgEmployeeEqvaRatioDO> prdOrgEmployeeEqvaRatioDOS = employeeEqvaRatioRepo.queryByEqvaRatioIdV4In(eqvaRatioIdV4List);
                for (PrdOrgEmployeeEqvaRatioDO employeeEqvaRatioDO : prdOrgEmployeeEqvaRatioDOS) {
                    Long eqvaRatioIdV4 = employeeEqvaRatioDO.getEqvaRatioIdV4();
                    for (Map<String, Object> eqvaRatioData : eqvaRatioDatas) {
                        Long eqvaRatioId = ((Integer) (eqvaRatioData.get("id") == null ? 0 : eqvaRatioData.get("id"))).longValue();
                        if (eqvaRatioId.equals(eqvaRatioIdV4)) {
                            //将传进来的值和当前值进行对比并更新
                            PrdOrgEmployeeEqvaRatioDO updatedEmployeeEqvaRatioDO = transEqvaRatioFromV4(eqvaRatioData, v4AndV5UserIds, v4AndV5OrgIds);
                            updatedEmployeeEqvaRatioDO.setId(employeeEqvaRatioDO.getId());
                            oldEqvaRatioDos.add(updatedEmployeeEqvaRatioDO);
                            break;
                        }
                    }
                }
                if (!oldEqvaRatioDos.isEmpty()) {
                    employeeEqvaRatioRepo.saveAll(oldEqvaRatioDos);
                }

                List<Map<String, Object>> newEmployeeEqvaDatas = eqvaRatioDatas.stream().filter(employeeEqvaData -> {
                    boolean flag = true;
                    Long employeeEqvaRatioId = ((Integer) (employeeEqvaData.get("id") == null ? 0 : employeeEqvaData.get("id"))).longValue();
                    for (PrdOrgEmployeeEqvaRatioDO employeeEqvaRatioDO : prdOrgEmployeeEqvaRatioDOS) {
                        if (employeeEqvaRatioDO.getEqvaRatioIdV4().equals(employeeEqvaRatioId)) {
                            flag = false;
                        }
                    }
                    return flag;
                }).collect(Collectors.toList());

                //插入新数据
                List<PrdOrgEmployeeEqvaRatioDO> newEqvaRatioDos = new ArrayList<>();
                for (Map<String, Object> newEmployeeEqvaData : newEmployeeEqvaDatas) {
                    PrdOrgEmployeeEqvaRatioDO employeeEqvaRatioDO = transEqvaRatioFromV4(newEmployeeEqvaData, v4AndV5UserIds, v4AndV5OrgIds);
                    newEqvaRatioDos.add(employeeEqvaRatioDO);
                }
                if (!newEqvaRatioDos.isEmpty()) {
                    employeeEqvaRatioRepo.saveAll(newEqvaRatioDos);
                }
                syncData = "更新了" + eqvaRatioDatas.size() + "数据";
            } else {
                syncData = "当量系数数据未变化";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        daoLog.save(logDO);
        log.info("【当量系数同步，同步日志：{}】", logDO);
        XxlJobLogger.log("同步当量系数结束..." + logDO);
    }

    /**
     * 转换当量系数字段
     *
     * @param employeeEqvaRatioData
     */
    private PrdOrgEmployeeEqvaRatioDO transEqvaRatioFromV4(Map<String, Object> employeeEqvaRatioData, Map<Long, Long> userMap, Map<Long, Long> v4AndV5OrgIds) {
        PrdOrgEmployeeEqvaRatioDO employeeEqvaRatioDO = BeanUtil.mapToBean(PrdOrgEmployeeEqvaRatioDO.class, employeeEqvaRatioData, Arrays.asList("id", "createTime", "createUserId"));
        if (employeeEqvaRatioData.get("eqvaRatio") != null) {
            employeeEqvaRatioDO.setEqvaRatio(BigDecimal.valueOf(Double.parseDouble(employeeEqvaRatioData.get("eqvaRatio").toString())));
        }
        if (employeeEqvaRatioData.get("id") != null) {
            employeeEqvaRatioDO.setEqvaRatioIdV4(Long.valueOf((Integer) employeeEqvaRatioData.get("id")));
        }
        if (employeeEqvaRatioData.get("buId") != null) {
            long buId = Long.parseLong(employeeEqvaRatioData.get("buId").toString());
            employeeEqvaRatioDO.setOrgId(v4AndV5OrgIds.get(buId));
        }
        if (employeeEqvaRatioData.get("userId") != null) {
            Long userId = Long.valueOf((Integer) employeeEqvaRatioData.get("userId"));
            employeeEqvaRatioDO.setUserId(userMap.get(userId));
        }
        if (employeeEqvaRatioData.get("startDate") != null) {
            employeeEqvaRatioDO.setStartDate(LocalDate.parse(employeeEqvaRatioData.get("startDate").toString()));
        }
        if (employeeEqvaRatioData.get("endDate") != null) {
            employeeEqvaRatioDO.setEndDate(LocalDate.parse(employeeEqvaRatioData.get("endDate").toString()));
        }
        if (employeeEqvaRatioData.get("delFlag") != null) {
            employeeEqvaRatioDO.setDeleteFlag(Integer.parseInt(employeeEqvaRatioData.get("delFlag").toString()));
        }
        return employeeEqvaRatioDO;
    }

    /**
     * 同步组织
     */
    @Transactional
    @Override
    public void syncOrgs() {
        String syncType = "org";
        LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        if (localDateTime == null) {
            localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            localDateTime = localDateTime.minusSeconds(180);
        }
        //获取4.0组织数据
        Map<String, Long> map = new HashMap<>();
        map.put("asyncTime", localDateTime.toEpochSecond(ZoneOffset.of("+8")));
//        String result = httpUtil.sendSyncGet(sync_crmOrg, map);
//        Map<String, Object> data = (Map) JSON.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if ((data.get("ok") + "").equals("true")) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                List<Map<String, Object>> orgDatas = (List<Map<String, Object>>) data.get("datum");
                List<PrdOrgOrganizationDO> orgList = new ArrayList<>();
                Map<Long, Long> parentMap = new HashMap<>();//存储上下级关系的map
                List<PrdOrgOrganizationRefDO> orgRefList = new ArrayList<>();//新建或更新的组织关系
                List<PrdOrgRoleDO> orgRoleList = new ArrayList<>();

                //获取4.0组织负责人对应的5.0的userid
                List<Long> tw4UserIds = orgDatas.stream().map(orgData -> ((Integer) (orgData.get("inchargeUserId") == null ? 0 : (orgData.get("inchargeUserId")))).longValue()).collect(Collectors.toList());
                List<Map<String, Object>> userDatas = transferUtilDAO.queryEmployeeTw5Maps(tw4UserIds);
                //通过mam存储负责人id
                Map<Long, Long> userDataMap = new HashMap<>();
                for (Map<String, Object> userMap : userDatas) {
                    userDataMap.put(Long.valueOf(userMap.get("userIdV4") + ""), Long.valueOf(userMap.get("userId") + ""));
                }
                //获取需要更新的数据
                List<Long> tw4OrgIds = orgDatas.stream().map(orgData -> ((Integer) orgData.get("id")).longValue()).collect(Collectors.toList());
                List<Map<String, Long>> oldOrgDatas = transferUtilDAO.queryOrgTw5Maps(tw4OrgIds);
                boolean isHave = true;
                if (oldOrgDatas == null || oldOrgDatas.size() <= 0) {
                    isHave = false;
                }
                //需要更新的组织主键集合
                List<Long> updateOrgIds = new ArrayList<>();
                //遍历拉取到的4.0组织数据
                for (Map<String, Object> orgData : orgDatas) {
                    //判断是更新还是新增
                    Map<String, Long> old = null;
                    if (isHave) {
                        List<Map<String, Long>> olds = oldOrgDatas.stream().filter(oldOrg -> Long.valueOf(oldOrg.get("orgIdV4") + "").longValue() == ((Integer) orgData.get("id")).longValue()).collect(Collectors.toList());
                        if (olds != null && olds.size() > 0) {
                            old = olds.get(0);
                        }
                    }
                    translateOrg(orgData, orgList, parentMap, userDataMap, old, updateOrgIds);
                }
                //保存或更新所有组织
                List<PrdOrgOrganizationDO> norgList = dao.saveOrganizationAll(orgList);

                //查询所有的组织
                List<PrdOrgOrganizationDO> allOrgList = dao.queryOrgAll();
                //获取需要更新的组织关系
                List<PrdOrgOrganizationRefDO> orgRefDOs = null;
                if (updateOrgIds.size() > 0) {
                    orgRefDOs = dao.queryOrgRefs(default_dimension_id, updateOrgIds);
                }
                for (PrdOrgOrganizationDO orgDO : norgList) {
                    Long parentId = 0L;
                    List<PrdOrgOrganizationDO> parents = allOrgList.stream().filter(parentOrg -> (parentOrg.getOrgIdV4() != null && parentMap.get(orgDO.getOrgIdV4()).longValue() == parentOrg.getOrgIdV4().longValue())).collect(Collectors.toList());
                    if (parents != null && parents.size() > 0) {
                        parentId = parents.get(0).getId();
                    }
                    if (updateOrgIds.size() == 0 || !updateOrgIds.contains(orgDO.getId())) {
                        //需要新建的组织关系和组织角色
                        PrdOrgOrganizationRefDO refDao = new PrdOrgOrganizationRefDO();
                        refDao.setOrgId(orgDO.getId());
                        refDao.setDimensionId(default_dimension_id);
                        refDao.setOrgType(1);
                        refDao.setParentId(parentId);
                        refDao.setTenantId(orgDO.getTenantId());
                        orgRefList.add(refDao);

                        PrdOrgRoleDO roleDO = new PrdOrgRoleDO();
                        roleDO.setOrgId(orgDO.getId());
                        roleDO.setRoleCode(default_role_Code);
                        roleDO.setTenantId(orgDO.getTenantId());
                        roleDO.setRoleName("组织负责人");
                        if (orgDO.getManageId() != null && orgDO.getManageId().longValue() != 0) {
                            roleDO.setRoleEmployees(orgDO.getManageId() + "");
                        }
                        orgRoleList.add(roleDO);
                    } else {
                        //需要更细的组织关系
                        if (orgRefDOs != null) {
                            PrdOrgOrganizationRefDO oldRef = orgRefDOs.stream().filter(orgRefDO -> orgRefDO.getOrgId().longValue() == orgDO.getId().longValue()).findFirst().get();
                            if (oldRef.getParentId().longValue() != parentId.longValue()) {
                                oldRef.setParentId(parentId);
                                orgRefList.add(oldRef);
                            }
                        }

                    }

                }
                dao.saveOrganizationRefAll(orgRefList);
                dao.saveOrgRoleAll(orgRoleList);

                syncData = "更新了" + orgDatas.size() + "数据";
            } else {
                syncData = "组织数据未变化";
            }

        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        daoLog.save(logDO);
    }

    /**
     * 同步组织员工关系
     */
    @Transactional
    @Override
    public void syncOrgRefUsers() {
        String syncType = "orgRefUser";
        LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        if (localDateTime == null) {
            localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            localDateTime = localDateTime.minusSeconds(180);
        }
        XxlJobLogger.log("组织员工关系同步开始...");
        XxlJobLogger.log("syncOrgRefUsers localDateTime：" + localDateTime);
        //获取4.0组织数据
        Map<String, Long> map = new HashMap<>();
        final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        map.put("asyncTime", asyncTimeLong);
        XxlJobLogger.log("syncOrgRefUsers asyncTime：" + asyncTimeLong);
//        String result = httpUtil.sendSyncGet(sync_crmBuRes, map);
//        Map<String, Object> data = (Map) JSON.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if ((data.get("ok") + "").equals("true")) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                List<Map<String, Object>> orgRefDatas = (List<Map<String, Object>>) data.get("datum");
                List<Long> tw4OrgIds = new ArrayList<>();
                List<Long> tw4UserIds = new ArrayList<>();
                List<Long> tw4OrgRefUserIds = new ArrayList<>();
                for (Map<String, Object> orgRefData : orgRefDatas) {
                    if (!ObjectUtils.isEmpty(orgRefData.get("buId"))) {
                        tw4OrgIds.add(((Integer) orgRefData.get("buId")).longValue());
                    }
                    if (!ObjectUtils.isEmpty(orgRefData.get("userId"))) {
                        tw4UserIds.add(((Integer) orgRefData.get("userId")).longValue());
                    }
                    if (!ObjectUtils.isEmpty(orgRefData.get("puserId"))) {
                        tw4UserIds.add(((Integer) orgRefData.get("puserId")).longValue());
                    }
                    if (!ObjectUtils.isEmpty(orgRefData.get("id"))) {
                        tw4OrgRefUserIds.add(((Integer) orgRefData.get("id")).longValue());
                    }
                }
                // 查询4.0组织和5.0组织对应关系  5.0里多条数据时，只匹配change_id =0的数据
                List<Map<String, Long>> orgDatas = transferUtilDAO.queryOrgTw5Maps(tw4OrgIds);
                //通过mam存储tw4.0和5.0对应关系组织id
                Map<Long, Long> orgDataMap = new HashMap<>();
                for (Map<String, Long> orgMap : orgDatas) {
                    orgDataMap.put(Long.valueOf(orgMap.get("orgIdV4") + ""), Long.valueOf(orgMap.get("id") + ""));
                }
                List<Map<String, Object>> userDatas = transferUtilDAO.queryEmployeeTw5Maps(tw4UserIds);
                //通过mam存储tw4.0和5.0对应关系用户id
                Map<Long, Long> userDataMap = new HashMap<>();
                for (Map<String, Object> userMap : userDatas) {
                    userDataMap.put(Long.valueOf(userMap.get("userIdV4") + ""), Long.valueOf(userMap.get("userId") + ""));
                }
                //获取需要更新的数据
                List<Map<String, Long>> oldOrgRefUserDatas = transferUtilDAO.queryOrgRefUserTw5Maps(tw4OrgRefUserIds);
                boolean isHave = true;
                if (oldOrgRefUserDatas == null || oldOrgRefUserDatas.size() <= 0) {
                    isHave = false;
                }
                List<PrdOrgEmployeeRefDO> orgEmployeeRefDOs = new ArrayList<>();
                for (Map<String, Object> orgRefData : orgRefDatas) {
                    Map<String, Long> old = null;
                    if (isHave) {
                        List<Map<String, Long>> olds = oldOrgRefUserDatas.stream().filter(oldOrgRefUser -> Long.valueOf(oldOrgRefUser.get("refIdV4") + "").longValue() == ((Integer) orgRefData.get("id")).longValue()).collect(Collectors.toList());
                        if (olds != null && olds.size() > 0) {
                            old = olds.get(0);
                        }

                    }
                    translateOrgRefUser(orgRefData, orgDataMap, userDataMap, old, orgEmployeeRefDOs);
                }
                dao.saveOrgEmployeeRefAll(orgEmployeeRefDOs);
                syncData = "更新了" + orgRefDatas.size() + "数据";
            } else {
                syncData = "组织员工关系数据未变化";
            }

        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        daoLog.save(logDO);
        XxlJobLogger.log("组织员工关系同步结束...:" + syncData);

    }

    /**
     * tw4.0翻译成5.0组织员工关系数据
     *
     * @param map               4.0源数据
     * @param orgDataMap        tw4.0和5.0对应关系组织id
     * @param userDataMap       tw4.0和5.0对应关系用户id
     * @param old               变更之前的数据
     * @param orgEmployeeRefDOs 新建或更新的数据容器
     */
    public void translateOrgRefUser(Map<String, Object> map, Map<Long, Long> orgDataMap, Map<Long, Long> userDataMap, Map<String, Long> old, List<PrdOrgEmployeeRefDO> orgEmployeeRefDOs) {
        PrdOrgEmployeeRefDO orgEmployeeRef = new PrdOrgEmployeeRefDO();
        if (old != null) {
            orgEmployeeRef.setId(Long.valueOf(old.get("id") + ""));
        }
        orgEmployeeRef.setIsCopy(0);
        if (!ObjectUtils.isEmpty(map.get("tenantId"))) {
            orgEmployeeRef.setTenantId((Long.valueOf(map.get("tenantId") + "")));
        } else {
            orgEmployeeRef.setTenantId(1L);
        }
//        if (ObjectUtils.isEmpty(userDataMap.get(((Integer) map.get("userId")).longValue()))) {
//            System.out.println(" map.get(\"buId\")::" + map.get("buId"));
//            System.out.println(" map.get(\"buId\")::" + map.get("userId"));
//        }
//        if (ObjectUtils.isEmpty(orgDataMap.get(((Integer) map.get("buId")).longValue()))) {
//            System.out.println(" map.get(\"buId\");::" + map.get("buId"));
//            System.out.println(" map.get(\"buId\");::" + map.get("userId"));
//        }
        orgEmployeeRef.setOrgId(orgDataMap.get(((Integer) map.get("buId")).longValue()));
        orgEmployeeRef.setUserId(userDataMap.get(((Integer) map.get("userId")).longValue()));
        if ((map.get("isBaseBuId") + "").equals("true")) {
            orgEmployeeRef.setIsDefault(0);
        } else {
            orgEmployeeRef.setIsDefault(1);
        }
        if (!ObjectUtils.isEmpty(map.get("puserId"))) {
            orgEmployeeRef.setParentId(userDataMap.get(((Integer) map.get("puserId")).longValue()));
        }
        orgEmployeeRef.setRefIdV4(((Integer) map.get("id")).longValue());
        if (!ObjectUtils.isEmpty(map.get("dateFrom"))) {
            orgEmployeeRef.setJoinDate(LocalDate.parse(map.get("dateFrom") + ""));
        }
        if (!ObjectUtils.isEmpty(map.get("dateTo"))) {
            orgEmployeeRef.setJoinDate(LocalDate.parse(map.get("dateTo") + ""));
        }
        if (!ObjectUtils.isEmpty(map.get("resStatus")) && (map.get("resStatus") + "").equals("INACTIVE")) {
            orgEmployeeRef.setDeleteFlag(1);
        }
        if (orgEmployeeRef.getOrgId() != null && orgEmployeeRef.getUserId() != null) {
            orgEmployeeRefDOs.add(orgEmployeeRef);
        }
    }

    /**
     * tw4.0翻译成5.0组织数据
     *
     * @param map         4.0源数据
     * @param orgList     需要保存的组织数据
     * @param parentMap   组织和上级组织关系存储容器
     * @param userDataMap 负责人数据
     * @param old         变更之前的组织数据
     * @param updateOrgs  需要更新的组织数据容器
     */

    public void translateOrg(Map<String, Object> map, List<PrdOrgOrganizationDO> orgList, Map<Long, Long> parentMap, Map<Long, Long> userDataMap, Map<String, Long> old, List<Long> updateOrgs) {
        PrdOrgOrganizationDO organizationDO = new PrdOrgOrganizationDO();
        if (old != null) {
            organizationDO.setId(Long.valueOf(old.get("id") + ""));
            updateOrgs.add(Long.valueOf(old.get("id") + ""));
        }
        organizationDO.setChangeId(0L);
        organizationDO.setOrganizationType(map.get("buType") == null ? null : map.get("buType") + "");
        organizationDO.setDimensionId(default_dimension_id);
        organizationDO.setOrgIdV4(((Integer) map.get("id")).longValue());
        organizationDO.setOrgName(map.get("buName") == null ? null : map.get("buName") + "");
        organizationDO.setOrgCode(map.get("buNo") == null ? null : map.get("buNo") + "");
        organizationDO.setOrgStatus(map.get("buStatus") == null ? null : map.get("buStatus") + "");
        organizationDO.setOrganizationType(map.get("buType") == null ? null : map.get("buType") + "");
        organizationDO.setIsCopy(0);
        if (((Integer) (map.get("inchargeUserId") == null ? 0 : (map.get("inchargeUserId")))).longValue() != 0) {
            organizationDO.setManageId(userDataMap.get(((Integer) map.get("inchargeUserId")).longValue()));
        }
        if (!ObjectUtils.isEmpty(map.get("pid"))) {

            parentMap.put(((Integer) map.get("id")).longValue(), ((Integer) map.get("pid")).longValue());
        }
        if (!ObjectUtils.isEmpty(map.get("tenantId"))) {
            organizationDO.setTenantId((Long.valueOf(map.get("tenantId") + "")));
        } else {
            organizationDO.setTenantId(1L);
        }

        orgList.add(organizationDO);
    }

    /**
     * 保存用户数据
     *
     * @param map
     * @param shortcutIds
     */
    @Transactional
    public void saveUser(Map<String, Object> map, Map<String, Object> oldUser, String shortcutIds, List<PrdOrgEmployeeDO> employeeDOS, List<PrdSystemUserRoleDO> userRoleDOS, List<PrdOrgPersonDO> personDOS, Map<Long, Long> bookDataMap) {
        boolean enabled = true;
        if ((map.get("isDisabled") + "").equals("1")) {
            enabled = false;
        }
        PrdOrgPersonDO personDO = new PrdOrgPersonDO();
        if (!ObjectUtils.isEmpty(map.get("tenantId"))) {
            personDO.setTenantId((Long.valueOf(map.get("tenantId") + "")));
            XxlJobLogger.log("personDO租户id为..." + Long.valueOf(map.get("tenantId") + ""));
        } else {
            personDO.setTenantId(1L);
        }

        personDO.setUserName(map.get("personalEmail") + "");
        personDO.setMobile(map.get("mobile") + "");
        personDO.setEnabled(enabled);
        personDO.setEmail(map.get("personalEmail") + "");
        personDO.setPersonName(map.get("resName") == null ? null : map.get("resName") + "");
        personDO.setForeignName(map.get("englishName") == null ? null : map.get("englishName") + "");
        personDO.setIdType(map.get("idType") == null ? null : map.get("idType") + "");
        personDO.setIdNo(map.get("idNo") == null ? null : map.get("idNo") + "");
        if (!ObjectUtils.isEmpty(map.get("idValidFrom"))) {
            personDO.setIdValidFrom(LocalDate.parse(map.get("idValidFrom") + ""));
        }
        if (!ObjectUtils.isEmpty(map.get("idValidTo"))) {
            personDO.setIdValidTo(LocalDate.parse(map.get("idValidTo") + ""));
        }
        personDO.setIdValidCodes("");
        if (!ObjectUtils.isEmpty(map.get("birthday"))) {
            personDO.setBirthday(LocalDate.parse(map.get("birthday") + ""));
        }
        personDO.setSex(map.get("resGender") == null ? null : map.get("resGender") + "");
//        personDO.setNationality(map.get("nationality") == null ? null : map.get("nationality") + "");
        personDO.setNationality("中国");
        personDO.setBirthplace(map.get("birthplace") == null ? null : map.get("birthplace") + "");
        personDO.setNation(map.get("nation") == null ? null : map.get("nation") + "");
        Integer marital = null;
        if ((map.get("marital") + "").equals("MARRIED")) {
            marital = 0;
        }
        if ((map.get("marital") + "").equals("UNMARRIED")) {
            marital = 1;
        }
        personDO.setMarital(marital);
        String addr = "";
        if (map.get("contactProvinceName") != null) {
            addr += map.get("contactProvinceName");
        }
        if (map.get("contactCityName") != null) {
            addr += map.get("contactCityName");
        }
        if (map.get("contactDistrict") != null) {
            addr += map.get("contactDistrict");
        }
        if (map.get("contactAddress") != null) {
            addr += map.get("contactAddress");
        }
        personDO.setAddr(addr);
        personDO.setUrgency_name(map.get("emContactName") == null ? null : map.get("emContactName") + "");
        personDO.setUrgency_mobile(map.get("emContactMobile") == null ? null : map.get("emContactMobile") + "");
        personDO.setUrgency_ref(map.get("emContactRelation") == null ? null : map.get("emContactRelation") + "");

        PrdOrgEmployeeDO ado = new PrdOrgEmployeeDO();
        if (oldUser == null) {
//            SysUserRpcSaveParam param = new SysUserRpcSaveParam();
            UserCreateDTO param = new UserCreateDTO();
//            param.setTenantId(personDO.getTenantId());
            param.setUsername(map.get("personalEmail") == null ? null : map.get("personalEmail") + "");
            param.setPassword(default_password);
            param.setFullName(map.get("accName") == null ? null : map.get("accName") + "");
//            param.setLastName("");
//            param.setFirstName(map.get("accName") == null ? null : map.get("accName") + "");
            param.setMobile(map.get("mobile") + "");
            param.setEmail(map.get("personalEmail") + "");
            param.setEnabled(enabled);
//            param.setRoleIds(new ArrayList<>());
//            param.setDataRoleIds(new ArrayList<>());
//            param.setFlowRoleIds(new ArrayList<>());
            param.setSourceType("sys");
//            param.setTerminals(new HashSet<>());
            try {
                ApiResult<Long> obj = userRpcService.upsert(param);
//            ApiResult<Object> obj = sysUserService.sysUserAccountCreate(param);
                if (obj.isSuccess()) {
                    log.info("【人员同步：创建用户返回结果：{}】", obj);
                    Long userId = Long.valueOf(obj.getData() + "");
                    String wecom = qyWxCommunicationService.getQyWxuserid(map.get("mobile") + "");
                    ado.setWecomId(wecom);
                    ado.setUserId(userId);

                    PrdSystemUserRoleDO roleDO = new PrdSystemUserRoleDO();
                    roleDO.setRoleId(default_role_id);
                    roleDO.setTenantId(personDO.getTenantId());
                    roleDO.setUserId(userId);
                    userRoleDOS.add(roleDO);

                    personDO = daoEmployee.savePerson(personDO);
                    log.info("【人员同步：创建自然人：{}】", personDO);
                } else {
                    PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
                    logDO.setSyncType("employee_sync_exception");
                    logDO.setSyncData("员工" + map.get("personalEmail") + "同步异常，详情：" + obj);
                    daoLog.save(logDO);
                }
            } catch (Exception e) {
                PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
                logDO.setSyncType("employee_sync_exception");
                logDO.setSyncData("员工" + map.get("personalEmail") + "同步异常，详情：" + e.getMessage());
                daoLog.save(logDO);
            }
        } else {
            if (!(map.get("personalEmail") + "").equals(oldUser.get("email") + "") || !(map.get("accName") + "").equals(oldUser.get("employeeName") + "") || !(map.get("mobile") + "").equals(oldUser.get("mobile") + "") || (enabled != Boolean.valueOf(oldUser.get("enabled") + ""))) {
                SysUserUpdateParam param = new SysUserUpdateParam();
                param.setEmail(map.get("personalEmail") + "");
                param.setEnabled(enabled);
                param.setId(Long.valueOf(oldUser.get("userId") + ""));
                param.setLastName("");
                param.setFirstName(map.get("accName") + "");
                param.setMobile(map.get("mobile") + "");
                sysUserService.update(param);
            }
            ado.setUserId(Long.valueOf(oldUser.get("userId") + ""));
            ado.setId(Long.valueOf(oldUser.get("id") + ""));
            ado.setSortIndex(ObjectUtils.isEmpty(oldUser.get("sortIndex")) ? 0 : Integer.valueOf(oldUser.get("sortIndex") + ""));
            // 帮我吧id会被覆盖掉
            if (oldUser.get("bangwo8AdviserId") != null) {
                ado.setBangwo8AdviserId(Long.valueOf(oldUser.get("bangwo8AdviserId") + ""));
            }
            if (oldUser.get("wecomId") != null) {
                ado.setWecomId(oldUser.get("wecomId") + "");
            }
            personDO.setId(oldUser.get("personId") == null ? null : Long.valueOf(oldUser.get("personId") + ""));
            personDOS.add(personDO);
        }
        if (personDO.getId() != null) {
            ado.setTenantId(personDO.getTenantId());
            ado.setPersonId(personDO.getId());
            ado.setUserIdV4(((Integer) map.get("userId")).longValue());
            if (map.get("ouAbId") != null) {
                ado.setBookId(bookDataMap.get(((Integer) map.get("ouAbId")).longValue()));
            }
            ado.setEmployeeNo(map.get("empNo") == null ? null : map.get("empNo") + "");
            ado.setEmployeeName(map.get("accName") + "");
            ado.setResourceStatus(map.get("resStatus") == null ? null : map.get("resStatus") + "");
            ado.setHrStatus(map.get("hrStatus") == null ? null : map.get("hrStatus") + "");
            ado.setDeleteFlag((Integer) map.get("delFlag"));
            if (!ObjectUtils.isEmpty(map.get("enrollDate"))) {
                ado.setEnrollDate(LocalDate.parse(map.get("enrollDate") + ""));
            }
            ado.setAccessLevel((Integer) map.get("accessLevel"));
            ado.setJobs(map.get("job") == null ? null : map.get("job") + "");
            ado.setShortcutIds(shortcutIds);
            ado.setEqvaRatio(map.get("eqvaRatio") == null ? BigDecimal.ZERO : new BigDecimal(map.get("eqvaRatio") + ""));
            ado.setExtString1(map.get("jobGrade") == null ? null : map.get("jobGrade") + "");
            ado.setExtString2(map.get("managementGrade") == null ? null : map.get("managementGrade") + "");
            ado.setExtString3(map.get("professionalSequence") == null ? null : map.get("professionalSequence") + "");
            ado.setExtString4(map.get("positionSequence") == null ? null : map.get("positionSequence") + "");
            ado.setExtString5(map.get("baseCity") == null ? null : map.get("baseCity") + "");
            ado.setExtString6(map.get("resType1") == null ? null : map.get("resType1") + "");
            ado.setExtString7(map.get("telfeeQuota") == null ? null : map.get("telfeeQuota") + "");
            ado.setExtString8(map.get("compfeeQuota") == null ? null : map.get("compfeeQuota") + "");
            ado.setExtString9(map.get("resType2") == null ? null : map.get("resType2") + "");
            ado.setSortIndex((Integer) map.get("userId"));
//        if (!ObjectUtils.isEmpty(map.get("enrollDate"))) {
//            ado.setExtDate1(LocalDate.parse(map.get("enrollDate") + ""));
            ado.setExtDate1(null);
//        }

            if (!ObjectUtils.isEmpty(map.get("regularDate"))) {
                ado.setExtDate2(LocalDate.parse(map.get("regularDate") + ""));
            }
            if (!ObjectUtils.isEmpty(map.get("contractSignDate"))) {
                ado.setExtDate3(LocalDate.parse(map.get("contractSignDate") + ""));
            }
            if (!ObjectUtils.isEmpty(map.get("contractExpireDate"))) {
                ado.setExtDate4(LocalDate.parse(map.get("contractExpireDate") + ""));
            }
            if (!ObjectUtils.isEmpty(map.get("internDate"))) {
                ado.setExtDate5(LocalDate.parse(map.get("internDate") + ""));
            }
            if (!ObjectUtils.isEmpty(map.get("probationBeginDate"))) {
                ado.setExtDate6(LocalDate.parse(map.get("probationBeginDate") + ""));
            }
            if (!ObjectUtils.isEmpty(map.get("probationEndDate"))) {
                ado.setExtDate7(LocalDate.parse(map.get("probationEndDate") + ""));
            }
            employeeDOS.add(ado);
        } else {
            PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
            logDO.setSyncType("employee_sync_exception");
            logDO.setSyncData("员工" + map.get("personalEmail") + "同步异常，详情：personId是空");
            daoLog.save(logDO);
        }
    }


    //获取默认快捷入口
    String getDefultShortcut() {
        List<Long> shortcutIds = daoEmployee.getShortcuts(shortcutSize);
        return org.apache.commons.lang3.StringUtils.join(shortcutIds.toArray(), ",");
    }

    private String getBangwo8Token() {
        String value = HttpRequest.post(String.join("", bangwo8Url, bangwo8TokenUrl))
                .basicAuth(bangwo8SecretId, bangwo8Secret)
                .form("grant_type", "client_credentials")
                .execute()
                .body();
        if (StringUtils.hasText(value)) {
            Map parse = (Map) JSON.parse(value);
            return (String) parse.get("access_token");
        } else {
            return null;
        }
    }

    @Override
    public void syncProjectsToBangwo8Pro(String param) {
        XxlJobLogger.log("获取token...");
        String token = getBangwo8Token();
        XxlJobLogger.log("帮我吧项目同步定时任务 新版...");
        //项目列表5.0
        String syncType = "bangbwo8_project_pro";
        LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        if (localDateTime == null) {
            localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            localDateTime = localDateTime.minusSeconds(180);
        }
        XxlJobLogger.log("帮我吧项目同步开始...");
        XxlJobLogger.log("syncProjectsToBangwo8Pro localDateTime：" + localDateTime);

        // 查询项目列表
        PmsProjectQuery pmsProjectQuery = new PmsProjectQuery();
        pmsProjectQuery.setProjStatus(ProjectStatusEnum.ACTIVE.getCode());
        pmsProjectQuery.setExt1("DEV_OPS");
        pmsProjectQuery.setModifyTimeGt(localDateTime);
        if (StringUtils.hasText(param)) {
            pmsProjectQuery.setProjNo(param);
        }
        List<PmsProjectVO> pmsProjectVOS = pmsProjectService.queryListDynamic(pmsProjectQuery);
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if (!ObjectUtils.isEmpty(pmsProjectVOS)) {

            //查询tw4项目与帮我吧项目关系表，确定是不是已经同步过的项目
            List<Map<String, Object>> projectList = projectBangwo8Repo.queryBangwo8Projects();
            Map<Long, Long> collectMap = projectList.stream().collect(HashMap::new, (projMap, item) -> projMap.put(Long.parseLong(item.get("projIdV4").toString()), Long.parseLong(item.get("projIdBangwo8").toString())), HashMap::putAll);

            int insertNum = 0;
            int updateNum = 0;
            for (PmsProjectVO projectData : pmsProjectVOS) {
                String bangwo8ProjName = projectData.getBangwo8ProjName();
                if (ObjectUtils.isEmpty(bangwo8ProjName)) {
                    continue;
                }
                JSONObject companyData = new JSONObject();
                JSONObject company = new JSONObject();
                company.put("companyName", bangwo8ProjName);//项目名称
                company.put("serveNote", projectData.getProjNo());//项目代码
                company.put("yxmdm", projectData.getProjNo());//原项目代码
//                        company.put("ServiceStartTime",projectData.get("contractStartDate"));//服务开始日
//                        company.put("ServiceEndTime",projectData.get("contractEndDate"));//服务到期日
//                        company.put("address",projectData.get("ouName"));//公司名称
                List<JSONObject> customFields = new ArrayList<>();

                // 产品小类
                String productSubClass = projectData.getProductSubClass();
                if (!ObjectUtils.isEmpty(productSubClass)) {
                    String saleType2 = productSubClass;

                    String saleClass = saleType2.equals("SELFYY204") ? "云时通" : saleType2.equals("SELFYY205") ? "TW" : saleType2.equals("SELFYY207") ? "鹰π" : saleType2.equals("SAPYY") ? "SAP" : saleType2.equals("JDEYY") ? "Oracle" : "";
                    company.put("tableName", saleClass);//标签
                    company.put("userGroup", saleClass);//分组
                }


                BigDecimal totalDays = projectData.getTotalDays();
                JSONObject htrt = new JSONObject();
                htrt.put("key", "htrt");
                htrt.put("value", totalDays);
                customFields.add(htrt);//合同人天

                JSONObject edrt = new JSONObject();
                edrt.put("key", "edrt");
                edrt.put("value", totalDays);
                customFields.add(edrt);//额定人天

                JSONObject eddl = new JSONObject();
                eddl.put("key", "eddl");
                eddl.put("value", projectData.getTotalEqva());
                customFields.add(eddl);//额定当量


                JSONObject xmlx = new JSONObject();
                String platType = ObjectUtils.isEmpty(projectData.getPlatType()) ? "4686877" : projectData.getPlatType().equals(SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode()) ? "4686878" : "4686877";
                xmlx.put("key", "xmlx");
                xmlx.put("value", platType);
                customFields.add(xmlx);//项目类型（有合同，无合同项目）

                JSONObject htqdrq = new JSONObject();
                htqdrq.put("key", "htqdrq");
                htqdrq.put("value", projectData.getContractSignDate());
                customFields.add(htqdrq);//合同签订日期

                Long pmResId = projectData.getPmResId();
                if (!ObjectUtils.isEmpty(pmResId)) {
                    PrdOrgEmployeeDO prdOrgEmployeeDO = employeeDAO.queryByUserId(pmResId);
                    JSONObject pm = new JSONObject();
                    pm.put("key", "pm");
                    pm.put("value", prdOrgEmployeeDO.getEmployeeName());
                    customFields.add(pm);//项目经理
                }

                JSONObject serviceStartTime = new JSONObject();
                serviceStartTime.put("key", "ServiceStartTime");
                serviceStartTime.put("value", projectData.getContractStartDate());
                customFields.add(serviceStartTime);//服务开始日

                JSONObject serviceEndTime = new JSONObject();
                serviceEndTime.put("key", "ServiceEndTime");
                serviceEndTime.put("value", projectData.getContractEndDate());
                customFields.add(serviceEndTime);//服务到期日

//                        JSONObject xmjc = new JSONObject();
//                        pm.put("key","xmjc");
//                        pm.put("value",);
//                        customFields.add(xmjc);//项目简称

                String projStatus = projectData.getProjStatus();
                if (!ObjectUtils.isEmpty(projStatus)) {
                    String status = projStatus.equals("ACTIVE") ? "4680517" : projStatus.equals("CLOSE") ? "4680518" : projStatus.equals("PENDING") ? "4680519" : projStatus.equals("APPROVING") ? "4688998" : projStatus.equals("CHECK") ? "4688999" : projStatus.equals("CLOSING") ? "4689000" : projStatus.equals("TOCLOSEACCOUNT") ? "4689001" : projStatus.equals("CHECK_OK") ? "4689002" : projStatus.equals("CHECK_NO") ? "4689003" : "";
                    JSONObject xmzt = new JSONObject();
                    xmzt.put("key", "xmzt");
                    xmzt.put("value", status);
                    customFields.add(xmzt);//项目 状态
                }

//                        params.put("",);//项目简称

                company.put("custom_fields", customFields);
                companyData.put("company", company);
                Long projectIdBangwo8 = collectMap.get(projectData.getId());
                if (projectIdBangwo8 != null) {
                    updateNum++;
//                            customFields.remove("fwgssx");
//                            customFields.remove("address");
                    company.put("custom_fields", customFields);
                    //调用更新接口
                    String body = HttpRequest.put(String.join("", bangwo8Url, bangwo8CompanyUrl, "/", projectIdBangwo8.toString(), ".json"))
                        .body(companyData.toJSONString())
                        .contentType(ContentType.JSON.toString())
                        .bearerAuth(token)
                        .execute()
                        .body();
                    // TODO 调用接口日志调用记录 com.elitesland.tw.tw5.server.prd.bangwo.service.BangWo8ServiceImpl
                    Map parse = (Map) JSON.parse(body);
                    if (parse.get("errorMsg") != null) {
                        XxlJobLogger.log(projectData.getProjName() + "同步接口调用失败::::::::" + parse.get("errorMsg"));
                        throw TwException.error("", "同步接口调用失败");
                    }
                } else {
                    insertNum++;
                    //调用新增接口
                    String body = HttpRequest.post(String.join("", bangwo8Url, bangwo8CompanyUrl, ".json"))
                        .body(companyData.toJSONString())
                        .contentType(ContentType.JSON.toString())
                        .bearerAuth(token)
                        .execute()
                        .body();
                    Map parse = (Map) JSON.parse(body);
                    if (parse.get("errorMsg") != null) {
                        if (parse.get("status").equals("110034")) {
                            //重复，跳过
                            continue;
                        }
                        ;
                        XxlJobLogger.log(projectData.getProjName() + "同步接口调用失败::::::::" + parse.get("errorMsg"));
                        throw TwException.error("", "同步接口调用失败:" + parse.get("errorMsg"));
                    } else {
                        Map company1 = (Map) parse.get("company");
                        long uId = Long.parseLong(company1.get("uId").toString());
                        //保存关系
                        ProjectBangwo8DO projectBangwo8DO = new ProjectBangwo8DO();
                        projectBangwo8DO.setProjIdV4(projectData.getId());
                        projectBangwo8DO.setProjIdBangwo8(uId);
                        projectBangwo8Repo.save(projectBangwo8DO);
                    }
//                        }
                }
            }
            syncData = "新增了" + insertNum + "条项目数据；更新了" + updateNum + "条项目数据；";
            XxlJobLogger.log(syncData);
        } else {
            syncData = "项目数据未变化";
        }

        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        daoLog.save(logDO);
        log.info("【项目同步，同步日志：{}】", logDO);
        XxlJobLogger.log("同步项目结束..." + logDO);
    }

    @Override
    public void syncAdvisersToBangwo8(String param) {
        XxlJobLogger.log("获取token...");
        String token = getBangwo8Token();
        XxlJobLogger.log("开始查询待更新顾问列表...");
        //用户列表
        String syncType = "bangbwo8_advisers";
        LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        if (localDateTime == null) {
            localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            localDateTime = localDateTime.minusSeconds(180);
        }
        XxlJobLogger.log("顾问同步开始...");
        XxlJobLogger.log("syncUsers localDateTime：" + localDateTime);
        Map<String, Object> map = new HashMap<>();
//        final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        //查询帮我吧顾问的变更的用户列表
        List<Long> bangwo8Advisers = roleDAO.queryUserIdByRoleCodeAndModifyTime("BANGWO8_ADVISERS", localDateTime);
        List<PrdOrgEmployeeVO> prdOrgEmployeeVOS = new ArrayList<>();
        if (!CollectionUtils.isEmpty(bangwo8Advisers)) {
            PrdOrgEmployeeQuery query = new PrdOrgEmployeeQuery();
            query.setUserIds(bangwo8Advisers);
            prdOrgEmployeeVOS = employeeDAO.queryList(query);
        }
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if (!CollectionUtils.isEmpty(prdOrgEmployeeVOS)) {
            Map<Long, Long> collectMap = prdOrgEmployeeVOS.stream().filter(item -> item.getBangwo8AdviserId() != null).collect(HashMap::new, (supportMap, item) -> supportMap.put(item.getId(), item.getBangwo8AdviserId()), HashMap::putAll);
            int insertNum = 0;
            int updateNum = 0;
            int repeatJumpNum = 0;
            int emailErrorNum = 0;
            List<String> newList = new ArrayList<>();
            List<String> repeatJumpItems = new ArrayList<>();
            for (PrdOrgEmployeeVO prdOrgEmployeeVO : prdOrgEmployeeVOS) {
//                if (prdOrgEmployeeVO.getForeignName()==null){continue;}
                JSONObject supportMap = new JSONObject();
                JSONObject support = new JSONObject();
                support.put("name", prdOrgEmployeeVO.getEmployeeName());//客服姓名
                support.put("sNum", prdOrgEmployeeVO.getEmployeeNo());//工号
                if (prdOrgEmployeeVO.getEmail() != null) {
                    String[] split = prdOrgEmployeeVO.getEmail().split("\\.");
                    String loginName = split[0] + split[1].split("@")[0];
                    support.put("sPassportName", loginName);//账号
                } else {
                    //没有email,不继续执行
                    emailErrorNum++;
                    continue;
                }
//                    support.put("password");//密码
                support.put("fixnumber", prdOrgEmployeeVO.getMobile());//固定电话
                support.put("mobile", prdOrgEmployeeVO.getMobile());//手机号
                support.put("email", prdOrgEmployeeVO.getEmail());//邮箱
                support.put("gender", prdOrgEmployeeVO.getSex() == null ? "1" : prdOrgEmployeeVO.getSex().equals("M") ? "2" : "1");//性别1:女；2：男
                support.put("dlxs", prdOrgEmployeeVO.getEqvaRatio());//当量系数
                support.put("gwxs", prdOrgEmployeeVO.getEqvaRatio());//顾问系数
                //调用4.0的接口查询额定当量

//                support.put("ryeddl",prdOrgEmployeeVO.getEqvaRatio());//额定当量
                supportMap.put("support", support);
                Long adviserBangwo8 = collectMap.get(prdOrgEmployeeVO.getId());
                if (adviserBangwo8 != null) {
                    support.put("sPassportName", null);//账号
                    //调用更新接口
                    String body = HttpRequest.put(String.join("", bangwo8Url, bangwo8AdvisersUrl, "/", adviserBangwo8.toString(), ".json"))
                            .body(supportMap.toJSONString())
                            .contentType(ContentType.JSON.toString())
                            .bearerAuth(token)
                            .execute()
                            .body();
                    Map parse = (Map) JSON.parse(body);
                    if (parse.get("errorMsg") != null) {
                        if (parse.get("status").equals("110042")) {
                            // 没有可更改的选项
                            continue;
                        }
                        XxlJobLogger.log(prdOrgEmployeeVO.getEmployeeName() + "同步接口调用失败::::::::" + parse.get("errorMsg"));
                        throw TwException.error("", prdOrgEmployeeVO.getEmployeeName() + "同步接口调用失败::::::" + parse.get("errorMsg"));
                    } else {
                        updateNum++;
                    }
                } else {
                    newList.add(supportMap.get("support").toString());
                    //调用新增接口
                    String body = HttpRequest.post(String.join("", bangwo8Url, bangwo8AdvisersUrl, ".json"))
                            .body(supportMap.toJSONString())
                            .contentType(ContentType.JSON.toString())
                            .bearerAuth(token)
                            .execute()
                            .body();
                    Map parse = (Map) JSON.parse(body);
                    if (parse.get("errorMsg") != null) {
                        if (parse.get("status").equals("110034") || parse.get("status").equals("110037")) {
                            repeatJumpNum++;
                            repeatJumpItems.add(supportMap.get("support").toString());
                            //人员重复，跳过
                            continue;
                        }
                        ;
                        XxlJobLogger.log(prdOrgEmployeeVO.getEmployeeName() + "同步接口调用失败::::::::" + parse.get("errorMsg"));
                        throw TwException.error("", prdOrgEmployeeVO.getEmployeeName() + "同步接口调用失败::::::" + parse.get("errorMsg"));
                    } else {
                        insertNum++;
                        Map support1 = (Map) parse.get("support");
                        long sId = Long.parseLong(support1.get("sId").toString());
                        //保存关系
                        employeeDAO.updateBangwo8AdviserId(prdOrgEmployeeVO.getUserId(), sId);
                    }
                }

            }
            syncData = "顾问列表：" + bangwo8Advisers + "需要新增同步顾问列表：" + newList + "；新增了" + insertNum + "条顾问数据；更新了" + updateNum + "条顾问数据；重复跳过了" + repeatJumpNum + "条顾问数据,跳过条目:::" + repeatJumpItems + ";" + emailErrorNum + "条数据缺少邮箱字段跳过";
            XxlJobLogger.log(syncData);
        } else {
            syncData = "顾问数据未变化";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        daoLog.save(logDO);
        log.info("【顾问同步，同步日志：{}】", logDO);
        XxlJobLogger.log("同步顾问结束..." + logDO);
    }


    /**
     * 从帮我吧同工单（以天为单位同步）
     * https://doc.bangwo8.com/doku.php?id=%E5%B8%AE%E6%88%91%E5%90%A7%E6%96%87%E6%A1%A3:%E6%95%B0%E6%8D%AE%E6%8E%A5%E5%8F%A3:%E5%B7%A5%E5%8D%95:%E5%B7%A5%E5%8D%95#%E8%AF%B7%E6%B1%82%E5%8F%82%E6%95%B01
     *
     * @param date
     */
    @Override
    public void syncTicketsFromBangwo8(LocalDateTime date) {
        String syncType = "bangwo8_tieckets";
        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
        //如果不传日期，就默认以上一次更新时间进行更新，如果传了日期就以当前日期进行更新
        if (date == null) {
            if (syncTime == null) {
                //如果没有，当月1号
                syncTime = LocalDateTime.now().withDayOfMonth(1);
            } else {
                //将同步时间提前10秒，防止拉数据遗漏
                //syncTime = syncTime.minusSeconds(10);
                //历史数据一直遗漏，时间提前一周进行同步
                syncTime = LocalDateTime.now().minusDays(7);
            }
        } else {
            // 以传入日期的0点进行同步
            syncTime = date;
        }
        // 开始处理业务的时间
        LocalDateTime currentTime = LocalDateTime.now();
        String syncData = "";
        XxlJobLogger.log("获取token...");
        String token = getBangwo8Token();
        XxlJobLogger.log("工单同步开始...");
        XxlJobLogger.log("syncTickets localDateTime：" + syncTime);
        int page = 1;
        int totalPage = 1;
        List<TimesheetPayload> timesheetListAll = new ArrayList<>();
        while (page <= totalPage) {
            XxlJobLogger.log("=============================开始拉取第" + page + "页；共" + totalPage + "页");
            //查询帮我吧工单列表
            // String body = HttpRequest.get(String.join("", bangwo8Url, bangwo8TicketsUrl, ".json","?updated_start=", DateUtil.format(syncTime, "yyyy-MM-dd HH:mm:ss"),"&updated_end=2023-12-21 19:20:07&per_page=100&page=",page+""))
            String body = HttpRequest.get(String.join("", bangwo8Url, bangwo8TicketsUrl, ".json","?updated_start=", DateUtil.format(syncTime, "yyyy-MM-dd HH:mm:ss"),"&per_page=100&page=",page+""))
                    // .form("updated_start", syncTime, "per_page", 100, "page", page)
                    .bearerAuth(token)
                    .execute()
                    .body();

            Map parse = (Map) JSON.parse(body);
            if (parse.get("errorMsg") != null) {
                XxlJobLogger.log("同步接口调用失败::::::::" + parse.get("errorMsg"));
                throw TwException.error("", "同步接口调用失败::::::" + parse.get("errorMsg"));
            } else {
                if (ObjectUtils.isEmpty(parse.get("count")) || Double.parseDouble(parse.get("count").toString()) < 1.0) {
                    log.info("帮我吧工时接口获取未获取到需要同步的数据，参数解析后为：{}", parse);
                    PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
                    logDO.setSyncType(syncType);
                    logDO.setSyncData("工时数据未变化"+parse.toString());
                    logDO.setSyncTime(currentTime);
                    daoLog.save(logDO);
                    log.info("【顾问工时同步，同步日志：{}】", logDO);
                    XxlJobLogger.log("同步顾问结束..." + logDO);
                    return;
                }
                totalPage = (int) (Math.ceil(Double.parseDouble(parse.get("count").toString()) / 100));
                page++;
                List<Map<String, Object>> projectList = projectBangwo8Repo.queryBangwo8Projects();
                Map<Long, Long> projectMap = projectList.stream().collect(HashMap::new, (projMap, item) -> projMap.put(Long.parseLong(item.get("projIdBangwo8").toString()), Long.parseLong(item.get("projIdV4").toString())), HashMap::putAll);
                List<PrdOrgEmployeeDO> prdOrgEmployeeDOS = employeeDAO.queryList();
                Map<Long, Long> employeeMap = prdOrgEmployeeDOS.stream().collect(HashMap::new, (empMap, item) -> empMap.put(item.getBangwo8AdviserId(), item.getUserId()), HashMap::putAll);
                List<Map<String, Object>> tickets = (List<Map<String, Object>>) parse.get("tickets");
                System.out.println(tickets);
                TimesheetListPayload timesheetListPayload = new TimesheetListPayload();
                timesheetListPayload.setSubmitted(false);
                List<TimesheetPayload> timesheetList = new ArrayList<>();
                timesheetListPayload.setTimesheetList(timesheetList);
                //遍历工单列表
                for (Map<String, Object> ticket : tickets) {
                    long ticketId = Long.parseLong(ticket.get("ticketId").toString());//工单编码
                    List<Map<String, Object>> customFields = (List<Map<String, Object>>) ticket.get("custom_fields");
                    String except = "";//排除工时
                    Object timesheetMess = null;
                    for (Map<String, Object> customField : customFields) {
                        if (customField.get("key").equals("field_17")) {
                            except = customField.get("value").toString();
                        }
                        if (customField.get("key").equals("field_16")) {
                            timesheetMess = customField.get("value");
                        }
                    }
                    if (!except.equals("4682108")) {
                        if (timesheetMess != null && !timesheetMess.equals("")) {
                            List<Map> timesheetMessList = (List<Map>) timesheetMess;
                            if (!CollectionUtils.isEmpty(timesheetMessList)) {
                                for (Map timesheet : timesheetMessList) {
                                    LocalDate workDate = null;
                                    try {
                                        workDate = LocalDate.parse(timesheet.get("field_1").toString().trim());
                                    } catch (Exception e) {
                                        XxlJobLogger.log("工单日期为空，跳过本条！！！！");
                                        continue;
                                    }
                                    LocalDateTime createTime = null;
                                    if (!ObjectUtils.isEmpty(timesheet.get("create_time"))) {
                                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                                        createTime = LocalDateTime.parse(timesheet.get("create_time").toString().trim(), formatter);
                                    }
                                    // 计算当前条的工时是否需要保存
                                    boolean saveFlag = false;
                                    // 如果工单的创建时间不为空，按照工单的创建时间大于同步时间来处理
                                    if (createTime != null && (createTime.isEqual(syncTime) || createTime.isAfter(syncTime))) {
                                        saveFlag = true;
                                    } else if (workDate != null) {
                                        // 将工作日期定为下一天的零点，保证会将工作日期为今天的所有的工时都同步
                                        LocalDateTime workDateSyncTime = workDate.plusDays(1).atStartOfDay();
                                        // 如果历史数据中没有创建时间呢，按照老的逻辑
                                        if (workDateSyncTime.isAfter(syncTime)) {
                                            saveFlag = true;
                                        }
                                    }
                                    if (saveFlag) {
                                        Object rowId = timesheet.get("rowId");
                                        if (ObjectUtils.isEmpty(timesheet.get("field_2"))) {
                                            XxlJobLogger.log("开始同步工时" + ticketId + "" + rowId + ",工时字段为空，跳过！");
                                            continue;
                                        }
                                        BigDecimal workHour = BigDecimal.valueOf(Double.parseDouble(timesheet.get("field_2").toString()));
                                        // field_3 代表工时同步，其他代表不需要同步
                                        Object field31 = timesheet.get("field_3");
                                        if (null != field31) {
                                            String field3 = field31.toString();
                                            if (!field3.equals("0")) {
                                                XxlJobLogger.log("开始同步工时" + ticketId + "" + rowId + ",工时字段为空，跳过！");
                                                log.info("开始同步工时" + ticketId + "" + rowId + ",工时字段为空，跳过！");
                                                continue;
                                            }
                                        }

//                                        XxlJobLogger.log("开始同步工时"+ticketId + "" + rowId);
                                        // 校验是否已经同步过
                                        int count = timesheetRepo.countByBangwo8NoAndDeleteFlag(Long.parseLong(ticketId + "" + rowId), 0);
                                        if (count < 1) {
                                            XxlJobLogger.log("--------校验为新工时，开始同步工时" + ticketId + "" + rowId);
                                            String custUserId = ticket.get("custUserId").toString();//联系人id
                                            //组装该条工时
                                            //调用联系人接口获取项目id
                                            String user = HttpRequest.get(String.join("", bangwo8Url, bangwo8UsersUrl, "/", custUserId, "_v2.json"))
                                                    .bearerAuth(token)
                                                    .execute()
                                                    .body();
                                            Map userMap = (Map) JSON.parse(user);
                                            if (userMap.get("errorMsg") == null) {
                                                XxlJobLogger.log("联系人接口调用成功！");
                                                //只有调用成功时才保存工时
                                                Map<String, Object> map1 = (Map) userMap.get("user");
                                                if (map1.get("companyId") == null) {
                                                    PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
                                                    logDO.setSyncType(syncType + "_excetion");
                                                    logDO.setSyncData("帮我吧工单查询客户项目失败，跳过此工单工时处理！ ");
                                                    daoLog.save(logDO);
                                                    XxlJobLogger.log("帮我吧工单查询客户项目失败，跳过此工单工时处理！ ");
                                                    continue;
                                                }
                                                Long projIdBangwo8 = Long.parseLong(map1.get("companyId").toString());//项目
                                                //翻译项目和顾问
                                                Long projIdV4 = projectMap.get(projIdBangwo8);
                                                Long tsUserId = employeeMap.get(Long.parseLong(ticket.get("servicerUserId").toString()));//顾问id
                                                if (tsUserId == null) {
                                                    PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
                                                    logDO.setSyncType(syncType + "_excetion");
                                                    logDO.setSyncData("帮我吧工单顾问" + ticket.get("servicerUserId") + "在tw系统不存在，跳过此工单工时处理！");
                                                    daoLog.save(logDO);
                                                    XxlJobLogger.log("帮我吧工单顾问" + ticket.get("servicerUserId") + "在tw系统不存在，跳过此工单工时处理！");
                                                    continue;
                                                }
                                                if (projIdV4 == null) {
                                                    PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
                                                    logDO.setSyncType(syncType + "_excetion");
                                                    logDO.setSyncData("帮我吧工单项目" + projIdBangwo8 + "在tw系统不存在，跳过此工单工时处理！");
                                                    daoLog.save(logDO);
                                                    XxlJobLogger.log("帮我吧工单项目" + projIdBangwo8 + "在tw系统不存在，跳过此工单工时处理！");
                                                    continue;
                                                }
                                                PrdOrgEmployeeDO prdOrgEmployeeDO = employeeDAO.queryByUserId(tsUserId);
                                                String workDesc = ticket.get("subject").toString();//工作内容
                                                //填工时
                                                TimesheetPayload timesheetPayload = new TimesheetPayload();
                                                timesheetPayload.setProjId(projIdV4);
                                                timesheetPayload.setTsUserId(tsUserId);
                                                timesheetPayload.setWorkDate(workDate);
                                                timesheetPayload.setSubmitted(false);
                                                timesheetPayload.setTsStatus("CREATE");
                                                timesheetPayload.setType("DEV_OPS");
                                                timesheetPayload.setWorkDesc(workDesc);
                                                timesheetPayload.setBangwo8No(Long.parseLong(ticketId + "" + rowId));
                                                timesheetPayload.setBangwo8WorkHour(workHour);
                                                timesheetPayload.setTicketUrl("https://issue.elitesland.com/osp2016/agent/ticketView.php?tId=" + ticket.get("ticketId"));//帮我吧工单链接
                                                //注意这里时这个人当天的工时不能超过8小时
//                                            timesheetPayload.setWorkHour(workHour.compareTo(BigDecimal.valueOf(8L))>-1?BigDecimal.valueOf(8):workHour);
                                                timesheetPayload.setWorkHour(workHour);
                                                // 拦截不规范的工时
                                                if (timesheetPayload.getProjId() == null || timesheetPayload.getWorkHour() == null) {
                                                    XxlJobLogger.log("项目id或者工时缺失，不规范，跳过");
                                                    continue;
                                                }
                                                timesheetList.add(timesheetPayload);

                                                //回调帮我吧工时
                                                JSONObject timesheetData = new JSONObject();
                                                JSONObject item_data = new JSONObject();
                                                item_data.put("owner", ticket.get("servicerUserId"));//顾问帮我吧id,
                                                item_data.put("ownerType", "servicer");//固定值，指顾问
                                                item_data.put("ticketId", ticket.get("ticketId"));//工单id
                                                item_data.put("relative_ticket_columnId", "28528665");//固定值，工单资产表字段的唯一标识
                                                item_data.put("field_1", prdOrgEmployeeDO.getEmployeeName());//顾问姓名
                                                item_data.put("field_2", workDate);//日期
                                                item_data.put("field_3", workHour);//工时
                                                item_data.put("field_4", prdOrgEmployeeDO.getEmployeeNo());//顾问工号
                                                item_data.put("field_5", "已同步");//同步标识
                                                item_data.put("tbsj", DateTimeFormatter.ofPattern("yyyy-MM-dd 00:00:00").format(LocalDateTime.now()));//同步日期
                                                timesheetData.put("item_data", item_data);
                                                //回调帮我吧，通知这条工时已经同步
                                                HttpRequest.post(String.join("", bangwo8Url, bangwo8TicketsCallbackUrl, ".json"))
                                                        .body(timesheetData.toJSONString())
                                                        .contentType(ContentType.JSON.toString())
                                                        .bearerAuth(token)
                                                        .execute()
                                                        .body();
                                            } else {
                                                XxlJobLogger.log("联系人接口调用失败，该工时未成功保存：" + userMap.get("errorMsg"));
                                            }
                                            XxlJobLogger.log("--------校验为新工时，结束同步工时" + ticketId + "" + rowId);
                                        }
                                    }
                                }
                            }
                        }

                    }
                }
                //对工时按照填报人进行分组，对分组后的工时进行重新处理，总和不能超过8小时
//                Map<Long, List<TimesheetPayload>> collect = timesheetList.stream().collect(Collectors.groupingBy(TimesheetPayload::getTsUserId));
//                for (Long userId : collect.keySet()) {
//                    List<TimesheetPayload> userTimesheets = collect.get(userId);
//                    // 按照工作日期进行分组
//                    Map<LocalDate, List<TimesheetPayload>> collect1 = userTimesheets.stream().collect(Collectors.groupingBy(TimesheetPayload::getWorkDate));
//                    for (LocalDate workDate : collect1.keySet()) {
//                        List<TimesheetPayload> userWorkDateTimesheets = collect1.get(workDate);
//                        //一个人在一个工作日的工时之和
//                        BigDecimal sum = userWorkDateTimesheets.stream().map(e -> e.getWorkHour()).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
//                        //查询当前用户在当天的已填写工时
//                        BigDecimal workHour = timesheetRepo.queryWorkHour(userId, workDate);
//                        workHour = workHour==null?BigDecimal.ZERO:workHour;
//                        if(sum.add(workHour).compareTo(BigDecimal.valueOf(8))>-1){
//                            //如果已填写工时+同步工时大于了8小时，直接跳过同步
//                            XxlJobLogger.log("工时已经超过8小时，跳过当天工时同步！");
//                            userWorkDateTimesheets.stream().forEach(e->e.setDeleteFlag(1));
//                        }
//                    }
////                    List<TimesheetPayload> timesheetPayloads = collect.get(userId);
////                    BigDecimal sum = timesheetPayloads.stream().map(e -> e.getWorkHour()).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
////                    if(sum.compareTo(BigDecimal.valueOf(8))>-1){
////                        timesheetPayloads.stream().forEach(e->e.setWorkHour(e.getWorkHour().multiply(BigDecimal.valueOf(8L)).divide(sum,5,RoundingMode.HALF_UP).setScale(1,RoundingMode.DOWN)));
////                    }
//                }
//                timesheetList = timesheetList.stream().filter(e-> (e.getDeleteFlag()!=null && e.getDeleteFlag()==1)).collect(Collectors.toList());
                if (!timesheetList.isEmpty()) {
                    timesheetListAll.addAll(timesheetList);
                    timesheetListPayload.setCheckFlag(false);
                    pmsTimesheetService.batchInsert(timesheetListPayload);
                }
            }
            XxlJobLogger.log("============================结束拉取第" + page + "页；共" + totalPage + "页");
        }
        if (timesheetListAll.isEmpty()) {
            syncData = "工时数据未变化";
            XxlJobLogger.log("工时数据未变化");
        } else {
            syncData = "新增了" + timesheetListAll.size() + "条工时数据";
            XxlJobLogger.log("新增了" + timesheetListAll.size() + "条工时数据");
        }
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        log.info("【顾问同步，同步日志：{}】", logDO);
        XxlJobLogger.log("同步顾问结束..." + logDO);
    }

    /**
     * 同步采购合同
     *
     * @param param
     */
    @Override
    public void syncPurchaseContractTo5(String param) {
        String syncType = "purchase_contract";
        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
        if (syncTime == null) {
            syncTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            syncTime = syncTime.minusSeconds(10);
        }
        XxlJobLogger.log("采购合同同步开始...");
        XxlJobLogger.log("syncActivity localDateTime：" + syncTime);
        //同步到5.0
        Map<String, Long> map = new HashMap<>();
        final long asyncTimeLong = syncTime.toEpochSecond(ZoneOffset.of("+8"));
        map.put("asyncTime", asyncTimeLong);
        //更新时间
        LocalDateTime currentTime = LocalDateTime.now();
        XxlJobLogger.log("syncActivity asyncTime：" + asyncTimeLong);
//        String result = httpUtil.sendSyncGet(purchase_contract_to5, map);
//        Map<String, Object> data = (Map) JSONObject.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if ((data.get("ok") + "").equals("true")) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
                Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
                Map<Long, Long> v4AndV5ProjectIds = projectService.getV4AndV5ProjectIds();
                final Object datum = data.get("datum");
                List<Map<String, Object>> purchaseContractDatas = (List<Map<String, Object>>) datum;
                //查询5.0已有的数据，进行更新操作
                List<PurchaseContractManagerDO> oldPurchaseContract = new ArrayList<>();
                //查询5.0已有的数据，对新旧数据进行对比，如有变动，进行更新操作
                List<Long> tw4purchaseContractIds = purchaseContractDatas.stream().map(purchaseContract -> ((Integer) (purchaseContract.get("id") == null ? 0 : purchaseContract.get("id"))).longValue()).collect(Collectors.toList());
                List<PurchaseContractManagerDO> purchaseContractManagerDOS = purchaseContractManagerRepo.queryByPurchaseContractIdV4In(tw4purchaseContractIds);
                for (PurchaseContractManagerDO purchaseContractManagerDO : purchaseContractManagerDOS) {
                    Long purchaseContractIdV4 = purchaseContractManagerDO.getPurchaseContractIdV4();
                    for (Map<String, Object> purchaseContract : purchaseContractDatas) {
                        Long purchaseContractId = ((Integer) (purchaseContract.get("id") == null ? 0 : purchaseContract.get("id"))).longValue();
                        if (purchaseContractId.equals(purchaseContractIdV4)) {
                            //直接将新值覆盖旧值
                            PurchaseContractManagerDO updatedPurchaseContractDo = transPurchaseContractFromV4(purchaseContract, v4AndV5UserIds, v4AndV5OrgIds, v4AndV5ProjectIds);
                            updatedPurchaseContractDo.setId(purchaseContractManagerDO.getId());
                            oldPurchaseContract.add(updatedPurchaseContractDo);
                            break;
                        }
                    }
                }
                if (!oldPurchaseContract.isEmpty()) {
                    purchaseContractManagerRepo.saveAll(oldPurchaseContract);
                }
                List<Map<String, Object>> newPurchaseContractDatas = purchaseContractDatas.stream().filter(timesheet -> {
                    boolean flag = true;
                    Long purchaseContractId = ((Integer) (timesheet.get("id") == null ? 0 : timesheet.get("id"))).longValue();
                    for (PurchaseContractManagerDO purchaseContractManagerDO : purchaseContractManagerDOS) {
                        if (purchaseContractManagerDO.getPurchaseContractIdV4().equals(purchaseContractId)) {
                            flag = false;
                        }
                    }
                    return flag;
                }).collect(Collectors.toList());
                List<PurchaseContractManagerDO> newPurchaseContract = new ArrayList<>();
                //插入新数据
                for (Map<String, Object> newPurchaseContractData : newPurchaseContractDatas) {
                    PurchaseContractManagerDO purchaseContractManagerDO = transPurchaseContractFromV4(newPurchaseContractData, v4AndV5UserIds, v4AndV5OrgIds, v4AndV5ProjectIds);
                    newPurchaseContract.add(purchaseContractManagerDO);
                }
                purchaseContractManagerRepo.saveAll(newPurchaseContract);
                syncData = "更新了" + oldPurchaseContract.size() + "条数据;新增了" + newPurchaseContract.size() + "条数据";
            } else {
                syncData = "采购合同数据未变化";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        log.info("【采购合同同步，同步日志：{}】", logDO);
        XxlJobLogger.log("采购合同同步结束..." + logDO);
    }


    /**
     * tw4.0翻译成5.0的采购合同
     *
     * @param purchaseContractData 4.0源数据
     * @param orgDataMap           tw4.0和5.0对应关系组织id
     * @param userDataMap          tw4.0和5.0对应关系用户id
     * @param projDataMap          tw4.0和5.0对应关系项目id
     */
    public PurchaseContractManagerDO transPurchaseContractFromV4(Map<String, Object> purchaseContractData, Map<Long, Long> userDataMap, Map<Long, Long> orgDataMap, Map<Long, Long> projDataMap) {
        // relatedProjectId 关联项目id
        // purchaseBuId 采购BU
        // purchaseInchargeResId  采购负责人(要在4.0翻译成user)
        // relatedSalesContract  关联销售合同--不用转换，直接在4.0那边处理好同步过来
        PurchaseContractManagerDO purchaseContractManagerDO = BeanUtil.mapToBean(PurchaseContractManagerDO.class, purchaseContractData, Arrays.asList("id"));
        if (purchaseContractData.get("id") != null) {
            purchaseContractManagerDO.setPurchaseContractIdV4(Long.valueOf((Integer) purchaseContractData.get("id")));
        }
        if (purchaseContractData.get("contractName") != null) {
            purchaseContractManagerDO.setPurchaseContractName(purchaseContractData.get("contractName").toString());
        }
        if (purchaseContractData.get("contractNo") != null) {
            purchaseContractManagerDO.setPurchaseContractNo(purchaseContractData.get("contractNo").toString());
        }
        if (purchaseContractData.get("purchaseType") != null) {
            purchaseContractManagerDO.setPurchaseContractType(purchaseContractData.get("purchaseType").toString());
        }

        if (purchaseContractData.get("relatedProjectId") != null) {
            Long relatedProjectId = Long.valueOf((Integer) purchaseContractData.get("relatedProjectId"));
            purchaseContractManagerDO.setRelatedProjectId(projDataMap.get(relatedProjectId));
        }
        if (purchaseContractData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) purchaseContractData.get("createUserId"));
            purchaseContractManagerDO.setCreateUserId(userDataMap.get(createUserId));
        }
        if (purchaseContractData.get("modifyUserId") != null) {
            Long modifyUserId = Long.valueOf((Integer) purchaseContractData.get("modifyUserId"));
            purchaseContractManagerDO.setModifyUserId(userDataMap.get(modifyUserId));
        }
        if (purchaseContractData.get("purchaseBuId") != null) {
            Long purchaseBuId = Long.valueOf((Integer) purchaseContractData.get("purchaseBuId"));
            purchaseContractManagerDO.setPurchaseBuId(orgDataMap.get(purchaseBuId));
        }
        if (purchaseContractData.get("purchaseInchargeResId") != null) {
            Long inchargeResId = Long.valueOf((Integer) purchaseContractData.get("purchaseInchargeResId"));
            purchaseContractManagerDO.setPurchaseInchargeResId(userDataMap.get(inchargeResId));
        }
        if (purchaseContractData.get("delFlag") != null) {
            Integer delFlag = (Integer) purchaseContractData.get("delFlag");
            purchaseContractManagerDO.setDeleteFlag(delFlag);
        }
        // 很奇怪的报错，data too long!
        if (purchaseContractManagerDO.getRemark() != null && purchaseContractManagerDO.getRemark().length() > 200) {
            purchaseContractManagerDO.setRemark(purchaseContractManagerDO.getRemark().substring(0, 200));
        }
        return purchaseContractManagerDO;
    }


//    /**
//     * 同步采购合同明细
//     *
//     * @param param
//     */
//    @Override
//    public void syncPurchaseContractDetailTo5(String param) {
//        String syncType = "purchase_contract_detail";
//        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
//        if (syncTime == null) {
//            syncTime = LocalDateTime.of(1970, 1, 1, 0, 0);
//        } else {
//            //将同步时间提前10秒，防止拉数据遗漏
//            syncTime = syncTime.minusSeconds(10);
//        }
//        XxlJobLogger.log("采购合同明细同步开始...");
//        XxlJobLogger.log("syncActivity localDateTime：" + syncTime);
//        //同步到5.0
//        Map<String, Long> map = new HashMap<>();
//        final long asyncTimeLong = syncTime.toEpochSecond(ZoneOffset.of("+8"));
//        map.put("asyncTime", asyncTimeLong);
//        //更新时间
//        LocalDateTime currentTime = LocalDateTime.now();
//        XxlJobLogger.log("syncActivity asyncTime：" + asyncTimeLong);
////        String result = httpUtil.sendSyncGet(purchase_contract_detail_to5, map);
////        Map<String, Object> data = (Map) JSONObject.parse(result);
//        Map<String, Object> data = new HashMap<>();
//        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
//        String syncData = "";
//        if ((data.get("ok") + "").equals("true")) {
//            if (!ObjectUtils.isEmpty(data.get("datum"))) {
//                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
//                Map<Long, Long> v4AndV5ProductIds = purchaseContractManagerRepo.findAll().stream().collect(Collectors.toMap(PurchaseContractManagerDO::getPurchaseContractIdV4, PurchaseContractManagerDO::getId, (key1, key2) -> key2));
//                Map<Long, Long> v4AndV5PurchaseContractIds = purchaseContractManagerRepo.findAll().stream().collect(Collectors.toMap(PurchaseContractManagerDO::getPurchaseContractIdV4, PurchaseContractManagerDO::getId, (key1, key2) -> key2));
//                final Object datum = data.get("datum");
//                List<Map<String, Object>> purchaseContractDetailDatas = (List<Map<String, Object>>) datum;
//                //查询5.0已有的数据，进行更新操作
//                List<PurchaseContractDetailsDO> oldPurchaseContractDetail = new ArrayList<>();
//                //查询5.0已有的数据，对新旧数据进行对比，如有变动，进行更新操作
//                List<Long> tw4purchaseContractDetailIds = purchaseContractDetailDatas.stream().map(purchaseContractDetail -> ((Integer) (purchaseContractDetail.get("id") == null ? 0 : purchaseContractDetail.get("id"))).longValue()).collect(Collectors.toList());
//                List<PurchaseContractDetailsDO> purchaseContractDetailsDOS = purchaseContractDetailsRepo.queryByPurchaseContractDetailIdV4In(tw4purchaseContractDetailIds);
//                for (PurchaseContractDetailsDO purchaseContractDetailsDO : purchaseContractDetailsDOS) {
//                    Long purchaseContractDetailIdV4 = purchaseContractDetailsDO.getPurchaseContractDetailIdV4();
//                    for (Map<String, Object> purchaseContractDetail : purchaseContractDetailDatas) {
//                        Long purchaseContractDetailId = ((Integer) (purchaseContractDetail.get("id") == null ? 0 : purchaseContractDetail.get("id"))).longValue();
//                        if (purchaseContractDetailId.equals(purchaseContractDetailIdV4)) {
//                            //直接将新值覆盖旧值
//                            PurchaseContractDetailsDO updatedPurchaseContractDetailDo = transPurchaseContractDetailFromV4(purchaseContractDetail, v4AndV5UserIds, v4AndV5ProductIds, v4AndV5PurchaseContractIds);
//                            updatedPurchaseContractDetailDo.setId(purchaseContractDetailsDO.getId());
//                            oldPurchaseContractDetail.add(updatedPurchaseContractDetailDo);
//                            break;
//                        }
//                    }
//                }
//                if (!oldPurchaseContractDetail.isEmpty()) {
//                    purchaseContractDetailsRepo.saveAll(oldPurchaseContractDetail);
//                }
//                List<Map<String, Object>> newPurchaseContractDetailDatas = purchaseContractDetailDatas.stream().filter(timesheet -> {
//                    boolean flag = true;
//                    Long purchaseContractId = ((Integer) (timesheet.get("id") == null ? 0 : timesheet.get("id"))).longValue();
//                    for (PurchaseContractDetailsDO purchaseContractDetailsDO : purchaseContractDetailsDOS) {
//                        if (purchaseContractDetailsDO.getPurchaseContractDetailIdV4().equals(purchaseContractId)) {
//                            flag = false;
//                        }
//                    }
//                    return flag;
//                }).collect(Collectors.toList());
//                List<PurchaseContractDetailsDO> newPurchaseContractDetail = new ArrayList<>();
//                //插入新数据
//                for (Map<String, Object> newPurchaseContractData : newPurchaseContractDetailDatas) {
//                    PurchaseContractDetailsDO purchaseContractDetailsDO = transPurchaseContractDetailFromV4(newPurchaseContractData, v4AndV5UserIds, v4AndV5ProductIds, v4AndV5PurchaseContractIds);
//                    newPurchaseContractDetail.add(purchaseContractDetailsDO);
//                }
//                purchaseContractDetailsRepo.saveAll(newPurchaseContractDetail);
//                syncData = "更新了" + oldPurchaseContractDetail.size() + "条数据;新增了" + newPurchaseContractDetail.size() + "条数据";
//            } else {
//                syncData = "采购合同明细数据未变化";
//            }
//        } else {
//            syncData = data.get("reason") + "";
//        }
//        logDO.setSyncType(syncType);
//        logDO.setSyncData(syncData);
//        logDO.setSyncTime(currentTime);
//        daoLog.save(logDO);
//        log.info("【采购合同明细同步，同步日志：{}】", logDO);
//        XxlJobLogger.log("采购合同明细同步结束..." + logDO);
//    }


    /**
     * tw4.0翻译成5.0的采购合同
     *
     * @param purchaseContractDetailsData 4.0源数据
     * @param v4AndV5ProductIds           tw4.0和5.0对应关系产品id
     * @param userDataMap                 tw4.0和5.0对应关系用户id
     * @param v4AndV5PurchaseContractIds  tw4.0和5.0对应关系销售合同id
     */
    public PurchaseContractDetailsDO transPurchaseContractDetailFromV4(Map<String, Object> purchaseContractDetailsData, Map<Long, Long> userDataMap, Map<Long, Long> v4AndV5ProductIds, Map<Long, Long> v4AndV5PurchaseContractIds) {
        // relatedProductId 关联产品
        // purchaseContractId 采购合同id
        PurchaseContractDetailsDO purchaseContractDetailsDO = BeanUtil.mapToBean(PurchaseContractDetailsDO.class, purchaseContractDetailsData, Arrays.asList("id"));
        if (purchaseContractDetailsData.get("id") != null) {
            purchaseContractDetailsDO.setPurchaseContractDetailIdV4(Long.valueOf((Integer) purchaseContractDetailsData.get("id")));
        }
//        if (purchaseContractDetailsData.get("contractId") != null) {
//            purchaseContractDetailsDO.setPurchaseContractId(Long.valueOf((Integer) purchaseContractDetailsData.get("contractId")));
//        }
        if (purchaseContractDetailsData.get("contractNo") != null) {
            purchaseContractDetailsDO.setPurchaseContractNo(purchaseContractDetailsData.get("contractNo").toString());
        }
        if (purchaseContractDetailsData.get("relatedProductId") != null) {
            Long relatedProductId = Long.valueOf((Integer) purchaseContractDetailsData.get("relatedProductId"));
            purchaseContractDetailsDO.setRelatedProductId(v4AndV5ProductIds.get(relatedProductId));
        }
        if (purchaseContractDetailsData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) purchaseContractDetailsData.get("createUserId"));
            purchaseContractDetailsDO.setCreateUserId(userDataMap.get(createUserId));
        }
        if (purchaseContractDetailsData.get("modifyUserId") != null) {
            Long modifyUserId = Long.valueOf((Integer) purchaseContractDetailsData.get("modifyUserId"));
            purchaseContractDetailsDO.setModifyUserId(userDataMap.get(modifyUserId));
        }
        if (purchaseContractDetailsData.get("contractId") != null) {
            Long purchaseContractId = Long.valueOf((Integer) purchaseContractDetailsData.get("contractId"));
            purchaseContractDetailsDO.setPurchaseContractId(v4AndV5PurchaseContractIds.get(purchaseContractId));
        }
        if (purchaseContractDetailsData.get("delFlag") != null) {
            Integer delFlag = (Integer) purchaseContractDetailsData.get("delFlag");
            purchaseContractDetailsDO.setDeleteFlag(delFlag);
        }
        if (purchaseContractDetailsData.get("deliveryDate") != null) {
            purchaseContractDetailsDO.setDeliveryDate(Convert.convert(LocalDateTime.class, LocalDate.parse(purchaseContractDetailsData.get("deliveryDate").toString())));
        }
        return purchaseContractDetailsDO;
    }


    /**
     * 财务期间同步定时任务
     *
     * @param param
     */
    @Override
    public void syncFinYearTo5(String param) {
        String syncType = "fin_year";
        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
        if (syncTime == null) {
            syncTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            syncTime = syncTime.minusSeconds(10);
        }
        XxlJobLogger.log("财务期间同步开始...");
        XxlJobLogger.log("syncFinYear localDateTime：" + syncTime);
        //同步到5.0
        Map<String, Long> map = new HashMap<>();
        final long asyncTimeLong = syncTime.toEpochSecond(ZoneOffset.of("+8"));
        map.put("asyncTime", asyncTimeLong);
        //更新时间
        LocalDateTime currentTime = LocalDateTime.now();
        XxlJobLogger.log("syncFinYear asyncTime：" + asyncTimeLong);
//        String result = httpUtil.sendSyncGet(fin_year_to5, map);
//        Map<String, Object> data = (Map) JSONObject.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if ((data.get("ok") + "").equals("true")) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
                final Object datum = data.get("datum");
                List<Map<String, Object>> finYearDatas = (List<Map<String, Object>>) datum;
                //查询5.0已有的数据，进行更新操作
                List<PrdSystemFinYearDO> oldFinYear = new ArrayList<>();
                //查询5.0已有的数据，对新旧数据进行对比，如有变动，进行更新操作
                List<Long> tw4FinYearIds = finYearDatas.stream().map(purchaseContract -> ((Integer) (purchaseContract.get("id") == null ? 0 : purchaseContract.get("id"))).longValue()).collect(Collectors.toList());
                List<PrdSystemFinYearDO> finYearDos = finYearRepo.findByFinYearIdV4In(tw4FinYearIds);
                for (PrdSystemFinYearDO finYearDO : finYearDos) {
                    Long finYearIdV4 = finYearDO.getFinYearIdV4();
                    for (Map<String, Object> finYear : finYearDatas) {
                        Long finYearId = ((Integer) (finYear.get("id") == null ? 0 : finYear.get("id"))).longValue();
                        if (finYearId.equals(finYearIdV4)) {
                            //直接将新值覆盖旧值
                            PrdSystemFinYearDO updatedFinYearDo = transFinYearFromV4(finYear, v4AndV5UserIds);
                            updatedFinYearDo.setId(updatedFinYearDo.getId());
                            oldFinYear.add(updatedFinYearDo);
                            break;
                        }
                    }
                }
                if (!oldFinYear.isEmpty()) {
                    finYearRepo.saveAll(oldFinYear);
                }
                List<Map<String, Object>> newFinYearDatas = finYearDatas.stream().filter(timesheet -> {
                    boolean flag = true;
                    Long finYearId = ((Integer) (timesheet.get("id") == null ? 0 : timesheet.get("id"))).longValue();
                    for (PrdSystemFinYearDO finYearDO : finYearDos) {
                        if (finYearDO.getFinYearIdV4().equals(finYearId)) {
                            flag = false;
                        }
                    }
                    return flag;
                }).collect(Collectors.toList());
                List<PrdSystemFinYearDO> newFinYear = new ArrayList<>();
                //插入新数据
                for (Map<String, Object> newPurchaseContractData : newFinYearDatas) {
                    PrdSystemFinYearDO finYearDO = transFinYearFromV4(newPurchaseContractData, v4AndV5UserIds);
                    newFinYear.add(finYearDO);
                }
                finYearRepo.saveAll(newFinYear);
                syncData = "更新了" + oldFinYear.size() + "条数据;新增了" + newFinYear.size() + "条数据";
            } else {
                syncData = "财务年度数据未变化";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        log.info("【财务年度同步，同步日志：{}】", logDO);
        XxlJobLogger.log("财务年度同步结束..." + logDO);
    }

    /**
     * tw4.0翻译成5.0的财务期间
     */
    public PrdSystemFinYearDO transFinYearFromV4(Map<String, Object> finYearData, Map<Long, Long> userDataMap) {
        PrdSystemFinYearDO finYearDO = BeanUtil.mapToBean(PrdSystemFinYearDO.class, finYearData, Arrays.asList("id"));
        if (finYearData.get("id") != null) {
            finYearDO.setFinYearIdV4(Long.valueOf((Integer) finYearData.get("id")));
        }
        if (finYearData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) finYearData.get("createUserId"));
            finYearDO.setCreateUserId(userDataMap.get(createUserId));
        }
        if (finYearData.get("modifyUserId") != null) {
            Long modifyUserId = Long.valueOf((Integer) finYearData.get("modifyUserId"));
            finYearDO.setModifyUserId(userDataMap.get(modifyUserId));
        }
        if (finYearData.get("delFlag") != null) {
            Integer delFlag = (Integer) finYearData.get("delFlag");
            finYearDO.setDeleteFlag(delFlag);
        }
        return finYearDO;
    }


    /**
     * 财务期间同步定时任务
     *
     * @param param
     */
    @Override
    public void syncFinPeriodTo5(String param) {
        String syncType = "fin_period";
        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
        if (syncTime == null) {
            syncTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            syncTime = syncTime.minusSeconds(10);
        }
        XxlJobLogger.log("财务期间同步开始...");
        XxlJobLogger.log("syncFinPeriod localDateTime：" + syncTime);
        //同步到5.0
        Map<String, Long> map = new HashMap<>();
        final long asyncTimeLong = syncTime.toEpochSecond(ZoneOffset.of("+8"));
        map.put("asyncTime", asyncTimeLong);
        //更新时间
        LocalDateTime currentTime = LocalDateTime.now();
        XxlJobLogger.log("syncFinPeriod asyncTime：" + asyncTimeLong);
//        String result = httpUtil.sendSyncGet(fin_period_to5, map);
//        Map<String, Object> data = (Map) JSONObject.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if ((data.get("ok") + "").equals("true")) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
                Map<Long, Long> v4AndV5FinYearIds = finYearRepo.findAll().stream().collect(Collectors.toMap(PrdSystemFinYearDO::getFinYearIdV4, PrdSystemFinYearDO::getId, (key1, key2) -> key2));
//                Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
//                Map<Long, Long> v4AndV5ProjectIds = projectService.getV4AndV5ProjectIds();
                final Object datum = data.get("datum");
                List<Map<String, Object>> finPeriodDatas = (List<Map<String, Object>>) datum;
                //查询5.0已有的数据，进行更新操作
                List<PrdSystemFinPeriodDO> oldFinPeriod = new ArrayList<>();
                //查询5.0已有的数据，对新旧数据进行对比，如有变动，进行更新操作
                List<Long> tw4FinPeriodIds = finPeriodDatas.stream().map(purchaseContract -> ((Integer) (purchaseContract.get("id") == null ? 0 : purchaseContract.get("id"))).longValue()).collect(Collectors.toList());
                List<PrdSystemFinPeriodDO> finPeriodDos = finPeriodRepo.findByFinPeriodIdV4In(tw4FinPeriodIds);
                for (PrdSystemFinPeriodDO finPeriodDO : finPeriodDos) {
                    Long finPeriodIdV4 = finPeriodDO.getFinPeriodIdV4();
                    for (Map<String, Object> finPeriod : finPeriodDatas) {
                        Long finPeriodId = ((Integer) (finPeriod.get("id") == null ? 0 : finPeriod.get("id"))).longValue();
                        if (finPeriodId.equals(finPeriodIdV4)) {
                            //直接将新值覆盖旧值
                            PrdSystemFinPeriodDO updatedFinPeriodDo = transFinPeriodFromV4(finPeriod, v4AndV5UserIds, v4AndV5FinYearIds);
                            updatedFinPeriodDo.setId(updatedFinPeriodDo.getId());
                            oldFinPeriod.add(updatedFinPeriodDo);
                            break;
                        }
                    }
                }
                if (!oldFinPeriod.isEmpty()) {
                    finPeriodRepo.saveAll(oldFinPeriod);
                }
                List<Map<String, Object>> newFinPeriodDatas = finPeriodDatas.stream().filter(timesheet -> {
                    boolean flag = true;
                    Long finPeriodId = ((Integer) (timesheet.get("id") == null ? 0 : timesheet.get("id"))).longValue();
                    for (PrdSystemFinPeriodDO finPeriodDO : finPeriodDos) {
                        if (finPeriodDO.getFinPeriodIdV4().equals(finPeriodId)) {
                            flag = false;
                        }
                    }
                    return flag;
                }).collect(Collectors.toList());
                List<PrdSystemFinPeriodDO> newFinPeriod = new ArrayList<>();
                //插入新数据
                for (Map<String, Object> newPurchaseContractData : newFinPeriodDatas) {
                    PrdSystemFinPeriodDO finPeriodDO = transFinPeriodFromV4(newPurchaseContractData, v4AndV5UserIds, v4AndV5FinYearIds);
                    newFinPeriod.add(finPeriodDO);
                }
                finPeriodRepo.saveAll(newFinPeriod);
                syncData = "更新了" + oldFinPeriod.size() + "条数据;新增了" + newFinPeriod.size() + "条数据";
            } else {
                syncData = "财务期间数据未变化";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        log.info("【财务期间同步，同步日志：{}】", logDO);
        XxlJobLogger.log("财务期间同步结束..." + logDO);
    }

    /**
     * tw4.0翻译成5.0的财务期间
     */
    public PrdSystemFinPeriodDO transFinPeriodFromV4(Map<String, Object> finPeriodData, Map<Long, Long> userDataMap, Map<Long, Long> finYearMap) {
        PrdSystemFinPeriodDO finPeriodDO = BeanUtil.mapToBean(PrdSystemFinPeriodDO.class, finPeriodData, Arrays.asList("id"));
        if (finPeriodData.get("id") != null) {
            finPeriodDO.setFinPeriodIdV4(Long.valueOf((Integer) finPeriodData.get("id")));
        }
        if (finPeriodData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) finPeriodData.get("createUserId"));
            finPeriodDO.setCreateUserId(userDataMap.get(createUserId));
        }
        if (finPeriodData.get("modifyUserId") != null) {
            Long modifyUserId = Long.valueOf((Integer) finPeriodData.get("modifyUserId"));
            finPeriodDO.setModifyUserId(userDataMap.get(modifyUserId));
        }
        if (finPeriodData.get("finYearId") != null) {
            Long finYearId = Long.valueOf((Integer) finPeriodData.get("finYearId"));
            finPeriodDO.setFinYearId(finYearMap.get(finYearId));
        }
        if (finPeriodData.get("delFlag") != null) {
            Integer delFlag = (Integer) finPeriodData.get("delFlag");
            finPeriodDO.setDeleteFlag(delFlag);
        }
        return finPeriodDO;
    }


    /**
     * 产品分类同步定时任务
     *
     * @param param
     */
    @Override
    public void syncProductClassTo5(String param) {
        String syncType = "product-class";
        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
        if (syncTime == null) {
            syncTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            syncTime = syncTime.minusSeconds(10);
        }
        XxlJobLogger.log("产品分类同步开始...");
        XxlJobLogger.log("syncProductClass localDateTime：" + syncTime);
        //同步到5.0
        Map<String, Long> map = new HashMap<>();
        final long asyncTimeLong = syncTime.toEpochSecond(ZoneOffset.of("+8"));
        map.put("asyncTime", asyncTimeLong);
        //更新时间
        LocalDateTime currentTime = LocalDateTime.now();
        XxlJobLogger.log("syncProductClass asyncTime：" + asyncTimeLong);
//        String result = httpUtil.sendSyncGet(product_class_to5, map);
//        Map<String, Object> data = (Map) JSONObject.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if ((data.get("ok") + "").equals("true")) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
                Map<Long, Long> v4AndV5ProductClassIds = productClassRepo.findAll().stream().collect(Collectors.toMap(PrdProductClassDO::getProductClassIdV4, PrdProductClassDO::getId, (key1, key2) -> key2));
//                Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
//                Map<Long, Long> v4AndV5ProjectIds = projectService.getV4AndV5ProjectIds();
                final Object datum = data.get("datum");
                List<Map<String, Object>> productClassDatas = (List<Map<String, Object>>) datum;
                //查询5.0已有的数据，进行更新操作
                List<PrdProductClassDO> oldProductClass = new ArrayList<>();
                //查询5.0已有的数据，对新旧数据进行对比，如有变动，进行更新操作
                List<Long> tw4ProductClassIds = productClassDatas.stream().map(purchaseContract -> ((Integer) (purchaseContract.get("id") == null ? 0 : purchaseContract.get("id"))).longValue()).collect(Collectors.toList());
                List<PrdProductClassDO> productClassDos = productClassRepo.findByProductClassIdV4In(tw4ProductClassIds);
                for (PrdProductClassDO productClassDO : productClassDos) {
                    Long productClassIdV4 = productClassDO.getProductClassIdV4();
                    for (Map<String, Object> productClass : productClassDatas) {
                        Long productClassId = ((Integer) (productClass.get("id") == null ? 0 : productClass.get("id"))).longValue();
                        if (productClassId.equals(productClassIdV4)) {
                            //直接将新值覆盖旧值
                            PrdProductClassDO updatedProductClassDo = transProductClassFromV4(productClass, v4AndV5UserIds, v4AndV5ProductClassIds);
                            updatedProductClassDo.setId(updatedProductClassDo.getId());
                            oldProductClass.add(updatedProductClassDo);
                            break;
                        }
                    }
                }
                if (!oldProductClass.isEmpty()) {
                    productClassRepo.saveAll(oldProductClass);
                }
                List<Map<String, Object>> newProductClassDatas = productClassDatas.stream().filter(timesheet -> {
                    boolean flag = true;
                    Long productClassId = ((Integer) (timesheet.get("id") == null ? 0 : timesheet.get("id"))).longValue();
                    for (PrdProductClassDO productClassDO : productClassDos) {
                        if (productClassDO.getProductClassIdV4().equals(productClassId)) {
                            flag = false;
                        }
                    }
                    return flag;
                }).collect(Collectors.toList());
                List<PrdProductClassDO> newProductClass = new ArrayList<>();
                //插入新数据
                for (Map<String, Object> newPurchaseContractData : newProductClassDatas) {
                    PrdProductClassDO productClassDO = transProductClassFromV4(newPurchaseContractData, v4AndV5UserIds, v4AndV5ProductClassIds);
                    newProductClass.add(productClassDO);
                }
                productClassRepo.saveAll(newProductClass);
                syncData = "更新了" + oldProductClass.size() + "条数据;新增了" + newProductClass.size() + "条数据";
                List<PrdProductClassDO> collect = oldProductClass.stream().filter(e -> e.getSeniorId() == null).collect(Collectors.toList());
                List<PrdProductClassDO> collect1 = newProductClass.stream().filter(e -> e.getSeniorId() == null).collect(Collectors.toList());
                collect.addAll(collect1);
                // 重新查询一遍
                v4AndV5ProductClassIds = productClassRepo.findAll().stream().collect(Collectors.toMap(PrdProductClassDO::getProductClassIdV4, PrdProductClassDO::getId, (key1, key2) -> key2));
                for (PrdProductClassDO prdProductClassDO : collect) {
                    prdProductClassDO.setSeniorId(v4AndV5ProductClassIds.get(prdProductClassDO.getSeniorId()));
                }
                productClassRepo.saveAll(collect);

            } else {
                syncData = "产品分类数据未变化";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        // 同步完成后，重新匹配一遍

        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        log.info("【产品分类同步，同步日志：{}】", logDO);
        XxlJobLogger.log("产品分类同步结束..." + logDO);
    }

    /**
     * tw4.0翻译成5.0的产品分类
     */
    public PrdProductClassDO transProductClassFromV4(Map<String, Object> productClassData, Map<Long, Long> userDataMap, Map<Long, Long> productClassMap) {
        PrdProductClassDO productClassDO = BeanUtil.mapToBean(PrdProductClassDO.class, productClassData, Arrays.asList("id"));
        if (productClassData.get("id") != null) {
            productClassDO.setProductClassIdV4(Long.valueOf((Integer) productClassData.get("id")));
        }
        if (productClassData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) productClassData.get("createUserId"));
            productClassDO.setCreateUserId(userDataMap.get(createUserId));
        }
        if (productClassData.get("modifyUserId") != null) {
            Long modifyUserId = Long.valueOf((Integer) productClassData.get("modifyUserId"));
            productClassDO.setModifyUserId(userDataMap.get(modifyUserId));
        }
        // 如果是一批的，如何处理
        if (productClassData.get("seniorId") != null) {
            Long seniorId = Long.valueOf((Integer) productClassData.get("seniorId"));
            productClassDO.setSeniorId(productClassMap.get(seniorId));
        }
        if (productClassData.get("delFlag") != null) {
            Integer delFlag = (Integer) productClassData.get("delFlag");
            productClassDO.setDeleteFlag(delFlag);
        }
        return productClassDO;
    }


    /**
     * 产品同步定时任务（对应4.0 T_BU_PROD）
     *
     * @param param
     */
    @Override
    public void syncProductTo5(String param) {
        String syncType = "product";
        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
        if (syncTime == null) {
            syncTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            syncTime = syncTime.minusSeconds(10);
        }
        XxlJobLogger.log("产品同步开始...");
        XxlJobLogger.log("syncProduct localDateTime：" + syncTime);
        //同步到5.0
        Map<String, Long> map = new HashMap<>();
        final long asyncTimeLong = syncTime.toEpochSecond(ZoneOffset.of("+8"));
        map.put("asyncTime", asyncTimeLong);
        //更新时间
        LocalDateTime currentTime = LocalDateTime.now();
        XxlJobLogger.log("syncProduct asyncTime：" + asyncTimeLong);
//        String result = httpUtil.sendSyncGet(product_to5, map);
//        Map<String, Object> data = (Map) JSONObject.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if ((data.get("ok") + "").equals("true")) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
                Map<Long, Long> v4AndV5ProductClassIds = productClassRepo.findAll().stream().collect(Collectors.toMap(PrdProductClassDO::getProductClassIdV4, PrdProductClassDO::getId, (key1, key2) -> key2));
                Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
//                Map<Long, Long> v4AndV5ProjectIds = projectService.getV4AndV5ProjectIds();
                final Object datum = data.get("datum");
                List<Map<String, Object>> productDatas = (List<Map<String, Object>>) datum;
                //查询5.0已有的数据，进行更新操作
                List<PrdProductDO> oldProduct = new ArrayList<>();
                //查询5.0已有的数据，对新旧数据进行对比，如有变动，进行更新操作
                List<Long> tw4ProductIds = productDatas.stream().map(purchaseContract -> ((Integer) (purchaseContract.get("id") == null ? 0 : purchaseContract.get("id"))).longValue()).collect(Collectors.toList());
                List<PrdProductDO> productDos = prdProductRepo.findByProductIdV4In(tw4ProductIds);
                for (PrdProductDO productDO : productDos) {
                    Long productIdV4 = productDO.getProductIdV4();
                    for (Map<String, Object> product : productDatas) {
                        Long productId = ((Integer) (product.get("id") == null ? 0 : product.get("id"))).longValue();
                        if (productId.equals(productIdV4)) {
                            //直接将新值覆盖旧值
                            PrdProductDO updatedProductDo = transProductFromV4(product, v4AndV5UserIds, v4AndV5OrgIds, v4AndV5ProductClassIds);
                            updatedProductDo.setId(updatedProductDo.getId());
                            oldProduct.add(updatedProductDo);
                            break;
                        }
                    }
                }
                if (!oldProduct.isEmpty()) {
                    prdProductRepo.saveAll(oldProduct);
                }
                List<Map<String, Object>> newProductDatas = productDatas.stream().filter(timesheet -> {
                    boolean flag = true;
                    Long productId = ((Integer) (timesheet.get("id") == null ? 0 : timesheet.get("id"))).longValue();
                    for (PrdProductDO productDO : productDos) {
                        if (productDO.getProductIdV4().equals(productId)) {
                            flag = false;
                        }
                    }
                    return flag;
                }).collect(Collectors.toList());
                List<PrdProductDO> newProduct = new ArrayList<>();
                //插入新数据
                for (Map<String, Object> newPurchaseContractData : newProductDatas) {
                    PrdProductDO productDO = transProductFromV4(newPurchaseContractData, v4AndV5UserIds, v4AndV5OrgIds, v4AndV5ProductClassIds);
                    newProduct.add(productDO);
                }
                prdProductRepo.saveAll(newProduct);
                syncData = "更新了" + oldProduct.size() + "条数据;新增了" + newProduct.size() + "条数据";
            } else {
                syncData = "产品数据未变化";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        log.info("【产品同步，同步日志：{}】", logDO);
        XxlJobLogger.log("产品同步结束..." + logDO);
    }

    /**
     * tw4.0翻译成5.0的产品
     * picResId在4.0要翻译成user
     */
    public PrdProductDO transProductFromV4(Map<String, Object> productData, Map<Long, Long> userDataMap, Map<Long, Long> buDataMap, Map<Long, Long> productClassMap) {
        PrdProductDO productDO = BeanUtil.mapToBean(PrdProductDO.class, productData, Arrays.asList("id"));
        if (productData.get("id") != null) {
            productDO.setProductIdV4(Long.valueOf((Integer) productData.get("id")));
        }
        if (productData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) productData.get("createUserId"));
            productDO.setCreateUserId(userDataMap.get(createUserId));
        }
        if (productData.get("modifyUserId") != null) {
            Long modifyUserId = Long.valueOf((Integer) productData.get("modifyUserId"));
            productDO.setModifyUserId(userDataMap.get(modifyUserId));
        }
        if (productData.get("classId") != null) {
            Long classId = Long.valueOf((Integer) productData.get("classId"));
            productDO.setClassId(productClassMap.get(classId));
        }
        if (productData.get("subClassId") != null) {
            Long subClassId = Long.parseLong(productData.get("subClassId").toString());
            productDO.setSubClassId(productClassMap.get(subClassId));
        }
        if (productData.get("buId") != null) {
            Long buId = Long.valueOf((Integer) productData.get("buId"));
            productDO.setBuId(buDataMap.get(buId));
        }
        if (productData.get("picResId") != null) {
            Long picResId = Long.valueOf((Integer) productData.get("picResId"));
            productDO.setPicResId(userDataMap.get(picResId));
        }
        if (productData.get("delFlag") != null) {
            Integer delFlag = (Integer) productData.get("delFlag");
            productDO.setDeleteFlag(delFlag);
        }
        return productDO;
    }


//    /**
//     * 地址簿同步定时任务（对应4.0 T_BU_PROD）
//     *
//     * @param param
//     */
//    @Override
//    public void syncAbTo5(String param) {
//        String syncType = "ab";
//        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
//        if (syncTime == null) {
//            syncTime = LocalDateTime.of(1970, 1, 1, 0, 0);
//        } else {
//            //将同步时间提前10秒，防止拉数据遗漏
//            syncTime = syncTime.minusSeconds(10);
//        }
//        XxlJobLogger.log("地址簿同步开始...");
//        XxlJobLogger.log("syncAb localDateTime：" + syncTime);
//        //同步到5.0
//        Map<String, Long> map = new HashMap<>();
//        final long asyncTimeLong = syncTime.toEpochSecond(ZoneOffset.of("+8"));
//        map.put("asyncTime", asyncTimeLong);
//        //更新时间
//        LocalDateTime currentTime = LocalDateTime.now();
//        XxlJobLogger.log("syncAb asyncTime：" + asyncTimeLong);
////        String result = httpUtil.sendSyncGet(ab_to5, map);
////        Map<String, Object> data = (Map) JSONObject.parse(result);
//        Map<String, Object> data = new HashMap<>();
//        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
//        String syncData = "";
//        if ((data.get("ok") + "").equals("true")) {
//            if (!ObjectUtils.isEmpty(data.get("datum"))) {
//                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
//                Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
////                Map<Long, Long> v4AndV5AbIds = prdAbRepo.findAll().stream().collect(Collectors.toMap(PrdAbDO::getBookIdV4, PrdAbDO::getId, (key1, key2) -> key2));
//                final Object datum = data.get("datum");
//                List<Map<String, Object>> abDatas = (List<Map<String, Object>>) datum;
//                //查询5.0已有的数据，进行更新操作
//                List<PrdAbDO> oldAb = new ArrayList<>();
//                //查询5.0已有的数据，对新旧数据进行对比，如有变动，进行更新操作
//                List<Long> tw4AbIds = abDatas.stream().map(ab -> ((Integer) (ab.get("id") == null ? 0 : ab.get("id"))).longValue()).collect(Collectors.toList());
//                List<PrdAbDO> abDos = prdAbRepo.findByBookIdV4In(tw4AbIds);
//                for (PrdAbDO abDO : abDos) {
//                    Long abIdV4 = abDO.getBookIdV4();
//                    for (Map<String, Object> ab : abDatas) {
//                        Long abId = ((Integer) (ab.get("id") == null ? 0 : ab.get("id"))).longValue();
//                        if (abId.equals(abIdV4)) {
//                            //直接将新值覆盖旧值
//                            PrdAbDO updatedAbDo = transAbFromV4(ab, v4AndV5UserIds, v4AndV5OrgIds);
//                            updatedAbDo.setId(abDO.getId());
//                            oldAb.add(updatedAbDo);
//                            break;
//                        }
//                    }
//                }
//                if (!oldAb.isEmpty()) {
//                    prdAbRepo.saveAll(oldAb);
//                }
//                List<Map<String, Object>> newAbDatas = abDatas.stream().filter(timesheet -> {
//                    boolean flag = true;
//                    Long abId = ((Integer) (timesheet.get("id") == null ? 0 : timesheet.get("id"))).longValue();
//                    for (PrdAbDO abDO : abDos) {
//                        if (abDO.getBookIdV4().equals(abId)) {
//                            flag = false;
//                        }
//                    }
//                    return flag;
//                }).collect(Collectors.toList());
//                List<PrdAbDO> newAb = new ArrayList<>();
//                //插入新数据
//                for (Map<String, Object> newPurchaseContractData : newAbDatas) {
//                    PrdAbDO abDO = transAbFromV4(newPurchaseContractData, v4AndV5UserIds, v4AndV5OrgIds);
//                    newAb.add(abDO);
//                }
//                prdAbRepo.saveAll(newAb);
//                syncData = "更新了" + oldAb.size() + "条数据;新增了" + newAb.size() + "条数据";
//            } else {
//                syncData = "地址簿数据未变化";
//            }
//        } else {
//            syncData = data.get("reason") + "";
//        }
//        logDO.setSyncType(syncType);
//        logDO.setSyncData(syncData);
//        logDO.setSyncTime(currentTime);
//        daoLog.save(logDO);
//        log.info("【地址簿同步，同步日志：{}】", logDO);
//        XxlJobLogger.log("地址簿同步结束..." + logDO);
//    }

//    /**
//     * tw4.0翻译成5.0的地址簿
//     * picResId在4.0要翻译成user
//     */
//    public PrdAbDO transAbFromV4(Map<String, Object> abData, Map<Long, Long> userDataMap, Map<Long, Long> buDataMap) {
//        PrdAbDO abDO = BeanUtil.mapToBean(PrdAbDO.class, abData, Arrays.asList("id"));
//        if (abData.get("id") != null) {
//            abDO.setBookIdV4(Long.valueOf((Integer) abData.get("id")));
//        }
//        // 地址簿绑定用户id
//        if (abData.get("userId") != null) {
//            Long userId = Long.valueOf((Integer) abData.get("userId"));
//            abDO.setUserId(userDataMap.get(userId));
//        }
//        if (abData.get("createUserId") != null) {
//            Long createUserId = Long.valueOf((Integer) abData.get("createUserId"));
//            abDO.setCreateUserId(userDataMap.get(createUserId));
//        }
//        if (abData.get("modifyUserId") != null) {
//            Long modifyUserId = Long.valueOf((Integer) abData.get("modifyUserId"));
//            abDO.setModifyUserId(userDataMap.get(modifyUserId));
//        }
//        if (abData.get("delFlag") != null) {
//            Integer delFlag = (Integer) abData.get("delFlag");
//            abDO.setDeleteFlag(delFlag);
//        }
//        if (abData.get("relateType") != null) {
//            String relateType = (String) abData.get("relateType");
//            relateType = relateType.replace("01", "customer").replace("02", "supplier").replace("03", "partner");
//            if (abDO.getBookIdV4() != null) {
//                List<PrdAbDO> byBookIdV4In = prdAbRepo.findByBookIdV4In(Collections.singletonList(abDO.getBookIdV4()));
//                if (!CollectionUtils.isEmpty(byBookIdV4In)) {
//                    PrdAbDO prdAbDO = byBookIdV4In.get(0);
//                    String relateType1 = prdAbDO.getRelateType();
//                    if (StringUtils.hasText(relateType1) && relateType1.contains("intercompany")) {
//                        relateType = relateType + ",intercompany";
//                    }
//                }
//            }
//            abDO.setRelateType(relateType);
//        }
//        if (abData.get("abNo") != null) {
//            abDO.setBookNo(abData.get("abNo").toString());
//        }
//        if (abData.get("abName") != null) {
//            abDO.setBookName(abData.get("abName").toString());
//        }
//        if (abData.get("abType") != null) {
//            String abType = (String) abData.get("abType");
//            if (!ObjectUtils.isEmpty(abType)) {
//                abType = abType.replace("01", "personal").replace("02", "company");
//            }
//            abDO.setBookType(abType);
//        }
//        return abDO;
//    }


    /**
     * 业绩统计同步定时任务
     *
     * @param param
     */
    @Override
    public void syncContractAchieveTo5(String param) {
        String syncType = "contractAchieve";
        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
        XxlJobLogger.log("业绩统计同步开始...");
        XxlJobLogger.log("syncContractAchieve localDateTime：" + syncTime);
        //同步到5.0
        Map<String, Long> map = new HashMap<>();
        //更新时间
        LocalDateTime currentTime = LocalDateTime.now();
//        String result = httpUtil.sendSyncGet(contract_achieve_to5, new HashMap<>());
//        Map<String, Object> data = (Map) JSONObject.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if ((data.get("ok") + "").equals("true")) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                final Object datum = data.get("datum");
                List<Map<String, Object>> contractAchieveDatas = (List<Map<String, Object>>) datum;
//                for (Map<String, Object> contractAchieve : contractAchieveDatas) {
//                    contractAchieve.put("new",true);
//                }
                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
                Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
                transContractAchieveFromV4AndSave(contractAchieveDatas, v4AndV5UserIds, v4AndV5OrgIds);
                syncData = "同步了" + contractAchieveDatas.size() + "条数据";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        log.info("【业绩统计同步，同步日志：{}】", logDO);
        XxlJobLogger.log("业绩统计同步结束..." + logDO);
    }

    /**
     * tw4.0翻译成5.0的业绩统计
     * picResId在4.0要翻译成user
     */
    public void transContractAchieveFromV4AndSave(List<Map<String, Object>> contractAchieveDataList, Map<Long, Long> userDataMap, Map<Long, Long> buDataMap) {
        // 按照合同id进行分组
        Map<Long, List<Map<String, Object>>> achieveMap = contractAchieveDataList.stream().collect(Collectors.groupingBy((Map a) -> Long.parseLong(a.get("contractId").toString())));
        for (Long aLong : achieveMap.keySet()) {
            List<Map<String, Object>> maps = achieveMap.get(aLong);
            Map<String, Object> contractAchieveDataMain = maps.get(0);
            ConAchieveDO contractAchieveDO = BeanUtil.mapToBean(ConAchieveDO.class, contractAchieveDataMain, new ArrayList<>());
            if (contractAchieveDataMain.get("effectiveAmt") != null) {
                contractAchieveDO.setObversionEffectiveAmt(BigDecimal.valueOf(Double.parseDouble(contractAchieveDataMain.get("effectiveAmt").toString())));
            }
            if (contractAchieveDataMain.get("new") != null && contractAchieveDataMain.get("new").equals(true)) {
                contractAchieveDO.setAchieveIdV4(Long.valueOf((Integer) contractAchieveDataMain.get("id")));
//            conAchieveDDO.setAchieveId(v4AndV5AchieveIds.get(Long.valueOf((Integer) contractAchieveData.get("id"))));
            }
            if (contractAchieveDataMain.get("createUserId") != null) {
                Long createUserId = Long.valueOf((Integer) contractAchieveDataMain.get("createUserId"));
                contractAchieveDO.setCreateUserId(userDataMap.get(createUserId));
            }
            if (contractAchieveDataMain.get("modifyUserId") != null) {
                Long modifyUserId = Long.valueOf((Integer) contractAchieveDataMain.get("modifyUserId"));
                contractAchieveDO.setModifyUserId(userDataMap.get(modifyUserId));
            }
            if (contractAchieveDataMain.get("delFlag") != null) {
                Integer delFlag = (Integer) contractAchieveDataMain.get("delFlag");
                contractAchieveDO.setDeleteFlag(delFlag);
            }
            // 保存主表
            ConAchieveDO save = conAchieveRepo.save(contractAchieveDO);
            for (Map<String, Object> contractAchieveDataDetail : maps) {
                ConAchieveDDO conAchieveDDO = BeanUtil.mapToBean(ConAchieveDDO.class, contractAchieveDataDetail, Arrays.asList("id"));
                // 保存子表
                conAchieveDDO.setAchieveId(save.getId());
                if (contractAchieveDataDetail.get("id") != null) {
                    conAchieveDDO.setAchievedIdV4(Long.parseLong(contractAchieveDataDetail.get("id").toString()));
                }
                if (contractAchieveDataDetail.get("createUserId") != null) {
                    Long createUserId = Long.valueOf((Integer) contractAchieveDataDetail.get("createUserId"));
                    conAchieveDDO.setCreateUserId(userDataMap.get(createUserId));
                }
                if (contractAchieveDataDetail.get("modifyUserId") != null) {
                    Long modifyUserId = Long.valueOf((Integer) contractAchieveDataDetail.get("modifyUserId"));
                    conAchieveDDO.setModifyUserId(userDataMap.get(modifyUserId));
                }
                if (contractAchieveDataDetail.get("delFlag") != null) {
                    Integer delFlag = (Integer) contractAchieveDataDetail.get("delFlag");
                    conAchieveDDO.setDeleteFlag(delFlag);
                }
                if (contractAchieveDataDetail.get("countType") != null) {
                    String achieveType = contractAchieveDataDetail.get("countType").toString();
                    conAchieveDDO.setAchieveType(achieveType);
                }
                if (contractAchieveDataDetail.get("buId") != null) {
                    Long buId = Long.valueOf((Integer) contractAchieveDataDetail.get("buId"));
                    conAchieveDDO.setBuId(buDataMap.get(buId));
                }
                if (contractAchieveDataDetail.get("chargeResId") != null) {
                    Long chargeResId = Long.valueOf((Integer) contractAchieveDataDetail.get("chargeResId"));
                    conAchieveDDO.setChargeResId(userDataMap.get(chargeResId));
                }
                // 保存子表
                conAchieveDRepo.save(conAchieveDDO);
            }
        }
    }


    /**
     * 收款计划同步定时任务
     *
     * @param param
     */
    @Override
    public void syncReceivePlanTo5(String param) {
        String syncType = "receivePlan";
        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
        XxlJobLogger.log("收款计划同步开始...");
        XxlJobLogger.log("syncReceivePlan localDateTime：" + syncTime);
        //更新时间
        LocalDateTime currentTime = LocalDateTime.now();
        //同步到5.0
        Map<String, Long> map = new HashMap<>();
        final long asyncTimeLong = currentTime.toEpochSecond(ZoneOffset.of("+8"));
        map.put("syncTime", asyncTimeLong);
//        String result = httpUtil.sendSyncGet(receive_plan_to5, map);
//        Map<String, Object> data = (Map) JSONObject.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if ((data.get("ok") + "").equals("true")) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
                Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
                final Object datum = data.get("datum");
                List<ConReceivablePlanDO> receivablePlanDOList = new ArrayList<>();
                List<Map<String, Object>> receivePlanDatas = (List<Map<String, Object>>) datum;
                for (Map<String, Object> receivePlan : receivePlanDatas) {
                    ConReceivablePlanDO receivablePlanDO = transReceivePlanFromV4(receivePlan, v4AndV5UserIds, v4AndV5OrgIds);
                    receivablePlanDOList.add(receivablePlanDO);
                }
                receivablePlanRepo.saveAll(receivablePlanDOList);
                syncData = "同步了" + receivePlanDatas.size() + "条数据";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        log.info("【收款计划同步，同步日志：{}】", logDO);
        XxlJobLogger.log("收款计划同步结束..." + logDO);
    }

    /**
     * tw4.0翻译成5.0的收款计划
     * picResId在4.0要翻译成user
     */
    public ConReceivablePlanDO transReceivePlanFromV4(Map<String, Object> receivePlanData, Map<Long, Long> userDataMap, Map<Long, Long> buDataMap) {
        ConReceivablePlanDO receivePlanDO = BeanUtil.mapToBean(ConReceivablePlanDO.class, receivePlanData, new ArrayList<>());
        if (receivePlanData.get("id") != null) {
            receivePlanDO.setReceivePlanIdV4(Long.valueOf((Integer) receivePlanData.get("id")));
            Long recvPlanIdV4 = Long.valueOf((Integer) receivePlanData.get("id"));
            ConReceivablePlanDO byReceivePlanIdV4 = receivablePlanRepo.findByReceivePlanIdV4(recvPlanIdV4);
            if (byReceivePlanIdV4 != null) {
                receivePlanDO.setId(byReceivePlanIdV4.getId());
            }
        }
        // 这种是5.0的数据同步到4.0的情况
        if (receivePlanData.get("recvplanIdV5") != null) {
            //5.0收款计划明细id
            receivePlanDO.setId((Long) receivePlanData.get("recvplanIdV5"));
        }
        if (receivePlanData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) receivePlanData.get("createUserId"));
            receivePlanDO.setCreateUserId(userDataMap.get(createUserId));
        }
        if (receivePlanData.get("modifyUserId") != null) {
            Long modifyUserId = Long.valueOf((Integer) receivePlanData.get("modifyUserId"));
            receivePlanDO.setModifyUserId(userDataMap.get(modifyUserId));
        }
        if (receivePlanData.get("delFlag") != null) {
            Integer delFlag = (Integer) receivePlanData.get("delFlag");
            receivePlanDO.setDeleteFlag(delFlag);
        }
        if (receivePlanData.get("batchStatus") != null) {
            String batchStatus = receivePlanData.get("batchStatus").toString();
            batchStatus = BatchStatusEnum.getByCode(batchStatus).getDesc();
            receivePlanDO.setInvStatus(batchStatus);
        }
        if (receivePlanData.get("phaseDesc") != null) {
            String phaseDesc = receivePlanData.get("phaseDesc").toString();
            receivePlanDO.setReceStage(phaseDesc);
        }
        // 当期收款比例要乘以100
        if (!ObjectUtils.isEmpty(receivePlanData.get("receRatio"))) {
            BigDecimal receRatio = (BigDecimal) receivePlanData.get("receRatio");
            receivePlanDO.setReceRatio(receRatio.multiply(BigDecimal.valueOf(100L)));
        }
        // 实际收款日期 actualReceDate
        if (!ObjectUtils.isEmpty(receivePlanData.get("actualRecvDate"))) {
            LocalDate actualRecvDate = LocalDate.parse(receivePlanData.get("actualRecvDate").toString());
            receivePlanDO.setActualReceDate(actualRecvDate);
        }
        return receivePlanDO;
    }


    /**
     * 合同开票单次同步
     *
     * @param param
     */
    @Override
    public void syncInvBatchTo5(String param) {
        String syncType = "invBatch";
        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
        XxlJobLogger.log("合同开票同步开始...");
        XxlJobLogger.log("syncReceivePlan localDateTime：" + syncTime);
        //更新时间
        LocalDateTime currentTime = LocalDateTime.now();
        //同步到5.0
        Map<String, Long> map = new HashMap<>();
        final long asyncTimeLong = LocalDateTime.parse(param).toEpochSecond(ZoneOffset.of("+8"));
        map.put("syncTime", asyncTimeLong);
//        String result = httpUtil.sendSyncGet(inv_batch_to5, map);//每次同步上次未同步过的但是符合条件的数据
//        Map<String, Object> data = (Map) JSONObject.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if ((data.get("ok") + "").equals("true")) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
                Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
                final Object datum = data.get("datum");
                List<ConInvBatchDO> invBatchDOList = new ArrayList<>();
                List<Map<String, Object>> invBatchDatas = (List<Map<String, Object>>) datum;
                for (Map<String, Object> invBatch : invBatchDatas) {
                    //特殊字段处理
                    if (!ObjectUtils.isEmpty(invBatch.get("taxRate"))) {
                        invBatch.put("taxRate", new BigDecimal(invBatch.get("taxRate").toString()));
                    }
                    if (!ObjectUtils.isEmpty(invBatch.get("createTime"))) {
                        invBatch.put("createTime", LocalDate.parse(invBatch.get("createTime").toString()).atStartOfDay());
                    }
                    ConInvBatchDO invBatchDO = transInvBatchFromV4(invBatch, v4AndV5UserIds, v4AndV5OrgIds);
                    invBatchDOList.add(invBatchDO);
                }
                conInvBatchRepo.saveAll(invBatchDOList);
                syncData = "同步了" + invBatchDOList.size() + "条数据";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        log.info("【合同开票同步，同步日志：{}】", logDO);
        XxlJobLogger.log("合同开票同步结束..." + logDO);
    }

    /**
     * tw4.0翻译成5.0的合同开票
     * picResId在4.0要翻译成user
     */
    public ConInvBatchDO transInvBatchFromV4(Map<String, Object> invBatchData, Map<Long, Long> userDataMap, Map<Long, Long> buDataMap) {
        ConInvBatchDO conInvBatchDO = BeanUtil.mapToBean(ConInvBatchDO.class, invBatchData, new ArrayList<>());
        if (invBatchData.get("id") != null) {
            conInvBatchDO.setInvBatchIdV4(Long.valueOf((Integer) invBatchData.get("id")));
        }
        if (invBatchData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) invBatchData.get("createUserId"));
            conInvBatchDO.setCreateUserId(userDataMap.get(createUserId));
        }
        if (invBatchData.get("modifyUserId") != null) {
            Long modifyUserId = Long.valueOf((Integer) invBatchData.get("modifyUserId"));
            conInvBatchDO.setModifyUserId(userDataMap.get(modifyUserId));
        }
        if (invBatchData.get("delFlag") != null) {
            Integer delFlag = (Integer) invBatchData.get("delFlag");
            conInvBatchDO.setDeleteFlag(delFlag);
        }
        return conInvBatchDO;
    }


    /**
     * 合同开票发票单次同步
     *
     * @param param
     */
    @Override
    public void syncInvBatchInvdtlTo5(String param) {
        String syncType = "invBatchInvdtl";
        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
        XxlJobLogger.log("合同开票发票同步开始...");
        XxlJobLogger.log("syncReceivePlan localDateTime：" + syncTime);
        //更新时间
        LocalDateTime currentTime = LocalDateTime.now();
        //同步到5.0
        Map<String, Long> map = new HashMap<>();
        final long asyncTimeLong = LocalDateTime.parse(param).toEpochSecond(ZoneOffset.of("+8"));
        map.put("syncTime", asyncTimeLong);
//        String result = httpUtil.sendSyncGet(inv_batch_invdtl_to5, map);//每次同步上次未同步过的但是符合条件的数据
//        Map<String, Object> data = (Map) JSONObject.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if ((data.get("ok") + "").equals("true")) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
                Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
                final Object datum = data.get("datum");
                List<ConInvBatchInvdtlDO> invBatchinvdtlDOList = new ArrayList<>();
                List<Map<String, Object>> invBatchinvdtlDatas = (List<Map<String, Object>>) datum;
                for (Map<String, Object> invBatchinvdtl : invBatchinvdtlDatas) {
                    ConInvBatchInvdtlDO invBatchinvdtlDO = transInvBatchInvdtlFromV4(invBatchinvdtl, v4AndV5UserIds, v4AndV5OrgIds);
                    invBatchinvdtlDOList.add(invBatchinvdtlDO);
                }
                invBatchInvdtlRepo.saveAll(invBatchinvdtlDOList);
                syncData = "同步了" + invBatchinvdtlDOList.size() + "条数据";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        log.info("【合同开票发票同步，同步日志：{}】", logDO);
        XxlJobLogger.log("合同开票发票同步结束..." + logDO);
    }

    /**
     * tw4.0翻译成5.0的收款计划
     * picResId在4.0要翻译成user
     */
    public ConInvBatchInvdtlDO transInvBatchInvdtlFromV4(Map<String, Object> invBatchInvdtlData, Map<Long, Long> userDataMap, Map<Long, Long> buDataMap) {
        ConInvBatchInvdtlDO conInvBatchInvdtlDO = BeanUtil.mapToBean(ConInvBatchInvdtlDO.class, invBatchInvdtlData, new ArrayList<>());
        if (invBatchInvdtlData.get("id") != null) {
            conInvBatchInvdtlDO.setInvBatchInvdtlIdV4(Long.valueOf((Integer) invBatchInvdtlData.get("id")));
        }
        if (invBatchInvdtlData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) invBatchInvdtlData.get("createUserId"));
            conInvBatchInvdtlDO.setCreateUserId(userDataMap.get(createUserId));
        }
        if (invBatchInvdtlData.get("modifyUserId") != null) {
            Long modifyUserId = Long.valueOf((Integer) invBatchInvdtlData.get("modifyUserId"));
            conInvBatchInvdtlDO.setModifyUserId(userDataMap.get(modifyUserId));
        }
        if (invBatchInvdtlData.get("delFlag") != null) {
            Integer delFlag = (Integer) invBatchInvdtlData.get("delFlag");
            conInvBatchInvdtlDO.setDeleteFlag(delFlag);
        }
        return conInvBatchInvdtlDO;
    }


//    /**
//     * 采购需求同步定时任务
//     *
//     * @param param
//     */
//    @Override
//    public void syncPurchaseDemandTo5(String param) {
//        String syncType = "purchaseDemand";
//        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
//        XxlJobLogger.log("采购需求同步开始...");
//        XxlJobLogger.log("syncPurchaseDemand localDateTime：" + syncTime);
//        //同步到5.0
//        Map<String, Long> map = new HashMap<>();
//        //更新时间
//        LocalDateTime currentTime = LocalDateTime.now();
////        String result = httpUtil.sendSyncGet(purchase_demand_to5, new HashMap<>());
////        Map<String, Object> data = (Map) JSONObject.parse(result);
//        Map<String, Object> data = new HashMap<>();
//        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
//        String syncData = "";
//        if ((data.get("ok") + "").equals("true")) {
//            if (!ObjectUtils.isEmpty(data.get("datum"))) {
//                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
//                final Object datum = data.get("datum");
//                List<ConPurchaseDemandDO> receivablePlanDOList = new ArrayList<>();
//                List<Map<String, Object>> purchaseDemandDatas = (List<Map<String, Object>>) datum;
//                for (Map<String, Object> purchaseDemand : purchaseDemandDatas) {
//                    ConPurchaseDemandDO purchaseDemandDO = transPurchaseDemandFromV4(purchaseDemand, v4AndV5UserIds);
//                    receivablePlanDOList.add(purchaseDemandDO);
//                }
//                purchaseDemandRepo.saveAll(receivablePlanDOList);
//                syncData = "同步了" + purchaseDemandDatas.size() + "条数据";
//            }
//        } else {
//            syncData = data.get("reason") + "";
//        }
//        logDO.setSyncType(syncType);
//        logDO.setSyncData(syncData);
//        logDO.setSyncTime(currentTime);
//        daoLog.save(logDO);
//        log.info("【采购需求同步，同步日志：{}】", logDO);
//        XxlJobLogger.log("采购需求同步结束..." + logDO);
//    }

//    /**
//     * tw4.0翻译成5.0的采购需求
//     * picResId在4.0要翻译成user
//     */
//    public ConPurchaseDemandDO transPurchaseDemandFromV4(Map<String, Object> purchaseDemandData, Map<Long, Long> userDataMap) {
//        ConPurchaseDemandDO purchaseDemandDO = BeanUtil.mapToBean(ConPurchaseDemandDO.class, purchaseDemandData, new ArrayList<>());
//        if (purchaseDemandData.get("id") != null) {
//            purchaseDemandDO.setPurDemandIdV4(Long.valueOf((Integer) purchaseDemandData.get("id")));
//        }
//        if (purchaseDemandData.get("createUserId") != null) {
//            Long createUserId = Long.valueOf((Integer) purchaseDemandData.get("createUserId"));
//            purchaseDemandDO.setCreateUserId(userDataMap.get(createUserId));
//        }
//        if (purchaseDemandData.get("modifyUserId") != null) {
//            Long modifyUserId = Long.valueOf((Integer) purchaseDemandData.get("modifyUserId"));
//            purchaseDemandDO.setModifyUserId(userDataMap.get(modifyUserId));
//        }
//        if (purchaseDemandData.get("delFlag") != null) {
//            Integer delFlag = (Integer) purchaseDemandData.get("delFlag");
//            purchaseDemandDO.setDeleteFlag(delFlag);
//        }
//        return purchaseDemandDO;
//    }


//    /**
//     * 采购需求同步定时任务
//     *
//     * @param param
//     */
//    @Override
//    public void syncPurchaseDemandDetailTo5(String param) {
//        String syncType = "purchaseDemandDetail";
//        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
//        XxlJobLogger.log("采购需求同步开始...");
//        XxlJobLogger.log("syncPurchaseDemandDetail localDateTime：" + syncTime);
//        //同步到5.0
//        Map<String, Long> map = new HashMap<>();
//        //更新时间
//        LocalDateTime currentTime = LocalDateTime.now();
////        String result = httpUtil.sendSyncGet(purchase_demand_detail_to5, new HashMap<>());
////        Map<String, Object> data = (Map) JSONObject.parse(result);
//        Map<String, Object> data = new HashMap<>();
//        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
//        String syncData = "";
//        if ((data.get("ok") + "").equals("true")) {
//            if (!ObjectUtils.isEmpty(data.get("datum"))) {
//                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
//                Map<Long, Long> v4AndV5PurchaseContractIds = purchaseContractManagerRepo.findAll().stream().collect(Collectors.toMap(PurchaseContractManagerDO::getPurchaseContractIdV4, PurchaseContractManagerDO::getId, (key1, key2) -> key2));
//                Map<Long, Long> v4AndV5ProductClassIds = productClassRepo.findAll().stream().collect(Collectors.toMap(PrdProductClassDO::getProductClassIdV4, PrdProductClassDO::getId, (key1, key2) -> key2));
//                Map<Long, Long> v4AndV5ProductIds = prdProductRepo.findAll().stream().collect(Collectors.toMap(PrdProductDO::getProductIdV4, PrdProductDO::getId, (key1, key2) -> key2));
//                Map<Long, Long> v4AndV5SupplierIds = prdAbRepo.findAll().stream().collect(Collectors.toMap(PrdAbDO::getBookIdV4, PrdAbDO::getId, (key1, key2) -> key2));
//                Map<Long, Long> v4AndV5PurDemandIds = purchaseDemandRepo.findAll().stream().collect(Collectors.toMap(ConPurchaseDemandDO::getPurDemandIdV4, ConPurchaseDemandDO::getId, (key1, key2) -> key2));
//
//                final Object datum = data.get("datum");
//                List<ConPurchaseDemandDDO> receivablePlanDOList = new ArrayList<>();
//                List<Map<String, Object>> purchaseDemandDetailDatas = (List<Map<String, Object>>) datum;
//                for (Map<String, Object> purchaseDemandDetail : purchaseDemandDetailDatas) {
//                    ConPurchaseDemandDDO receivablePlanDO = transPurchaseDemandDetailFromV4(purchaseDemandDetail, v4AndV5UserIds, v4AndV5PurchaseContractIds, v4AndV5ProductClassIds, v4AndV5ProductIds, v4AndV5SupplierIds, v4AndV5PurDemandIds);
//                    receivablePlanDOList.add(receivablePlanDO);
//                }
//                purchaseDemandDRepo.saveAll(receivablePlanDOList);
//                syncData = "同步了" + purchaseDemandDetailDatas.size() + "条数据";
//            }
//        } else {
//            syncData = data.get("reason") + "";
//        }
//        logDO.setSyncType(syncType);
//        logDO.setSyncData(syncData);
//        logDO.setSyncTime(currentTime);
//        daoLog.save(logDO);
//        log.info("【采购需求同步，同步日志：{}】", logDO);
//        XxlJobLogger.log("采购需求同步结束..." + logDO);
//    }

    /**
     * tw4.0翻译成5.0的采购需求
     * picResId在4.0要翻译成user
     */
    public ConPurchaseDemandDDO transPurchaseDemandDetailFromV4(Map<String, Object> purchaseDemandDetailData, Map<Long, Long> userDataMap, Map<Long, Long> v4AndV5PurchaseContractIds, Map<Long, Long> v4AndV5ProductClassIds, Map<Long, Long> v4AndV5ProductIds, Map<Long, Long> v4AndV5SupplierIds, Map<Long, Long> v4AndV5PurDemandIds) {
        ConPurchaseDemandDDO purchaseDemandDetailDO = BeanUtil.mapToBean(ConPurchaseDemandDDO.class, purchaseDemandDetailData, new ArrayList<>());
        if (purchaseDemandDetailData.get("id") != null) {
            purchaseDemandDetailDO.setDemandDetailIdV4(Long.valueOf((Integer) purchaseDemandDetailData.get("id")));
        }
        if (purchaseDemandDetailData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) purchaseDemandDetailData.get("createUserId"));
            purchaseDemandDetailDO.setCreateUserId(userDataMap.get(createUserId));
        }
        if (purchaseDemandDetailData.get("modifyUserId") != null) {
            Long modifyUserId = Long.valueOf((Integer) purchaseDemandDetailData.get("modifyUserId"));
            purchaseDemandDetailDO.setModifyUserId(userDataMap.get(modifyUserId));
        }
        if (purchaseDemandDetailData.get("delFlag") != null) {
            Integer delFlag = (Integer) purchaseDemandDetailData.get("delFlag");
            purchaseDemandDetailDO.setDeleteFlag(delFlag);
        }
        if (purchaseDemandDetailData.get("purContractId") != null) {
            Long purContractId = Long.valueOf((Integer) purchaseDemandDetailData.get("purContractId"));
            Long purContractIdV5 = v4AndV5PurchaseContractIds.get(purContractId);
            purchaseDemandDetailDO.setPurContractId(purContractIdV5);
        }
        // 采购大类
        if (purchaseDemandDetailData.get("productClassId") != null) {
            Long productClassId = Long.valueOf((Integer) purchaseDemandDetailData.get("productClassId"));
            productClassId = v4AndV5ProductClassIds.get(productClassId);
            purchaseDemandDetailDO.setProductClassId(productClassId);
        }
        // 采购小类
        if (purchaseDemandDetailData.get("productSubClassId") != null) {
            Long productSubClassId = Long.valueOf((Integer) purchaseDemandDetailData.get("productSubClassId"));
            productSubClassId = v4AndV5ProductClassIds.get(productSubClassId);
            purchaseDemandDetailDO.setProductSubClassId(productSubClassId);
        }
        // 需求日期
        if (purchaseDemandDetailData.get("demandDate") != null) {
            purchaseDemandDetailDO.setDemandDate(LocalDate.parse(purchaseDemandDetailData.get("demandDate").toString().substring(0, 10)));
        }
        // 关联产品
        if (purchaseDemandDetailData.get("productId") != null) {
            Long productId = Long.valueOf((Integer) purchaseDemandDetailData.get("productId"));
            productId = v4AndV5ProductIds.get(productId);
            purchaseDemandDetailDO.setProductId(productId);
        }
        if (purchaseDemandDetailData.get("demandDirectorUserId") != null) {
            Long demandDirectorUserId = Long.valueOf((Integer) purchaseDemandDetailData.get("demandDirectorUserId"));
            purchaseDemandDetailDO.setDemandDirectorUserId(userDataMap.get(demandDirectorUserId));
        }
        // 供应商
        if (purchaseDemandDetailData.get("supplierId") != null) {
            Long supplierId = Long.valueOf((Integer) purchaseDemandDetailData.get("supplierId"));
            if (supplierId != null && v4AndV5SupplierIds.get(supplierId) != null) {
                purchaseDemandDetailDO.setSupplierId(Long.parseLong(v4AndV5SupplierIds.get(supplierId).toString()));
            }
        }
        if (purchaseDemandDetailData.get("purDemandId") != null) {
            Long purDemandId = Long.valueOf((Integer) purchaseDemandDetailData.get("purDemandId"));
            purchaseDemandDetailDO.setPurDemandId(v4AndV5PurDemandIds.get(purDemandId));
        }
        if (purchaseDemandDetailData.get("taxRate") != null) {
            BigDecimal taxRate = BigDecimal.valueOf(Double.parseDouble(purchaseDemandDetailData.get("taxRate").toString()));
            purchaseDemandDetailDO.setTaxRate(taxRate.divide(BigDecimal.valueOf(100L)));
        }
        return purchaseDemandDetailDO;
    }


    /**
     * 外包费用同步定时任务
     *
     * @param param
     */
    @Override
    public void syncChannelCostConTo5(String param) {
        String syncType = "channelCost";
        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
        XxlJobLogger.log("外包费用同步开始...");
        XxlJobLogger.log("syncChannelCost localDateTime：" + syncTime);
        //同步到5.0
        Map<String, Long> map = new HashMap<>();
        //更新时间
        LocalDateTime currentTime = LocalDateTime.now();
//        String result = httpUtil.sendSyncGet(channel_cost_con_to5, new HashMap<>());
//        Map<String, Object> data = (Map) JSONObject.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if ((data.get("ok") + "").equals("true")) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
                Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
                final Object datum = data.get("datum");
                List<ConEpibolyCostConDO> epibolyCostConDOS = new ArrayList<>();
                List<Map<String, Object>> channelCostDatas = (List<Map<String, Object>>) datum;
                for (Map<String, Object> channelCost : channelCostDatas) {
                    ConEpibolyCostConDO epibolyCostConDO = transChannelCostFromV4(channelCost, v4AndV5UserIds, v4AndV5OrgIds);
                    epibolyCostConDOS.add(epibolyCostConDO);
                }
                epibolyCostConRepo.saveAll(epibolyCostConDOS);
                syncData = "同步了" + channelCostDatas.size() + "条数据";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        log.info("【外包费用同步，同步日志：{}】", logDO);
        XxlJobLogger.log("外包费用同步结束..." + logDO);
    }

    /**
     * tw4.0翻译成5.0的外包费用
     * picResId在4.0要翻译成user
     */
    public ConEpibolyCostConDO transChannelCostFromV4(Map<String, Object> channelCostData, Map<Long, Long> userDataMap, Map<Long, Long> buDataMap) {
        ConEpibolyCostConDO channelCostDO = BeanUtil.mapToBean(ConEpibolyCostConDO.class, channelCostData, new ArrayList<>());
        if (channelCostData.get("id") != null) {
            channelCostDO.setCostConIdV4(Long.valueOf((Integer) channelCostData.get("id")));
        }
        if (channelCostData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) channelCostData.get("createUserId"));
            channelCostDO.setCreateUserId(userDataMap.get(createUserId));
        }
        if (channelCostData.get("modifyUserId") != null) {
            Long modifyUserId = Long.valueOf((Integer) channelCostData.get("modifyUserId"));
            channelCostDO.setModifyUserId(userDataMap.get(modifyUserId));
        }
        if (channelCostData.get("delFlag") != null) {
            Integer delFlag = (Integer) channelCostData.get("delFlag");
            channelCostDO.setDeleteFlag(delFlag);
        }
        if (channelCostData.get("applyBuId") != null) {
            Long applyBuId = Long.valueOf((Integer) channelCostData.get("applyBuId"));
            channelCostDO.setApplyBuId(buDataMap.get(applyBuId));
        }
        if (channelCostData.get("applyUserId") != null) {
            Long applyUserId = Long.valueOf((Integer) channelCostData.get("applyUserId"));
            channelCostDO.setApplyUserId(userDataMap.get(applyUserId));
        }
        return channelCostDO;
    }

    /**
     * 外包费用同步定时任务
     *
     * @param param
     */
    @Override
    public void syncChannelCostCondTo5(String param) {
        String syncType = "channelCost";
        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
        XxlJobLogger.log("外包费用同步开始...");
        XxlJobLogger.log("syncChannelCost localDateTime：" + syncTime);
        //同步到5.0
        Map<String, Long> map = new HashMap<>();
        //更新时间
        LocalDateTime currentTime = LocalDateTime.now();
//        String result = httpUtil.sendSyncGet(channel_cost_con_d_to5, new HashMap<>());
//        Map<String, Object> data = (Map) JSONObject.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if ((data.get("ok") + "").equals("true")) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
                Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
                Map<Long, Long> v4AndV5CostConIds = epibolyCostConRepo.findAll().stream().collect(Collectors.toMap(ConEpibolyCostConDO::getCostConIdV4, ConEpibolyCostConDO::getId, (key1, key2) -> key2));

                final Object datum = data.get("datum");
                List<ConEpibolyCostConDDO> epibolyCostConDDOS = new ArrayList<>();
                List<Map<String, Object>> channelCostDatas = (List<Map<String, Object>>) datum;
                for (Map<String, Object> channelCost : channelCostDatas) {
                    ConEpibolyCostConDDO epibolyCostConDDO = transChannelCostDFromV4(channelCost, v4AndV5UserIds, v4AndV5OrgIds, v4AndV5CostConIds);
                    epibolyCostConDDOS.add(epibolyCostConDDO);
                }
                List<ConEpibolyCostConDDO> conEpibolyCostConDDOS = epibolyCostConDRepo.saveAll(epibolyCostConDDOS);
                // 翻译parentId
                Map<Long, Long> v4AndV5CostCondIds = conEpibolyCostConDDOS.stream().collect(Collectors.toMap(ConEpibolyCostConDDO::getCostCondIdV4, ConEpibolyCostConDDO::getId, (key1, key2) -> key2));
                conEpibolyCostConDDOS.stream().forEach(e -> e.setParentId(v4AndV5CostCondIds.get(e.getParentId())));
                epibolyCostConDRepo.saveAll(conEpibolyCostConDDOS);
                syncData = "同步了" + channelCostDatas.size() + "条数据";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        log.info("【外包费用同步，同步日志：{}】", logDO);
        XxlJobLogger.log("外包费用同步结束..." + logDO);
    }

    /**
     * tw4.0翻译成5.0的外包费用
     * picResId在4.0要翻译成user
     */
    public ConEpibolyCostConDDO transChannelCostDFromV4(Map<String, Object> channelCostData, Map<Long, Long> userDataMap, Map<Long, Long> buDataMap, Map<Long, Long> v4AndV5CostConIds) {
        ConEpibolyCostConDDO channelCostDDO = BeanUtil.mapToBean(ConEpibolyCostConDDO.class, channelCostData, new ArrayList<>());
        if (channelCostData.get("id") != null) {
            channelCostDDO.setCostCondIdV4(Long.valueOf((Integer) channelCostData.get("id")));
        }
        if (channelCostData.get("createUserId") != null) {
            Long createUserId = Long.valueOf((Integer) channelCostData.get("createUserId"));
            channelCostDDO.setCreateUserId(userDataMap.get(createUserId));
        }
        if (channelCostData.get("modifyUserId") != null) {
            Long modifyUserId = Long.valueOf((Integer) channelCostData.get("modifyUserId"));
            channelCostDDO.setModifyUserId(userDataMap.get(modifyUserId));
        }
        if (channelCostData.get("delFlag") != null) {
            Integer delFlag = (Integer) channelCostData.get("delFlag");
            channelCostDDO.setDeleteFlag(delFlag);
        }
        if (channelCostData.get("epibolyCostConId") != null) {
            Long epibolyCostConId = Long.valueOf((Integer) channelCostData.get("epibolyCostConId"));
            channelCostDDO.setEpibolyCostConId(v4AndV5CostConIds.get(epibolyCostConId));
        }
        return channelCostDDO;
    }


    /**
     * 收款计划4.0-5.0，关键字段同步
     *
     * @param param
     */
    @Override
    public void syncContractRecvplanTo5(String param) {
        String syncType = "updateReceivePlanTo5";
        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
        if (syncTime == null) {
            syncTime = LocalDateTime.of(2023, 7, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            syncTime = syncTime.minusSeconds(10);
        }
        XxlJobLogger.log("采购需求同步开始...");
        XxlJobLogger.log("syncPurchaseDemandDetail localDateTime：" + syncTime);
        //同步到5.0
        Map<String, Long> map = new HashMap<>();
        final long asyncTimeLong = syncTime.toEpochSecond(ZoneOffset.of("+8"));
        map.put("syncTime", asyncTimeLong);
        //更新时间
        LocalDateTime currentTime = LocalDateTime.now();
//        String result = httpUtil.sendSyncGet(update_receive_plan_to5, map);
//        Map<String, Object> data = (Map) JSONObject.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if ((data.get("ok") + "").equals("true")) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                final Object datum = data.get("datum");

                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
                Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
                List<ConReceivablePlanDO> receivablePlanDOList = new ArrayList<>();
                List<Map<String, Object>> receivePlanDatas = (List<Map<String, Object>>) datum;
                for (Map<String, Object> receivePlanData : receivePlanDatas) {
                    XxlJobLogger.log("开始更新一条收款计划数据：" + receivePlanData.get("id") + ";" + receivePlanData.get("recvplanIdV5"));
                    ConReceivablePlanDO receivablePlanDO = transReceivePlanFromV4(receivePlanData, v4AndV5UserIds, v4AndV5OrgIds);
                    receivablePlanDOList.add(receivablePlanDO);
                }
                receivablePlanRepo.saveAll(receivablePlanDOList);
                syncData = "同步了更新了" + receivePlanDatas.size() + "条数据";


//                for (Map<String, Object> receivePlanData : receivePlanDatas) {
//                    XxlJobLogger.log("开始更新一条收款计划数据："+receivePlanData.get("id")+";"+receivePlanData.get("recvplanIdV5"));
//                    Long recvplanIdV5=0L;
//                    if(receivePlanData.get("recvplanIdV5")!=null){
//                        //5.0收款计划明细id
//                        recvplanIdV5 = (Long) receivePlanData.get("recvplanIdV5");
//                        XxlJobLogger.log("....1");
//                    }else if(receivePlanData.get("id")!=null){
//                        Long recvPlanIdV4 = Long.valueOf((Integer) receivePlanData.get("id"));
//                        XxlJobLogger.log("....2");
//                        ConReceivablePlanDO byReceivePlanIdV4 = receivablePlanRepo.findByReceivePlanIdV4(recvPlanIdV4);
//                        XxlJobLogger.log("....3");
//                        if(byReceivePlanIdV4!=null){
//                            recvplanIdV5 = byReceivePlanIdV4.getId();
//                        }
//                    }
//                    XxlJobLogger.log("....4");
//                    String receStatus = receivePlanData.get("receStatus")==null?null:receivePlanData.get("receStatus").toString();
//                    String batchStatus = receivePlanData.get("batchStatus")==null?null:receivePlanData.get("batchStatus").toString();
//                    BigDecimal alreadyInvAmt =receivePlanData.get("alreadyInvAmt")==null?null:(BigDecimal)receivePlanData.get("alreadyInvAmt");
//                    BigDecimal alreadyReceAmt =receivePlanData.get("alreadyReceAmt")==null?null:(BigDecimal)receivePlanData.get("alreadyReceAmt");
//                    //预计收款日期
//
//                    XxlJobLogger.log("....5");
//                    if(batchStatus!=null) {
//                        batchStatus = BatchStatusEnum.getByCode(batchStatus).getDesc();
//                    }
//                    XxlJobLogger.log("...开始更新");
//                    receivablePlanRepo.updateStatus(recvplanIdV5,receStatus,batchStatus,alreadyInvAmt,alreadyReceAmt);
//                    XxlJobLogger.log("======================更新完成！==========================");
//                }
                syncData = "同步了" + receivePlanDatas.size() + "条数据";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        log.info("【收款计划同步，同步日志：{}】", logDO);
        XxlJobLogger.log("收款计划同步更新结束..." + logDO);
    }

    /**
     * 采购需求4.0-5.0，关键字段同步
     * purContractId，demandStatus
     *
     * @param param
     */
    @Override
    public void syncPurcDemandTo5(String param) {
        String syncType = "updatePurchaseDemandTo5";
        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
        if (syncTime == null) {
            syncTime = LocalDateTime.of(2023, 7, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            syncTime = syncTime.minusSeconds(10);
        }
        XxlJobLogger.log("采购需求同步开始...");
        XxlJobLogger.log("syncPurchaseDemandDetail localDateTime：" + syncTime);
        //同步到5.0
        Map<String, Long> map = new HashMap<>();
        final long asyncTimeLong = syncTime.toEpochSecond(ZoneOffset.of("+8"));
        map.put("syncTime", asyncTimeLong);
        //更新时间
        LocalDateTime currentTime = LocalDateTime.now();
//        String result = httpUtil.sendSyncGet(update_purchase_demand_detail_to5, map);
//        Map<String, Object> data = (Map) JSONObject.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if ((data.get("ok") + "").equals("true")) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                final Object datum = data.get("datum");
                List<Map<String, Object>> purchaseDemandDetailDatas = (List<Map<String, Object>>) datum;
                for (Map<String, Object> purchaseDemandDetail : purchaseDemandDetailDatas) {
                    Long demandDIdV5 = 0L;
                    if (purchaseDemandDetail.get("demandDIdV5") != null) {
                        //5.0采购明细id
                        demandDIdV5 = (Long) purchaseDemandDetail.get("demandDIdV5");
                    } else if (purchaseDemandDetail.get("id") != null) {
                        Long demandDIdV4 = Long.valueOf((Integer) purchaseDemandDetail.get("id"));
                        ConPurchaseDemandDDO byDemandDetailIdV4 = purchaseDemandDRepo.findByDemandDetailIdV4(demandDIdV4);
                        demandDIdV5 = byDemandDetailIdV4.getId();
                    }
                    String demandStatus = purchaseDemandDetail.get("demandStatus") == null ? null : purchaseDemandDetail.get("demandStatus").toString();
                    Long purContractIdV5 = null;
                    if (purchaseDemandDetail.get("purContractId") != null) {
                        Long purContractId = Long.valueOf((Integer) purchaseDemandDetail.get("purContractId"));
                        Map<Long, Long> v4AndV5PurchaseContractIds = purchaseContractManagerRepo.findAll().stream().collect(Collectors.toMap(PurchaseContractManagerDO::getPurchaseContractIdV4, PurchaseContractManagerDO::getId, (key1, key2) -> key2));
                        purContractIdV5 = v4AndV5PurchaseContractIds.get(purContractId);
                    }
                    purchaseDemandDRepo.updatePruchaseDemandedById(demandDIdV5, purContractIdV5, demandStatus);

                }
                syncData = "同步了" + purchaseDemandDetailDatas.size() + "条数据";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        log.info("【采购需求同步，同步日志：{}】", logDO);
        XxlJobLogger.log("采购需求同步更新结束..." + logDO);
    }

    /**
     * 外包费用4.0-5.0，关键字段同步
     *
     * @param param
     */
    @Override
    public void syncCostConTo5(String param) {
        String syncType = "updateCostConTo5";
        LocalDateTime syncTime = daoLog.queryOrgSyncTime(syncType);
        if (syncTime == null) {
            syncTime = LocalDateTime.of(2023, 7, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            syncTime = syncTime.minusSeconds(10);
        }
        XxlJobLogger.log("外包费用同步开始...");
        XxlJobLogger.log("syncCostCon localDateTime：" + syncTime);
        //同步到5.0
        Map<String, Long> map = new HashMap<>();
        final long asyncTimeLong = syncTime.toEpochSecond(ZoneOffset.of("+8"));
        map.put("syncTime", asyncTimeLong);
        //更新时间
        LocalDateTime currentTime = LocalDateTime.now();
//        String result = httpUtil.sendSyncGet(update_channel_cost_con_d_to5, map);
//        Map<String, Object> data = (Map) JSONObject.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if ((data.get("ok") + "").equals("true")) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                final Object datum = data.get("datum");
                List<Map<String, Object>> costConDatas = (List<Map<String, Object>>) datum;
                for (Map<String, Object> costConData : costConDatas) {
                    Long costConDIdV5 = 0L;
                    if (costConData.get("costConDIdV5") != null) {
                        //5.0外包费用id
                        costConDIdV5 = (Long) costConData.get("costConDIdV5");

                    } else if (costConData.get("id") != null) {
                        Long demandDIdV4 = Long.valueOf((Integer) costConData.get("id"));
                        ConEpibolyCostConDDO byCostCondIdV4 = epibolyCostConDRepo.findByCostCondIdV4(demandDIdV4);
                        costConDIdV5 = byCostCondIdV4.getId();
                    }
                    String docType = costConData.get("docType") == null ? null : costConData.get("docType").toString();
                    String documentNo = costConData.get("documentNumber") == null ? null : costConData.get("documentNumber").toString();
                    epibolyCostConDRepo.updateDocTypeAndNo(costConDIdV5, docType, documentNo);
                }
                syncData = "同步了" + costConDatas.size() + "条数据";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        log.info("【收款计划同步，同步日志：{}】", logDO);
        XxlJobLogger.log("收款计划同步更新结束..." + logDO);
    }

    @Override
    public void syncTicketsFromBangwo8Single(Long ticketId) {
        XxlJobLogger.log("获取token...");
        String token = getBangwo8Token();
        XxlJobLogger.log("工单同步开始...");
        int page = 1;
        int totalPage = 1;
        List<TimesheetPayload> timesheetListAll = new ArrayList<>();
        while (page <= totalPage) {
            XxlJobLogger.log("=============================开始拉取第" + page + "页；共" + totalPage + "页");
            String body = HttpRequest.get(String.join("", bangwo8Url, "api/v1/tickkets", ticketId.toString(),"_v2.json"))
                    .bearerAuth(token)
                    .execute()
                    .body();

            Map parse = (Map) JSON.parse(body);
            Map<String, Object> ticket = (Map<String, Object>) parse.get("tickets");
            if (parse.get("errorMsg") != null) {
                XxlJobLogger.log("同步接口调用失败::::::::" + parse.get("errorMsg"));
                throw TwException.error("", "同步接口调用失败::::::" + parse.get("errorMsg"));
            } else {
                List<Map<String, Object>> projectList = projectBangwo8Repo.queryBangwo8Projects();
                Map<Long, Long> projectMap = projectList.stream().collect(HashMap::new, (projMap, item) -> projMap.put(Long.parseLong(item.get("projIdBangwo8").toString()), Long.parseLong(item.get("projIdV4").toString())), HashMap::putAll);
                List<PrdOrgEmployeeDO> prdOrgEmployeeDOS = employeeDAO.queryList();
                Map<Long, Long> employeeMap = prdOrgEmployeeDOS.stream().collect(HashMap::new, (empMap, item) -> empMap.put(item.getBangwo8AdviserId(), item.getUserId()), HashMap::putAll);
                List<Map<String, Object>> tickets = (List<Map<String, Object>>) parse.get("tickets");
                System.out.println(tickets);
                TimesheetListPayload timesheetListPayload = new TimesheetListPayload();
                timesheetListPayload.setSubmitted(false);
                List<TimesheetPayload> timesheetList = new ArrayList<>();
                timesheetListPayload.setTimesheetList(timesheetList);
                //遍历工单列表
                    List<Map<String, Object>> customFields = (List<Map<String, Object>>) ticket.get("custom_fields");
                    String except = "";//排除工时
                    Object timesheetMess = null;
                    for (Map<String, Object> customField : customFields) {
                        if (customField.get("key").equals("field_17")) {
                            except = customField.get("value").toString();
                        }
                        if (customField.get("key").equals("field_16")) {
                            timesheetMess = customField.get("value");
                        }
                    }
                    if (!except.equals("4682108")) {
                        if (timesheetMess != null && !timesheetMess.equals("")) {
                            List<Map> timesheetMessList = (List<Map>) timesheetMess;
                            if (!CollectionUtils.isEmpty(timesheetMessList)) {
                                for (Map timesheet : timesheetMessList) {
                                    LocalDate workDate = null;
                                    try {
                                        workDate = LocalDate.parse(timesheet.get("field_1").toString().trim());
                                    } catch (Exception e) {
                                        XxlJobLogger.log("工单日期为空，跳过本条！！！！");
                                        continue;
                                    }
                                    LocalDateTime createTime = null;
                                    if (!ObjectUtils.isEmpty(timesheet.get("create_time"))) {
                                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                                        createTime = LocalDateTime.parse(timesheet.get("create_time").toString().trim(), formatter);
                                    }
                                    // 计算当前条的工时是否需要保存
                                        Object rowId = timesheet.get("rowId");
                                        if (ObjectUtils.isEmpty(timesheet.get("field_2"))) {
                                            XxlJobLogger.log("开始同步工时" + ticketId + "" + rowId + ",工时字段为空，跳过！");
                                            continue;
                                        }
                                        BigDecimal workHour = BigDecimal.valueOf(Double.parseDouble(timesheet.get("field_2").toString()));
                                        // field_3 代表工时同步，其他代表不需要同步
                                        Object field31 = timesheet.get("field_3");
                                        if (null != field31) {
                                            String field3 = field31.toString();
                                            if (!field3.equals("0")) {
                                                XxlJobLogger.log("开始同步工时" + ticketId + "" + rowId + ",工时字段为空，跳过！");
                                                log.info("开始同步工时" + ticketId + "" + rowId + ",工时字段为空，跳过！");
                                                continue;
                                            }
                                        }

//                                        XxlJobLogger.log("开始同步工时"+ticketId + "" + rowId);
                                        // 校验是否已经同步过
                                        int count = timesheetRepo.countByBangwo8NoAndDeleteFlag(Long.parseLong(ticketId + "" + rowId), 0);
                                        if (count < 1) {
                                            XxlJobLogger.log("--------校验为新工时，开始同步工时" + ticketId + "" + rowId);
                                            String custUserId = ticket.get("custUserId").toString();//联系人id
                                            //组装该条工时
                                            //调用联系人接口获取项目id
                                            String user = HttpRequest.get(String.join("", bangwo8Url, bangwo8UsersUrl, "/", custUserId, "_v2.json"))
                                                    .bearerAuth(token)
                                                    .execute()
                                                    .body();
                                            Map userMap = (Map) JSON.parse(user);
                                            if (userMap.get("errorMsg") == null) {
                                                XxlJobLogger.log("联系人接口调用成功！");
                                                //只有调用成功时才保存工时
                                                Map<String, Object> map1 = (Map) userMap.get("user");
                                                Long projIdBangwo8 = Long.parseLong(map1.get("companyId").toString());//项目
                                                //翻译项目和顾问
                                                Long projIdV4 = projectMap.get(projIdBangwo8);
                                                Long tsUserId = employeeMap.get(Long.parseLong(ticket.get("servicerUserId").toString()));//顾问id
                                                PrdOrgEmployeeDO prdOrgEmployeeDO = employeeDAO.queryByUserId(tsUserId);
                                                String workDesc = ticket.get("subject").toString();//工作内容
                                                //填工时
                                                TimesheetPayload timesheetPayload = new TimesheetPayload();
                                                timesheetPayload.setProjId(projIdV4);
                                                timesheetPayload.setTsUserId(tsUserId);
                                                timesheetPayload.setWorkDate(workDate);
                                                timesheetPayload.setSubmitted(false);
                                                timesheetPayload.setTsStatus("CREATE");
                                                timesheetPayload.setType("DEV_OPS");
                                                timesheetPayload.setWorkDesc(workDesc);
                                                timesheetPayload.setBangwo8No(Long.parseLong(ticketId + "" + rowId));
                                                timesheetPayload.setBangwo8WorkHour(workHour);
                                                timesheetPayload.setTicketUrl("https://issue.elitesland.com/osp2016/agent/ticketView.php?tId=" + ticket.get("ticketId"));//帮我吧工单链接
                                                //注意这里时这个人当天的工时不能超过8小时
//                                            timesheetPayload.setWorkHour(workHour.compareTo(BigDecimal.valueOf(8L))>-1?BigDecimal.valueOf(8):workHour);
                                                timesheetPayload.setWorkHour(workHour);
                                                // 拦截不规范的工时
                                                if (timesheetPayload.getProjId() == null || timesheetPayload.getWorkHour() == null) {
                                                    XxlJobLogger.log("项目id或者工时缺失，不规范，跳过");
                                                    continue;
                                                }
                                                timesheetList.add(timesheetPayload);

                                                //回调帮我吧工时
                                                JSONObject timesheetData = new JSONObject();
                                                JSONObject item_data = new JSONObject();
                                                item_data.put("owner", ticket.get("servicerUserId"));//顾问帮我吧id,
                                                item_data.put("ownerType", "servicer");//固定值，指顾问
                                                item_data.put("ticketId", ticket.get("ticketId"));//工单id
                                                item_data.put("relative_ticket_columnId", "28528665");//固定值，工单资产表字段的唯一标识
                                                item_data.put("field_1", prdOrgEmployeeDO.getEmployeeName());//顾问姓名
                                                item_data.put("field_2", workDate);//日期
                                                item_data.put("field_3", workHour);//工时
                                                item_data.put("field_4", prdOrgEmployeeDO.getEmployeeNo());//顾问工号
                                                item_data.put("field_5", "已同步");//同步标识
                                                item_data.put("tbsj", DateTimeFormatter.ofPattern("yyyy-MM-dd 00:00:00").format(LocalDateTime.now()));//同步日期
                                                timesheetData.put("item_data", item_data);
                                                //回调帮我吧，通知这条工时已经同步
                                                HttpRequest.post(String.join("", bangwo8Url, bangwo8TicketsCallbackUrl, ".json"))
                                                        .body(timesheetData.toJSONString())
                                                        .contentType(ContentType.JSON.toString())
                                                        .bearerAuth(token)
                                                        .execute()
                                                        .body();
                                            } else {
                                                XxlJobLogger.log("联系人接口调用失败，该工时未成功保存：" + userMap.get("errorMsg"));
                                            }
                                            XxlJobLogger.log("--------校验为新工时，结束同步工时" + ticketId + "" + rowId);
                                        }
                                }
                            }
                        }

                    }
                }
//                if (!timesheetList.isEmpty()) {
//                    timesheetListAll.addAll(timesheetList);
//                    timesheetListPayload.setCheckFlag(false);
//                    pmsTimesheetService.batchInsert(timesheetListPayload);
//                }
            }
    }


}
