package com.elitesland.tw.tw5.server.prd.partner.common.controller;


import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessParnerTaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerChangePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.CommonKeysPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BusinessPartnerQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.*;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCollaboratePartnerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessSupplierInfoVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.prd.partner.common.convert.BusinessPartnerConvert;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 业务伙伴管理
 *
 * @author wangluyu
 * @folder 业务伙伴管理
 * @date 2023-05-16
 */
@Api(tags = "业务伙伴管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessPartner")
@Slf4j
public class BusinessPartnerController {

    private final BusinessPartnerService businessPartnerService;
    private final UdcUtil udcUtil;

    /**
     * 业务伙伴管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 业务伙伴管理
     */
    @PostMapping
    @ApiOperation("业务伙伴管理-保存")
    public TwOutputUtil save(@RequestBody BusinessPartnerPayload payload) {
        if (payload.getId() != null) {
            businessPartnerService.insertOtherIdentity(payload, true);
        } else {
            businessPartnerService.insert(payload);
        }
        return TwOutputUtil.ok();
    }

    /**
     * 业务伙伴管理-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 业务伙伴管理
     */
    @PutMapping
    @ApiOperation("业务伙伴管理-更新")
    public TwOutputUtil<BusinessPartnerVO> update(@RequestBody BusinessPartnerPayload payload) {
        return TwOutputUtil.ok(businessPartnerService.update(payload));
    }

    /**
     * 业务伙伴管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     * @folder 业务伙伴管理
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("业务伙伴管理-主键查询")
    public TwOutputUtil<BusinessPartnerVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessPartnerService.queryByKey(key));
    }

    /**
     * 业务伙伴管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     * @folder 业务伙伴管理
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("业务伙伴管理-分页")
    public TwOutputUtil<PagingVO<BusinessPartnerVO>> paging(BusinessPartnerQuery query) {
        return TwOutputUtil.ok(businessPartnerService.queryPaging(query));
    }

    /**
     * 业务伙伴管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     * @folder 业务伙伴管理
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("业务伙伴管理-查询列表")
    public TwOutputUtil<List<BusinessPartnerVO>> queryList(BusinessPartnerQuery query) {
        return TwOutputUtil.ok(businessPartnerService.queryListDynamic(query));
    }

    /**
     * 业务伙伴管理-删除
     *
     * @param keys 主键id
     * @return result
     * @folder 业务伙伴管理
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("业务伙伴管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        businessPartnerService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 业务伙伴管理-查询母公司下拉列表
     *
     * @return {@link TwOutputUtil}
     * @folder 业务伙伴管理
     */
    @GetMapping("/listSimple")
    @ApiOperation("业务伙伴管理-查询母公司下拉列表")
    public TwOutputUtil<List<BusinessPartnerSimpleVO>> queryListSimple() {
        return TwOutputUtil.ok(businessPartnerService.queryListSimple());
    }

    /**
     * 业务伙伴名称重复性校验
     *
     * @param query partnerName
     * @return {@link TwOutputUtil}
     * @folder 业务伙伴管理
     */
    @GetMapping("/judgePartnerName")
    @ApiOperation("业务伙伴管理-业务伙伴名称重复性校验")
    public TwOutputUtil judgePartnerName(BusinessPartnerQuery query) {
        businessPartnerService.judgePartnerName(query.getPartnerName());
        return TwOutputUtil.ok();
    }

    // TODO 导出

    @GetMapping("/excelExport")
    @ApiOperation("业务伙伴管理-导出")
    public void excelExport(BusinessPartnerQuery query, HttpServletResponse response) throws IOException {

        //导出顺序是反的
//        OrderItem orderItem = OrderItem.asc("createTime");
//        query.defaultOrder(orderItem);
        //获取想要导出的数据
        List<BusinessPartnerVO> vos;
        if (query.getIds() != null && query.getIds().size() > 0) {
            vos = businessPartnerService.queryListByIds(query.getIds());
        } else {
            vos = businessPartnerService.queryListDynamic(query);
        }
        vos = udcUtil.translateList(vos);
        if (BusinessPartnerTypeEnum.ORGANIZATION.getCode().equals(query.getPartnerType())) {
            exportCompany(vos, response);
        }
        if (BusinessPartnerTypeEnum.INDIVIDUAL.getCode().equals(query.getPartnerType())) {
            exportIndividual(vos, response);
        }

    }

    //导出公司
    public void exportCompany(List<BusinessPartnerVO> vos, HttpServletResponse response) throws IOException {
        List<BusinessPartnerExportVO> resultList = BusinessPartnerConvert.INSTANCE.voListVoExcelExport(vos);
        //定义文件名称
        String sheetName = "业务伙伴";
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), BusinessPartnerExportVO.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        ExcelUtil.excelHelper(sheet, BusinessPartnerExportVO.class, null);
        //写入
        sheet.doWrite(resultList);
    }

    //导出个人
    public void exportIndividual(List<BusinessPartnerVO> vos, HttpServletResponse response) throws IOException {
        List<BusinessPartnerIndividualExportVO> resultList = BusinessPartnerConvert.INSTANCE.voListVoIndividualExcelExport(vos);
        //定义文件名称
        String sheetName = "业务伙伴";
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), BusinessPartnerIndividualExportVO.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        ExcelUtil.excelHelper(sheet, BusinessPartnerIndividualExportVO.class, null);
        //写入
        sheet.doWrite(resultList);
    }


    @GetMapping("/judgeIdentityDisplay")
    @ApiOperation("业务伙伴管理-判断身份部分标签是否展示")
    public TwOutputUtil<BusinessPartnerIdentityVO> judgeIdentityDisplay(@RequestParam(name = "partnerId") String partnerId) {
        return TwOutputUtil.ok(businessPartnerService.judgeIdentityDisplay(Long.valueOf(partnerId)));
    }


    /**
     * 业务伙伴管理-组织树
     *
     * @return {@link TwOutputUtil}
     * @folder 业务伙伴管理
     */
    @GetMapping("/listTree")
    @ApiOperation("业务伙伴管理-组织树")
    public TwOutputUtil<List<BusinessPartnerTreeVO>> listTree(BusinessPartnerQuery query) {
        return TwOutputUtil.ok(businessPartnerService.listTree(query));
    }

    /**
     * 业务伙伴管理-全部详情查询
     *
     * @return {@link TwOutputUtil}
     * @folder 业务伙伴管理
     */
    @GetMapping("/queryBusinessPartnerInfoByPartnerName")
    @ApiOperation("业务伙伴管理-通过名字查询查询全部详情")
    public TwOutputUtil<List<BusinessPartnerInfoVO>> queryBusinessPartnerInfoByPartnerName(String partnerName) {
        return TwOutputUtil.ok(businessPartnerService.queryBusinessPartnerInfoByPartnerName(partnerName));
    }

    @GetMapping("/test")
    @ApiOperation("业务伙伴管理-测试")
    public TwOutputUtil<BusinessPartnerDTO> test() {
        BusinessPartnerDTO businessPartnerDTO = new BusinessPartnerDTO();
        BusinessPartnerTranslateVO businessPartnerTranslateVO = new BusinessPartnerTranslateVO();
        BookAddressVO bookAddressVO = new BookAddressVO();
        BookContactsVO bookContactsVO = new BookContactsVO();
        BookInvoiceVO bookInvoiceVO = new BookInvoiceVO();
        BookAccountVO bookAccountVO = new BookAccountVO();
        BusinessCustomerInfoVO businessCustomerInfoVO = new BusinessCustomerInfoVO();
        BusinessCollaboratePartnerInfoVO businessCollaboratePartnerInfoVO = new BusinessCollaboratePartnerInfoVO();
        BusinessSupplierInfoVO businessSupplierInfoVO = new BusinessSupplierInfoVO();
        businessPartnerDTO.setBusinessPartnerVO(businessPartnerTranslateVO);
        businessPartnerDTO.setBusinessCollaboratePartnerInfoVO(businessCollaboratePartnerInfoVO);
        businessPartnerDTO.setBusinessSupplierInfoVO(businessSupplierInfoVO);
        businessPartnerDTO.setBusinessCustomerInfoVO(businessCustomerInfoVO);
        businessPartnerDTO.setBookAccountVOList(Collections.singletonList(bookAccountVO));
        businessPartnerDTO.setBookAddressVOList(Collections.singletonList(bookAddressVO));
        businessPartnerDTO.setBookInvoiceVOList(Collections.singletonList(bookInvoiceVO));
        businessPartnerDTO.setBookContactsVOList(Collections.singletonList(bookContactsVO));
        return TwOutputUtil.ok(businessPartnerDTO);
    }

    //银行账户/开票变更
    @PostMapping("/changeAccountAndInvoice")
    @ApiOperation("业务伙伴管理-银行账户/开票信息变更")
    public TwOutputUtil changeAccountAndInvoice(@RequestBody BusinessPartnerChangePayload payload) {
        businessPartnerService.changeAccountAndInvoice(payload);
        return TwOutputUtil.ok();
    }

    //银行账户/开票变更
    @PostMapping("/changeAccountAndInvoiceUpdate")
    @ApiOperation("业务伙伴管理-银行账户/开票信息变更更新")
    public TwOutputUtil changeAccountAndInvoiceUpdate(@RequestBody BusinessPartnerChangePayload payload) {
        businessPartnerService.changeAccountAndInvoiceUpdate(payload);
        return TwOutputUtil.ok();
    }

    //银行账户/开票变更
    @GetMapping("/queryChangeAccountAndInvoiceInfo")
    @ApiOperation("业务伙伴管理-银行账户/开票信息变更详情查询")
    public TwOutputUtil<BusinessPartnerChangeVO> queryChangeAccountAndInvoiceInfo(Long businessKey, Long partnerId) {
        return TwOutputUtil.ok(businessPartnerService.queryChangeAccountAndInvoiceInfo(businessKey, partnerId));
    }


    @PostMapping("/businessPartnerTaskInfo")
    @ApiOperation("业务伙伴管理-工作流任务详情查询")
    public TwOutputUtil<BusinessPartnerTaskVO> businessPartnerTaskInfo(@RequestBody BusinessParnerTaskInfoPayload payload) {
        return TwOutputUtil.ok(businessPartnerService.businessPartnerTaskInfo(payload));
    }

    /**
     * 客户管理-待确认潜在客户查询
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryConfirmedCustomer")
    @ApiOperation("客户管理-待确认潜在客户查询")
    @UdcNameClass
    public TwOutputUtil<PagingVO<BusinessConfirmedCustomerVO>> queryConfirmedCustomer(BusinessPartnerQuery query) {
        return TwOutputUtil.ok(businessPartnerService.queryConfirmedCustomer(query));
    }

    /**
     * 客户管理-待确认潜在客户查询
     *
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/updateConfirmedCustomer")
    @ApiOperation("客户管理-待确认潜在客户更新")
    public TwOutputUtil updateConfirmedCustomer(@RequestBody CommonKeysPayload payload) {
        businessPartnerService.updateConfirmedCustomer(payload);
        return TwOutputUtil.ok();
    }

//    @GetMapping("/testCreateFile")
//    public TwOutputUtil testCreateFile(String filePath){
//        try {
//            if(!StringUtils.hasText(filePath)){
//                filePath = "/opt/upload/activity/EL_tw-Server5-pms_common/2023829/";
//            }
//            File mkdir = FileUtil.mkdir(filePath);
//            if(mkdir!=null){
//                File file = FileUtil.newFile(filePath+"/1.txt");
//                file.createNewFile();
//                if (file.exists()){
//                    return TwOutputUtil.ok("ok");
//                }
//           }
//        }catch (Exception e){
//            log.error(e.getMessage(),e);
//        }
//        return TwOutputUtil.error("创建文件失败");
//    }

    /**
     * 业务伙伴-根据bookId查询客户信息
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryCustomerByBookId")
    @ApiOperation("业务伙伴-根据bookId查询客户信息")
    public TwOutputUtil<BusinessPartnerVO> queryCustomerByBookId(Long bookId){
        return  TwOutputUtil.ok(businessPartnerService.queryCustomerByBookId(bookId));
    }
    /**
     * 客户激活修改银行信息/开票信息数据(方法复用)
     */
    /**
     * 业务伙伴-根据bookId查询客户信息
     *
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/updateAccAndInvoice")
    @ApiOperation("业务伙伴-客户激活修改银行信息/开票信息数据")
    public TwOutputUtil updateAccAndInvoice(@RequestBody BusinessPartnerChangeVO vo){
        businessPartnerService.updateAccAndInvoice(vo);
        return TwOutputUtil.ok();
    }


    /**
     * 客户激活修改银行信息/开票信息数据(方法复用)
     */
    /**
     * 业务伙伴-根据bookId查询客户信息
     *
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/updateAccAndInvoice2")
    @ApiOperation("业务伙伴-客户激活修改银行信息/开票信息数据")
    public TwOutputUtil updateAccAndInvoice2(@RequestBody BusinessPartnerChangeVO vo){
        businessPartnerService.updateAccAndInvoice2(vo);
        return TwOutputUtil.ok();
    }


    /**
     * 增加收款计划时校验该客户是否有开票信息或正在流转的客户激活流程或客户变更流程
     * @param custId
     * @return
     */
    @GetMapping("/checkExitInvices")
    @ApiOperation("业务伙伴-根据BookId校验该客户是否有开票信息或正在流转的客户激活流程或客户变更流程")
    public TwOutputUtil<Boolean> checkExitInvices(Long custId) {
        return TwOutputUtil.ok(businessPartnerService.checkExitInvices(custId));
    }



    /**
     * 测试业务伙伴定时任务同步
     */

//    @PostMapping("/businessPartnerSync")
//    @ApiOperation("业务伙伴-测试业务伙伴定时任务同步")
//    public TwOutputUtil businessPartnerSync(String businessPartnerNo){
//        businessPartnerService.businessPartnerSync(businessPartnerNo);
//        return TwOutputUtil.ok();
//    }

    /**
     * 根据BookId返回信息
     * @param bookIdList 地址簿Id
     * @return result
     */
    @GetMapping ("/findListInfoByBookIds")
    @ApiOperation("业务伙伴-根据BookId返回信息")
    public TwOutputUtil<List<BusinessPartnerListInfoVO>> findListInfoByBookIds(@RequestParam("bookIdList") List<Long> bookIdList) {
        return TwOutputUtil.ok(businessPartnerService.findListInfoByBookIds(bookIdList));
    }


}
