package com.elitesland.tw.tw5.server.prd.partner.identity.controller;

import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessDistributorInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessDistributorInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessDistributorInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessDistributorInfoVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 业务伙伴-经销商信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Api(tags = "业务伙伴-经销商信息")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessDistributorInfo")
@Slf4j
public class BusinessDistributorInfoController {

    private final BusinessDistributorInfoService businessDistributorInfoService;

    /**
     * 业务伙伴-经销商信息-新增
     *

     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("业务伙伴-经销商信息-新增")
    public TwOutputUtil insert(@RequestBody BusinessDistributorInfoPayload payload){
        return TwOutputUtil.ok(businessDistributorInfoService.insert(payload));
    }

    /**
     * 业务伙伴-经销商信息-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("业务伙伴-经销商信息-更新")
    public TwOutputUtil update(@RequestBody BusinessDistributorInfoPayload payload){
        return TwOutputUtil.ok(businessDistributorInfoService.update(payload));
    }

//    /**
//     * 业务伙伴-经销商信息-主键查询 暂且没用 需要可放开
//     *
//     * @param key 关键
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/{key}")
//    // @UdcNameClass
//    @ApiOperation("业务伙伴-经销商信息-主键查询")
//    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(businessDistributorInfoService.queryByKey(key));
//    }

//    /**
//     * 业务伙伴-经销商信息-分页 暂且没用 需要可放开
//     *
//     * @param query 查询
//     * @return {@link TwOutputUtil}
//     */
//    @GetMapping("/paging")
//    // @UdcNameClass
//    @ApiOperation("业务伙伴-经销商信息-分页")
//    public TwOutputUtil paging(BusinessDistributorInfoQuery query) {
//        return TwOutputUtil.ok(businessDistributorInfoService.queryPaging(query));
//    }

    /**
     * 业务伙伴-经销商信息-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("业务伙伴-经销商信息-查询列表")
    public TwOutputUtil<List<BusinessDistributorInfoVO>> queryList(BusinessDistributorInfoQuery query) {
        return TwOutputUtil.ok(businessDistributorInfoService.queryListDynamic(query));
    }

    /**
     * 业务伙伴-经销商信息-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("业务伙伴-经销商信息-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        businessDistributorInfoService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
