package com.elitesland.tw.tw5.server.prd.partner.identity.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessSupplierInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessSupplierInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessSupplierInfoVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.BusinessSupplierInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.QBusinessSupplierInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessSupplierInfoRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 业务伙伴-供应商信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Repository
@RequiredArgsConstructor
public class BusinessSupplierInfoDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessSupplierInfoRepo repo;
    private final QBusinessSupplierInfoDO qdo = QBusinessSupplierInfoDO.businessSupplierInfoDO;
    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessSupplierInfoVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessSupplierInfoVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 业务伙伴id business_partner.id
                qdo.partnerId,
                // 供应商编号
                qdo.supplierNo,
                // jde同步标志
                qdo.syncJdeFlag,
                // 供应商状态 udc[CRM:BUSINESS_PARTNER:STATUS]
                qdo.supplierStatus,
                // 供应商级别 udc[crm:customer_grade]
                qdo.supplierGradle,
                // 供应商产品
                qdo.supplierProduct,
                // 供货开始时间
                qdo.startTime,
                // 供货结束时间
                qdo.endTime,
                // 结算周期
                qdo.settlementPeriod,
                // 供货期间说明
                qdo.supplyDescription,
                // 资质审核资料附件
                qdo.fileCode1,
                // 实地考察资料
                qdo.fileCode2,
                // 扩展字段1
                qdo.ext1,
                // 扩展字段2
                qdo.ext2,
                // 扩展字段3
                qdo.ext3,
                // 扩展字段4
                qdo.ext4,
                // 扩展字段5
                qdo.ext5
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessSupplierInfoVO> getJpaQueryWhere(BusinessSupplierInfoQuery query) {
        JPAQuery<BusinessSupplierInfoVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BusinessSupplierInfoQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BusinessSupplierInfoQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 业务伙伴id business_partner.id 精确 */
        if (!ObjectUtils.isEmpty(query.getPartnerId())) {
            list.add(qdo.partnerId.eq(query.getPartnerId()));
        }
        if (!ObjectUtils.isEmpty(query.getPartnerIds())) {
            list.add(qdo.partnerId.in(query.getPartnerIds()));
        }
        /** 供应商编号 精确 */
        if (!ObjectUtils.isEmpty(query.getSupplierNo())) {
            list.add(qdo.supplierNo.eq(query.getSupplierNo()));
        }
        /** jde同步标志 精确 */
        if (!ObjectUtils.isEmpty(query.getSyncJdeFlag())) {
            list.add(qdo.syncJdeFlag.eq(query.getSyncJdeFlag()));
        }
        /** 供应商状态 udc[CRM:BUSINESS_PARTNER:STATUS] 精确 */
        if (!ObjectUtils.isEmpty(query.getSupplierStatus())) {
            list.add(qdo.supplierStatus.eq(query.getSupplierStatus()));
        }
        /** 供应商级别 udc[crm:customer_grade] 精确 */
        if (!ObjectUtils.isEmpty(query.getSupplierGradle())) {
            list.add(qdo.supplierGradle.eq(query.getSupplierGradle()));
        }
        /** 供应商产品 精确 */
        if (!ObjectUtils.isEmpty(query.getSupplierProduct())) {
            list.add(qdo.supplierProduct.eq(query.getSupplierProduct()));
        }
        /** 供货开始时间 精确 */
        if (!ObjectUtils.isEmpty(query.getStartTime())) {
            list.add(qdo.startTime.eq(query.getStartTime()));
        }
        /** 供货结束时间 精确 */
        if (!ObjectUtils.isEmpty(query.getEndTime())) {
            list.add(qdo.endTime.eq(query.getEndTime()));
        }
        /** 结算周期 精确 */
        if (!ObjectUtils.isEmpty(query.getSettlementPeriod())) {
            list.add(qdo.settlementPeriod.eq(query.getSettlementPeriod()));
        }
        /** 供货期间说明 精确 */
        if (!ObjectUtils.isEmpty(query.getSupplyDescription())) {
            list.add(qdo.supplyDescription.eq(query.getSupplyDescription()));
        }
        /** 扩展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 扩展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 扩展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 扩展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 扩展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BusinessSupplierInfoVO queryByKey(Long id) {
        JPAQuery<BusinessSupplierInfoVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BusinessSupplierInfoVO> queryListDynamic(BusinessSupplierInfoQuery query) {
        JPAQuery<BusinessSupplierInfoVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BusinessSupplierInfoVO> queryPaging(BusinessSupplierInfoQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BusinessSupplierInfoVO> jpaQuery = getJpaQueryWhere(query);
        List<BusinessSupplierInfoVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessSupplierInfoVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BusinessSupplierInfoDO save(BusinessSupplierInfoDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BusinessSupplierInfoDO> saveAll(List<BusinessSupplierInfoDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BusinessSupplierInfoPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 业务伙伴id business_partner.id
        if (payload.getPartnerId() != null) {
            update.set(qdo.partnerId, payload.getPartnerId());
        }
        // 供应商编号
        if (payload.getSupplierNo() != null) {
            update.set(qdo.supplierNo, payload.getSupplierNo());
        }
        // jde同步标志
        if (payload.getSyncJdeFlag() != null) {
            update.set(qdo.syncJdeFlag, payload.getSyncJdeFlag());
        }
        // 供应商状态 udc[CRM:BUSINESS_PARTNER:STATUS]
        if (payload.getSupplierStatus() != null) {
            update.set(qdo.supplierStatus, payload.getSupplierStatus());
        }
        // 供应商级别 udc[crm:customer_grade]
        if (payload.getSupplierGradle() != null) {
            update.set(qdo.supplierGradle, payload.getSupplierGradle());
        }
        // 供应商产品
        if (payload.getSupplierProduct() != null) {
            update.set(qdo.supplierProduct, payload.getSupplierProduct());
        }
        // 供货开始时间
        if (payload.getStartTime() != null) {
            update.set(qdo.startTime, payload.getStartTime());
        }
        // 供货结束时间
        if (payload.getEndTime() != null) {
            update.set(qdo.endTime, payload.getEndTime());
        }
        // 结算周期
        if (payload.getSettlementPeriod() != null) {
            update.set(qdo.settlementPeriod, payload.getSettlementPeriod());
        }
        // 供货期间说明
        if (payload.getSupplyDescription() != null) {
            update.set(qdo.supplyDescription, payload.getSupplyDescription());
        }
        // 资质审核资料附件
        if (payload.getFileCode1() != null) {
            update.set(qdo.fileCode1, payload.getFileCode1());
        }
        // 实地考察资料
        if (payload.getFileCode2() != null) {
            update.set(qdo.fileCode2, payload.getFileCode2());
        }

        // 扩展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 扩展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 扩展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 扩展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 扩展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 业务伙伴id business_partner.id
            if (nullFields.contains("partnerId")) {
                update.setNull(qdo.partnerId);
            }
            // 供应商编号
            if (nullFields.contains("supplierNo")) {
                update.setNull(qdo.supplierNo);
            }
            // jde同步标志
            if (nullFields.contains("syncJdeFlag")) {
                update.setNull(qdo.syncJdeFlag);
            }
            // 供应商状态 udc[CRM:BUSINESS_PARTNER:STATUS]
            if (nullFields.contains("supplierStatus")) {
                update.setNull(qdo.supplierStatus);
            }
            // 供应商级别 udc[crm:customer_grade]
            if (nullFields.contains("supplierGradle")) {
                update.setNull(qdo.supplierGradle);
            }
            // 供应商产品
            if (nullFields.contains("supplierProduct")) {
                update.setNull(qdo.supplierProduct);
            }
            // 供货开始时间
            if (nullFields.contains("startTime")) {
                update.setNull(qdo.startTime);
            }
            // 供货结束时间
            if (nullFields.contains("endTime")) {
                update.setNull(qdo.endTime);
            }
            // 结算周期
            if (nullFields.contains("settlementPeriod")) {
                update.setNull(qdo.settlementPeriod);
            }
            // 供货期间说明
            if (nullFields.contains("supplyDescription")) {
                update.setNull(qdo.supplyDescription);
            }
            // 资质审核资料附件
            if (nullFields.contains("fileCode1")) {
                update.setNull(qdo.fileCode1);
            }
            // 实地考察资料
            if (nullFields.contains("fileCode2")) {
                update.setNull(qdo.fileCode2);
            }
            // 扩展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 扩展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 扩展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 扩展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 扩展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    //供应商状态更新
    public void updateSupplierStatus(Long partnerId,String supplierStatus){
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.supplierStatus, supplierStatus)
                .where(qdo.partnerId.eq(partnerId))
                .where(qdo.deleteFlag.eq(0));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        update.execute();
    }

    public BusinessSupplierInfoVO quertByBookId(Long supplierBookId) {

        JPAQuery<BusinessSupplierInfoVO> jpaQuery =
                jpaQueryFactory.select(Projections.bean(BusinessSupplierInfoVO.class,
                        qdo.id,
                        //qdo.remark,
                        //qdo.createUserId,
                        //qdo.creator,
                        //qdo.createTime,
                        //qdo.modifyUserId,
                        //qdo.updater,
                        //qdo.modifyTime,
                        // 业务伙伴id business_partner.id
                        qdo.partnerId,
                        // 供应商编号
                        qdo.supplierNo,
                        // jde同步标志
                        qdo.syncJdeFlag,
                        // 供应商状态 udc[CRM:BUSINESS_PARTNER:STATUS]
                        qdo.supplierStatus
                        // 供应商级别 udc[crm:customer_grade]
//                        qdo.supplierGradle,
//                        // 供应商产品
//                        qdo.supplierProduct,
//                        // 供货开始时间
//                        qdo.startTime,
//                        // 供货结束时间
//                        qdo.endTime,
                        // 结算周期
//                        qdo.settlementPeriod,
                        // 供货期间说明
//                        qdo.supplyDescription,
                        // 资质审核资料附件
//                        qdo.fileCode1,
                        // 实地考察资料
//                        qdo.fileCode2,
                        // 扩展字段1
//                        qdo.ext1,
                        // 扩展字段2
//                        qdo.ext2,
                        // 扩展字段3
//                        qdo.ext3,
                        // 扩展字段4
//                        qdo.ext4,
                        // 扩展字段5
//                        qdo.ext5
                )).from(qdo).leftJoin(qBusinessPartnerDO).on(qdo.partnerId.eq(qBusinessPartnerDO.id));

        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qBusinessPartnerDO.deleteFlag.eq(0));
        jpaQuery.where(qBusinessPartnerDO.bookId.eq(supplierBookId));
        return jpaQuery.fetchFirst();
    }
}

