package com.elitesland.tw.tw5.server.prd.partner.strategy.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessStrategyDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.QBusinessStrategyDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessStrategyRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 分级策略
 *
 * @author wangly
 * @date 2023-06-16
 */
@Repository
@RequiredArgsConstructor
public class BusinessStrategyDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessStrategyRepo repo;
    private final QBusinessStrategyDO qdo = QBusinessStrategyDO.businessStrategyDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessStrategyVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessStrategyVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 策略编号
                qdo.strategyNo,
                // 分级策略名称
                qdo.strategyName,
                // 分级策略适用身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]
                qdo.strategyIdentity,
                // 策略状态 udc[CRM:BUSINESS_STRATEGY:STATUS]
                qdo.strategyStatus,
                // 策略优先级 udc[CRM:BUSINESS_STRATEGY:PRIORITY]
                qdo.strategyPriority,
                // 策略范围 udc[CRM:BUSINESS_STRATEGY:RANGE]
                qdo.strategyRange,
                // 排序号
                qdo.sortNo,
                // 拓展字段1
                qdo.ext1,
                // 拓展字段2
                qdo.ext2,
                // 拓展字段3
                qdo.ext3,
                // 拓展字段4
                qdo.ext4,
                // 拓展字段5
                qdo.ext5,
                // 策略范围明细
                qdo.strategyRangeDetail
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessStrategyVO> getJpaQueryWhere(BusinessStrategyQuery query) {
        JPAQuery<BusinessStrategyVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BusinessStrategyQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BusinessStrategyQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 策略编号 精确 */
        if (!ObjectUtils.isEmpty(query.getStrategyNo())) {
            list.add(qdo.strategyNo.eq(query.getStrategyNo()));
        }
        /** 分级策略名称 精确 */
        if (!ObjectUtils.isEmpty(query.getStrategyName())) {
            list.add(qdo.strategyName.like(SqlUtil.toSqlLikeString(query.getStrategyName())));
        }
        /** 分级策略适用身份 udc[CRM:BUSINESS_PARTNER:IDENTITY] 精确 */
        if (!ObjectUtils.isEmpty(query.getStrategyIdentity())) {
            list.add(qdo.strategyIdentity.eq(query.getStrategyIdentity()));
        }
        /** 策略状态 udc[CRM:BUSINESS_STRATEGY:STATUS] 精确 */
        if (!ObjectUtils.isEmpty(query.getStrategyStatus())) {
            list.add(qdo.strategyStatus.eq(query.getStrategyStatus()));
        }
        /** 策略优先级 udc[CRM:BUSINESS_STRATEGY:PRIORITY] 精确 */
        if (!ObjectUtils.isEmpty(query.getStrategyPriority())) {
            list.add(qdo.strategyPriority.eq(query.getStrategyPriority()));
        }
        /** 策略范围 udc[CRM:BUSINESS_STRATEGY:RANGE] 精确 */
        if (!ObjectUtils.isEmpty(query.getStrategyRange())) {
            list.add(qdo.strategyRange.eq(query.getStrategyRange()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 拓展字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 拓展字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        /** 策略范围明细 精确 */
        if (!ObjectUtils.isEmpty(query.getStrategyRangeDetail())) {
            list.add(qdo.strategyRangeDetail.eq(query.getStrategyRangeDetail()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BusinessStrategyVO queryByKey(Long id) {
        JPAQuery<BusinessStrategyVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BusinessStrategyVO> queryListDynamic(BusinessStrategyQuery query) {
        JPAQuery<BusinessStrategyVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BusinessStrategyVO> queryPaging(BusinessStrategyQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BusinessStrategyVO> jpaQuery = getJpaQueryWhere(query);
        List<BusinessStrategyVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessStrategyVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BusinessStrategyDO save(BusinessStrategyDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BusinessStrategyDO> saveAll(List<BusinessStrategyDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BusinessStrategyPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 策略编号
        if (payload.getStrategyNo() != null) {
            update.set(qdo.strategyNo, payload.getStrategyNo());
        }
        // 分级策略名称
        if (payload.getStrategyName() != null) {
            update.set(qdo.strategyName, payload.getStrategyName());
        }
        // 分级策略适用身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]
        if (payload.getStrategyIdentity() != null) {
            update.set(qdo.strategyIdentity, payload.getStrategyIdentity());
        }
        // 策略状态 udc[CRM:BUSINESS_STRATEGY:STATUS]
        if (payload.getStrategyStatus() != null) {
            update.set(qdo.strategyStatus, payload.getStrategyStatus());
        }
        // 策略优先级 udc[CRM:BUSINESS_STRATEGY:PRIORITY]
        if (payload.getStrategyPriority() != null) {
            update.set(qdo.strategyPriority, payload.getStrategyPriority());
        }
        // 策略范围 udc[CRM:BUSINESS_STRATEGY:RANGE]
        if (payload.getStrategyRange() != null) {
            update.set(qdo.strategyRange, payload.getStrategyRange());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        // 拓展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 拓展字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 拓展字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 策略范围明细
        if (payload.getStrategyRangeDetail() != null) {
            update.set(qdo.strategyRangeDetail, payload.getStrategyRangeDetail());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 策略编号
            if (nullFields.contains("strategyNo")) {
                update.setNull(qdo.strategyNo);
            }
            // 分级策略名称
            if (nullFields.contains("strategyName")) {
                update.setNull(qdo.strategyName);
            }
            // 分级策略适用身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]
            if (nullFields.contains("strategyIdentity")) {
                update.setNull(qdo.strategyIdentity);
            }
            // 策略状态 udc[CRM:BUSINESS_STRATEGY:STATUS]
            if (nullFields.contains("strategyStatus")) {
                update.setNull(qdo.strategyStatus);
            }
            // 策略优先级 udc[CRM:BUSINESS_STRATEGY:PRIORITY]
            if (nullFields.contains("strategyPriority")) {
                update.setNull(qdo.strategyPriority);
            }
            // 策略范围 udc[CRM:BUSINESS_STRATEGY:RANGE]
            if (nullFields.contains("strategyRange")) {
                update.setNull(qdo.strategyRange);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }
            // 拓展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 拓展字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 拓展字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
            // 策略范围明细
            if (nullFields.contains("strategyRangeDetail")) {
                update.setNull(qdo.strategyRangeDetail);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }
    /**
     * 查询 更新客户级别定时任务 的分级策略
     *
     */
    public List<BusinessStrategyVO> queryStraegyJobHandler(){
        JPAQuery<BusinessStrategyVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdo.strategyStatus.eq(BusinessStrategyStatusEnum.OPEN.getCode()));
        OrderItem strategyPriorityOrderItem = OrderItem.desc("strategyPriority");
        List<OrderItem> OrderItemList = new ArrayList<>();
        OrderItemList.add(strategyPriorityOrderItem);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, OrderItemList));
        //jpaQuery.limit(1);
        return jpaQuery.fetch();
//        List<BusinessStrategyVO> businessStrategyVOList = jpaQuery.fetch();
//        if(!CollectionUtils.isEmpty(businessStrategyVOList)){
//            return businessStrategyVOList;
//        }
//        return  null;
    }

}

