package com.elitesland.tw.tw5.server.prd.partner.strategy.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 分级策略等级配置
 *
 * @author wangly
 * @date 2023-06-16
 */
@Entity
@Table(name = "business_strategy_grade_setting", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "business_strategy_grade_setting", comment = "分级策略等级配置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessStrategyGradeSettingDO extends BaseModel implements Serializable  {
    /** 策略id business_strategy.id */
    @Comment("策略id business_strategy.id")
    @Column()
    private Long strategyId;
    /** 等级类别 udc[crm:customer_grade] */
    @Comment("等级类别 udc[crm:customer_grade]")
    @Column()
    private String gradleType;
    /** 分数开始 */
    @Comment("分数开始")
    @Column()
    private BigDecimal scoreStart;
    /** 分数结束 */
    @Comment("分数结束")
    @Column()
    private BigDecimal scoreEnd;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    public void copy(BusinessStrategyGradeSettingDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
