package com.elitesland.tw.tw5.server.prd.personplan.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


 /**
  * @author : WWW
  * @date : 2024-2-21
  * @desc : 人员规划
  */
@RestController
@RequestMapping("/api/personPlan")
@RequiredArgsConstructor
@Api(value = "人员规划", tags = {"人员规划"})
public class PersonPlanController {
    
    private final PersonPlanService personPlanService;
    
    
    @GetMapping("get")
    @ApiOperation("详情-人员规划")
    public TwOutputUtil<PersonPlanVO> get(Long id) {
    
        PersonPlanVO res = personPlanService.get(id);
        return TwOutputUtil.ok(res);
        
    }


     @GetMapping("getByObjIdAndPlanType")
     @ApiOperation("根据项目id查询-人员规划")
     @UdcNameClass
     public TwOutputUtil<PersonPlanVO> getByObjIdAndPlanType(Long objId,String [] planType) {

         PersonPlanVO res = personPlanService.getByObjIdAndPlanType(objId, Arrays.asList(planType));
         return TwOutputUtil.ok(res);

     }
    
    
    @PostMapping("saveOrUp")
    @ApiOperation("新增/修改-人员规划")
    public TwOutputUtil<Long> save(@RequestBody PersonPlanPayload personPlanPayload) {
        
        PersonPlanVO res = personPlanService.save(personPlanPayload);
        return TwOutputUtil.ok(res.getId());
        
    }
    
    
    @PostMapping("update")
    @ApiOperation("修改-人员规划")
    public TwOutputUtil<Long> update(@RequestBody PersonPlanPayload personPlanPayload) {
        
        Long res = personPlanService.update(personPlanPayload);
        return TwOutputUtil.ok(res);
        
    }
    
    
    @PostMapping("del")
    @ApiOperation("删除-人员规划")
    public TwOutputUtil<Long> del(@RequestBody List<Long> ids) {
    
        Long res = personPlanService.del(ids);
        return TwOutputUtil.ok(res);
        
    }
    
    
    @PostMapping("page")
    @UdcNameClass
    @ApiOperation("分页查询-人员规划")
    public TwOutputUtil<PagingVO<PersonPlanVO>> page(@RequestBody PersonPlanQuery personPlanQuery) {
        
        PagingVO<PersonPlanVO> res = personPlanService.page(personPlanQuery);
        return TwOutputUtil.ok(res);
        
    }
    
    
    
    @GetMapping("getList")
    @ApiOperation("列表查询-人员规划")
    public TwOutputUtil<List<PersonPlanVO>> getList(PersonPlanQuery personPlanQuery) {
    
        List<PersonPlanVO> res = personPlanService.getList(personPlanQuery);
        return TwOutputUtil.ok(res);
        
    }


    @PostMapping("saveNewVersion")
    @ApiOperation("保存新版本-人员规划")
    public TwOutputUtil saveNewVersion(@RequestBody PersonPlanPayload personPlanPayload) {
        personPlanService.saveNewVersion(personPlanPayload);
        return TwOutputUtil.ok();
    }


     @GetMapping("transferData")
     @ApiOperation("资源规划老数据迁移-人员规划")
     public TwOutputUtil transferData() {
         personPlanService.transferData();
         return TwOutputUtil.ok();
     }
}

