package com.elitesland.tw.tw5.server.prd.personplan.dao;

import com.elitesland.tw.tw5.server.prd.personplan.entity.PersonPlanTmpDO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.QPersonPlanTmpDO;
import com.elitesland.tw.tw5.server.prd.personplan.repo.PersonPlanTmpRepo;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@RequiredArgsConstructor
public class PersonPlanTmpDAO {

    private final PersonPlanTmpRepo repo;

    private final JPAQueryFactory jpaQueryFactory;

    private final QPersonPlanTmpDO qPersonplanTmpDO = QPersonPlanTmpDO.personPlanTmpDO;


    public void save(PersonPlanTmpDO personPlanTmpDO) {
        repo.save(personPlanTmpDO);
    }

    @Transactional
    public void deleteAllByDtlId(Long dtlId) {
        jpaQueryFactory.update(qPersonplanTmpDO)
                .set(qPersonplanTmpDO.deleteFlag, 1)
                .where(qPersonplanTmpDO.planDtlId.eq(dtlId))
                .execute();
    }


}
