package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitesland.tw.tw5.api.prd.pms.payload.PmsInnerProjectApplyPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsInnerProjectApplyQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsInnerProjectApplyVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsInnerProjectApplyService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 内部项目申请
 *
 * @author carl
 * @date 2023-08-23
 */
@Api(tags = "内部项目申请")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsInnerProjectApply")
@Slf4j
public class PmsInnerProjectApplyController {

    private final PmsInnerProjectApplyService pmsInnerProjectApplyService;


    /**
     * 内部项目申请-新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("内部项目申请-新增或修改")
    @GlobalTransactional
    public TwOutputUtil<PmsInnerProjectApplyVO> save(@RequestBody PmsInnerProjectApplyPayload payload) {
        return TwOutputUtil.ok(pmsInnerProjectApplyService.save(payload));
    }

//    /**
//     * 内部项目申请-新增
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PostMapping
//    @ApiOperation("内部项目申请-新增")
//    public TwOutputUtil<PmsInnerProjectApplyVO> insert(@RequestBody PmsInnerProjectApplyPayload payload) {
//        return TwOutputUtil.ok(pmsInnerProjectApplyService.insert(payload));
//    }
//
//    /**
//     * 内部项目申请-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("内部项目申请-更新")
//    public TwOutputUtil<PmsInnerProjectApplyVO> update(@RequestBody PmsInnerProjectApplyPayload payload) {
//        return TwOutputUtil.ok(pmsInnerProjectApplyService.update(payload));
//    }

    /**
     * 内部项目申请-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("内部项目申请-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PmsInnerProjectApplyPayload payload){
        return TwOutputUtil.ok(pmsInnerProjectApplyService.updateByKeyDynamic(payload));
    }

    /**
     * 内部项目申请-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("内部项目申请-主键查询")
    public TwOutputUtil<PmsInnerProjectApplyVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsInnerProjectApplyService.queryByKey(key));
    }

    /**
     * 内部项目申请-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("内部项目申请-分页")
    public TwOutputUtil<PagingVO<PmsInnerProjectApplyVO>> paging(PmsInnerProjectApplyQuery query) {
        return TwOutputUtil.ok(pmsInnerProjectApplyService.queryPaging(query));
    }

    /**
     * 内部项目申请-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("内部项目申请-查询列表")
    public TwOutputUtil<List<PmsInnerProjectApplyVO>> queryList(PmsInnerProjectApplyQuery query) {
        return TwOutputUtil.ok(pmsInnerProjectApplyService.queryListDynamic(query));
    }

    /**
     * 内部项目申请-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("内部项目申请-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsInnerProjectApplyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 添加项目id
     *
     * @param id
     * @param projId
     * @return
     */
    @GetMapping("/addProject")
    // @UdcNameClass
    @ApiOperation("添加项目id")
    public TwOutputUtil<PmsInnerProjectApplyVO> addProject(long id, long projId) {
        pmsInnerProjectApplyService.addProject(id, projId);
        return TwOutputUtil.ok();
    }

}

