package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 项目汇报计划管理
 *
 * @author carl
 * @date 2023-09-05
 */
@Entity
@Table(name = "pms_project_report_plan", indexes = {
        @Index(name = "proj_index", columnList = "proj_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_report_plan", comment = "项目汇报计划管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectReportPlanDO extends BaseModel implements Serializable {
    /**
     * 项目id
     */
    @Comment("项目id")
    @Column(name = "proj_id")
    private Long projId;
    /**
     * 期间
     */
    @Comment("期间")
    @Column()
    private LocalDate periodDate;
    /**
     * 金额
     */
    @Comment("金额")
    @Column()
    private BigDecimal amt;
    /**
     * 项目汇报id
     */
    @Comment("项目汇报id")
    @Column()
    private Long briefId;

    /**
     * 汇报编号
     */
    @Comment("汇报编号")
    @Column()
    private String briefNo;

    public void copy(PmsProjectReportPlanDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
