package com.elitesland.tw.tw5.server.prd.purchase.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.BillVerDetailPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.BillVerDetailQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.BillVerDetailVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.purchase.entity.BillVerDetailDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.QBillVerDetailDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.QPurchaseAgreementDetailsDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.QPurchaseContractDetailsDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.BillVerDetailRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 预付款收据管理
 *
 * @author wangly
 * @date 2024-05-27
 */
@Repository
@RequiredArgsConstructor
public class BillVerDetailDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BillVerDetailRepo repo;
    private final QBillVerDetailDO qdo = QBillVerDetailDO.billVerDetailDO;
    private final QPurchaseContractDetailsDO qPurchaseContractDetailsDO = QPurchaseContractDetailsDO.purchaseContractDetailsDO;
    private final QPurchaseAgreementDetailsDO qPurchaseAgreementDetailsDO = QPurchaseAgreementDetailsDO.purchaseAgreementDetailsDO;


    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BillVerDetailVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BillVerDetailVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 付款申请单ID
                qdo.paymentApplyId,
                // 票据号
                qdo.billNo,
                // 本次核销金额
                qdo.theAmt,
                // 票据金额
                qdo.invoiceAmt,
                // 已核销金额
                qdo.writtenOffAmt,
                // 税率
                qdo.rate,
                // 票据日期
                qdo.invoiceDate,
                // 关联采购明细Id
                qdo.purConOrAgreementDetailId,
                // 关联采购明细Id
                qdo.purConDetailId,
                // 票据附件
                qdo.fileCode,
                // jde票据公司
                qdo.jdecompany,
                // jde单据号
                qdo.jdedocumentno,
                // jde单据类型
                qdo.jdedocumenttype,
                // jde付款项
                qdo.jdepaymentitem,
                // jde发票凭证失败原因
                qdo.jdeinvoicefailreason,
                // 预留字段1
                qdo.ext1,
                // 预留字段2
                qdo.ext2,
                // 预留字段3
                qdo.ext3,
                // 预留字段4
                qdo.ext4,
                // 预留字段5
                qdo.ext5,
                // 预留字段6
                qdo.ext6,
                // 预留字段7
                qdo.ext7,
                // 预留字段8
                qdo.ext8
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BillVerDetailVO> getJpaQueryWhere(BillVerDetailQuery query) {
        JPAQuery<BillVerDetailVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BillVerDetailQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BillVerDetailQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 付款申请单ID 精确 */
        if (!ObjectUtils.isEmpty(query.getPaymentApplyId())) {
            list.add(qdo.paymentApplyId.eq(query.getPaymentApplyId()));
        }
        /** 票据号 精确 */
        if (!ObjectUtils.isEmpty(query.getBillNo())) {
            list.add(qdo.billNo.eq(query.getBillNo()));
        }
        /** 本次核销金额 精确 */
        if (!ObjectUtils.isEmpty(query.getTheAmt())) {
            list.add(qdo.theAmt.eq(query.getTheAmt()));
        }
        /** 票据金额 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceAmt())) {
            list.add(qdo.invoiceAmt.eq(query.getInvoiceAmt()));
        }
        /** 已核销金额 精确 */
        if (!ObjectUtils.isEmpty(query.getWrittenOffAmt())) {
            list.add(qdo.writtenOffAmt.eq(query.getWrittenOffAmt()));
        }
        /** 税率 精确 */
        if (!ObjectUtils.isEmpty(query.getRate())) {
            list.add(qdo.rate.eq(query.getRate()));
        }
        /** 票据日期 精确 */
        if (!ObjectUtils.isEmpty(query.getInvoiceDate())) {
            list.add(qdo.invoiceDate.eq(query.getInvoiceDate()));
        }
        /** 关联采购明细Id 精确 */
        if (!ObjectUtils.isEmpty(query.getPurConOrAgreementDetailId())) {
            list.add(qdo.purConOrAgreementDetailId.eq(query.getPurConOrAgreementDetailId()));
        }
        /** 关联采购明细Id 精确 */
        if (!ObjectUtils.isEmpty(query.getPurConDetailId())) {
            list.add(qdo.purConDetailId.eq(query.getPurConDetailId()));
        }
        /** 票据附件 精确 */
        if (!ObjectUtils.isEmpty(query.getFileCode())) {
            list.add(qdo.fileCode.eq(query.getFileCode()));
        }
        /** jde票据公司 精确 */
        if (!ObjectUtils.isEmpty(query.getJdecompany())) {
            list.add(qdo.jdecompany.eq(query.getJdecompany()));
        }
        /** jde单据号 精确 */
        if (!ObjectUtils.isEmpty(query.getJdedocumentno())) {
            list.add(qdo.jdedocumentno.eq(query.getJdedocumentno()));
        }
        /** jde单据类型 精确 */
        if (!ObjectUtils.isEmpty(query.getJdedocumenttype())) {
            list.add(qdo.jdedocumenttype.eq(query.getJdedocumenttype()));
        }
        /** jde付款项 精确 */
        if (!ObjectUtils.isEmpty(query.getJdepaymentitem())) {
            list.add(qdo.jdepaymentitem.eq(query.getJdepaymentitem()));
        }
        /** jde发票凭证失败原因 精确 */
        if (!ObjectUtils.isEmpty(query.getJdeinvoicefailreason())) {
            list.add(qdo.jdeinvoicefailreason.eq(query.getJdeinvoicefailreason()));
        }
        /** 预留字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 预留字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 预留字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        /** 预留字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExt4())) {
            list.add(qdo.ext4.eq(query.getExt4()));
        }
        /** 预留字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExt5())) {
            list.add(qdo.ext5.eq(query.getExt5()));
        }
        /** 预留字段6 精确 */
        if (!ObjectUtils.isEmpty(query.getExt6())) {
            list.add(qdo.ext6.eq(query.getExt6()));
        }
        /** 预留字段7 精确 */
        if (!ObjectUtils.isEmpty(query.getExt7())) {
            list.add(qdo.ext7.eq(query.getExt7()));
        }
        /** 预留字段8 精确 */
        if (!ObjectUtils.isEmpty(query.getExt8())) {
            list.add(qdo.ext8.eq(query.getExt8()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BillVerDetailVO queryByKey(Long id) {
        JPAQuery<BillVerDetailVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BillVerDetailVO> queryListDynamic(BillVerDetailQuery query) {
        JPAQuery<BillVerDetailVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BillVerDetailVO> queryPaging(BillVerDetailQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<BillVerDetailVO> jpaQuery = getJpaQueryWhere(query);
        List<BillVerDetailVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BillVerDetailVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BillVerDetailDO save(BillVerDetailDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BillVerDetailDO> saveAll(List<BillVerDetailDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BillVerDetailPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 付款申请单ID
        if (payload.getPaymentApplyId() != null) {
            update.set(qdo.paymentApplyId, payload.getPaymentApplyId());
        }
        // 票据号
        if (payload.getBillNo() != null) {
            update.set(qdo.billNo, payload.getBillNo());
        }
        // 本次核销金额
        if (payload.getTheAmt() != null) {
            update.set(qdo.theAmt, payload.getTheAmt());
        }
        // 票据金额
        if (payload.getInvoiceAmt() != null) {
            update.set(qdo.invoiceAmt, payload.getInvoiceAmt());
        }
        // 已核销金额
        if (payload.getWrittenOffAmt() != null) {
            update.set(qdo.writtenOffAmt, payload.getWrittenOffAmt());
        }
        // 税率
        if (payload.getRate() != null) {
            update.set(qdo.rate, payload.getRate());
        }
        // 票据日期
        if (payload.getInvoiceDate() != null) {
            update.set(qdo.invoiceDate, payload.getInvoiceDate());
        }
        // 关联采购明细Id
        if (payload.getPurConOrAgreementDetailId() != null) {
            update.set(qdo.purConOrAgreementDetailId, payload.getPurConOrAgreementDetailId());
        }
        // 关联采购明细Id
        if (payload.getPurConDetailId() != null) {
            update.set(qdo.purConDetailId, payload.getPurConDetailId());
        }
        // 票据附件
        if (payload.getFileCode() != null) {
            update.set(qdo.fileCode, payload.getFileCode());
        }
        // JDE批号
        if (payload.getInvoiceVoucher() != null) {
            update.set(qdo.invoiceVoucher, payload.getInvoiceVoucher());
        }
        // jde票据公司
        if (payload.getJdecompany() != null) {
            update.set(qdo.jdecompany, payload.getJdecompany());
        }
        // jde单据号
        if (payload.getJdedocumentno() != null) {
            update.set(qdo.jdedocumentno, payload.getJdedocumentno());
        }
        // jde单据类型
        if (payload.getJdedocumenttype() != null) {
            update.set(qdo.jdedocumenttype, payload.getJdedocumenttype());
        }
        // jde付款项
        if (payload.getJdepaymentitem() != null) {
            update.set(qdo.jdepaymentitem, payload.getJdepaymentitem());
        }
        // jde发票凭证失败原因
        if (payload.getJdeinvoicefailreason() != null) {
            update.set(qdo.jdeinvoicefailreason, payload.getJdeinvoicefailreason());
        }
        // 预留字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 预留字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 预留字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 预留字段4
        if (payload.getExt4() != null) {
            update.set(qdo.ext4, payload.getExt4());
        }
        // 预留字段5
        if (payload.getExt5() != null) {
            update.set(qdo.ext5, payload.getExt5());
        }
        // 预留字段6
        if (payload.getExt6() != null) {
            update.set(qdo.ext6, payload.getExt6());
        }
        // 预留字段7
        if (payload.getExt7() != null) {
            update.set(qdo.ext7, payload.getExt7());
        }
        // 预留字段8
        if (payload.getExt8() != null) {
            update.set(qdo.ext8, payload.getExt8());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 付款申请单ID
            if (nullFields.contains("paymentApplyId")) {
                update.setNull(qdo.paymentApplyId);
            }
            // 票据号
            if (nullFields.contains("billNo")) {
                update.setNull(qdo.billNo);
            }
            // 本次核销金额
            if (nullFields.contains("theAmt")) {
                update.setNull(qdo.theAmt);
            }
            // 票据金额
            if (nullFields.contains("invoiceAmt")) {
                update.setNull(qdo.invoiceAmt);
            }
            // 已核销金额
            if (nullFields.contains("writtenOffAmt")) {
                update.setNull(qdo.writtenOffAmt);
            }
            // 税率
            if (nullFields.contains("rate")) {
                update.setNull(qdo.rate);
            }
            // 票据日期
            if (nullFields.contains("invoiceDate")) {
                update.setNull(qdo.invoiceDate);
            }
            // 关联采购明细Id
            if (nullFields.contains("purConOrAgreementDetailId")) {
                update.setNull(qdo.purConOrAgreementDetailId);
            }
            // 关联采购明细Id
            if (nullFields.contains("purConDetailId")) {
                update.setNull(qdo.purConDetailId);
            }
            // 票据附件
            if (nullFields.contains("fileCode")) {
                update.setNull(qdo.fileCode);
            }
            // jde票据公司
            if (nullFields.contains("jdecompany")) {
                update.setNull(qdo.jdecompany);
            }
            // jde单据号
            if (nullFields.contains("jdedocumentno")) {
                update.setNull(qdo.jdedocumentno);
            }
            // jde单据类型
            if (nullFields.contains("jdedocumenttype")) {
                update.setNull(qdo.jdedocumenttype);
            }
            // jde付款项
            if (nullFields.contains("jdepaymentitem")) {
                update.setNull(qdo.jdepaymentitem);
            }
            // jde发票凭证失败原因
            if (nullFields.contains("jdeinvoicefailreason")) {
                update.setNull(qdo.jdeinvoicefailreason);
            }
            // 预留字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 预留字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 预留字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
            // 预留字段4
            if (nullFields.contains("ext4")) {
                update.setNull(qdo.ext4);
            }
            // 预留字段5
            if (nullFields.contains("ext5")) {
                update.setNull(qdo.ext5);
            }
            // 预留字段6
            if (nullFields.contains("ext6")) {
                update.setNull(qdo.ext6);
            }
            // 预留字段7
            if (nullFields.contains("ext7")) {
                update.setNull(qdo.ext7);
            }
            // 预留字段8
            if (nullFields.contains("ext8")) {
                update.setNull(qdo.ext8);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据付款申请单id查询票据核销明细列表
     *
     * @param docType        类型
     * @param paymentApplyId 付款申请单id
     */
    public List<BillVerDetailVO> queryListIsNullByPaymentApplyId(String docType, Long paymentApplyId) {
        JPAQuery<BillVerDetailVO> jpaQueryByDocType = getJpaQueryByDocType(docType);
        jpaQueryByDocType.where(qdo.paymentApplyId.eq(paymentApplyId));
        jpaQueryByDocType.where(qdo.invoiceVoucher.isNull());
        jpaQueryByDocType.where(qdo.deleteFlag.eq(0));

        return jpaQueryByDocType.fetch();
    }

    /**
     * 根据付款申请单id查询票据核销明细列表
     *
     * @param docType        类型
     * @param paymentApplyId 付款申请单id
     */
    public List<BillVerDetailVO> queryListByPaymentApplyId(String docType, Long paymentApplyId) {
        JPAQuery<BillVerDetailVO> jpaQueryByDocType = getJpaQueryByDocType(docType);
        jpaQueryByDocType.where(qdo.paymentApplyId.eq(paymentApplyId));
        jpaQueryByDocType.where(qdo.deleteFlag.eq(0));
        return jpaQueryByDocType.fetch();
    }


    /**
     * 根据关联明细获取jpaQuery
     *
     * @param docType 关联单据类型
     * @return JPAQuery<InvInvoiceVerDetailVO>
     */
    private JPAQuery<BillVerDetailVO> getJpaQueryByDocType(String docType) {
        JPAQuery<BillVerDetailVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BillVerDetailVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                // 租户ID
                qdo.tenantId,
                // 付款申请单ID
                qdo.paymentApplyId,
                // 发票号
                qdo.billNo,
                // 本次核销金额
                qdo.theAmt,
                // 发票金额
                qdo.invoiceAmt,
                // 已核销金额
                qdo.writtenOffAmt,
                // 税率
                qdo.rate,
                // 发票日期
                qdo.invoiceDate,
                //发票凭证字段
                qdo.invoiceVoucher,
                //JDE单据公司
                qdo.jdecompany,
                //JDE单据号
                qdo.jdedocumentno,
                //JDE单据类型
                qdo.jdedocumenttype,
                //JDE付款项
                qdo.jdepaymentitem,
                qdo.jdeinvoicefailreason,
                // 关联采购明细ID
                qdo.purConOrAgreementDetailId,
                // 附件
                qdo.fileCode

        )).from(qdo);
        // 关联合同
        if (PurchasePaymentEnum.PaymentDocType.CONTRACT.getCode().equals(docType)) {
            jpaQuery.leftJoin(qPurchaseContractDetailsDO).on(qdo.purConOrAgreementDetailId.eq(qPurchaseContractDetailsDO.id)
                    .and(qPurchaseContractDetailsDO.deleteFlag.eq(0)));
            // 采购协议
        } else if (PurchasePaymentEnum.PaymentDocType.AGREEMENT.getCode().equals(docType)) {
            jpaQuery.leftJoin(qPurchaseAgreementDetailsDO).on(qdo.purConOrAgreementDetailId.eq(qPurchaseAgreementDetailsDO.id)
                    .and(qPurchaseAgreementDetailsDO.deleteFlag.eq(0)));

        } else {
            return getJpaQuerySelect();
        }
        return jpaQuery;
    }

    /**
     * 根据付款申请单id删除票据核销明细
     *
     * @param paymentApplyId 付款申请单id
     */
    public void deleteByPaymentApplyId(Long paymentApplyId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.paymentApplyId.eq(paymentApplyId));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        update.execute();
    }
}

