package com.elitesland.tw.tw5.server.prd.salecon.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivableQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivableService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivableVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 合同收款
 *
 * @author lemon
 * @date 2023-08-31
 */
@Api(tags = "合同收款")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/conReceivable")
@Slf4j
public class ConReceivableController {

private final ConReceivableService conReceivableService;

    /**
     * 合同收款-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("合同收款-新增")
    public TwOutputUtil<ConReceivableVO> insert(@RequestBody ConReceivablePayload payload){
         return TwOutputUtil.ok(conReceivableService.insert(payload));
    }

    /**
     * 合同收款-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("合同收款-更新")
    public TwOutputUtil<ConReceivableVO> update(@RequestBody ConReceivablePayload payload){
        return TwOutputUtil.ok(conReceivableService.update(payload));
    }

    /**
     * 合同收款-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("合同收款-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody ConReceivablePayload payload){
        return TwOutputUtil.ok(conReceivableService.updateByKeyDynamic(payload));
    }

    /**
     * 合同收款-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("合同收款-主键查询")
    public TwOutputUtil<ConReceivableVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(conReceivableService.queryByKey(key));
    }

    /**
     * 合同收款-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("合同收款-分页")
    public TwOutputUtil<PagingVO<ConReceivableVO>> paging(ConReceivableQuery query) {
        return TwOutputUtil.ok(conReceivableService.queryPaging(query));
    }

    /**
     * 合同收款-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("合同收款-查询列表")
    public TwOutputUtil<List<ConReceivableVO>> queryList(ConReceivableQuery query) {
        return TwOutputUtil.ok(conReceivableService.queryListDynamic(query));
    }

    /**
     * 合同收款-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("合同收款-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         conReceivableService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }


    /**
     * 更新收款表银行账号、总账日期
     *
     * @param invId      开票记录id
     * @param accountNo  银行账号
     * @param ledgerDate 总账日期
     * @return 更新记录数
     */
    @PatchMapping("/updateRecvAccount/{invId}/{accountNo}/{ledgerDate}")
    public TwOutputUtil updateRecvAccount(@PathVariable("invId") Long invId, @PathVariable("accountNo") String accountNo, @PathVariable("ledgerDate") String ledgerDate) {
        return TwOutputUtil.ok(conReceivableService.updateRecvAccount(invId, accountNo, ledgerDate));
    }

}

