package com.elitesland.tw.tw5.server.prd.salecon.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConPurchaseDemandDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConPurchaseDemandDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConPurchaseDemandDVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectDO;
import com.elitesland.tw.tw5.server.prd.product.entity.QPrdProductDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.QPurchaseContractManagerDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConPurchaseDemandDDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QConPurchaseDemandDDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QConPurchaseDemandDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QSaleConContractDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConPurchaseDemandDRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 采购需求处理明细
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Repository
@RequiredArgsConstructor
public class ConPurchaseDemandDDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final ConPurchaseDemandDRepo repo;
    //明细表
    private final QConPurchaseDemandDDO qdo = QConPurchaseDemandDDO.conPurchaseDemandDDO;
    //需求表
    private final QConPurchaseDemandDO qConPurchaseDemandDO = QConPurchaseDemandDO.conPurchaseDemandDO;
    //合同表
    private final QSaleConContractDO qdoSaleCon = QSaleConContractDO.saleConContractDO;
    //客户表
    // private final QCrmCustomerDO qdoCrmCust = QCrmCustomerDO.crmCustomerDO;
    //关联合同表
    private final QSaleConContractDO qdoRelatedCon = new QSaleConContractDO("qdoRelatedCon");

    private final QPrdProductDO productDO = QPrdProductDO.prdProductDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;

    // private final QPrdAbDO qdoAb = QPrdAbDO.prdAbDO;

    private final QPmsProjectDO qPmsProjectDO = QPmsProjectDO.pmsProjectDO;

    private final QPurchaseContractManagerDO qPurchaseContractManagerDO = QPurchaseContractManagerDO.purchaseContractManagerDO;
    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;
    private final QBusinessPartnerDO qBusinessPartnerSupplierDO = new QBusinessPartnerDO("qBusinessPartnerSupplierDO");

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<ConPurchaseDemandDVO> getJpaQuerySimpleSelect() {
        return jpaQueryFactory.select(Projections.bean(ConPurchaseDemandDVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                qdo.demandDetailIdV4,
                qdo.saleConId,
                // 建议供应商ID
                qdo.supplierId,
                // 需求说明
                qdo.demandSaid,
                // 关联产品
                qdo.productId,
                // 采购大类
                qdo.productClass,
                qdo.productClassId,
                // 采购小类
                qdo.productSubClass,
                qdo.productSubClassId,
                // 数量
                qdo.demandNum,
                // 含税单价
                qdo.taxPrice,
                // 货币
                qdo.symbol,
                // 税率
                qdo.taxRate,
                // 含税总额
                qdo.taxAmt,
                // 不含税总额
                qdo.notTaxAmt,
                // 采购合同id
                qdo.purContractId,
                // 采购需求id
                qdo.purDemandId,
                // 需求状态
                qdo.demandStatus,
                // 需求负责人
                qdo.demandDirectorUserId,
                // 需求编号
                qdo.demandCode.as("demandCode"),
                // 需求类别
                qdo.demandType,
                // 需求日期
                qdo.demandDate

        )).from(qdo);
    }

    /**
     * 根据销售合同查询
     *
     * @param saleConId 查询参数
     * @return 结果集合
     */
    public List<ConPurchaseDemandDVO> queryListBySaleConIds(List<Long> saleConIds) {
        JPAQuery<ConPurchaseDemandDVO> jpaQuery = getJpaQuerySimpleSelect();
        jpaQuery.where(qdo.saleConId.in(saleConIds));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<ConPurchaseDemandDVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(ConPurchaseDemandDVO.class,
                        qdo.id,
                        qdo.remark,
                        qdo.createUserId,
                        qdo.creator,
                        qdo.createTime,
                        qdo.modifyUserId,
                        qdo.updater,
                        qdo.modifyTime,
                        qdo.demandDetailIdV4,
                        // 建议供应商ID
                        qdo.supplierId,
                        // 需求说明
                        qdo.demandSaid,
                        // 关联产品
                        qdo.productId,
                        productDO.prodName.as("productName"),
                        // 采购大类
                        qdo.productClass,
                        qdo.productClassId,
                        // 采购小类
                        qdo.productSubClass,
                        qdo.productSubClassId,
                        // 数量
                        qdo.demandNum,
                        // 含税单价
                        qdo.taxPrice,
                        // 货币
                        qdo.symbol,
                        // 税率
                        qdo.taxRate,
                        // 含税总额
                        qdo.taxAmt,
                        // 不含税总额
                        qdo.notTaxAmt,
                        // 采购合同id
                        qdo.purContractId,
                        // 采购合同编号
                        qPurchaseContractManagerDO.purchaseContractNo.as("purContractCode"),
                        // 采购需求id
                        qdo.purDemandId,
                        // 销售合同id
                        qdoSaleCon.id.as("saleConId"),
                        // 销售合同名称
                        qdoSaleCon.name.as("saleConName"),
                        // 销售合同编号
                        qdoSaleCon.code.as("saleConCode"),
                        // 客户Id
                        qdoSaleCon.custId,
                        // 客户名称
                        qBusinessPartnerDO.partnerName.as("custName"),
                        // 需求状态
                        qdo.demandStatus,
                        // 需求负责人
                        qdo.demandDirectorUserId,
                        // 需求编号
                        qdo.demandCode.as("demandCode"),
                        // 需求类别
                        qdo.demandType,
                        // 需求日期
                        qdo.demandDate,
                        // 参考合同号
                        qdoSaleCon.referCode,
                        // 客户id
                        qdoSaleCon.custId,
                        // 关联合同ID
                        qdoSaleCon.relatedContractId,
                        // 关联合同号
                        qdoRelatedCon.code.as("relatedContractCode"),
                        // 关联合同状态
                        qdoSaleCon.status.as("relatedContractStatus"),
                        // 项目Id
                        qPmsProjectDO.id.as("projId")
                )).from(qdo)
                .leftJoin(qdoSaleCon).on(qdo.saleConId.longValue().eq(qdoSaleCon.id.longValue()))
                .leftJoin(qBusinessPartnerDO).on(qdoSaleCon.custId.longValue().eq(qBusinessPartnerDO.bookId.longValue()))
                .leftJoin(qdoRelatedCon).on(qdoSaleCon.relatedContractId.longValue().eq(qdoRelatedCon.id.longValue()))
                .leftJoin(productDO).on(qdo.productId.longValue().eq(productDO.id.longValue()))
                .leftJoin(qPmsProjectDO).on(qPmsProjectDO.contractId.eq(qdoSaleCon.id))
                .leftJoin(qPurchaseContractManagerDO).on(qdo.purContractId.eq(qPurchaseContractManagerDO.id))
                .leftJoin(qdoRef).on(qdoSaleCon.saleManUserId.longValue().eq(qdoRef.userId.longValue()).and(qdoRef.isDefault.eq(0)).and(qdoRef.isCopy.eq(0)).and(qdoRef.deleteFlag.eq(0)));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<ConPurchaseDemandDVO> getJpaQueryWhere(ConPurchaseDemandDQuery query) {
        JPAQuery<ConPurchaseDemandDVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        jpaQuery.groupBy(qdo.id);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(ConPurchaseDemandDQuery query) {
//        long total = jpaQueryFactory
//            .select(qdo.count())
//            .from(qdo)
//            .where(where(query))
//            .fetchOne();
        long total = getJpaQueryWhere(query).fetchCount();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(ConPurchaseDemandDQuery query) {
        List<Predicate> list = new ArrayList<>();
        list.add(qdo.deleteFlag.eq(0));
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 记录唯一ID 精确 */
        if (!CollectionUtils.isEmpty(query.getIds())) {
            list.add(qdo.id.in(query.getIds()));
        }
        /** 需求备注 模糊 */
        if (!ObjectUtils.isEmpty(query.getRemark())) {
            list.add(qdo.remark.like(SqlUtil.toSqlLikeString(query.getRemark())));
        }
        /** 建议供应商ID 精确 */
        if (!ObjectUtils.isEmpty(query.getSupplierId())) {
            list.add(qdo.supplierId.eq(query.getSupplierId()));
        }
        /** 需求说明 模糊 */
        if (!ObjectUtils.isEmpty(query.getDemandSaid())) {
            list.add(qdo.demandSaid.like(SqlUtil.toSqlLikeString(query.getDemandSaid())));
        }
        /** 关联产品 精确 */
        if (!ObjectUtils.isEmpty(query.getProductId())) {
            list.add(qdo.productId.eq(query.getProductId()));
        }
        /** 采购大类 精确 */
        if (!ObjectUtils.isEmpty(query.getProductClass())) {
            list.add(qdo.productClass.eq(query.getProductClass()));
        }
        /** 采购小类 精确 */
        if (!ObjectUtils.isEmpty(query.getProductSubClass())) {
            list.add(qdo.productSubClass.eq(query.getProductSubClass()));
        }
        /** 数量 精确 */
        if (!ObjectUtils.isEmpty(query.getDemandNum())) {
            list.add(qdo.demandNum.eq(query.getDemandNum()));
        }
        /** 含税单价 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxPrice())) {
            list.add(qdo.taxPrice.eq(query.getTaxPrice()));
        }
        /** 货币 精确 */
        if (!ObjectUtils.isEmpty(query.getSymbol())) {
            list.add(qdo.symbol.eq(query.getSymbol()));
        }
        /** 税率 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxRate())) {
            list.add(qdo.taxRate.eq(query.getTaxRate()));
        }
        /** 含税总额 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxAmt())) {
            list.add(qdo.taxAmt.eq(query.getTaxAmt()));
        }
        /** 不含税总额 精确 */
        if (!ObjectUtils.isEmpty(query.getNotTaxAmt())) {
            list.add(qdo.notTaxAmt.eq(query.getNotTaxAmt()));
        }
        /** 采购合同id 精确 */
        if (!ObjectUtils.isEmpty(query.getPurContractId())) {
            list.add(qdo.purContractId.eq(query.getPurContractId()));
        }
        /** 采购需求id 精确 */
        if (!ObjectUtils.isEmpty(query.getPurDemandId())) {
            list.add(qdo.purDemandId.eq(query.getPurDemandId()));
        }
        /** 需求类别 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleConId())) {
            list.add(qdo.saleConId.eq(query.getSaleConId()));
        }
        /** 需求编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getDemandCode())) {
            list.add(qdo.demandCode.like(SqlUtil.toSqlLikeString(query.getDemandCode())));
        }
        /** 销售合同编号 模糊 */
        if (!ObjectUtils.isEmpty(query.getSaleConCode())) {
            list.add(qdoSaleCon.code.like(SqlUtil.toSqlLikeString(query.getSaleConCode())));
        }
        /** 需求负责人ID 精确 */
        if (!ObjectUtils.isEmpty(query.getDemandDirectorUserId())) {
            list.add(qdo.demandDirectorUserId.eq(query.getDemandDirectorUserId()));
        }
        /** 需求类别 精确 */
        if (!ObjectUtils.isEmpty(query.getDemandType())) {
            list.add(qdo.demandType.eq(query.getDemandType()));
        }
        /** 需求日期 范围 */
        if (!ObjectUtils.isEmpty(query.getDemandDate())) {
            list.add(qdo.demandDate.between(query.getDemandDate().get(0), query.getDemandDate().get(1)));
        }
        /** 参考合同号 模糊 */
        if (!ObjectUtils.isEmpty(query.getReferCode())) {
            list.add(qdoSaleCon.referCode.like(SqlUtil.toSqlLikeString(query.getReferCode())));
        }
        /** 客户 精确 */
        if (!ObjectUtils.isEmpty(query.getCustId())) {
            list.add(qdoSaleCon.custId.eq(query.getCustId()));
        }
        /** 采购需求状态 精确 */
        if (!ObjectUtils.isEmpty(query.getDemandStatus())) {
            list.add(qdo.demandStatus.eq(query.getDemandStatus()));
        }
        /**
         * 关于列表权限
         */
        if ((!CollectionUtils.isEmpty(query.getOrgIdsByPermission()) || (!CollectionUtils.isEmpty(query.getUserIdsByPermission())))) {
            list.add(qdoSaleCon.deliBuId.in(query.getOrgIdsByPermission()).or(qdoSaleCon.signBuId.in(query.getOrgIdsByPermission())).or(qdoRef.orgId.in(query.getOrgIdsByPermission()))
                    .or(qdoSaleCon.saleManUserId.in(query.getUserIdsByPermission())).or(qdoSaleCon.deliUserId.in(query.getUserIdsByPermission())).or(qdoSaleCon.createUserId.in(query.getUserIdsByPermission())));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public ConPurchaseDemandDVO queryByKey(Long id) {
        JPAQuery<ConPurchaseDemandDVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<ConPurchaseDemandDVO> queryListDynamic(ConPurchaseDemandDQuery query) {
        JPAQuery<ConPurchaseDemandDVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<ConPurchaseDemandDVO> queryPaging(ConPurchaseDemandDQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<ConPurchaseDemandDVO> jpaQuery = getJpaQueryWhere(query);
        List<ConPurchaseDemandDVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<ConPurchaseDemandDVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public ConPurchaseDemandDDO save(ConPurchaseDemandDDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<ConPurchaseDemandDDO> saveAll(List<ConPurchaseDemandDDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(ConPurchaseDemandDPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 合同id
        if (payload.getSaleConId() != null) {
            update.set(qdo.saleConId, payload.getSaleConId());
        }
        // 需求编号
        if (payload.getDemandCode() != null) {
            update.set(qdo.demandCode, payload.getDemandCode());
        }
        // 需求类别
        if (payload.getDemandType() != null) {
            update.set(qdo.demandType, payload.getDemandType());
        }
        // 需求备注
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        // 建议供应商ID
        if (payload.getSupplierId() != null) {
            update.set(qdo.supplierId, payload.getSupplierId());
        }
        // 需求说明
        if (payload.getDemandSaid() != null) {
            update.set(qdo.demandSaid, payload.getDemandSaid());
        }
        // 关联产品
        if (payload.getProductId() != null) {
            update.set(qdo.productId, payload.getProductId());
        }
        // 采购大类
        if (payload.getProductClass() != null) {
            update.set(qdo.productClass, payload.getProductClass());
        }
        // 采购小类
        if (payload.getProductSubClass() != null) {
            update.set(qdo.productSubClass, payload.getProductSubClass());
        }
        // 数量
        if (payload.getDemandNum() != null) {
            update.set(qdo.demandNum, payload.getDemandNum());
        }
        // 含税单价
        if (payload.getTaxPrice() != null) {
            update.set(qdo.taxPrice, payload.getTaxPrice());
        }
        // 货币
        if (payload.getSymbol() != null) {
            update.set(qdo.symbol, payload.getSymbol());
        }
        // 税率
        if (payload.getTaxRate() != null) {
            update.set(qdo.taxRate, payload.getTaxRate());
        }
        // 含税总额
        if (payload.getTaxAmt() != null) {
            update.set(qdo.taxAmt, payload.getTaxAmt());
        }
        // 不含税总额
        if (payload.getNotTaxAmt() != null) {
            update.set(qdo.notTaxAmt, payload.getNotTaxAmt());
        }
        // 采购合同id
        if (payload.getPurContractId() != null) {
            update.set(qdo.purContractId, payload.getPurContractId());
        }
        // 采购需求Id
        if (payload.getPurDemandId() != null) {
            update.set(qdo.purDemandId, payload.getPurDemandId());
        }
        // 需求日期
        if (payload.getDemandDate() != null) {
            update.set(qdo.demandDate, payload.getDemandDate());
        }
        // 需求负责人
        if (payload.getDemandDirectorUserId() != null) {
            update.set(qdo.demandDirectorUserId, payload.getDemandDirectorUserId());
        }
        // 需求状态
        if (payload.getDemandStatus() != null) {
            update.set(qdo.demandStatus, payload.getDemandStatus());
        }
        // 需求状态
        if (payload.getDemandDetailIdV4() != null) {
            update.set(qdo.demandDetailIdV4, payload.getDemandDetailIdV4());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 合同id
            if (nullFields.contains("saleConId")) {
                update.setNull(qdo.saleConId);
            }
            // 需求编号
            if (nullFields.contains("demandCode")) {
                update.setNull(qdo.demandCode);
            }
            // 需求类别
            if (nullFields.contains("demandType")) {
                update.setNull(qdo.demandType);
            }
            // 需求备注
            if (nullFields.contains("remark")) {
                update.setNull(qdo.remark);
            }
            // 建议供应商ID
            if (nullFields.contains("supplierId")) {
                update.setNull(qdo.supplierId);
            }
            // 需求说明
            if (nullFields.contains("demandSaid")) {
                update.setNull(qdo.demandSaid);
            }
            // 关联产品
            if (nullFields.contains("productId")) {
                update.setNull(qdo.productId);
            }
            // 采购大类
            if (nullFields.contains("proDuctClass")) {
                update.setNull(qdo.productClass);
            }
            // 采购小类
            if (nullFields.contains("productSubClass")) {
                update.setNull(qdo.productSubClass);
            }
            // 数量
            if (nullFields.contains("demandNum")) {
                update.setNull(qdo.demandNum);
            }
            // 含税单价
            if (nullFields.contains("taxPrice")) {
                update.setNull(qdo.taxPrice);
            }
            // 货币
            if (nullFields.contains("symbol")) {
                update.setNull(qdo.symbol);
            }
            // 税率
            if (nullFields.contains("taxRate")) {
                update.setNull(qdo.taxRate);
            }
            // 含税总额
            if (nullFields.contains("taxAmt")) {
                update.setNull(qdo.taxAmt);
            }
            // 不含税总额
            if (nullFields.contains("notTaxAmt")) {
                update.setNull(qdo.notTaxAmt);
            }
            // 采购合同id
            if (nullFields.contains("purContractId")) {
                update.setNull(qdo.purContractId);
            }

            // 采购合同id
            if (nullFields.contains("purDemandId")) {
                update.setNull(qdo.purDemandId);
            }
            // 需求日期
            if (nullFields.contains("demandDate")) {
                update.setNull(qdo.demandDate);
            }
            // 需求负责人
            if (nullFields.contains("demandDirectorUserId")) {
                update.setNull(qdo.demandDirectorUserId);
            }
            // 需求状态
            if (payload.getDemandStatus() != null) {
                update.set(qdo.demandStatus, payload.getDemandStatus());
            }
            if (nullFields.contains("demandStatus")) {
                update.setNull(qdo.demandStatus);
            }
            if (nullFields.contains("demandDetailIdV4")) {
                update.setNull(qdo.demandDetailIdV4);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据需求id查询需求详情
     *
     * @param id
     * @return List<ConPurchaseDemandDVO>
     */
    public List<ConPurchaseDemandDVO> queryByPurDemandId(Long id) {
        JPAQuery<ConPurchaseDemandDVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.purDemandId.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.groupBy(qdo.id);
        return jpaQuery.fetch();
    }


    public void updatePurContractId(Long id, Long purContractId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo);
        update.set(qdo.purContractId, purContractId);
        update.where(qdo.id.eq(id)).execute();
    }

    public void cancelPurContract(List<Long> purContractIds) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo);
        update.setNull(qdo.purContractId);
        update.where(qdo.purContractId.in(purContractIds)).execute();
    }
}

