package com.elitesland.tw.tw5.server.prd.salecon.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConRecvplanChangeLogPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConRecvplanChangeLogQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConRecvplanChangeLogVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConRecvplanChangeLogDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QConRecvplanChangeLogDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConRecvplanChangeLogRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 历史记录
 *
 * @author Lemon
 * @date 2023-08-09
 */
@Repository
@RequiredArgsConstructor
public class ConRecvplanChangeLogDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final ConRecvplanChangeLogRepo repo;
    private final QConRecvplanChangeLogDO qdo = QConRecvplanChangeLogDO.conRecvplanChangeLogDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<ConRecvplanChangeLogVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(ConRecvplanChangeLogVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                // 关联收款计划ID
                qdo.recvplanId,
                // 旧时间
                qdo.oldRecvOrInvDate,
                // 新时间
                qdo.recvOrInvDate,
                // 类型，RECV-收款，INV-开票
                qdo.type,
                // 修改原因
                qdo.reason,
                // 是否发送催款函：0 否 1 是
                qdo.flag1,
                // 备注2
                qdo.flag2,
                // 备用3
                qdo.flag3,
                // 创建者用户ID
                qdo.applyUserId,
                // 收款计划确认单ID
                qdo.rcvpConfirmId,
                // 变更前金额
                qdo.beforeAmt,
                // 变更后金额
                qdo.afterAmt
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<ConRecvplanChangeLogVO> getJpaQueryWhere(ConRecvplanChangeLogQuery query) {
        JPAQuery<ConRecvplanChangeLogVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(ConRecvplanChangeLogQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(ConRecvplanChangeLogQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 主键 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 关联收款计划ID 精确 */
        if (!ObjectUtils.isEmpty(query.getRecvplanId())) {
            list.add(qdo.recvplanId.eq(query.getRecvplanId()));
        }
        if (!CollectionUtils.isEmpty(query.getRecvplanIds())) {
            list.add(qdo.recvplanId.in(query.getRecvplanIds()));
        }
//        /** 旧时间 精确 */
//        if (!ObjectUtils.isEmpty(query.getOldRecvOrInvDate())) {
//            list.add(qdo.oldRecvOrInvDate.eq(query.getOldRecvOrInvDate()));
//        }
//        /** 新时间 精确 */
//        if (!ObjectUtils.isEmpty(query.getRecvOrInvDate())) {
//            list.add(qdo.recvOrInvDate.eq(query.getRecvOrInvDate()));
//        }
//        /** 类型，RECV-收款，INV-开票 精确 */
//        if (!ObjectUtils.isEmpty(query.getType())) {
//            list.add(qdo.type.eq(query.getType()));
//        }
//        /** 修改原因 精确 */
//        if (!ObjectUtils.isEmpty(query.getReason())) {
//            list.add(qdo.reason.eq(query.getReason()));
//        }
//        /** 是否发送催款函：0 否 1 是 精确 */
//        if (!ObjectUtils.isEmpty(query.getFlag1())) {
//            list.add(qdo.flag1.eq(query.getFlag1()));
//        }
//        /** 备注2 精确 */
//        if (!ObjectUtils.isEmpty(query.getFlag2())) {
//            list.add(qdo.flag2.eq(query.getFlag2()));
//        }
//        /** 备用3 精确 */
//        if (!ObjectUtils.isEmpty(query.getFlag3())) {
//            list.add(qdo.flag3.eq(query.getFlag3()));
//        }
//        /** 创建者用户ID 精确 */
//        if (!ObjectUtils.isEmpty(query.getApplyUserId())) {
//            list.add(qdo.applyUserId.eq(query.getApplyUserId()));
//        }
//        /** 收款计划确认单ID 精确 */
//        if (!ObjectUtils.isEmpty(query.getRcvpConfirmId())) {
//            list.add(qdo.rcvpConfirmId.eq(query.getRcvpConfirmId()));
//        }
//        /** 变更前金额 精确 */
//        if (!ObjectUtils.isEmpty(query.getBeforeAmt())) {
//            list.add(qdo.beforeAmt.eq(query.getBeforeAmt()));
//        }
//        /** 变更后金额 精确 */
//        if (!ObjectUtils.isEmpty(query.getAfterAmt())) {
//            list.add(qdo.afterAmt.eq(query.getAfterAmt()));
//        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public ConRecvplanChangeLogVO queryByKey(Long id) {
        JPAQuery<ConRecvplanChangeLogVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<ConRecvplanChangeLogVO> queryListDynamic(ConRecvplanChangeLogQuery query) {
        JPAQuery<ConRecvplanChangeLogVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<ConRecvplanChangeLogVO> queryPaging(ConRecvplanChangeLogQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<ConRecvplanChangeLogVO> jpaQuery = getJpaQueryWhere(query);
        List<ConRecvplanChangeLogVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<ConRecvplanChangeLogVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public ConRecvplanChangeLogDO save(ConRecvplanChangeLogDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<ConRecvplanChangeLogDO> saveAll(List<ConRecvplanChangeLogDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(ConRecvplanChangeLogPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 主键
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 关联收款计划ID
        if (payload.getRecvplanId() != null) {
            update.set(qdo.recvplanId, payload.getRecvplanId());
        }
        // 旧时间
        if (payload.getOldRecvOrInvDate() != null) {
            update.set(qdo.oldRecvOrInvDate, payload.getOldRecvOrInvDate());
        }
        // 新时间
        if (payload.getRecvOrInvDate() != null) {
            update.set(qdo.recvOrInvDate, payload.getRecvOrInvDate());
        }
        // 类型，RECV-收款，INV-开票
        if (payload.getType() != null) {
            update.set(qdo.type, payload.getType());
        }
        // 修改原因
        if (payload.getReason() != null) {
            update.set(qdo.reason, payload.getReason());
        }
        // 是否发送催款函：0 否 1 是
        if (payload.getFlag1() != null) {
            update.set(qdo.flag1, payload.getFlag1());
        }
        // 备注2
        if (payload.getFlag2() != null) {
            update.set(qdo.flag2, payload.getFlag2());
        }
        // 备用3
        if (payload.getFlag3() != null) {
            update.set(qdo.flag3, payload.getFlag3());
        }
        // 创建者用户ID
        if (payload.getApplyUserId() != null) {
            update.set(qdo.applyUserId, payload.getApplyUserId());
        }
        // 收款计划确认单ID
        if (payload.getRcvpConfirmId() != null) {
            update.set(qdo.rcvpConfirmId, payload.getRcvpConfirmId());
        }
        // 变更前金额
        if (payload.getBeforeAmt() != null) {
            update.set(qdo.beforeAmt, payload.getBeforeAmt());
        }
        // 变更后金额
        if (payload.getAfterAmt() != null) {
            update.set(qdo.afterAmt, payload.getAfterAmt());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 主键
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 关联收款计划ID
            if (nullFields.contains("recvplanId")) {
                update.setNull(qdo.recvplanId);
            }
            // 旧时间
            if (nullFields.contains("oldRecvOrInvDate")) {
                update.setNull(qdo.oldRecvOrInvDate);
            }
            // 新时间
            if (nullFields.contains("recvOrInvDate")) {
                update.setNull(qdo.recvOrInvDate);
            }
            // 类型，RECV-收款，INV-开票
            if (nullFields.contains("type")) {
                update.setNull(qdo.type);
            }
            // 修改原因
            if (nullFields.contains("reason")) {
                update.setNull(qdo.reason);
            }
            // 是否发送催款函：0 否 1 是
            if (nullFields.contains("flag1")) {
                update.setNull(qdo.flag1);
            }
            // 备注2
            if (nullFields.contains("flag2")) {
                update.setNull(qdo.flag2);
            }
            // 备用3
            if (nullFields.contains("flag3")) {
                update.setNull(qdo.flag3);
            }
            // 创建者用户ID
            if (nullFields.contains("applyUserId")) {
                update.setNull(qdo.applyUserId);
            }
            // 收款计划确认单ID
            if (nullFields.contains("rcvpConfirmId")) {
                update.setNull(qdo.rcvpConfirmId);
            }
            // 变更前金额
            if (nullFields.contains("beforeAmt")) {
                update.setNull(qdo.beforeAmt);
            }
            // 变更后金额
            if (nullFields.contains("afterAmt")) {
                update.setNull(qdo.afterAmt);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

