package com.elitesland.tw.tw5.server.prd.schedule.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author zoey
 * @Description:日历表
 * @date 2022/4/19 - 15:12
 */
@Entity
@Table(name = "prd_calendar")
@org.hibernate.annotations.Table(appliesTo = "prd_calendar", comment = "日历表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdCalendarDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;

    @Comment("只读标志")
    @Column(name = "readonly", nullable = false)
    private Integer readonly;

    @Comment("默认标志")
    @Column(name = "default_flag", nullable = false)
    private Integer defaultFlag;

    @Comment("日历标题")
    @Column(name = "title", nullable = false)
    private String title;

    @Comment("日历描述")
    private String description;

    @Comment("日历颜色")
    @Column(name = "color", nullable = false)
    private String color;

    @Comment("企业微信主键")
    private String qyWxCalId;
}
