package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFieldObjRoleFunctionVO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemPermissionFieldObjRoleFunctionDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * @author Michael
 * @date 2023/11/7 17:32
 **/
@Repository
@RequiredArgsConstructor
public class PrdSystemPermissionFieldObjRoleFunctionDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final QPrdSystemPermissionFieldObjRoleFunctionDO qdo = QPrdSystemPermissionFieldObjRoleFunctionDO.prdSystemPermissionFieldObjRoleFunctionDO;

    /**
     * 拼接查询字段
     *
     * @return JPAQuery 对象
     */
    private JPAQuery<PrdSystemPermissionFieldObjRoleFunctionVO> getJpaQuerySelect(){
        return jpaQueryFactory.select(Projections.bean(PrdSystemPermissionFieldObjRoleFunctionVO.class,
                qdo.id,
                qdo.roleId,
                qdo.isVisible,
                qdo.isEdit,
                qdo.fieldId,
                qdo.functionObjectId
        )).from(qdo);
    }


    /**
     * 根据角色ID和功能ID查询 字段-功能对象-角色关联表
     * @param roleId
     * @param functionObjectId
     * @return
     */
    public List<PrdSystemPermissionFieldObjRoleFunctionVO> queryByRoleIdAndFunctionId(Long roleId, Long functionObjectId) {
        JPAQuery<PrdSystemPermissionFieldObjRoleFunctionVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.roleId.eq(roleId));
        jpaQuery.where(qdo.functionObjectId.eq(functionObjectId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 根据角色ID，功能对象ID集合，查询功能对象ID
     * @param roleId
     * @param functionObjectIds
     * @return
     */
    public List<Long> queryByRoleIdAndFunctionIds(Long roleId, Set<Long> functionObjectIds) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.fieldId).distinct()
                .from(qdo);
        jpaQuery.where(qdo.roleId.eq(roleId));
        jpaQuery.where(qdo.functionObjectId.in(functionObjectIds));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 根据字段id删除字段-角色-功能关联表
     * @param deleteList    fieldIds字段集合
     * @return
     */
    public Long deleteByFieldIds(List<Long> deleteList) {
        return jpaQueryFactory.delete(qdo)
                .where(qdo.fieldId.in(deleteList).and(qdo.deleteFlag.eq(0)))
                .execute();
    }

    /**
     * 根据功能对象IDS查询去重的角色ID
     * @param functionObjectIds
     * @return
     */
    public List<Long> queryRoleIdsByFunctionObjectIds(List<Long> functionObjectIds) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.roleId).distinct()
                .from(qdo)
                .where(qdo.functionObjectId.in(functionObjectIds).and(qdo.deleteFlag.eq(0)));
        return jpaQuery.fetch();
    }

    /**
     * 根据功能对象IDS删除字段-角色-功能关联表
     * @param deleteFunctionObjectIds
     * @return
     */
    public Long deleteByFunctionObjectIds(List<Long> deleteFunctionObjectIds) {
        return jpaQueryFactory.delete(qdo)
                .where(qdo.functionObjectId.in(deleteFunctionObjectIds).and(qdo.deleteFlag.eq(0)))
                .execute();
    }
}
