package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemProblemFeedbackPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemProblemFeedbackQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemProblemFeedbackVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemProblemFeedbackDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemProblemFeedbackDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemProblemFeedbackProcessDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemProblemFeedbackRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Repository
@RequiredArgsConstructor
public class PrdSystemProblemFeedbackDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemProblemFeedbackRepo repo;
    private final JdbcTemplate jdbcTemplate;
    private final QPrdSystemProblemFeedbackDO qdo = QPrdSystemProblemFeedbackDO.prdSystemProblemFeedbackDO;
    private final QPrdSystemProblemFeedbackProcessDO processQdo = QPrdSystemProblemFeedbackProcessDO.prdSystemProblemFeedbackProcessDO;
    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdSystemProblemFeedbackDO save(PrdSystemProblemFeedbackDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存数组
     *
     * @param adoList do对象数组
     * @return 保存后的对象
     */
    public List<PrdSystemProblemFeedbackDO> saveAll(List<PrdSystemProblemFeedbackDO> adoList) {
        return repo.saveAll(adoList);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PrdSystemProblemFeedbackPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (!ObjectUtils.isEmpty(payload.getFeedbackTitle())) {
            update.set(qdo.feedbackTitle, payload.getFeedbackTitle());
        }
        if (!ObjectUtils.isEmpty(payload.getProblemUrl())) {
            update.set(qdo.problemUrl, payload.getProblemUrl());
        }
        if (!ObjectUtils.isEmpty(payload.getFileCodes())) {
            update.set(qdo.fileCodes, payload.getFileCodes());
        }
        if (!ObjectUtils.isEmpty(payload.getFeedbackStatus())) {
            update.set(qdo.feedbackStatus, payload.getFeedbackStatus());
        }
        if (!ObjectUtils.isEmpty(payload.getCloseReason())) {
            update.set(qdo.closeReason, payload.getCloseReason());
        }
        if (!ObjectUtils.isEmpty(payload.getUrgentFlag())) {
            update.set(qdo.urgentFlag, payload.getUrgentFlag());
        }
        if (!ObjectUtils.isEmpty(payload.getReplyStatus())) {
            update.set(qdo.replyStatus, payload.getReplyStatus());
        }
        if (!ObjectUtils.isEmpty(payload.getContent())) {
            update.set(qdo.content, payload.getContent());
        }
        if (!ObjectUtils.isEmpty(payload.getCommonFlag())) {
            update.set(qdo.commonFlag, payload.getCommonFlag());
        }
        if (!ObjectUtils.isEmpty(payload.getProblemType())) {
            update.set(qdo.problemType, payload.getProblemType());
        }
        if (!ObjectUtils.isEmpty(payload.getFunctionId())) {
            update.set(qdo.functionId, payload.getFunctionId());
        }
        if (!ObjectUtils.isEmpty(payload.getDirectorUserId())) {
            update.set(qdo.directorUserId, payload.getDirectorUserId());
        }
        if (!ObjectUtils.isEmpty(payload.getReadAmount())) {
            update.set(qdo.readAmount, payload.getReadAmount());
        }
        if (!ObjectUtils.isEmpty(payload.getTags())) {
            update.set(qdo.tags, payload.getTags());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("remark")) {
                update.setNull(qdo.remark);
            }
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PrdSystemProblemFeedbackVO queryByKey(Long id) {
        JPAQuery<PrdSystemProblemFeedbackVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据主键集合查询
     *
     * @param ids 查询参数
     * @return 结果集合
     */
    public List<PrdSystemProblemFeedbackDO> queryDyIdIn(Collection<Long> ids) {
        return repo.findByIdIn(ids);
    }

    /**                                                                                         l,,,
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdSystemProblemFeedbackVO> queryPaging(PrdSystemProblemFeedbackQuery query) {
        JPAQuery<PrdSystemProblemFeedbackVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<PrdSystemProblemFeedbackVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PrdSystemProblemFeedbackVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 拼装查询条件
     * .
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemProblemFeedbackVO> getJpaQueryWhere(PrdSystemProblemFeedbackQuery query) {
        JPAQuery<PrdSystemProblemFeedbackVO> jpaQuery = getJpaQuerySelect();

        if (!ObjectUtils.isEmpty(query.getFeedbackTitle())) {
            jpaQuery.where(qdo.feedbackTitle.like(SqlUtil.toSqlLikeString(query.getFeedbackTitle())));
        }
        if (!ObjectUtils.isEmpty(query.getFeedbackStatus())) {
            jpaQuery.where(qdo.feedbackStatus.eq(query.getFeedbackStatus()));
        }
        if (!ObjectUtils.isEmpty(query.getCommonFlag())) {
            jpaQuery.where(qdo.commonFlag.eq(query.getCommonFlag()));
        }
        if ((!ObjectUtils.isEmpty(query.getStartCreateTime())) && (!ObjectUtils.isEmpty(query.getEndCreateTime()))) {
            jpaQuery.where(qdo._super.createTime.between(query.getStartCreateTime(),query.getEndCreateTime()));
        }
        if (!ObjectUtils.isEmpty(query.getProblemType())) {
            jpaQuery.where(qdo.problemType.eq(query.getProblemType()));
        }
        if (!ObjectUtils.isEmpty(query.getFunctionId())) {
            jpaQuery.where(qdo.functionId.eq(query.getFunctionId()));
        }
        if ((!ObjectUtils.isEmpty(query.getStartProcessCreateTime())) && (!ObjectUtils.isEmpty(query.getEndProcessCreateTime()))) {
            jpaQuery.where(processQdo._super.createTime.between(query.getStartProcessCreateTime(),query.getEndProcessCreateTime()));
        }
        if (!ObjectUtils.isEmpty(query.getCreateUserId())) {
            jpaQuery.where(qdo._super.createUserId.eq(query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty(query.getLevel())) {
            jpaQuery.where(qdo.level.eq(query.getLevel()));
        }
        if(query.getOpsAdmin()!=null){
//            jpaQuery.where(qdo.directorUserId.ne(query.getOpsAdmin()));
        }else if(!ObjectUtils.isEmpty(query.getDirectorUserId())){
            jpaQuery.where(qdo.directorUserId.eq(query.getDirectorUserId()));
        }
        jpaQuery.where(qdo.deleteFlag.eq(0)).where(processQdo.deleteFlag.eq(0));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));

        return jpaQuery.distinct();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemProblemFeedbackVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemProblemFeedbackVO.class,
                qdo.id,
                qdo.feedbackTitle,
                qdo.problemUrl,
                qdo.fileCodes,
                qdo.feedbackStatus,
                qdo.closeReason,
                qdo.urgentFlag,
                qdo.replyStatus,
                qdo.content,
                qdo.problemType,
                qdo.functionId,
                qdo.directorUserId,
                qdo.readAmount,
                qdo.tags,
                qdo.commonFlag,
                qdo.remark,
                qdo.createTime,
                qdo.createUserId,
                qdo.creator,
                qdo.level
        )).from(qdo).leftJoin(processQdo).on(qdo.id.eq(processQdo.feedbackId));
    }

    /**
     * 统计时间段内所有问题反馈
     * @param startTime
     * @param endTime
     * @return
     */
    public List<Map<String, Object>> findNumberStatisticalByAll(LocalDateTime startTime, LocalDateTime endTime) {
        return repo.findNumberStatisticalByAll(startTime, endTime);
    }

    /**
     * 统计时间段内所有处理过问题反馈
     * @param startTime
     * @param endTime
     * @return
     */
    public List<Map<String, Object>> findNumberStatisticalByClose(LocalDateTime startTime, LocalDateTime endTime) {
        return repo.findNumberStatisticalByClose(startTime, endTime);
    }

    /**
     * 根据问题类型统计时间段内问题反馈
     * @param startTime
     * @param endTime
     * @return
     */
    public List<Map<String, Object>> findNumberStatisticalGroupByProblemType(LocalDateTime startTime, LocalDateTime endTime) {
        return repo.findNumberStatisticalGroupByProblemType(startTime, endTime);
    }

    /**
     * 根据所属功能统计时间段内所有问题反馈
     * @param startTime
     * @param endTime
     * @return
     */
    public List<Map<String, Object>> findNumberStatisticalGroupByFunctionId(LocalDateTime startTime, LocalDateTime endTime) {
        return repo.findNumberStatisticalGroupByFunctionId(startTime, endTime);
    }
}
