package com.elitesland.tw.tw5.server.prd.system.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 业务对象的 功能列表
 *
 * @Author Bill
 * @Date 2023/9/18 11:48
 **/
@Entity
@Table(name = "prd_system_new_function")
@org.hibernate.annotations.Table(appliesTo = "prd_system_new_function", comment = "业务对象的功能列表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PrdSystemNewFunctionDO extends BaseModel {

    private static final long serialVersionUID = -8019781481166350571L;

    @Column(name = "function_code")
    @Comment("功能编号")
    private String functionCode;

    @Column(name = "function_name")
    @Comment("功能名称")
    private String functionName;

    @Column(name = "function_type")
    @Comment("功能类型")
    private String functionType;

    @Column(name = "function_status")
    @Comment("功能状态")
    private Integer functionStatus;

    @Column(name = "client_type")
    @Comment("客户端类型")
    private String clientType;

    @Column(name = "object_id")
    @Comment("对象主键")
    private Long objectId;

    @Column(name = "parent_function_code")
    @Comment("父功能编码")
    private String parentFunctionCode;

    public void copy(PrdSystemNewFunctionDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
