package com.elitesland.tw.tw5.server.prd.system.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerOperationDO;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.Where;
import org.springframework.beans.BeanUtils;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 角色组列表
 *
 * @Author Bill
 * @Date 2023/9/19 9:57
 **/
@Entity
@Table(name = "prd_system_role_group")
@org.hibernate.annotations.Table(appliesTo = "prd_system_role_group", comment = "角色组列表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PrdSystemRoleGroupDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 7951369677086234770L;

    @Comment("角色组名称")
    @Column(name = "role_group_name")
    private String roleGroupName;

    @Comment("角色组类型")
    @Column(name = "role_group_type")
    private String roleGroupType;

    public void copy(PrdSystemRoleGroupDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
