package com.elitesland.tw.tw5.server.prd.task.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.query.TaskSettleTimesheetQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskSettleTimesheetService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskSettleTimesheetVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 任务结算工时关系表
 *
 * @author carl
 * @date 2023-12-20
 */
@Api(tags = "任务结算工时关系表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/task/taskSettleTimesheet")
@Slf4j
public class TaskSettleTimesheetController {

    private final TaskSettleTimesheetService taskSettleTimesheetService;


    /**
     * 任务结算工时关系表-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("任务结算工时关系表-主键查询")
    public TwOutputUtil<TaskSettleTimesheetVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(taskSettleTimesheetService.queryByKey(key));
    }

    /**
     * 任务结算工时关系表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("任务结算工时关系表-分页")
    public TwOutputUtil<PagingVO<TaskSettleTimesheetVO>> paging(TaskSettleTimesheetQuery query) {
        return TwOutputUtil.ok(taskSettleTimesheetService.queryPaging(query));
    }

    /**
     * 任务结算工时关系表-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("任务结算工时关系表-查询列表")
    public TwOutputUtil<List<TaskSettleTimesheetVO>> queryList(TaskSettleTimesheetQuery query) {
        return TwOutputUtil.ok(taskSettleTimesheetService.queryListDynamic(query));
    }

}

