package com.elitesland.tw.tw5.server.prd.task.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskSettleTimesheetPayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskSettleTimesheetQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskSettleTimesheetService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskSettleTimesheetVO;
import com.elitesland.tw.tw5.server.prd.task.convert.TaskSettleTimesheetConvert;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskSettleTimesheetDAO;
import com.elitesland.tw.tw5.server.prd.task.entity.TaskSettleTimesheetDO;
import com.elitesland.tw.tw5.server.prd.task.repo.TaskSettleTimesheetRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 任务结算工时关系表
 *
 * @author carl
 * @date 2023-12-20
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TaskSettleTimesheetServiceImpl extends BaseServiceImpl implements TaskSettleTimesheetService {

    private final TaskSettleTimesheetRepo taskSettleTimesheetRepo;
    private final TaskSettleTimesheetDAO taskSettleTimesheetDAO;

    @Override
    public PagingVO<TaskSettleTimesheetVO> queryPaging(TaskSettleTimesheetQuery query) {
        return taskSettleTimesheetDAO.queryPaging(query);
    }

    @Override
    public List<TaskSettleTimesheetVO> queryListDynamic(TaskSettleTimesheetQuery query) {
        return taskSettleTimesheetDAO.queryListDynamic(query);
    }

    @Override
    public TaskSettleTimesheetVO queryByKey(Long key) {
        TaskSettleTimesheetDO entity = taskSettleTimesheetRepo.findById(key).orElseGet(TaskSettleTimesheetDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TaskSettleTimesheetVO vo = TaskSettleTimesheetConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskSettleTimesheetVO batchInsert(List<TaskSettleTimesheetPayload> payloads) {
        List<TaskSettleTimesheetDO> taskSettleTimesheetDOS = TaskSettleTimesheetConvert.INSTANCE.toDos(payloads);
        taskSettleTimesheetRepo.saveAll(taskSettleTimesheetDOS);
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskSettleTimesheetVO update(TaskSettleTimesheetPayload payload) {
        TaskSettleTimesheetDO entity = taskSettleTimesheetRepo.findById(payload.getId()).orElseGet(TaskSettleTimesheetDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TaskSettleTimesheetDO entityDo = TaskSettleTimesheetConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TaskSettleTimesheetConvert.INSTANCE.toVo(taskSettleTimesheetRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TaskSettleTimesheetPayload payload) {
        TaskSettleTimesheetDO entity = taskSettleTimesheetRepo.findById(payload.getId()).orElseGet(TaskSettleTimesheetDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = taskSettleTimesheetDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            taskSettleTimesheetDAO.deleteSoft(keys);
        }
    }

}
