package com.elitesland.tw.tw5.server.prd.ts.service;


import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetService;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingMonthPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingTypePayload;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingMonthVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingTypeVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalResPayload;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsNotaskApprovalConfigPayload;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsNotaskApprovalConfigRulePayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsNotaskApprovalConfigQuery;
import com.elitesland.tw.tw5.api.prd.ts.query.TsNotaskApprovalConfigRuleQuery;
import com.elitesland.tw.tw5.api.prd.ts.service.TsNotaskApprovalConfigRuleService;
import com.elitesland.tw.tw5.api.prd.ts.service.TsNotaskApprovalConfigService;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalConfigVO;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalRoleResVO;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsNotaskApprovalConfigRuleVO;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsNotaskApprovalConfigVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.my.service.PmsTimesheetServiceImpl;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvSettingConvert;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvSettingMonthConvert;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvSettingTypeConvert;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvSettingDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvSettingMonthDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvSettingTypeDO;
import com.elitesland.tw.tw5.server.prd.ts.convert.TsNotaskApprovalConfigConvert;
import com.elitesland.tw.tw5.server.prd.ts.convert.TsNotaskApprovalConfigRuleConvert;
import com.elitesland.tw.tw5.server.prd.ts.dao.TsNotaskApprovalConfigDAO;
import com.elitesland.tw.tw5.server.prd.ts.dao.TsNotaskApprovalConfigRuleDAO;
import com.elitesland.tw.tw5.server.prd.ts.entity.TsNotaskApprovalConfigDO;
import com.elitesland.tw.tw5.server.prd.ts.entity.TsNotaskApprovalConfigRuleDO;
import com.elitesland.tw.tw5.server.prd.ts.repo.TsNotaskApprovalConfigRepo;
import com.elitesland.tw.tw5.server.prd.ts.repo.TsNotaskApprovalConfigRuleRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.stream.Collectors;

/**
 * notask_config
 *
 * @author zoey
 * @date 2024-04-30
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TsNotaskApprovalConfigServiceImpl extends BaseServiceImpl implements TsNotaskApprovalConfigService {

    private final TsNotaskApprovalConfigRepo tsNotaskApprovalConfigRepo;
    private final TsNotaskApprovalConfigDAO tsNotaskApprovalConfigDAO;
    private final CacheUtil cacheUtil;
    private final UdcUtil udcUtil;
    private final TsNotaskApprovalConfigRuleRepo tsNotaskApprovalConfigRuleRepo;
    private final TsNotaskApprovalConfigRuleDAO tsNotaskApprovalConfigRuleDAO;
    private final TsNotaskApprovalConfigRuleService tsNotaskApprovalConfigRuleService;
    private final PmsTimesheetService pmsTimesheetService;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;

    @Override
    public Integer insertCheck(TsNotaskApprovalConfigPayload payload) {
        int count =0;
        if(payload.getId()!=null){
            count = tsNotaskApprovalConfigRepo.countByDeliBuIdAndTsYearAndIdNot(payload.getDeliBuId(), payload.getTsYear(), payload.getId());
        } else{
            // 查询
            count = tsNotaskApprovalConfigRepo.countByDeliBuIdAndTsYear(payload.getDeliBuId(), payload.getTsYear());
        }
        return count;
    }

    @Override
    public PagingVO<TsNotaskApprovalConfigVO> queryPaging(TsNotaskApprovalConfigQuery query){
        return tsNotaskApprovalConfigDAO.queryPaging(query);
    }

    @Override
    public List<TsNotaskApprovalConfigVO> queryListDynamic(TsNotaskApprovalConfigQuery query){
        return tsNotaskApprovalConfigDAO.queryListDynamic(query);
    }

    @Override
    public TsNotaskApprovalConfigVO queryByKey(Long key) {
        TsNotaskApprovalConfigDO entity = tsNotaskApprovalConfigRepo.findById(key).orElseGet(TsNotaskApprovalConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TsNotaskApprovalConfigVO vo = TsNotaskApprovalConfigConvert.INSTANCE.toVo(entity);
        List<TsNotaskApprovalConfigRuleVO> tsNotaskApprovalConfigRuleVOS = tsNotaskApprovalConfigRuleService.queryByConfigId(key);
        vo.setTsNotaskApprovalConfigRulePVOList(tsNotaskApprovalConfigRuleVOS);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TsNotaskApprovalConfigVO insert(TsNotaskApprovalConfigPayload payload) {
        // 查询
        int count = tsNotaskApprovalConfigRepo.countByDeliBuIdAndTsYear(payload.getDeliBuId(), payload.getTsYear());
        if(count>0){
            throw TwException.error("",payload.getTsYear()+"年" + cacheUtil.getOrgName(payload.getDeliBuId()) +"已配置!");
        }
        TsNotaskApprovalConfigDO entityDo = TsNotaskApprovalConfigConvert.INSTANCE.toDo(payload);
        TsNotaskApprovalConfigVO tsNotaskApprovalConfigVO = TsNotaskApprovalConfigConvert.INSTANCE.toVo(tsNotaskApprovalConfigRepo.save(entityDo));
        Long configVOId = tsNotaskApprovalConfigVO.getId();
        //保存子表数据
        List<TsNotaskApprovalConfigRulePayload> tsNotaskApprovalConfigRulePayloadList = payload.getTsNotaskApprovalConfigRulePayloadList();
        tsNotaskApprovalConfigRulePayloadList.stream().forEach(e->e.setConfigId(configVOId));
        if(!tsNotaskApprovalConfigRulePayloadList.isEmpty()){
            List<TsNotaskApprovalConfigRuleDO> tsNotaskApprovalConfigRuleDOS = TsNotaskApprovalConfigRuleConvert.INSTANCE.toDoList(tsNotaskApprovalConfigRulePayloadList);
            List<TsNotaskApprovalConfigRuleVO> tsNotaskApprovalConfigRuleVOS = TsNotaskApprovalConfigRuleConvert.INSTANCE.toVoList(tsNotaskApprovalConfigRuleRepo.saveAll(tsNotaskApprovalConfigRuleDOS));
            tsNotaskApprovalConfigVO.setTsNotaskApprovalConfigRulePVOList(tsNotaskApprovalConfigRuleVOS);
        }
        return tsNotaskApprovalConfigVO;


    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TsNotaskApprovalConfigVO update(TsNotaskApprovalConfigPayload payload) {
        // 查询
        int count = tsNotaskApprovalConfigRepo.countByDeliBuIdAndTsYearAndIdNot(payload.getDeliBuId(), payload.getTsYear(),payload.getId());
        if(count>0){
            throw TwException.error("",payload.getTsYear()+"年" + cacheUtil.getOrgName(payload.getDeliBuId()) +"已配置!");
        }
        List<Long> deleteConfigRuleKeys = payload.getDeleteConfigRuleKeys();
        if(!CollectionUtils.isEmpty(deleteConfigRuleKeys)){
            tsNotaskApprovalConfigRuleDAO.deleteSoft(deleteConfigRuleKeys);
        }
        TsNotaskApprovalConfigDO entity = tsNotaskApprovalConfigRepo.findById(payload.getId()).orElseGet(TsNotaskApprovalConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TsNotaskApprovalConfigDO entityDo = TsNotaskApprovalConfigConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        TsNotaskApprovalConfigVO tsNotaskApprovalConfigVO = TsNotaskApprovalConfigConvert.INSTANCE.toVo(tsNotaskApprovalConfigRepo.save(entity));
        //保存子表数据,三种情况，新增，修改，删除
        List<TsNotaskApprovalConfigRulePayload> tsNotaskApprovalConfigRulePayloadList = payload.getTsNotaskApprovalConfigRulePayloadList();
        if(!tsNotaskApprovalConfigRulePayloadList.isEmpty()){
            List<TsNotaskApprovalConfigRuleDO> tsNotaskApprovalConfigRuleDOS = TsNotaskApprovalConfigRuleConvert.INSTANCE.toDoList(tsNotaskApprovalConfigRulePayloadList);
            List<TsNotaskApprovalConfigRuleVO> tsNotaskApprovalConfigRuleVOS = new ArrayList<>();
            for (TsNotaskApprovalConfigRuleDO tsNotaskApprovalConfigRuleDO : tsNotaskApprovalConfigRuleDOS) {
                if(tsNotaskApprovalConfigRuleDO.getId()!=null){
                    TsNotaskApprovalConfigRuleDO tsNotaskApprovalConfigRuleEntity = tsNotaskApprovalConfigRuleRepo.findById(tsNotaskApprovalConfigRuleDO.getId()).orElseGet(TsNotaskApprovalConfigRuleDO::new);
                    Assert.notNull(entity.getId(), "不存在");
                    tsNotaskApprovalConfigRuleEntity.copy(tsNotaskApprovalConfigRuleDO);
                    tsNotaskApprovalConfigRuleVOS.add(TsNotaskApprovalConfigRuleConvert.INSTANCE.toVo(tsNotaskApprovalConfigRuleRepo.save(tsNotaskApprovalConfigRuleEntity)));
                }else{
                    tsNotaskApprovalConfigRuleDO.setConfigId(payload.getId());
                    tsNotaskApprovalConfigRuleVOS.add(TsNotaskApprovalConfigRuleConvert.INSTANCE.toVo(tsNotaskApprovalConfigRuleRepo.save(tsNotaskApprovalConfigRuleDO)));
                }
            }
            tsNotaskApprovalConfigVO.setTsNotaskApprovalConfigRulePVOList(tsNotaskApprovalConfigRuleVOS);
        }
        return tsNotaskApprovalConfigVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TsNotaskApprovalConfigPayload payload) {
        TsNotaskApprovalConfigDO entity = tsNotaskApprovalConfigRepo.findById(payload.getId()).orElseGet(TsNotaskApprovalConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = tsNotaskApprovalConfigDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            tsNotaskApprovalConfigDAO.deleteSoft(keys);
            // 删除明细
            tsNotaskApprovalConfigRuleService.deleteSoft(keys);
        }
    }

    @Override
    public List<PrdSystemSelectionVO> noTaskActivityList(LocalDate workDate) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        PrdOrgOrganizationRefVO organizationRefVO = cacheUtil.getUserBuLevel1(loginUserId);
        if(organizationRefVO==null){
            throw TwException.error("","当前用户没有对应一级组织，无法获取活动！");
        }
        // 人力资源外包部门员工跳过查询
        if(organizationRefVO.getOrgCode().equals("BD0023")){
            return new ArrayList<>();
        }
        Long orgId = organizationRefVO.getOrgId();
        int year = workDate.getYear();
        TsNotaskApprovalConfigQuery query = new TsNotaskApprovalConfigQuery();
        query.setEffective(1);
        query.setTsYear(year);
        query.setDeliBuId(orgId);
        List<TsNotaskApprovalConfigVO> tsNotaskApprovalConfigVOS = queryListDynamic(query);
        if(!CollectionUtils.isEmpty(tsNotaskApprovalConfigVOS)){
            // 获取配置详情
            TsNotaskApprovalConfigVO tsNotaskApprovalConfigVO = queryByKey(tsNotaskApprovalConfigVOS.get(0).getId());
            List<TsNotaskApprovalConfigRuleVO> tsNotaskApprovalConfigRuleVOList = tsNotaskApprovalConfigVO.getTsNotaskApprovalConfigRulePVOList();
            if(!CollectionUtils.isEmpty(tsNotaskApprovalConfigRuleVOList)){
                tsNotaskApprovalConfigRuleVOList = udcUtil.translateList(tsNotaskApprovalConfigRuleVOList);
                List<PrdSystemSelectionVO> systemSelectionVOS = new ArrayList<>();
                for (TsNotaskApprovalConfigRuleVO tsNotaskApprovalConfigRuleVO : tsNotaskApprovalConfigRuleVOList) {
                    // 是否配置的用户类型未用户，如果是用户的话，是否包含当前登录人
                    if(tsNotaskApprovalConfigRuleVO.getIsUser()==1){
                        String users = tsNotaskApprovalConfigRuleVO.getUsers();
                        List<Long> longList = Arrays.stream(users.split(","))
                                .map(Long::parseLong)
                                .collect(Collectors.toList());
                        if(!longList.contains(loginUserId)){
                            continue;
                        }
                    }
                    if(StringUtils.hasText(tsNotaskApprovalConfigRuleVO.getActivity())){
                        PrdSystemSelectionVO systemSelection = cacheUtil.getSystemSelection("prd:timesheet:notask");
                        List<PrdSystemSelectionVO> selectionChildren = systemSelection.getChildren();
                        // 翻译活动
                        for (String activity : tsNotaskApprovalConfigRuleVO.getActivity().split(",")) {
                            for (PrdSystemSelectionVO selectionChild : selectionChildren) {
                                if(selectionChild.getSelectionValue().equals(activity)){
                                    systemSelectionVOS.add(selectionChild);
                                }
                            }
                        }
                    }
                }
                systemSelectionVOS = systemSelectionVOS.stream()
                        .collect(Collectors.toMap(PrdSystemSelectionVO::getSelectionKey, p -> p, (p1, p2) -> p1))
                        .values().stream()
                        .collect(Collectors.toList());
                return systemSelectionVOS;
            }else{
                throw TwException.error("","当前事业部当前年度无项目无任务审批配置规则明细缺失，无法获取到活动！");
            }
        }else{
            throw TwException.error("","当前事业部当前年度无项目无任务审批配置缺失，无法获取到活动！");
        }
    }

    @Override
    public Map<String,Object> noTaskApprovalConfigRule(BigDecimal worHour,LocalDate workDate, String activity) {
        List<TsApprovalResPayload> resPayloads = new ArrayList<>();
        Integer ut = 0;
        int year = workDate.getYear();
        //本月的第一天
        LocalDate firstDay = LocalDate.of(year,workDate.getMonth(),1);
        //本月的最后一天
        LocalDate lastDay =workDate.with(TemporalAdjusters.lastDayOfMonth());
        List<LocalDate> fistDayAndLastDay = Arrays.asList(firstDay, lastDay);

        Long loginUserId = GlobalUtil.getLoginUserId();
        BigDecimal workDays = BigDecimal.ZERO;
        // 获取当前用户本月当前活动的工时
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setTsActIden(activity);
        timesheetQuery.setTsUserId(loginUserId);
        timesheetQuery.setWorkDateBetween(fistDayAndLastDay);
        List<TimesheetVO> timesheetVOS = pmsTimesheetService.queryList(timesheetQuery);
        if(!CollectionUtils.isEmpty(timesheetVOS)){
            BigDecimal totalWorkHour = timesheetVOS.stream()
                    .map(TimesheetVO::getWorkHour)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            workDays = totalWorkHour.divide(new BigDecimal(8));
        }
        PrdOrgOrganizationRefVO organizationRefVO = cacheUtil.getUserBuLevel1(loginUserId);
        if(organizationRefVO==null){
            throw TwException.error("","当前用户没有对应一级组织，无法获取到对应部门的配置！");
        }
        Long orgId = organizationRefVO.getOrgId();
        // 默认一级审批人事业部负责人
        Long manageId = organizationRefVO.getManageId();
        TsNotaskApprovalConfigQuery query = new TsNotaskApprovalConfigQuery();
        query.setEffective(1);
        query.setTsYear(year);
        query.setDeliBuId(orgId);
        List<TsNotaskApprovalConfigVO> tsNotaskApprovalConfigVOS = queryListDynamic(query);
        if(!CollectionUtils.isEmpty(tsNotaskApprovalConfigVOS)){
            TsNotaskApprovalConfigRuleQuery tsNotaskApprovalConfigRuleQuery = new TsNotaskApprovalConfigRuleQuery();
            tsNotaskApprovalConfigRuleQuery.setConfigId(tsNotaskApprovalConfigVOS.get(0).getId());
            tsNotaskApprovalConfigRuleQuery.setActivity(activity);
            tsNotaskApprovalConfigRuleQuery.setUsers(loginUserId.toString());
//            tsNotaskApprovalConfigRuleQuery.setConditionDays(workDays);
//            tsNotaskApprovalConfigRuleQuery.setUpperLimit(workDays);
            // 查询到所有符合条件记录
            List<TsNotaskApprovalConfigRuleVO> tsNotaskApprovalConfigRuleVOS = tsNotaskApprovalConfigRuleDAO.queryListDynamic(tsNotaskApprovalConfigRuleQuery);
            Long firstApprUserId= null;// 第一审批人
            if(!CollectionUtils.isEmpty(tsNotaskApprovalConfigRuleVOS)){
                // 如果有匹配用户的配置，只匹配这有具体用品配置这一条,做重复校验，要么被用户包含，要么被组织包含
                for (TsNotaskApprovalConfigRuleVO tsNotaskApprovalConfigRuleVO : tsNotaskApprovalConfigRuleVOS) {
                    if(tsNotaskApprovalConfigRuleVO.getIsUser()==1){
                        tsNotaskApprovalConfigRuleVOS = Collections.singletonList(tsNotaskApprovalConfigRuleVO);
                        break;
                    }
                }
                TsNotaskApprovalConfigRuleVO tsNotaskApprovalConfigRuleVO = tsNotaskApprovalConfigRuleVOS.get(0);
                String scope = tsNotaskApprovalConfigRuleVO.getScope();
                BigDecimal upperLimit = tsNotaskApprovalConfigRuleVO.getUpperLimit();
                // 判断是否达到填写上限
                if(scope!=null && upperLimit!=null){
                    switch (scope){
                        case "person":
                            if(workDays.compareTo(upperLimit)>0){
                                throw TwException.error("","当前活动:["+cacheUtil.getSystemSelectionNameByValue("prd:timesheet:notask",activity)+"]的工时已经超过本人本月的填报上限!");
                            }
                            break;
                        case "org":
                            Set<Long> childOrgs = prdOrgOrganizationDAO.queryAllChildOrgs(Collections.singletonList(orgId).stream().collect(Collectors.toSet()));
                            // 获取当前事业部的所有成员
                            //查询部门下的成员
                            List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = prdOrgOrganizationDAO.queryEmployeeList(childOrgs);
                            Set<Long> userIds = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toSet());

                            // 获取当前事业部本月当前活动的工时
                            timesheetQuery.setTsUserId(null);
                            timesheetQuery.setTsUserIdList(userIds);
                            timesheetVOS = pmsTimesheetService.queryList(timesheetQuery);
                            if(!CollectionUtils.isEmpty(timesheetVOS)){
                                BigDecimal totalWorkHour = timesheetVOS.stream()
                                        .map(TimesheetVO::getWorkHour)
                                        .reduce(BigDecimal.ZERO, BigDecimal::add);
                                workDays = totalWorkHour.divide(new BigDecimal(8));
                            }
                            if(workDays.compareTo(upperLimit)>0){
                                throw TwException.error("","当前活动:["+cacheUtil.getSystemSelectionNameByValue("prd:timesheet:notask",activity)+"]的工时已经超过本事业部本月的填报上限!");
                            }
                            break;
                    }
                }
                // 指定第一审批人
                String firstApprUserRole = tsNotaskApprovalConfigRuleVO.getFirstApprUserRole();
                if(firstApprUserRole!=null){
                    PrdOrgEmployeeRefVO userDefaultOrg = cacheUtil.getUserDefaultOrg(loginUserId);
                    switch (firstApprUserRole){
                        case "PUSER"://上级
                            firstApprUserId = userDefaultOrg.getParentId();
                            break;
                        case "BULEADER"://二级bu负责人

                            firstApprUserId = userDefaultOrg.getManageId();
                            break;
                    }
                }else{
                    throw TwException.error("","第一审批人未指定");
                }
                String triggerCondition = tsNotaskApprovalConfigRuleVO.getTriggerCondition();
                BigDecimal conditionDays = tsNotaskApprovalConfigRuleVO.getConditionDays();
                if(triggerCondition !=null && conditionDays!=null){
                    // 指定第二审批人
                    if((triggerCondition.equals("gt") && workDays.compareTo(conditionDays)>0) || (triggerCondition.equals("ltoe") && workDays.compareTo(conditionDays)<1) ){
                        // 处理审批人，保存审批记录
                        resPayloads = getApprovalResPayload(tsNotaskApprovalConfigRuleVO,firstApprUserId,manageId);
                    }else{
                        //未匹配到规则
                        resPayloads = getApprovalResPayload(null,firstApprUserId,manageId);
                    }
                }else{
                    //
                    //未匹配到规则
                    resPayloads = getApprovalResPayload(null,firstApprUserId,manageId);
                }
                // ut值
                ut = tsNotaskApprovalConfigRuleVO.getUt();
            }else{
                //未匹配到规则
                resPayloads = getApprovalResPayload(null,firstApprUserId,manageId);
            }
        }else{
            throw TwException.error("","匹配不到工时审批配置，无法获取到审批人！");
        }

        Map<String,Object> result = new HashMap<>();
        result.put("tsApprovalResPayloads",resPayloads);
        result.put("ut",ut);
        return result;
    }

    List<TsApprovalResPayload> getApprovalResPayload(TsNotaskApprovalConfigRuleVO tsNotaskApprovalConfigRuleVO,Long firstApprUserId,Long secondApprUserId) {
        List<TsApprovalResPayload> resPayloads = new ArrayList<>();
        // 保存第一审批人
        // 默认配置
        TsApprovalResPayload firstResPayload = new TsApprovalResPayload();
        firstResPayload.setApprovalStatus(TimesheetStatus.APPROVING.getCode());
        firstResPayload.setSortIndex(1);
        firstResPayload.setLastFlag(0);
        // 事业部负责人审批
        firstResPayload.setApprovalResId(firstApprUserId);
        if (tsNotaskApprovalConfigRuleVO != null) {
            log.info("tsNotaskApprovalConfigRuleVOId:{}", tsNotaskApprovalConfigRuleVO.getId());
            log.info("tsNotaskApprovalConfigRuleVO:{}", tsNotaskApprovalConfigRuleVO);
            if (tsNotaskApprovalConfigRuleVO.getApprUserId() != null) {
                Long apprUserId = tsNotaskApprovalConfigRuleVO.getApprUserId();
                if(!apprUserId.equals(firstApprUserId)){
                    TsApprovalResPayload resPayload = new TsApprovalResPayload();
                    resPayload.setConfigType("NOTASK");
                    resPayload.setConfigId(tsNotaskApprovalConfigRuleVO.getId());
                    resPayload.setApprovalStatus(TimesheetStatus.BEFOREAPPROVE.getCode());
                    resPayload.setSortIndex(2);
                    resPayload.setLastFlag(1);
                    resPayload.setApprovalResId(apprUserId);
                    // 当第二节点不等于第一节点，依次保存
                    resPayloads.add(firstResPayload);
                    resPayloads.add(resPayload);
                }else{
                    // 只保存第一节点
                    firstResPayload.setLastFlag(1);
                    resPayloads.add(firstResPayload);
                }

            } else {
                throw TwException.error("", "获取审批配置节点1错误,配置id:" + tsNotaskApprovalConfigRuleVO.getId());
            }
        }else{
            if(!secondApprUserId.equals(firstApprUserId)){
                // 默认配置
                TsApprovalResPayload resPayload = new TsApprovalResPayload();
                resPayload.setApprovalStatus(TimesheetStatus.BEFOREAPPROVE.getCode());
                resPayload.setSortIndex(2);
                resPayload.setLastFlag(1);
                // 事业部负责人审批
                resPayload.setApprovalResId(secondApprUserId);
                // 当第二节点不等于第一节点，依次保存
                resPayloads.add(firstResPayload);
                resPayloads.add(resPayload);
            }else{
                // 只保存第一节点
                firstResPayload.setLastFlag(1);
                resPayloads.add(firstResPayload);
            }
        }
        return resPayloads;
    }


}
