package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvBatchPayload;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvBatchService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.BatchStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.ReceStatusEnum;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvBatchDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivablePlanDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivablePlanDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivablePlanRepo;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * @author zoey
 * @date 2023/08/17
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "SALE_CON_INVOICING" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class SaleConCloseInvoicingWorkflowCallBackController implements WorkflowCallBack {


    private final ConInvBatchService invBatchService;
    private final ConInvBatchDAO invBatchDAO;
    private final ConReceivablePlanDAO receivablePlanDAO;
    private final ConReceivablePlanRepo receivablePlanRepo;

    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {

        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        String taskKey = payload.getTaskKey();
        String businessKey = payload.getBusinessKey();
        ConInvBatchPayload conInvBatchPayload = new ConInvBatchPayload();
        conInvBatchPayload.setId(Long.valueOf(businessKey));
        // 通过开票id查询收款计划id,（当申请开票时收款计划不唯一，要注意多条数据的问题）
        switch (taskKey){
            //确认合同信息节点-审批中
            case "Activity_1uh82em":
                conInvBatchPayload.setBatchStatus(BatchStatusEnum.APPLYING.getCode());
                //删除百望流水单
//                invBatchService.deleteInvInfoToBaiwang(Long.valueOf(businessKey),1); // 删除发送至百望的流水单信息
                break;
            //确认开票完成-已批准待开票
            case "Activity_03eqeup":
                conInvBatchPayload.setBatchStatus(BatchStatusEnum.APPROVETOINV.getCode());
                //删除百望流水单
//                invBatchService.deleteInvInfoToBaiwang(Long.valueOf(businessKey),1); // 删除发送至百望的流水单信息
                //读取验证结果，百望直连开票
                ConInvBatchVO conInvBatchVO = invBatchService.queryByKey(Long.valueOf(businessKey));
                if(conInvBatchVO.getInvFlag()!=null && conInvBatchVO.getInvFlag()==1){
                    invBatchService.outputInvoiceInBaiwang(Long.valueOf(businessKey),1);
                }
                break;
//            确认对方已收到发票节点-已开票待收款
            case "Activity_16uktyp":
                conInvBatchPayload.setBatchStatus(BatchStatusEnum.APPROVETORECV.getCode());
                // 更新收款计划收款状态为已开票
                receivablePlanRepo.updateReceStatusByBatchId(Long.valueOf(businessKey),ReceStatusEnum.OK_INVOICE.getCode());
                // 更新收款计划的已开票金额和未开票金额,直接更新为计划当期收款金额
                receivablePlanRepo.updateInvAmt(Long.valueOf(businessKey));
                break;
            default:
        }
        invBatchDAO.updateByKeyDynamic(conInvBatchPayload);
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }


    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        ConInvBatchPayload conInvBatchPayload = new ConInvBatchPayload();
        conInvBatchPayload.setId(Long.parseLong(businessKey));
        //根据业务key查询当前业务对象
        ConInvBatchVO conInvBatchVO = invBatchService.queryByKey(Long.valueOf(businessKey));
        if (conInvBatchVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    //将单据状态改为“激活”
                    conInvBatchPayload.setBatchStatus(BatchStatusEnum.CREATE.getCode());
                    conInvBatchPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    //删除百望流水单
//                    invBatchService.deleteInvInfoToBaiwang(Long.valueOf(businessKey),1); // 删除发送至百望的流水单信息
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    conInvBatchPayload.setBatchStatus(BatchStatusEnum.CREATE.getCode());
                    conInvBatchPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    //删除百望流水单
//                    invBatchService.deleteInvInfoToBaiwang(Long.valueOf(businessKey),1); // 删除发送至百望的流水单信息
                    break;
                case INVALID://先删除流程再删除单据
                    conInvBatchPayload.setBatchStatus(BatchStatusEnum.CREATE.getCode());
                    conInvBatchPayload.setDeleteFlag(1);
                    conInvBatchPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    // 更新收款计划收款状态为未开票
//                    receivablePlanRepo.updateReceStatusByBatchId(Long.valueOf(businessKey),ReceStatusEnum.NO_INVOICE.getCode());
                    //删除百望流水单
                    invBatchService.deleteInvInfoToBaiwang(Long.valueOf(businessKey),1); // 删除发送至百望的流水单信息
                    // 解除绑定
                    receivablePlanRepo.unbindBatchByBatchId(Long.valueOf(businessKey));
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    conInvBatchPayload.setBatchStatus(BatchStatusEnum.CREATE.getCode());
                    conInvBatchPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    //删除百望流水单
//                    invBatchService.deleteInvInfoToBaiwang(Long.valueOf(businessKey),1); // 删除发送至百望的流水单信息
                    break;
                case APPROVED:
                    //一般情况将单据状态变成"已开票待收款"
//                    conInvBatchPayload.setBatchStatus(BatchStatusEnum.APPROVETORECV.getCode());
                    conInvBatchPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    conInvBatchPayload.setApprovedTime(LocalDateTime.now());
                    // 更新收款计划收款状态为已开票
                    receivablePlanRepo.updateReceStatusByBatchId(Long.valueOf(businessKey),ReceStatusEnum.OK_INVOICE.getCode());
                    // 更新收款计划的已开票金额和未开票金额,直接更新为计划当期收款金额
                    receivablePlanRepo.updateInvAmt(Long.valueOf(businessKey));
                    //读取验证结果，决定是否发邮件
                    if(conInvBatchVO.getEmailFlag()!=null && conInvBatchVO.getEmailFlag()==1){
                        //TODO: 获取所有发票明细，获取downloadUrl，发送邮件
                        invBatchService.sendEmail(conInvBatchVO);
                    }
                    //读取合同工作类型（T&M），决定是否发送待办
                    if(conInvBatchVO.getWorkType()!=null && conInvBatchVO.getWorkType().equals("T&M")){
                        // 将开票变成待回收状态
                        conInvBatchPayload.setRecycleSettleFlag(0);
                    }
                    break;
                case APPROVING:
//                    conInvBatchPayload.setBatchStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                    conInvBatchPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    break;
                default:
            }
            invBatchDAO.updateByKeyDynamic(conInvBatchPayload);
        }
        return WorkflowResult.success(null);
    }
}
