/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.ab.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbContactsPayload;
import com.elitesland.tw.tw5.api.prd.ab.query.PrdAbContactsQuery;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbContactsService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbContactsVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmFollowService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.ab.convert.PrdAbContactsConvert;
import com.elitesland.tw.tw5.server.prd.ab.dao.PrdAbContactsDAO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbContactsDO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CrmFollowObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PrdAbContactsServiceImpl
extends BaseServiceImpl
implements PrdAbContactsService {
    private static final Logger log = LoggerFactory.getLogger(PrdAbContactsServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final PrdAbContactsDAO dao;
    private final CrmFollowService followService;
    private final PrdSystemLogService logService;
    private final ExcelUtil excelUtil;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    @Value(value="${tw4.contacts.operation}")
    private String contacts_operation;
    @Value(value="${tw4.contacts.del}")
    private String contacts_del;

    @Transactional
    public PrdAbContactsVO insert(PrdAbContactsPayload payload) {
        String code = this.generateSeqNum("CONTACTS_NO", new String[0]);
        PrdAbContactsDO contactsDO = PrdAbContactsConvert.INSTANCE.toDo(payload);
        contactsDO.setContactsNo(code);
        contactsDO.setContactsStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
        contactsDO = this.dao.save(contactsDO);
        this.saveBaseLog(payload.getBookId(), payload.getObjectType(), PrdSystemLogEnum.CREATE.getDesc());
        this.saveLog(contactsDO.getId(), PrdSystemObjectEnum.Contacts.getCode(), PrdSystemLogEnum.CREATE.getDesc() + PrdSystemObjectEnum.Contacts.getDesc());
        return PrdAbContactsConvert.INSTANCE.toVo(contactsDO);
    }

    void saveBaseLog(Long bookId, String objectType, String logType) {
        Long customerId = this.dao.queryIdByBookId(bookId);
        this.logService.saveNewLog(customerId, objectType, logType + "\u8054\u7cfb\u4eba");
    }

    void saveLog(Long id, String objectType, String logType) {
        this.logService.saveNewLog(id, objectType, logType);
    }

    @Transactional
    public boolean delete(Long bookId, String objectType, List<Long> keys) {
        this.dao.delete(keys);
        this.saveBaseLog(bookId, objectType, PrdSystemLogEnum.DELETE.getDesc());
        return true;
    }

    @Transactional
    public boolean update(PrdAbContactsPayload payload) {
        PrdAbContactsVO contactsVO = this.dao.queryByKey(payload.getId());
        if (contactsVO == null || !contactsVO.getContactsStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            throw TwException.error("", "\u8be5\u6570\u636e\u5df2\u6682\u6302");
        }
        this.dao.updateByKeyDynamic(payload);
        this.saveBaseLog(payload.getBookId(), payload.getObjectType(), PrdSystemLogEnum.UPDATE.getDesc());
        this.saveLog(payload.getId(), PrdSystemObjectEnum.Contacts.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemObjectEnum.Contacts.getDesc());
        return true;
    }

    @Transactional
    public boolean updateStatus(Long key, String status) {
        this.dao.updateStatus(key, status);
        this.logService.saveNewLog(key, PrdSystemObjectEnum.Contacts.getCode(), this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemStatus.getCode(), status) + PrdSystemObjectEnum.Contacts.getDesc());
        return true;
    }

    public List<PrdAbContactsVO> queryList(Long bookId) {
        List<PrdAbContactsVO> contactsVOS = this.dao.queryList(bookId);
        contactsVOS.forEach(contactsVO -> this.transferSystemSelection((PrdAbContactsVO)contactsVO));
        return contactsVOS;
    }

    public PagingVO<PrdAbContactsVO> paging(PrdAbContactsQuery query) {
        PagingVO<PrdAbContactsVO> contactsPagingVOs = this.dao.queryPaging(query);
        List contactsVOS = contactsPagingVOs.getRecords();
        contactsVOS.forEach(contactsVO -> this.transferSystemSelection((PrdAbContactsVO)contactsVO));
        return contactsPagingVOs;
    }

    public PrdAbContactsVO queryByKey(Long key) {
        PrdAbContactsVO contactsVO = this.dao.queryByKey(key);
        this.transferSystemSelection(contactsVO);
        return contactsVO;
    }

    public void addFollow(CrmFollowPayload payload) {
        PrdAbContactsVO contactsVO = this.dao.queryByKey(payload.getObjectId());
        if (contactsVO == null || !contactsVO.getContactsStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            throw TwException.error("", "\u8be5\u6570\u636e\u5df2\u6682\u6302");
        }
        payload.setFollowObject(CrmFollowObjectEnum.Contacts.getCode());
        this.followService.addFollow(payload);
        this.saveLog(payload.getObjectId(), PrdSystemObjectEnum.Contacts.getCode(), PrdSystemLogEnum.ADD.getDesc() + PrdSystemLogEnum.FOLLOW.getDesc());
    }

    public void updateFollow(CrmFollowPayload payload) {
        PrdAbContactsVO contactsVO = this.dao.queryByKey(payload.getObjectId());
        if (contactsVO == null || !contactsVO.getContactsStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            throw TwException.error("", "\u8be5\u6570\u636e\u5df2\u6682\u6302");
        }
        payload.setFollowObject(CrmFollowObjectEnum.Contacts.getCode());
        this.followService.updateFollow(payload);
        this.saveLog(payload.getId(), PrdSystemObjectEnum.Contacts.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemLogEnum.FOLLOW.getDesc());
    }

    public List<CrmFollowVO> queryListFollow(Long objectId) {
        return this.followService.queryFollowList(objectId, CrmFollowObjectEnum.Contacts.name());
    }

    public PagingVO<PrdSystemLogVO> queryLogList(PrdSystemLogQuery query) {
        query.setLogObject(PrdSystemObjectEnum.Contacts.getCode());
        return this.logService.pageLog(query);
    }

    public void downloadBatch(HttpServletResponse response, PrdAbContactsQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/prdAbContactsBatch.xlsx");
        PagingVO<PrdAbContactsVO> paging = this.paging(query);
        List records = paging.getRecords();
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u8054\u7cfb\u4eba\u6570\u636e");
            if (!CollectionUtils.isEmpty((Collection)records) && batchProjectSheet != null) {
                int nextRow = 1;
                for (PrdAbContactsVO dataPayload : records) {
                    XSSFRow row = batchProjectSheet.createRow(nextRow);
                    this.excelUtil.setCellValue((Row)row, 0, nextRow);
                    this.excelUtil.setCellValue((Row)row, 1, dataPayload.getBookName());
                    this.excelUtil.setCellValue((Row)row, 2, dataPayload.getContactsNo());
                    this.excelUtil.setCellValue((Row)row, 3, dataPayload.getContactsStatusName());
                    this.excelUtil.setCellValue((Row)row, 4, dataPayload.getContactsTypeName());
                    this.excelUtil.setCellValue((Row)row, 5, dataPayload.getContactsName());
                    this.excelUtil.setCellValue((Row)row, 6, dataPayload.getContactsPhone());
                    this.excelUtil.setCellValue((Row)row, 7, dataPayload.getContactsTelephone());
                    this.excelUtil.setCellValue((Row)row, 8, dataPayload.getContactsEmail());
                    this.excelUtil.setCellValue((Row)row, 9, dataPayload.getContactsAddress());
                    this.excelUtil.setCellValue((Row)row, 10, dataPayload.getSocialAccountType());
                    this.excelUtil.setCellValue((Row)row, 11, dataPayload.getSocialAccount());
                    this.excelUtil.setCellValue((Row)row, 12, dataPayload.getContactsDepartment());
                    this.excelUtil.setCellValue((Row)row, 13, dataPayload.getContactsPosition());
                    this.excelUtil.setCellValue((Row)row, 14, dataPayload.getSexName());
                    this.excelUtil.setCellValue((Row)row, 15, dataPayload.getBirthday());
                    Boolean isKeyPerson = dataPayload.getIsKeyPerson();
                    String isKeyPersonStr = isKeyPerson == null ? "\u5426" : (isKeyPerson != false ? "\u662f" : "\u5426");
                    this.excelUtil.setCellValue((Row)row, 16, isKeyPersonStr);
                    ++nextRow;
                }
            }
            String fileName = "\u8054\u7cfb\u4eba\u6570\u636e-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void transferSystemSelection(PrdAbContactsVO vo) {
        vo.setContactsStatusName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemStatus.getCode(), vo.getContactsStatus()));
        vo.setSexName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeSex.getCode(), vo.getSex()));
        vo.setContactsTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.AbContacts_type.getCode(), vo.getContactsType()));
    }

    public PrdAbContactsServiceImpl(CacheUtil cacheUtil, PrdAbContactsDAO dao, CrmFollowService followService, PrdSystemLogService logService, ExcelUtil excelUtil, TransferUtilServiceImpl transferUtilService, HttpUtil httpUtil) {
        this.cacheUtil = cacheUtil;
        this.dao = dao;
        this.followService = followService;
        this.logService = logService;
        this.excelUtil = excelUtil;
        this.transferUtilService = transferUtilService;
        this.httpUtil = httpUtil;
    }
}

