/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccSubjectTemplateDetailPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccSubjectTemplateDetailQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccSubjectTemplateDetailService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBudgetItemVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccSubjectTemplateDetailVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccSubjectTemplateVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccSubjectTemplateDetailConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccSubjectTemplateDetailDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccSubjectTemplateDetailDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccSubjectTemplateDetailRepo;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class AccSubjectTemplateDetailServiceImpl
extends BaseServiceImpl
implements AccSubjectTemplateDetailService {
    private static final Logger log = LoggerFactory.getLogger(AccSubjectTemplateDetailServiceImpl.class);
    private final AccSubjectTemplateDetailRepo accSubjectTemplateDetailRepo;
    private final AccSubjectTemplateDetailDAO accSubjectTemplateDetailDAO;

    public List<AccSubjectTemplateDetailVO> bacthInsert(List<AccSubjectTemplateDetailPayload> payloads, AccSubjectTemplateVO accSubjectTemplateVO) {
        List collect = payloads.stream().filter(payload -> payload.getAccId() != null).map(AccSubjectTemplateDetailPayload::getBusinessId).distinct().collect(Collectors.toList());
        if (collect.size() < payloads.size()) {
            throw TwException.error("", "\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0\u9879\u76ee\u6838\u7b97\u6570\u636e");
        }
        List<Long> businessIds = this.accSubjectTemplateDetailDAO.queryBusinessIdList(accSubjectTemplateVO.getId());
        if (!ObjectUtils.isEmpty(businessIds)) {
            payloads = payloads.stream().filter(payload -> payload.getId() != null || !businessIds.contains(payload.getBusinessId())).collect(Collectors.toList());
        }
        List<AccSubjectTemplateDetailDO> entityDos = AccSubjectTemplateDetailConvert.INSTANCE.toDos(payloads);
        this.accSubjectTemplateDetailDAO.saveAll(entityDos);
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.accSubjectTemplateDetailDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftByTemlIds(List<Long> temlIds) {
        this.accSubjectTemplateDetailDAO.deleteSoftByTemlIds(temlIds);
    }

    public PagingVO<AccSubjectTemplateDetailVO> queryPaging(AccSubjectTemplateDetailQuery query) {
        return this.accSubjectTemplateDetailDAO.queryPaging(query);
    }

    public List<AccSubjectTemplateDetailVO> queryListByTmplId(Long tmplId) {
        return this.accSubjectTemplateDetailDAO.queryListByTmplId(tmplId);
    }

    public List<AccBudgetItemVO> queryBudgetItemList(Long tmplId) {
        return this.accSubjectTemplateDetailDAO.queryBudgetItemList(tmplId);
    }

    public AccSubjectTemplateDetailServiceImpl(AccSubjectTemplateDetailRepo accSubjectTemplateDetailRepo, AccSubjectTemplateDetailDAO accSubjectTemplateDetailDAO) {
        this.accSubjectTemplateDetailRepo = accSubjectTemplateDetailRepo;
        this.accSubjectTemplateDetailDAO = accSubjectTemplateDetailDAO;
    }
}

