/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.examination.callback;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEmployeCompositeAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluatePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdProbationExamPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEmployeCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdProbationExamService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdProbationExamVO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/PROBATION_EXAM/callBack"})
@Transactional
public class PrdProbationExamCallback
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(PrdProbationExamCallback.class);
    private final PrdProbationExamService prdProbationExamService;
    private final PrdEvaluateService prdEvaluateService;
    private final PrdEmployeCompositeAbilityService prdEmployeCompositeAbilityService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        if (StringUtils.isBlank((CharSequence)businessKey)) {
            throw new BusinessException("\u83b7\u53d6\u7684businessKey\u4e3a\u7a7a");
        }
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        Long id = Long.valueOf(businessKey);
        PrdProbationExamVO prdProbationExamVO = this.prdProbationExamService.get(id);
        PrdProbationExamPayload prdProbationExamPayload = new PrdProbationExamPayload();
        prdProbationExamPayload.setId(id);
        prdProbationExamPayload.setType(prdProbationExamVO.getType());
        if (prdProbationExamVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    prdProbationExamPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: 
                case INVALID: {
                    prdProbationExamPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case REJECTED: {
                    prdProbationExamPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    prdProbationExamPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    prdProbationExamPayload.setApprovedTime(LocalDateTime.now());
                    PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload = new PrdEmployeCompositeAbilityPayload();
                    prdEmployeCompositeAbilityPayload.setUserId(prdProbationExamVO.getUserId());
                    prdEmployeCompositeAbilityPayload.setFormId(prdProbationExamVO.getId());
                    prdEmployeCompositeAbilityPayload.setState(Integer.valueOf(1));
                    Boolean change = this.prdEmployeCompositeAbilityService.updateStateByFormId(prdEmployeCompositeAbilityPayload);
                    prdProbationExamPayload.setFinishFlag(Boolean.valueOf(true));
                    PrdEvaluatePayload prdEvaluatePayload = new PrdEvaluatePayload();
                    prdEvaluatePayload.setState(Integer.valueOf(1));
                    prdEvaluatePayload.setFromId(prdProbationExamVO.getId());
                    Long res = this.prdEvaluateService.updateStateByFormId(prdEvaluatePayload);
                    break;
                }
                case APPROVING: {
                    prdProbationExamPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                }
            }
            this.prdProbationExamService.updateByCondition(prdProbationExamPayload);
        }
        return WorkflowResult.success(null);
    }

    public PrdProbationExamCallback(PrdProbationExamService prdProbationExamService, PrdEvaluateService prdEvaluateService, PrdEmployeCompositeAbilityService prdEmployeCompositeAbilityService) {
        this.prdProbationExamService = prdProbationExamService;
        this.prdEvaluateService = prdEvaluateService;
        this.prdEmployeCompositeAbilityService = prdEmployeCompositeAbilityService;
    }
}

