/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.personnel.service;

import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonAccountService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonAccountVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.PersonAccountConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.PersonAccountDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.PersonAccountDO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PersonAccountServiceImpl
implements PersonAccountService {
    private static final Logger log = LoggerFactory.getLogger(PersonAccountServiceImpl.class);
    private final PersonAccountDAO personAccountDAO;
    private final CacheUtil cacheUtil;

    public void saveAll(List<PersonAccountVO> personAccountVOList, Long personId) {
        if (personAccountVOList != null) {
            if (personAccountVOList.size() == 0) {
                this.personAccountDAO.deleteAllByPersonId(personId);
            } else {
                for (PersonAccountVO personAccountVO : personAccountVOList) {
                    if (personAccountVO.getPersonId() != null) continue;
                    personAccountVO.setPersonId(personId);
                }
                this.personAccountDAO.saveAll(PersonAccountConvert.INSTANCE.toDos(personAccountVOList));
            }
        }
    }

    public List<PersonAccountVO> findAllByPersonId(Long personId) {
        List<PersonAccountDO> personAccountDOList = this.personAccountDAO.findAllByPersonId(personId);
        return PersonAccountConvert.INSTANCE.toVos(personAccountDOList);
    }

    public void deleteAllByPersonId(Long personId) {
        this.personAccountDAO.deleteAllByPersonId(personId);
    }

    public List<PersonAccountVO> findAllByUserId(Long userId) {
        PrdOrgEmployeeVO employeeVO = this.cacheUtil.getEmployee(userId);
        Long personId = employeeVO.getPersonId();
        return this.findAllByPersonId(personId);
    }

    public PersonAccountServiceImpl(PersonAccountDAO personAccountDAO, CacheUtil cacheUtil) {
        this.personAccountDAO = personAccountDAO;
        this.cacheUtil = cacheUtil;
    }
}

