/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectActivityPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectActivityQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectTemplateActService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectTemplateActVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectActivityConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectActivityDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectActivityProcessDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectActivityDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectActivityProcessRepo;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectActivityRepo;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PmsProjectActivityServiceImpl
extends BaseServiceImpl
implements PmsProjectActivityService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectActivityServiceImpl.class);
    private final PmsProjectActivityRepo pmsProjectActivityRepo;
    private final PmsProjectActivityDAO pmsProjectActivityDAO;
    private final ConReceivablePlanService conReceivablePlanService;
    private final PmsProjectActivityProcessDAO pmsProjectActivityProcessDAO;
    private final PmsProjectDAO pmsProjectDAO;
    private final WorkflowUtil workflowUtil;
    private final PmsProjectActivityProcessRepo pmsProjectActivityProcessRepo;
    private final PrdSystemRoleService roleService;
    private final PmsProjectTemplateActService pmsProjectTemplateActService;
    private final TransactionUtilService transactionUtilService;
    private final CacheUtil cacheUtil;
    private static String sheetName = "\u6d3b\u52a8\u7ba1\u7406\u5bfc\u5165\u6a21\u677f";

    @Transactional(rollbackFor={Exception.class})
    public List<PmsProjectActivityVO> queryListDynamic(PmsProjectActivityQuery query) {
        Long projId = query.getProjId();
        if (ObjectUtils.isEmpty((Object)projId)) {
            throw TwException.error("", "\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(projId);
        if (ObjectUtils.isEmpty((Object)pmsProjectVO)) {
            throw TwException.error("", "\u9879\u76ee\u4e0d\u5b58\u5728 !");
        }
        Boolean initActivity = true;
        List<Object> activityVOS = this.pmsProjectActivityDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(activityVOS)) {
            if (query.getInitFlag() != null && query.getInitFlag() == 1) {
                this.pmsProjectActivityDAO.deleteSoftByProjectId(projId);
            } else {
                initActivity = false;
                this.addPlanData(pmsProjectVO, activityVOS);
            }
        }
        if (initActivity.booleanValue()) {
            List actVOS = this.pmsProjectTemplateActService.queryByTemplateId(pmsProjectVO.getProjTempId());
            List collect = actVOS.stream().filter(vo -> vo.getActStageFlag() != null && vo.getActStageFlag() == 1).collect(Collectors.toList());
            ArrayList<PmsProjectActivityDO> activityDOS = new ArrayList<PmsProjectActivityDO>();
            actVOS.forEach(actVO -> {
                PmsProjectActivityDO pmsProjectActivityDO = new PmsProjectActivityDO();
                pmsProjectActivityDO.setProjId(projId);
                pmsProjectActivityDO.setActNo(actVO.getActCode());
                pmsProjectActivityDO.setActName(actVO.getActName());
                pmsProjectActivityDO.setMilestoneFlag(actVO.getMilestoneFlag());
                pmsProjectActivityDO.setPhaseFlag(actVO.getActStageFlag());
                pmsProjectActivityDO.setFromtmplFlag(1);
                pmsProjectActivityDO.setSortNo(actVO.getSortNo());
                pmsProjectActivityDO.setWorkbenchFlag(1);
                pmsProjectActivityDO.setRemark(actVO.getRemark());
                if (actVO.getActStageFlag() == null || actVO.getActStageFlag() == 0) {
                    Optional<PmsProjectTemplateActVO> first = collect.stream().filter(vo -> actVO.getActCode().startsWith(vo.getActCode())).findFirst();
                    if (first.isPresent()) {
                        pmsProjectActivityDO.setParentNo(first.get().getActCode());
                    } else {
                        throw TwException.error("", "\u8be5\u9879\u76ee\u6a21\u677f\u4e2d\u5bf9\u5e94\u7684\u6d3b\u52a8\u7f16\u53f7\u3010" + actVO.getActCode() + "\u3011\uff0c\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u9636\u6bb5\uff0c\u8bf7\u68c0\u67e5\u9879\u76ee\u6a21\u677f\u914d\u7f6e");
                    }
                }
                activityDOS.add(pmsProjectActivityDO);
            });
            if (activityDOS.size() > 0) {
                List<PmsProjectActivityDO> pmsProjectActivityDOS = this.pmsProjectActivityDAO.saveAll(activityDOS);
                activityVOS = PmsProjectActivityConvert.INSTANCE.toVoList(pmsProjectActivityDOS);
                this.transactionUtilService.executeWithRunnable(() -> {
                    ArrayList<PmsProjectActivityDO> newDOS = new ArrayList<PmsProjectActivityDO>();
                    pmsProjectActivityDOS.forEach(activityDO -> {
                        if (activityDO.getPhaseFlag() == null || activityDO.getPhaseFlag() == 0) {
                            PmsProjectActivityDO pmsProjectActivityDO = pmsProjectActivityDOS.stream().filter(phaseDO -> phaseDO.getActNo().equals(activityDO.getParentNo())).findFirst().get();
                            activityDO.setParentId(pmsProjectActivityDO.getId());
                            newDOS.add((PmsProjectActivityDO)activityDO);
                        }
                    });
                    if (newDOS.size() > 0) {
                        this.pmsProjectActivityDAO.saveAll(newDOS);
                    }
                });
            }
        }
        return activityVOS;
    }

    void addPlanData(PmsProjectVO pmsProjectVO, List<PmsProjectActivityVO> activityVOS) {
        if (!ObjectUtils.isEmpty((Object)pmsProjectVO.getContractId())) {
            List planVOList = this.conReceivablePlanService.queryBySaleConId(pmsProjectVO.getContractId());
            if (!ObjectUtils.isEmpty((Object)planVOList)) {
                planVOList = planVOList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getReceStatus()) && !"INVALID".equals(v.getReceStatus())).collect(Collectors.toList());
            }
            if (!ObjectUtils.isEmpty((Object)planVOList)) {
                Map planInfo = planVOList.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
                activityVOS.forEach(v -> {
                    ConReceivablePlanVO planVO;
                    if (!ObjectUtils.isEmpty((Object)v.getReceivePlanId()) && !ObjectUtils.isEmpty((Object)(planVO = (ConReceivablePlanVO)planInfo.get(v.getReceivePlanId())))) {
                        v.setReceivePlanDesc(planVO.getReceStage());
                        v.setReceRatio(planVO.getReceRatio());
                        v.setReceAmt(planVO.getReceAmt());
                        v.setReceStatus(planVO.getReceStatus());
                        v.setExpectReceDate(planVO.getExpectReceDate());
                        if (v.getExpectReceDate() != null && v.getExpectReceDate().isAfter(v.getStartDate()) && v.getExpectReceDate().isBefore(v.getEndDate())) {
                            v.setExpectReceDateFlag(1);
                        } else {
                            v.setExpectReceDateFlag(0);
                        }
                    }
                });
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectActivityVO insertOrUpdate(PmsProjectActivityPayload payload) {
        this.checkData(payload);
        if (ObjectUtils.isEmpty((Object)payload.getFromtmplFlag())) {
            payload.setFromtmplFlag(Integer.valueOf(0));
        }
        if (ObjectUtils.isEmpty((Object)payload.getWorkbenchFlag())) {
            payload.setWorkbenchFlag(Integer.valueOf(1));
        }
        PmsProjectActivityDO entityDo = PmsProjectActivityConvert.INSTANCE.toDo(payload);
        return PmsProjectActivityConvert.INSTANCE.toVo((PmsProjectActivityDO)this.pmsProjectActivityRepo.save(entityDo));
    }

    private void checkData(PmsProjectActivityPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getProjId())) {
            throw TwException.error("", "\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (ObjectUtils.isEmpty((Object)payload.getActNo()) || ObjectUtils.isEmpty((Object)payload.getActName())) {
            throw TwException.error("", "\u6d3b\u52a8\u7f16\u53f7\u548c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (!ObjectUtils.isEmpty((Object)payload.getPhaseFlag()) && 1 == payload.getPhaseFlag() && (ObjectUtils.isEmpty((Object)payload.getStartDate()) || ObjectUtils.isEmpty((Object)payload.getEndDate()))) {
            throw TwException.error("", "\u9636\u6bb5\u6d3b\u52a8\u7684\u8d77\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (!ObjectUtils.isEmpty((Object)payload.getStartDate()) && !ObjectUtils.isEmpty((Object)payload.getEndDate()) && payload.getStartDate().isAfter(payload.getEndDate())) {
            throw TwException.error("", "\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f !");
        }
        List<PmsProjectActivityVO> list = this.pmsProjectActivityDAO.queryByProjId(payload.getProjId());
        Optional<PmsProjectActivityVO> first = list.stream().filter(vo -> vo.getActNo().equals(payload.getActNo())).findFirst();
        if (first.isPresent()) {
            if (ObjectUtils.isEmpty((Object)payload.getId())) {
                throw TwException.error("", "\u9879\u76ee\u6d3b\u52a8\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d !");
            }
            if (first.get().getId().longValue() != payload.getId().longValue()) {
                throw TwException.error("", "\u9879\u76ee\u6d3b\u52a8\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d !");
            }
        }
        if (payload.getPhaseFlag() == null || payload.getPhaseFlag() == 0) {
            Optional<PmsProjectActivityVO> first0 = list.stream().filter(vo -> payload.getActNo().startsWith(vo.getActNo())).findFirst();
            if (first.isPresent()) {
                payload.setParentNo(first0.get().getActNo());
                payload.setParentId(first0.get().getId());
            } else {
                throw TwException.error("", "\u8be5\u6d3b\u52a8\u7f16\u53f7\u3010" + payload.getActNo() + "\u3011\uff0c\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u9636\u6bb5");
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<PmsProjectActivityVO> activityVOS = this.pmsProjectActivityDAO.queryByKeys(keys);
            List collect = activityVOS.stream().filter(vo -> vo.getPhaseFlag() != null && vo.getPhaseFlag() == 1 && vo.getPlanEqva() != null && vo.getPlanEqva().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(collect)) {
                throw TwException.error("", "\u8be5\u9636\u6bb5\u5df2\u505a\u9884\u7b97\uff0c\u4e0d\u53ef\u5220\u9664");
            }
            this.pmsProjectActivityDAO.deleteSoft(keys);
        }
    }

    public String getActivityStatus(Long projId) {
        PmsProjectActivityQuery query = new PmsProjectActivityQuery();
        query.setProjId(projId);
        long count = this.pmsProjectActivityDAO.count(query);
        if (count > 0L) {
            return "APPROVED";
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void importFile(MultipartFile file, Long projId) {
        if (file == null) {
            throw TwException.error("", "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        Sheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            throw TwException.error("", "\u8868\u7ed3\u6784\u9519\u8bef");
        }
        List<PmsProjectActivityVO> fromDb = this.pmsProjectActivityDAO.queryByProjId(projId);
        int dataStartRow = 2;
        ArrayList<PmsProjectActivityDO> activityDOS = new ArrayList<PmsProjectActivityDO>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); ++i) {
            Date endDate;
            Date startDate;
            Row row = sheet.getRow(i);
            String actNo = ExcelUtil.getCellFormatValue(row.getCell(0));
            String actName = ExcelUtil.getCellFormatValue(row.getCell(1));
            if (!StringUtils.hasText((String)actNo) || !StringUtils.hasText((String)actName)) break;
            PmsProjectActivityDO pmsProjectActivityDO = new PmsProjectActivityDO();
            Optional<PmsProjectActivityVO> first = fromDb.stream().filter(db -> db.getActNo().equals(actNo)).findFirst();
            if (first.isPresent()) {
                pmsProjectActivityDO.setId(first.get().getId());
            }
            pmsProjectActivityDO.setProjId(projId);
            pmsProjectActivityDO.setFromtmplFlag(0);
            pmsProjectActivityDO.setWorkbenchFlag(1);
            pmsProjectActivityDO.setActNo(actNo);
            pmsProjectActivityDO.setActName(actName);
            String typeDesc = ExcelUtil.getCellFormatValue(row.getCell(2));
            if ("\u91cc\u7a0b\u7891".equals(typeDesc)) {
                pmsProjectActivityDO.setMilestoneFlag(1);
            }
            if ("\u9636\u6bb5".equals(typeDesc)) {
                pmsProjectActivityDO.setPhaseFlag(1);
            }
            if ((startDate = row.getCell(3).getDateCellValue()) != null) {
                pmsProjectActivityDO.setStartDate(startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            }
            if ((endDate = row.getCell(4).getDateCellValue()) != null) {
                pmsProjectActivityDO.setEndDate(endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            }
            pmsProjectActivityDO.setRemark(ExcelUtil.getCellFormatValue(row.getCell(5)));
            activityDOS.add(pmsProjectActivityDO);
        }
        if (!ObjectUtils.isEmpty(activityDOS)) {
            ArrayList updateDOS = new ArrayList();
            List collect = activityDOS.stream().filter(vo -> vo.getPhaseFlag() != null && vo.getPhaseFlag() == 1).collect(Collectors.toList());
            activityDOS.forEach(activityDO -> {
                if (activityDO.getPhaseFlag() == null || activityDO.getPhaseFlag() == 0) {
                    Optional<PmsProjectActivityDO> first = collect.stream().filter(vo -> activityDO.getActNo().startsWith(vo.getActNo())).findFirst();
                    if (first.isPresent()) {
                        PmsProjectActivityDO pmsProjectActivityDO = first.get();
                        activityDO.setParentNo(pmsProjectActivityDO.getActNo());
                        if (pmsProjectActivityDO.getId() != null) {
                            activityDO.setParentId(pmsProjectActivityDO.getId());
                        } else {
                            updateDOS.add(activityDO);
                        }
                    } else {
                        Optional<PmsProjectActivityVO> first1 = fromDb.stream().filter(vo -> vo.getPhaseFlag() != null && vo.getPhaseFlag() == 1 && activityDO.getActNo().startsWith(vo.getActNo())).findFirst();
                        if (first1.isPresent()) {
                            activityDO.setParentNo(first1.get().getActNo());
                            activityDO.setParentId(first1.get().getId());
                        } else {
                            throw TwException.error("", "\u8be5\u6d3b\u52a8\u7f16\u53f7\u3010" + activityDO.getActNo() + "\u3011\uff0c\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u9636\u6bb5");
                        }
                    }
                }
            });
            List<PmsProjectActivityDO> pmsProjectActivityDOS = this.pmsProjectActivityDAO.saveAll(activityDOS);
            if (updateDOS.size() > 0) {
                this.transactionUtilService.executeWithRunnable(() -> {
                    updateDOS.forEach(activityDO -> {
                        PmsProjectActivityDO pmsProjectActivityDO = pmsProjectActivityDOS.stream().filter(phaseDO -> phaseDO.getActNo().equals(activityDO.getParentNo())).findFirst().get();
                        activityDO.setParentId(pmsProjectActivityDO.getId());
                    });
                    this.pmsProjectActivityDAO.saveAll(updateDOS);
                });
            }
        }
    }

    public void downloadFile(HttpServletResponse response) {
        ClassPathResource classPathResource = new ClassPathResource("template/pmsProjActivityTemplate.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            String fileName = "\u6d3b\u52a8\u7ba1\u7406\u5bfc\u5165\u6a21\u677f-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PagingVO<PmsProjectActivityVO> queryPaging(PmsProjectActivityQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getProjId())) {
            throw TwException.error("", "\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        return this.pmsProjectActivityDAO.queryPaging(query);
    }

    public long countListDynamic(PmsProjectActivityQuery query) {
        return this.pmsProjectActivityDAO.count(query);
    }

    public List<PmsProjectActivityVO> listForTimesheet(PmsProjectActivityQuery query) {
        Long projId = query.getProjId();
        if (ObjectUtils.isEmpty((Object)projId)) {
            throw TwException.error("", "\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(projId);
        if (ObjectUtils.isEmpty((Object)pmsProjectVO)) {
            throw TwException.error("", "\u9879\u76ee\u4e0d\u5b58\u5728 !");
        }
        query.setPhaseFlag(Integer.valueOf(1));
        List<PmsProjectActivityVO> activityVOS = this.pmsProjectActivityDAO.queryListDynamic(query);
        return activityVOS;
    }

    public List<PmsProjectActivityVO> queryActiveList(Long projId, int phaseFlag) {
        PmsProjectActivityQuery activityQuery = new PmsProjectActivityQuery();
        activityQuery.setProjId(projId);
        activityQuery.setPhaseFlag(Integer.valueOf(phaseFlag));
        return this.queryListDynamic(activityQuery);
    }

    public List<PmsProjectActivityVO> querySimpleActiveList(Long projId) {
        PmsProjectActivityQuery activityQuery = new PmsProjectActivityQuery();
        activityQuery.setProjId(projId);
        List<PmsProjectActivityVO> list = this.pmsProjectActivityDAO.queryListDynamic(activityQuery);
        if (!ObjectUtils.isEmpty(list)) {
            list.forEach(v -> {
                if (ObjectUtils.isEmpty((Object)v.getUsedEqva())) {
                    v.setUsedEqva(BigDecimal.ZERO);
                }
                if (ObjectUtils.isEmpty((Object)v.getOccupyEqva())) {
                    v.setOccupyEqva(BigDecimal.ZERO);
                }
            });
        }
        return list;
    }

    public PmsProjectActivityVO queryByKey(Long key) {
        return this.pmsProjectActivityDAO.queryByKey(key);
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PmsProjectActivityPayload payload) {
        long result = this.pmsProjectActivityDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchUpdate(List<PmsProjectActivityPayload> activityPayloads) {
        ArrayList<PmsProjectActivityDO> activityDOS = new ArrayList<PmsProjectActivityDO>();
        for (PmsProjectActivityPayload payload : activityPayloads) {
            PmsProjectActivityDO entity = PmsProjectActivityConvert.INSTANCE.toDo(payload);
            activityDOS.add(entity);
        }
        if (!ObjectUtils.isEmpty(activityDOS)) {
            this.pmsProjectActivityRepo.saveAll(activityDOS);
        }
    }

    public PmsProjectActivityServiceImpl(PmsProjectActivityRepo pmsProjectActivityRepo, PmsProjectActivityDAO pmsProjectActivityDAO, ConReceivablePlanService conReceivablePlanService, PmsProjectActivityProcessDAO pmsProjectActivityProcessDAO, PmsProjectDAO pmsProjectDAO, WorkflowUtil workflowUtil, PmsProjectActivityProcessRepo pmsProjectActivityProcessRepo, PrdSystemRoleService roleService, PmsProjectTemplateActService pmsProjectTemplateActService, TransactionUtilService transactionUtilService, CacheUtil cacheUtil) {
        this.pmsProjectActivityRepo = pmsProjectActivityRepo;
        this.pmsProjectActivityDAO = pmsProjectActivityDAO;
        this.conReceivablePlanService = conReceivablePlanService;
        this.pmsProjectActivityProcessDAO = pmsProjectActivityProcessDAO;
        this.pmsProjectDAO = pmsProjectDAO;
        this.workflowUtil = workflowUtil;
        this.pmsProjectActivityProcessRepo = pmsProjectActivityProcessRepo;
        this.roleService = roleService;
        this.pmsProjectTemplateActService = pmsProjectTemplateActService;
        this.transactionUtilService = transactionUtilService;
        this.cacheUtil = cacheUtil;
    }
}

