/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.controller;

import com.elitesland.tw.tw5.api.prd.salecon.payload.ConAchievePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConAchieveQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConAchieveService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e1a\u7ee9\u7edf\u8ba1"})
@RestController
@RequestMapping(value={"/api/contract/conAchieve"})
public class ConAchieveController {
    private static final Logger log = LoggerFactory.getLogger(ConAchieveController.class);
    private final ConAchieveService conAchieveService;

    @PutMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58")
    public TwOutputUtil saveAchieve(@RequestBody ConAchievePayload payload) {
        return TwOutputUtil.ok(this.conAchieveService.saveAchieve(payload));
    }

    @PostMapping
    @ApiOperation(value="\u65b0\u589e")
    public TwOutputUtil insert(@RequestBody ConAchievePayload payload) {
        return TwOutputUtil.ok(this.conAchieveService.insert(payload));
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u65b0")
    public TwOutputUtil update(@RequestBody ConAchievePayload payload) {
        return TwOutputUtil.ok(this.conAchieveService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.conAchieveService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    @ApiOperation(value="\u5206\u9875")
    public TwOutputUtil paging(ConAchieveQuery query) {
        return TwOutputUtil.ok(this.conAchieveService.queryPaging(query));
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil queryList(ConAchieveQuery query) {
        return TwOutputUtil.ok(this.conAchieveService.queryListDynamic(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.conAchieveService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/achieve/{contractId}"})
    @UdcNameClass
    @ApiOperation(value="\u6839\u636e\u5408\u540cID\u67e5\u8be2\u4e1a\u7ee9\u7edf\u8ba1")
    public TwOutputUtil queryByContractId(@PathVariable Long contractId) {
        return TwOutputUtil.ok(this.conAchieveService.queryByContractId(contractId));
    }

    @GetMapping(value={"/initSignAndDeli/{contractId}"})
    @UdcNameClass
    @ApiOperation(value="\u521d\u59cb\u5316\u52a0\u8f7d\u4e1a\u7ee9\u7edf\u8ba1")
    public TwOutputUtil initSignAndDeli(@PathVariable Long contractId) {
        return TwOutputUtil.ok(this.conAchieveService.initSignAndDeli(contractId));
    }

    @PostMapping(value={"/initSignAndDeliDib/{contractId}"})
    @UdcNameClass
    @ApiOperation(value="\u521d\u59cb\u5316\u52a0\u8f7d\u4e1a\u7ee9\u7edf\u8ba1\u8fea\u535a")
    public TwOutputUtil initSignAndDeliDib(@PathVariable Long contractId, BigDecimal obversionEffectiveAmt) {
        return TwOutputUtil.ok(this.conAchieveService.initSignAndDeliDib(contractId, obversionEffectiveAmt));
    }

    public ConAchieveController(ConAchieveService conAchieveService) {
        this.conAchieveService = conAchieveService;
    }
}

