/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFunctionSpecialPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionSpecialQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionSpecialVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFunctionSpecialDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemFunctionSpecialDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemFunctionSpecialRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PrdSystemFunctionSpecialDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemFunctionSpecialRepo repo;
    private final QPrdSystemFunctionSpecialDO qdo = QPrdSystemFunctionSpecialDO.prdSystemFunctionSpecialDO;

    public PrdSystemFunctionSpecialDO save(PrdSystemFunctionSpecialDO ado) {
        return (PrdSystemFunctionSpecialDO)this.repo.save(ado);
    }

    private JPAQuery<PrdSystemFunctionSpecialVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdSystemFunctionSpecialVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.functionId, this.qdo.specialName, this.qdo.specialUrl, this.qdo.specialType, this.qdo.specialCode, this.qdo.specialRoles, this.qdo.systemLevel, this.qdo.createUserId, this.qdo.createTime})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PrdSystemFunctionSpecialVO> getJpaQueryWhere(PrdSystemFunctionSpecialQuery query) {
        JPAQuery<PrdSystemFunctionSpecialVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getFunctionId())) {
            jpaQuery.where((Predicate)this.qdo.functionId.eq((Object)query.getFunctionId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSpecialName())) {
            jpaQuery.where((Predicate)this.qdo.specialName.like(SqlUtil.toSqlLikeString(query.getSpecialName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRemark())) {
            jpaQuery.where((Predicate)this.qdo.remark.like(SqlUtil.toSqlLikeString(query.getRemark())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSpecialType())) {
            jpaQuery.where((Predicate)this.qdo.specialType.eq((Object)query.getSpecialType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSpecialCode())) {
            jpaQuery.where((Predicate)this.qdo.specialCode.eq((Object)query.getSpecialCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            jpaQuery.where((Predicate)this.qdo.id.ne((Object)query.getId()));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public List<PrdSystemFunctionSpecialVO> queryListDynamic(PrdSystemFunctionSpecialQuery query) {
        JPAQuery<PrdSystemFunctionSpecialVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public long updateByKeyDynamic(PrdSystemFunctionSpecialPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getFunctionId() != null) {
            update.set(this.qdo.functionId, (Object)payload.getFunctionId());
        }
        if (payload.getSpecialName() != null) {
            update.set((Path)this.qdo.specialName, (Object)payload.getSpecialName());
        }
        if (payload.getRemark() != null) {
            update.set((Path)this.qdo.remark, (Object)payload.getRemark());
        }
        if (payload.getSpecialType() != null) {
            update.set(this.qdo.specialType, (Object)payload.getSpecialType());
        }
        if (payload.getSpecialUrl() != null) {
            update.set((Path)this.qdo.specialUrl, (Object)payload.getSpecialUrl());
        }
        if (payload.getSpecialCode() != null) {
            update.set((Path)this.qdo.specialCode, (Object)payload.getSpecialCode());
        }
        if (payload.getSpecialRoles() != null) {
            update.set((Path)this.qdo.specialRoles, (Object)payload.getSpecialRoles());
        }
        if (payload.getSystemLevel() != null) {
            update.set(this.qdo.systemLevel, (Object)payload.getSystemLevel());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0 && nullFields.contains("remark")) {
            update.setNull((Path)this.qdo.remark);
        }
        return update.execute();
    }

    public long delete(List<Long> keys) {
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.in(keys)});
        return delete.execute();
    }

    public long deleteSoft(Long key) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.eq((Object)key)});
        return update.execute();
    }

    public PrdSystemFunctionSpecialVO queryByKey(Long id) {
        JPAQuery<PrdSystemFunctionSpecialVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdSystemFunctionSpecialVO)jpaQuery.fetchFirst();
    }

    public PrdSystemFunctionSpecialVO specialInspect(String specialUrl) {
        JPAQuery<PrdSystemFunctionSpecialVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.specialUrl.eq((Object)specialUrl));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PrdSystemFunctionSpecialVO)jpaQuery.fetchFirst();
    }

    public PagingVO<PrdSystemFunctionSpecialVO> queryPaging(PrdSystemFunctionSpecialQuery query) {
        JPAQuery<PrdSystemFunctionSpecialVO> jpaQuery = this.getJpaQueryWhere(query);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public PrdSystemFunctionSpecialDAO(JPAQueryFactory jpaQueryFactory, PrdSystemFunctionSpecialRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

