/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.task.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleDetailService;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistributePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.BuProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistributeService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistributeVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskPayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskCommonService;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoExcelExport;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalSettleStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.DistributeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProcDefKey;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskSourceTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.task.common.PricingMethodEnum;
import com.elitesland.tw.tw5.server.prd.task.convert.TaskInfoConvert;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskInfoDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskPackageDAO;
import com.elitesland.tw.tw5.server.prd.task.entity.TaskInfoDO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TaskInfoServiceImpl
extends BaseServiceImpl
implements TaskInfoService {
    private static final Logger log = LoggerFactory.getLogger(TaskInfoServiceImpl.class);
    private final TaskInfoDAO taskInfoDAO;
    private final TaskPackageDAO taskPackageDAO;
    private final ComChangeService changeService;
    private final WorkflowUtil workflowUtil;
    private final CacheUtil cacheUtil;
    private final PmsDistributeService pmsDistributeService;
    private final TaskCommonService taskCommonService;
    private final BudgetCommonService budgetCommonService;
    private final CalTaskSettleDetailService calTaskSettleDetailService;
    private final PmsProjectService pmsProjectService;
    private final BuProjectService buProjectService;
    private final CrmOpportunityService opportunityService;
    private final PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService;

    public List<String> getEffectiveTaskStatus() {
        List<String> effectiveTaskStatus = Arrays.asList(TaskStatusEnum.INPROCESS.getCode(), TaskStatusEnum.VALIDATING.getCode(), TaskStatusEnum.FINISHED.getCode());
        return effectiveTaskStatus;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateTask(TaskInfoPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getId())) {
            throw TwException.error("", "\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        TaskInfoVO taskInfoVO = this.taskInfoDAO.queryByKey0(payload.getId());
        if (!TaskStatusEnum.CREATE.getCode().equals(taskInfoVO.getTaskStatus())) {
            throw TwException.error("", "\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u7684\u4efb\u52a1\u53ef\u4ee5\u4fee\u6539\uff01");
        }
        this.taskInfoDAO.save(this.getData(payload));
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchAddTask(TaskPayload taskPayload) {
        List taskInfoPayloads = taskPayload.getTaskInfoPayloads();
        this.checkData(taskInfoPayloads);
        taskInfoPayloads.forEach(taskInfoPayload -> {
            taskInfoPayload.setTaskApplyFlag(Integer.valueOf(0));
            taskInfoPayload.setTaskStatus(TaskStatusEnum.CREATE.getCode());
            taskInfoPayload.setDisterResId(null);
        });
        List<TaskInfoVO> taskInfoVOS = this.batchSave(taskInfoPayloads);
        if (taskPayload.getDistributeFlag().booleanValue()) {
            for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                this.startDistributeProcess(taskInfoVO.getId());
            }
        }
    }

    void checkData(List<TaskInfoPayload> taskInfoPayloads) {
        if (ObjectUtils.isEmpty(taskInfoPayloads)) {
            throw TwException.error("", "\u4efb\u52a1\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        ArrayList<Long> taskPackageIds = new ArrayList<Long>();
        taskInfoPayloads.forEach(taskInfoPayload -> {
            if (taskInfoPayload.getTaskPackageId() == null) {
                throw TwException.error("", "\u5f52\u5c5e\u4efb\u52a1\u5305\u4e0d\u53ef\u4e3a\u7a7a");
            }
            taskPackageIds.add(taskInfoPayload.getTaskPackageId());
        });
        List<TaskPackageVO> taskPackageVOS = this.taskPackageDAO.queryByKeys(taskPackageIds);
        if (taskPackageVOS.size() == 0) {
            throw TwException.error("", "\u5f52\u5c5e\u4efb\u52a1\u5305\u4e0d\u5b58\u5728");
        }
        Map taskPackageMap = taskPackageVOS.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
        taskInfoPayloads.forEach(taskInfoPayload -> {
            TaskPackageVO taskPackageVO = (TaskPackageVO)taskPackageMap.get(taskInfoPayload.getTaskPackageId());
            if (taskPackageVO == null || !taskPackageVO.getTaskPackageStatus().equals(TaskStatusEnum.INPROCESS.getCode())) {
                throw TwException.error("", "\u4ec5\u652f\u6301\u5904\u7406\u4e2d\u7684\u4efb\u52a1\u5305\u4efb\u52a1\u521b\u5efa");
            }
        });
    }

    public TaskInfoVO queryByKey(Long taskId, Boolean needTaskPackage) {
        if (!ObjectUtils.isEmpty((Object)needTaskPackage) && needTaskPackage.booleanValue()) {
            return this.taskInfoDAO.queryByKey(taskId);
        }
        return this.taskInfoDAO.queryByKey0(taskId);
    }

    public TaskInfoVO queryByTaskNo(String taskNo) {
        return this.taskInfoDAO.queryByTaskNo(taskNo);
    }

    public List<TaskInfoVO> queryList(TaskInfoQuery taskInfoQuery) {
        if (!StringUtils.hasText((String)taskInfoQuery.getTaskStatus())) {
            taskInfoQuery.setTaskStatuss(this.getEffectiveTaskStatus());
        }
        List<TaskInfoVO> taskInfoVOS = this.taskInfoDAO.queryListDynamic(taskInfoQuery);
        return taskInfoVOS;
    }

    public List<TaskInfoVO> queryListCommon(TaskInfoQuery taskInfoQuery) {
        List<TaskInfoVO> taskInfoVOS = this.taskInfoDAO.queryListDynamic(taskInfoQuery);
        if (!ObjectUtils.isEmpty(taskInfoVOS)) {
            taskInfoVOS.forEach(vo -> vo.setEffectiveEqva(vo.getTotalEqva().subtract(vo.getUsedEqva() == null ? BigDecimal.ZERO : vo.getUsedEqva())));
        }
        return taskInfoVOS;
    }

    public PagingVO<TaskInfoVO> queryPage(TaskInfoQuery taskInfoQuery) {
        PagingVO<TaskInfoVO> taskInfoVOPagingVO;
        Long loginUserId = GlobalUtil.getLoginUserId();
        taskInfoQuery.setLoginUserId(loginUserId);
        if (taskInfoQuery.getSearchType() != null) {
            if (taskInfoQuery.getSearchType() == 1) {
                taskInfoQuery.setTaskResId(loginUserId);
                taskInfoQuery.setTaskStatusFlag(Integer.valueOf(0));
                List<String> strings = Arrays.asList(TaskStatusEnum.CREATE.getCode(), TaskStatusEnum.DISPATCH.getCode());
                taskInfoQuery.setTaskStatuss(strings);
            }
            if (taskInfoQuery.getSearchType() == 2) {
                taskInfoQuery.setDisterResId(loginUserId);
            }
        } else {
            this.operPermissionFlag(taskInfoQuery);
        }
        if ((taskInfoVOPagingVO = this.taskInfoDAO.queryPaging(taskInfoQuery)).getTotal() > 0L) {
            LocalDate currentDate = LocalDate.now();
            taskInfoVOPagingVO.getRecords().forEach(taskInfoVO -> {
                BigDecimal totalEqva = taskInfoVO.getTotalEqva();
                BigDecimal settledEqva = taskInfoVO.getSettledEqva() == null ? BigDecimal.ZERO : taskInfoVO.getSettledEqva();
                BigDecimal occupyEqva = totalEqva.subtract(settledEqva);
                taskInfoVO.setOccupyEqva(occupyEqva);
                taskInfoVO.setCreator(this.cacheUtil.getUserName(taskInfoVO.getCreateUserId()));
                List<String> strings = Arrays.asList(TaskStatusEnum.FINISHED.getCode(), TaskStatusEnum.CLOSED.getCode());
                if (strings.contains(taskInfoVO.getTaskStatus())) {
                    taskInfoVO.setOverdue("\u5426");
                } else if (taskInfoVO.getPlanEndDate() != null) {
                    Period period = Period.between(taskInfoVO.getPlanEndDate(), currentDate);
                    int overdueDays = period.getDays();
                    if (overdueDays > 0) {
                        taskInfoVO.setOverdue("\u662f");
                        taskInfoVO.setOverdueDays((long)overdueDays);
                    } else {
                        taskInfoVO.setOverdue("\u5426");
                    }
                }
            });
        }
        return taskInfoVOPagingVO;
    }

    void operPermissionFlag(TaskInfoQuery query) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TASK_ADMIN.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
        if (!rolePermission.booleanValue()) {
            List<Long> orgIds = this.cacheUtil.getOrgIdsByManageId(query.getLoginUserId());
            PmsProjectQuery queryProject = new PmsProjectQuery();
            if (orgIds.size() > 0) {
                queryProject.setDeliBuIds(orgIds);
            }
            queryProject.setPermissionFlag(Boolean.valueOf(true));
            List pmsProjectVOS = this.pmsProjectService.queryListDynamic(queryProject);
            if (pmsProjectVOS.size() > 0) {
                List collect = pmsProjectVOS.stream().map(PmsProjectVO::getId).collect(Collectors.toList());
                query.setPmsProjIds(collect);
            }
            BuProjectQuery buProject = new BuProjectQuery();
            buProject.setLoginUserId(query.getLoginUserId());
            buProject.setPermissionFlag(Boolean.valueOf(true));
            List buProjectVOS = this.buProjectService.queryListDynamic(buProject);
            if (buProjectVOS.size() > 0) {
                List collect = buProjectVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList());
                query.setBuProjIds(collect);
            }
            CrmOpportunityQuery queryOpportunity = new CrmOpportunityQuery();
            queryOpportunity.setPreSaleOrgIds(orgIds);
            queryOpportunity.setLoginUserId(query.getLoginUserId());
            queryOpportunity.setIsPermission(Boolean.valueOf(true));
            List crmOpportunityListVOS = this.opportunityService.queryListDynamic(queryOpportunity);
            if (crmOpportunityListVOS.size() > 0) {
                List collect = crmOpportunityListVOS.stream().map(CrmOpportunityListVO::getProjectId).collect(Collectors.toList());
                query.setOppProjIds(collect);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public List<TaskInfoVO> batchSave(List<TaskInfoPayload> taskInfoPayloads) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        List<TaskInfoDO> taskInfoDOS = taskInfoPayloads.stream().map(taskInfoPayload -> {
            TaskInfoDO data = this.getData((TaskInfoPayload)taskInfoPayload);
            if (data.getDisterResId() == null) {
                data.setDisterResId(loginUserId);
            }
            return data;
        }).collect(Collectors.toList());
        this.checkBudget(taskInfoPayloads);
        return TaskInfoConvert.INSTANCE.toVoList(this.taskInfoDAO.saveAll(taskInfoDOS));
    }

    void checkBudget(List<TaskInfoPayload> taskInfoPayloads) {
        HashMap<String, List> projMap = new HashMap<String, List>();
        taskInfoPayloads.forEach(taskInfoPayload -> {
            if (taskInfoPayload.getTaskParentId() == null) {
                Long reasonId;
                String reasonType = taskInfoPayload.getReasonType();
                String key = reasonType + "-" + (reasonId = taskInfoPayload.getReasonId());
                ArrayList<TaskInfoPayload> taskInfoPayloads1 = (ArrayList<TaskInfoPayload>)projMap.get(key);
                if (taskInfoPayloads1 == null) {
                    taskInfoPayloads1 = new ArrayList<TaskInfoPayload>();
                }
                taskInfoPayloads1.add((TaskInfoPayload)taskInfoPayload);
                projMap.put(key, taskInfoPayloads1);
            }
        });
        projMap.forEach((key, value) -> {
            String[] split = key.split("-");
            String reasonType = split[0];
            Long reasonId = Long.valueOf(split[1]);
            BigDecimal planAllEqva = value.stream().map(TaskInfoPayload::getPlanEqva).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            this.budgetCommonService.checkBudgetEqva(reasonId, reasonType, null, planAllEqva);
            Map<Long, List<TaskInfoPayload>> collect = value.stream().filter(pay -> pay.getRelatedActId() != null).collect(Collectors.groupingBy(TaskInfoPayload::getRelatedActId));
            collect.forEach((key0, value0) -> {
                BigDecimal planAllEqva0 = value.stream().map(TaskInfoPayload::getPlanEqva).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                this.budgetCommonService.checkBudgetEqva(reasonId, reasonType, key0, planAllEqva0);
            });
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void taskDecompose(TaskPayload taskPayload) {
        Long taskParentId = taskPayload.getTaskParentId();
        if (ObjectUtils.isEmpty((Object)taskParentId)) {
            throw TwException.error("", "\u4e0a\u7ea7\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        TaskInfoVO taskParent = this.taskInfoDAO.queryByKey(taskParentId);
        if (ObjectUtils.isEmpty((Object)taskParent)) {
            throw TwException.error("", "\u4e0a\u7ea7\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!TaskStatusEnum.INPROCESS.getCode().equals(taskParent.getTaskStatus())) {
            throw TwException.error("", "\u53ea\u6709\u5904\u7406\u4e2d\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u8fdb\u884c\u4efb\u52a1\u62c6\u89e3");
        }
        String taskParentName = taskParent.getTaskName();
        if (!taskParent.getTaskResId().equals(GlobalUtil.getLoginUserId())) {
            throw TwException.error("", "\u4efb\u52a1\u5206\u89e3\u5931\u8d25\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u8be5\u64cd\u4f5c\uff01");
        }
        List taskInfoPayloads = taskPayload.getTaskInfoPayloads();
        if (!ObjectUtils.isEmpty((Object)taskInfoPayloads)) {
            BigDecimal remainingQuantity;
            BigDecimal settledEqva;
            BigDecimal approvedEqva;
            BigDecimal totalQuantity = taskInfoPayloads.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getPlanEqva())).map(TaskInfoPayload::getPlanEqva).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal usedEqva = taskParent.getUsedEqva() == null ? BigDecimal.ZERO : taskParent.getUsedEqva();
            BigDecimal bigDecimal = approvedEqva = taskParent.getApprovedEqva() == null ? BigDecimal.ZERO : taskParent.getApprovedEqva();
            if (approvedEqva.compareTo(usedEqva) > 0) {
                usedEqva = approvedEqva;
            }
            BigDecimal bigDecimal2 = settledEqva = taskParent.getSettledEqva() == null ? BigDecimal.ZERO : taskParent.getSettledEqva();
            if (settledEqva.compareTo(usedEqva) > 0) {
                usedEqva = settledEqva;
            }
            if (totalQuantity.compareTo(remainingQuantity = taskParent.getTotalEqva().subtract(usedEqva)) > 0) {
                throw TwException.error("", "\u6240\u5206\u89e3\u7684\u4efb\u52a1\u7684\u6240\u6709\u5f53\u91cf\u6570\u4e4b\u548c\u4e0d\u80fd\u5927\u4e8e\u4e0a\u7ea7\u4efb\u52a1\u7684\u5269\u4f59\u5f53\u91cf\u6570");
            }
            HashSet packageIds = new HashSet();
            taskInfoPayloads.forEach(info -> {
                if (ObjectUtils.isEmpty((Object)info.getPlanEqva()) || info.getPlanEqva().compareTo(BigDecimal.ZERO) <= 0) {
                    throw TwException.error("", "\u62c6\u5206\u4efb\u52a1\u5f53\u91cf\u4e0d\u5408\u89c4");
                }
                info.setId(null);
                info.setTaskStatus(TaskStatusEnum.CREATE.getCode());
                info.setTaskParentId(taskParentId);
                info.setTaskParentName(taskParentName);
                info.setTaskApplyFlag(Integer.valueOf(0));
                info.setReasonType(taskParent.getReasonType());
                info.setReasonId(taskParent.getReasonId());
                if (info.getTaskPackageId() == null) {
                    throw TwException.error("", "\u5f52\u5c5e\u4efb\u52a1\u5305\u4e0d\u53ef\u4e3a\u7a7a");
                }
                packageIds.add(info.getTaskPackageId());
            });
            List<TaskPackageVO> taskPackageVOS = this.taskPackageDAO.queryByKeys(new ArrayList<Long>(packageIds));
            if (taskPackageVOS.size() != packageIds.size()) {
                throw TwException.error("", "\u5f52\u5c5e\u4efb\u52a1\u5305\u4e0d\u5b58\u5728");
            }
            taskInfoPayloads.forEach(info -> {
                Optional<TaskPackageVO> first = taskPackageVOS.stream().filter(vo -> vo.getId().equals(info.getTaskPackageId()) && vo.getReceiverResId().equals(info.getTaskResId())).findFirst();
                if (!first.isPresent()) {
                    throw TwException.error("", "\u3010" + info.getTaskName() + "\u3011\u4efb\u52a1\u8d1f\u8d23\u4eba\u4e0e\u5f52\u5c5e\u4efb\u52a1\u5305\u4e0d\u5339\u914d");
                }
                TaskPackageVO taskPackageVO = first.get();
                if (!info.getReasonType().equals(taskPackageVO.getReasonType())) {
                    throw TwException.error("", "\u3010" + info.getTaskName() + "\u3011\u5173\u8054\u4efb\u52a1\u5305\u3010" + taskPackageVO.getTaskPackageName() + "\u3011\u4e8b\u7531\u7c7b\u578b\u4e0d\u5339\u914d");
                }
                if (!info.getReasonId().equals(taskPackageVO.getReasonId())) {
                    throw TwException.error("", "\u3010" + info.getTaskName() + "\u3011\u5173\u8054\u4efb\u52a1\u5305\u3010" + taskPackageVO.getTaskPackageName() + "\u3011\u4e8b\u7531\u4e0d\u5339\u914d");
                }
                if (!StringUtils.hasText((String)taskPackageVO.getTaskPackageStatus()) || !TaskStatusEnum.INPROCESS.getCode().equals(taskPackageVO.getTaskPackageStatus())) {
                    throw TwException.error("", "\u3010" + taskPackageVO.getTaskPackageName() + "\u3011\u4efb\u52a1\u5305\u72b6\u6001\u4e0d\u5728\u5904\u7406\u4e2d\uff0c\u4e0d\u53ef\u6d3e\u53d1\u4efb\u52a1");
                }
                info.setDisterResId(null);
            });
            List<TaskInfoVO> taskInfoVOS = this.batchSave(taskInfoPayloads);
            if (taskPayload.getDistributeFlag().booleanValue()) {
                TaskInfoPayload taskParentPayload = new TaskInfoPayload();
                taskParentPayload.setId(taskParentId);
                BigDecimal newTotalEqva = taskParent.getTotalEqva().subtract(totalQuantity);
                BigDecimal splitEqva = taskParent.getSplitEqva() == null ? BigDecimal.ZERO : taskParent.getSplitEqva();
                BigDecimal newSplitEqva = splitEqva.add(totalQuantity);
                BigDecimal newPlanEqva = newTotalEqva.add(newSplitEqva);
                if (taskParent.getPlanEqva() == null || newPlanEqva.compareTo(taskParent.getPlanEqva()) != 0) {
                    throw TwException.error("", "\u4efb\u52a1\u8ba1\u5212\u5f53\u91cf\u4e0d\u5339\u914d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                taskParentPayload.setTotalEqva(newTotalEqva);
                taskParentPayload.setSplitEqva(newSplitEqva);
                this.taskInfoDAO.updateByKeyDynamic(taskParentPayload);
                for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                    this.startDistributeProcess(taskInfoVO.getId());
                }
            }
        }
    }

    public void taskAutoCreate(TaskPayload taskPayload) {
        List<Long> userIds = this.checkAndInitData(taskPayload);
        TaskPackageQuery taskPackageQuery = new TaskPackageQuery();
        taskPackageQuery.setReasonType(taskPayload.getReasonType());
        taskPackageQuery.setReasonId(taskPayload.getReasonId());
        taskPackageQuery.setReceiverResIds(userIds);
        taskPackageQuery.setTaskPackageStatus(TaskStatusEnum.INPROCESS.getCode());
        List taskPackageVOS = this.taskCommonService.queryTaskPackageList(taskPackageQuery);
        taskPayload.getTaskInfoPayloads().forEach(taskInfoPayload -> {
            List collect = taskPackageVOS.stream().filter(vo -> vo.getReceiverResId().equals(taskInfoPayload.getTaskResId())).collect(Collectors.toList());
            if (ObjectUtils.isEmpty(collect)) {
                throw TwException.error("", "\u6d3e\u53d1\u8d44\u6e90\u4e0d\u5b58\u5728\u6539\u9879\u76ee\u4e0b\u7684\u4efb\u52a1\u5305");
            }
            TaskPackageVO taskPackageVO = (TaskPackageVO)collect.get(0);
            taskInfoPayload.setTaskPackageId(taskPackageVO.getId());
        });
        this.batchSave(taskPayload.getTaskInfoPayloads());
    }

    public List<TaskInfoVO> queryTaskSimpleList(TaskInfoQuery taskInfoQuery) {
        return this.taskInfoDAO.queryTaskSimpleList(taskInfoQuery);
    }

    public void batchExport(HttpServletResponse response, TaskInfoQuery taskInfoQuery) throws IOException {
        PagingVO<TaskInfoVO> taskInfoVOPagingVO;
        Long loginUserId = GlobalUtil.getLoginUserId();
        taskInfoQuery.setLoginUserId(loginUserId);
        if (taskInfoQuery.getSearchType() != null) {
            if (taskInfoQuery.getSearchType() == 1) {
                taskInfoQuery.setTaskResId(loginUserId);
                taskInfoQuery.setTaskStatusFlag(Integer.valueOf(0));
                List<String> strings = Arrays.asList(TaskStatusEnum.CREATE.getCode(), TaskStatusEnum.DISPATCH.getCode());
                taskInfoQuery.setTaskStatuss(strings);
            }
            if (taskInfoQuery.getSearchType() == 2) {
                taskInfoQuery.setDisterResId(loginUserId);
            }
        } else {
            this.operPermissionFlag(taskInfoQuery);
        }
        if ((taskInfoVOPagingVO = this.taskInfoDAO.queryPaging(taskInfoQuery)).getTotal() > 0L) {
            LocalDate currentDate = LocalDate.now();
            taskInfoVOPagingVO.getRecords().forEach(taskInfoVO -> {
                BigDecimal totalEqva = taskInfoVO.getTotalEqva();
                BigDecimal settledEqva = taskInfoVO.getSettledEqva() == null ? BigDecimal.ZERO : taskInfoVO.getSettledEqva();
                BigDecimal occupyEqva = totalEqva.subtract(settledEqva);
                taskInfoVO.setOccupyEqva(occupyEqva);
                taskInfoVO.setCreator(this.cacheUtil.getUserName(taskInfoVO.getCreateUserId()));
                List<String> strings = Arrays.asList(TaskStatusEnum.FINISHED.getCode(), TaskStatusEnum.CLOSED.getCode());
                if (strings.contains(taskInfoVO.getTaskStatus())) {
                    taskInfoVO.setOverdue("\u5426");
                } else if (taskInfoVO.getPlanEndDate() != null) {
                    Period period = Period.between(taskInfoVO.getPlanEndDate(), currentDate);
                    int overdueDays = period.getDays();
                    if (overdueDays > 0) {
                        taskInfoVO.setOverdue("\u662f");
                        taskInfoVO.setOverdueDays((long)overdueDays);
                    } else {
                        taskInfoVO.setOverdue("\u5426");
                    }
                }
            });
        }
        String sheetName = "\u4efb\u52a1\u6570\u636e";
        List records = taskInfoVOPagingVO.getRecords();
        List<TaskInfoExcelExport> taskInfoExcelExportList = TaskInfoConvert.INSTANCE.toExcel(records);
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), TaskInfoExcelExport.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, TaskInfoExcelExport.class, null);
        for (TaskInfoExcelExport taskInfoExcelExport : taskInfoExcelExportList) {
            if (null != taskInfoExcelExport.getPlanStartDate()) {
                taskInfoExcelExport.setPlanStartDateStr(taskInfoExcelExport.getPlanStartDate().toString());
            }
            if (null != taskInfoExcelExport.getPlanEndDate()) {
                taskInfoExcelExport.setPlanEndDateStr(taskInfoExcelExport.getPlanEndDate().toString());
            }
            if (null != taskInfoExcelExport.getCreateTime()) {
                taskInfoExcelExport.setCreateTimeStr(taskInfoExcelExport.getCreateTime().toString());
            }
            if (null != taskInfoExcelExport.getTotalEqva() && null != taskInfoExcelExport.getUsedEqva()) {
                taskInfoExcelExport.setEffectiveEqva(taskInfoExcelExport.getTotalEqva().subtract(taskInfoExcelExport.getUsedEqva()));
            }
            String evalStr = "\u5426";
            if (taskInfoExcelExport.getEvaluationflag() != null && taskInfoExcelExport.getEvaluationflag() == 1) {
                evalStr = "\u662f";
            }
            taskInfoExcelExport.setEvaluationflagStr(evalStr);
            taskInfoExcelExport.setTaskRes(this.cacheUtil.getUserName(taskInfoExcelExport.getTaskResId()));
            taskInfoExcelExport.setDisterResName(this.cacheUtil.getUserName(taskInfoExcelExport.getDisterResId()));
            taskInfoExcelExport.setAss(this.cacheUtil.getUserName(taskInfoExcelExport.getAssId()));
            taskInfoExcelExport.setReasonTypeDesc(this.cacheUtil.getSystemSelectionNameByValue("PMS:PROJECT:TYPE", taskInfoExcelExport.getReasonType()));
            taskInfoExcelExport.setTaskTypeDesc(this.cacheUtil.getSystemSelectionNameByValue("work:assignment:assignment_type", taskInfoExcelExport.getTaskType()));
            taskInfoExcelExport.setTaskStatusDesc(this.cacheUtil.getSystemSelectionNameByValue("PMS:TASK:STATUS", taskInfoExcelExport.getTaskStatus()));
        }
        sheet.doWrite(taskInfoExcelExportList);
    }

    private List<Long> checkAndInitData(TaskPayload taskPayload) {
        if (!StringUtils.hasText((String)taskPayload.getReasonType())) {
            throw TwException.error("", "\u4e8b\u7531\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)taskPayload.getSourceType())) {
            throw TwException.error("", "\u4efb\u52a1\u6765\u6e90\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (taskPayload.getReasonId() == null) {
            throw TwException.error("", "\u4e8b\u7531id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (taskPayload.getSourceId() == null) {
            throw TwException.error("", "\u6765\u6e90\u6570\u636eid\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)taskPayload.getTaskInfoPayloads())) {
            throw TwException.error("", "\u6d3e\u53d1\u4efb\u52a1\u4e0d\u53ef\u4e3a\u7a7a");
        }
        HashMap userTaskInfoMap = new HashMap();
        taskPayload.getTaskInfoPayloads().forEach(taskInfoPayload -> {
            if (taskInfoPayload.getTaskResId() == null) {
                throw TwException.error("", "\u4efb\u52a1\u8d1f\u8d23\u4eba\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (taskInfoPayload.getPlanEqva() == null) {
                throw TwException.error("", "\u4efb\u52a1\u6d3e\u53d1\u5f53\u91cf\u4e0d\u53ef\u4e3a\u7a7a");
            }
            TaskInfoPayload taskInfoPayload1 = (TaskInfoPayload)userTaskInfoMap.get(taskInfoPayload.getTaskResId());
            if (taskInfoPayload1 == null) {
                userTaskInfoMap.put(taskInfoPayload.getTaskResId(), taskInfoPayload);
            } else {
                taskInfoPayload1.setPlanEqva(taskInfoPayload1.getPlanEqva().add(taskInfoPayload.getPlanEqva()));
            }
            taskInfoPayload.setReasonId(taskPayload.getReasonId());
            taskInfoPayload.setReasonType(taskPayload.getReasonType());
            taskInfoPayload.setSourceId(taskPayload.getSourceId());
            taskInfoPayload.setSourceType(taskPayload.getSourceType());
            taskInfoPayload.setTaskApplyFlag(Integer.valueOf(0));
            taskInfoPayload.setDisterResId(null);
            if (taskInfoPayload.getPlanStartDate() == null) {
                taskInfoPayload.setPlanStartDate(taskPayload.getPlanStartDate());
            }
            if (taskInfoPayload.getPlanEndDate() == null) {
                taskInfoPayload.setPlanEndDate(taskPayload.getPlanEndDate());
            }
            if (taskPayload.getSourceType().equals(TaskSourceTypeEnum.REWARD.getCode())) {
                taskInfoPayload.setTaskName(taskPayload.getReasonName() + "-" + LocalDate.now() + "-\u5956\u52b1\u5047");
                taskInfoPayload.setTaskStatus(TaskStatusEnum.PENDING.getCode());
                taskInfoPayload.setApprovedEqva(taskInfoPayload.getPlanEqva());
            }
        });
        List collect = userTaskInfoMap.values().stream().collect(Collectors.toList());
        taskPayload.setTaskInfoPayloads(collect);
        return userTaskInfoMap.keySet().stream().collect(Collectors.toList());
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveChangeLog(TaskInfoPayload payload) {
        Long taskId = payload.getId();
        if (ObjectUtils.isEmpty((Object)taskId)) {
            throw TwException.error("", "\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        BigDecimal additionEqva = payload.getAdditionEqva();
        if (ObjectUtils.isEmpty((Object)additionEqva)) {
            throw TwException.error("", "\u53d8\u66f4\u5f53\u91cf\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        BigDecimal planEqva = payload.getPlanEqva();
        if (ObjectUtils.isEmpty((Object)planEqva)) {
            throw TwException.error("", "\u53d8\u66f4\u540e\u4efb\u52a1\u5f53\u91cf\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        Long taskPackageId = payload.getTaskPackageId();
        if (ObjectUtils.isEmpty((Object)taskPackageId)) {
            throw TwException.error("", "\u4efb\u52a1\u5305id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        TaskInfoVO taskInfoVO = this.taskInfoDAO.queryByKey(taskId);
        if (ObjectUtils.isEmpty((Object)taskInfoVO)) {
            throw TwException.error("", "\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (taskInfoVO.getTaskParentId() != null) {
            throw TwException.error("", "\u62c6\u5206\u4efb\u52a1\u4e0d\u80fd\u5f53\u91cf\u8c03\u6574");
        }
        if (!GlobalUtil.getLoginUserId().equals(taskInfoVO.getCreateUserId())) {
            throw TwException.error("", "\u53ea\u6709\u53d1\u4efb\u52a1\u4eba\u53ef\u4ee5\u5bf9\u5df2\u53d1\u51fa\u7684\u4efb\u52a1\u8fdb\u884c\u5f53\u91cf\u7684\u8c03\u6574");
        }
        if (!TaskStatusEnum.INPROCESS.getCode().equals(taskInfoVO.getTaskStatus())) {
            throw TwException.error("", "\u53ea\u6709\u5904\u7406\u4e2d\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u8fdb\u884c\u4efb\u52a1\u7684\u8c03\u6574");
        }
        if (taskInfoVO.getSettledEqva() != null && planEqva.compareTo(taskInfoVO.getSettledEqva()) < 0) {
            throw TwException.error("", "\u5f53\u91cf\u6570\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u7ed3\u7b97\u5f53\u91cf\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (taskInfoVO.getSplitEqva() != null && planEqva.compareTo(taskInfoVO.getSplitEqva()) < 0) {
            throw TwException.error("", "\u5f53\u91cf\u6570\u4e0d\u80fd\u5c0f\u4e8e\u62c6\u5206\u5f53\u91cf\u6570\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        this.budgetCommonService.checkBudgetEqva(taskInfoVO.getReasonId(), taskInfoVO.getReasonType(), payload.getRelatedActId(), additionEqva);
        Long changeId = payload.getChangeId();
        ComChangePayload changePayload = new ComChangePayload();
        changePayload.setId(changeId);
        changePayload.setChangeContent(JSONObject.toJSONString((Object)payload));
        changePayload.setExtString1(taskInfoVO.getPlanEqva().toString());
        changePayload.setExtString2(planEqva.toString());
        changePayload.setExtString3(additionEqva.toString());
        changePayload.setExtString4(payload.getChangeDes());
        changePayload.setChangeDocId("" + payload.getId());
        if (ObjectUtils.isEmpty((Object)changeId)) {
            changeId = this.changeService.save(ChangeTypeEnum.PMS_TASK_CHANGE.getCode(), (Object)taskInfoVO, (Object)payload, taskId.toString());
            changePayload.setId(changeId);
        } else {
            ComChangeVO comChangeVO = this.changeService.queryByKey(changeId);
            changePayload.setApprProcInstId(comChangeVO.getApprProcInstId());
        }
        if (payload.getChangeFlag().booleanValue()) {
            if (ObjectUtils.isEmpty((Object)changePayload.getApprProcInstId())) {
                BigDecimal totalAdditionEqva = taskInfoVO.getAdditionEqva().add(additionEqva);
                this.submitChangeProc(payload, changePayload, totalAdditionEqva);
            } else {
                changePayload.setApprStatus(ProcInstStatus.APPROVING.name());
                changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                this.changeService.updateByKeyDynamic(changePayload);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys, Boolean ... isCheck) {
        if (CollectionUtils.isNotEmpty(keys)) {
            List<TaskInfoVO> taskInfoVOS;
            if ((isCheck == null || isCheck.length == 0 || isCheck[0].booleanValue()) && CollectionUtils.isNotEmpty(taskInfoVOS = this.taskInfoDAO.queryByKeys(keys))) {
                for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                    if (TaskStatusEnum.CREATE.getCode().equals(taskInfoVO.getTaskStatus())) continue;
                    throw TwException.error("", "\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u7684\u4efb\u52a1\u53ef\u4ee5\u5220\u9664\uff01");
                }
            }
            this.taskInfoDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void taskApply(TaskPayload taskPayload) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        List taskInfoPayloads = taskPayload.getTaskInfoPayloads();
        if (ObjectUtils.isEmpty((Object)taskInfoPayloads)) {
            throw TwException.error("", "\u4efb\u52a1\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        HashSet packageIds = new HashSet();
        taskInfoPayloads.forEach(v -> {
            if (v.getTaskPackageId() == null) {
                throw TwException.error("", "\u5f52\u5c5e\u4efb\u52a1\u5305\u4e0d\u53ef\u4e3a\u7a7a");
            }
            v.setTaskApplyFlag(Integer.valueOf(1));
            v.setTaskResId(loginUserId);
            packageIds.add(v.getTaskPackageId());
        });
        List<TaskPackageVO> taskPackageVOS = this.taskPackageDAO.queryByKeys(new ArrayList<Long>(packageIds));
        if (taskPackageVOS.size() != packageIds.size()) {
            throw TwException.error("", "\u5f52\u5c5e\u4efb\u52a1\u5305\u4e0d\u5b58\u5728");
        }
        BigDecimal eqvaRatio = this.prdOrgEmployeeEqvaRatioService.getEqvaRatio(loginUserId, LocalDate.now());
        taskInfoPayloads.forEach(v -> {
            TaskPackageVO taskPackageVO = taskPackageVOS.stream().filter(packageVO -> packageVO.getId().equals(v.getTaskPackageId())).findFirst().get();
            if (taskPackageVO.getReceiverResId().longValue() != loginUserId.longValue()) {
                throw TwException.error("", "\u5173\u8054\u4efb\u52a1\u5305\u4e0d\u5c5e\u4e8e\u672c\u4eba");
            }
            if ((taskPackageVO.getEqvaRatio() == null ? BigDecimal.ZERO : taskPackageVO.getEqvaRatio()).compareTo(eqvaRatio) != 0) {
                throw TwException.error("", "\u5173\u8054\u4efb\u52a1\u5305\u5f53\u91cf\u7cfb\u6570:" + taskPackageVO.getEqvaRatio() + " \u548c\u5f53\u524d\u7cfb\u6570\u4e0d\u5339\u914d:" + eqvaRatio);
            }
            v.setDisterResId(taskPackageVO.getDisterResId());
        });
        List<TaskInfoVO> taskInfoVOS = this.batchSave(taskInfoPayloads);
        if (taskPayload.getDistributeFlag().booleanValue()) {
            for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                this.submitApplyProc(taskInfoVO);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void operationTaskFinish(Long key, String operationStatus) {
        TaskInfoPayload payload;
        TaskInfoVO infoVO = this.taskInfoDAO.queryByKey0(key);
        if (infoVO != null && infoVO.getTaskStatus().equals(TaskStatusEnum.VALIDATING.getCode())) {
            if (!infoVO.getDisterResId().equals(GlobalUtil.getLoginUserId())) {
                throw TwException.error("", "\u4ec5\u652f\u6301\u6d3e\u53d1\u8d44\u6e90\u64cd\u4f5c");
            }
            payload = new TaskInfoPayload();
            payload.setId(key);
            if (StringUtils.hasText((String)operationStatus) && "1".equals(operationStatus)) {
                payload.setTaskStatus(TaskStatusEnum.FINISHED.getCode());
                payload.setTaskProgress(new BigDecimal(100));
            } else {
                payload.setTaskStatus(TaskStatusEnum.INPROCESS.getCode());
            }
        } else {
            throw TwException.error("", "\u4ec5\u652f\u6301\u9a8c\u6536\u4e2d\u7684\u4efb\u52a1\u5904\u7406");
        }
        this.taskInfoDAO.updateByKeyDynamic(payload);
    }

    public void taskFinish(List<Long> keys) {
        List<TaskInfoVO> taskInfoVOS;
        if (CollectionUtils.isNotEmpty(keys) && CollectionUtils.isNotEmpty(taskInfoVOS = this.taskInfoDAO.queryByKeys(keys))) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            ArrayList<Long> taskIds = new ArrayList<Long>();
            for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                if (!loginUserId.equals(taskInfoVO.getTaskResId())) {
                    throw TwException.error("", "\u53ea\u6709\u63a5\u5305\u4eba\u53ef\u4ee5\u70b9\u51fb\u5b8c\u5de5");
                }
                if (!TaskStatusEnum.INPROCESS.getCode().equals(taskInfoVO.getTaskStatus())) {
                    throw TwException.error("", "\u53ea\u6709\u5904\u7406\u4e2d\u7684\u4efb\u52a1\u624d\u53ef\u4ee5\u70b9\u51fb\u5b8c\u5de5");
                }
                taskIds.add(taskInfoVO.getId());
            }
            this.closeCheck(taskIds);
            for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                TaskInfoPayload payload = new TaskInfoPayload();
                payload.setId(taskInfoVO.getId());
                payload.setTaskStatus(TaskStatusEnum.VALIDATING.getCode());
                this.taskInfoDAO.updateByKeyDynamic(payload);
            }
        }
    }

    public void taskClose(List<Long> keys) {
        List<TaskInfoVO> taskInfoVOS;
        if (CollectionUtils.isNotEmpty(keys) && CollectionUtils.isNotEmpty(taskInfoVOS = this.taskInfoDAO.queryByKeys(keys))) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            ArrayList<Long> taskIds = new ArrayList<Long>();
            for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                if (!loginUserId.equals(taskInfoVO.getDisterResId()) && !loginUserId.equals(taskInfoVO.getDisterPackegeResId())) {
                    throw TwException.error("", "\u6ca1\u6709\u5173\u95ed\u6743\u9650");
                }
                if (!this.getEffectiveTaskStatus().contains(taskInfoVO.getTaskStatus())) {
                    throw TwException.error("", "\u5b58\u5728\u4e0d\u652f\u6301\u5173\u95ed\u7684\u4efb\u52a1\u72b6\u6001");
                }
                taskIds.add(taskInfoVO.getId());
            }
            this.closeCheck(taskIds);
            for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                BigDecimal approvedEqva;
                TaskInfoPayload payload = new TaskInfoPayload();
                payload.setId(taskInfoVO.getId());
                BigDecimal settledEqva = taskInfoVO.getSettledEqva() == null ? BigDecimal.ZERO : taskInfoVO.getSettledEqva();
                BigDecimal usedEqva = taskInfoVO.getUsedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getUsedEqva();
                BigDecimal bigDecimal = approvedEqva = taskInfoVO.getApprovedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getApprovedEqva();
                if (approvedEqva.compareTo(usedEqva) > 0) {
                    usedEqva = approvedEqva;
                }
                if (settledEqva.compareTo(usedEqva) > 0) {
                    usedEqva = settledEqva;
                }
                payload.setReleaseEqva(taskInfoVO.getTotalEqva().subtract(usedEqva));
                payload.setTotalEqva(usedEqva);
                payload.setTaskProgress(new BigDecimal(100));
                payload.setTaskStatus(TaskStatusEnum.CLOSED.getCode());
                this.taskInfoDAO.updateByKeyDynamic(payload);
            }
        }
    }

    void closeCheck(List<Long> taskIds) {
        List<String> settleStatus = Arrays.asList(CalSettleStatusEnum.CREATE.getCode(), CalSettleStatusEnum.IN_PROCESS.getCode(), CalSettleStatusEnum.REJECTED.getCode());
        List settleDetails = this.calTaskSettleDetailService.queryTaskSettleDetails(taskIds, settleStatus);
        if (!ObjectUtils.isEmpty((Object)settleDetails)) {
            throw TwException.error("", "\u5b58\u5728\u7ed3\u7b97\u4e2d\u6216\u7ed3\u7b97\u672a\u901a\u8fc7\u7ed3\u7b97\u5355,\u7ed3\u7b97\u5355\u53f7\u3010" + String.join((CharSequence)",", settleDetails) + "\u3011");
        }
    }

    public long findAcceptCount(Long userId) {
        TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
        taskInfoQuery.setTaskStatus(TaskStatusEnum.VALIDATING.getCode());
        taskInfoQuery.setDisterResId(userId);
        List<TaskInfoVO> list = this.taskInfoDAO.queryListDynamic(taskInfoQuery);
        if (!ObjectUtils.isEmpty(list)) {
            return list.size();
        }
        return 0L;
    }

    public void processStatusChange(ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        TaskInfoVO taskInfoVO = this.taskInfoDAO.queryByKey0(Long.valueOf(businessKey));
        if (taskInfoVO != null) {
            TaskInfoPayload taskInfoPayload = new TaskInfoPayload();
            taskInfoPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    taskInfoPayload.setTaskStatus(TaskStatusEnum.CREATE.getCode());
                    break;
                }
                case INTERRUPT: {
                    taskInfoPayload.setTaskStatus(TaskStatusEnum.CREATE.getCode());
                    break;
                }
                case INVALID: {
                    taskInfoPayload.setDeleteFlag(Integer.valueOf(1));
                    taskInfoPayload.setTaskStatus(TaskStatusEnum.CREATE.getCode());
                    break;
                }
                case REJECTED: {
                    taskInfoPayload.setTaskStatus(TaskStatusEnum.CREATE.getCode());
                    break;
                }
                case APPROVED: {
                    taskInfoPayload.setTaskStatus(TaskStatusEnum.INPROCESS.getCode());
                    break;
                }
                case APPROVING: {
                    taskInfoPayload.setTaskStatus(TaskStatusEnum.APPLYING.getCode());
                }
            }
            this.taskInfoDAO.updateByKeyDynamic(taskInfoPayload);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void processChangeStatusChange(ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        ComChangeVO comChangeVO = this.changeService.queryByKey(Long.valueOf(businessKey));
        if (comChangeVO != null) {
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setId(comChangeVO.getId());
            changePayload.setApprStatus(procInstStatus.name());
            changePayload.setApprProcInstId(comChangeVO.getApprProcInstId());
            TaskInfoPayload taskInfoPayload = new TaskInfoPayload();
            taskInfoPayload.setId(Long.valueOf(comChangeVO.getChangeDocId()));
            taskInfoPayload.setTaskStatus(TaskStatusEnum.INPROCESS.getCode());
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    break;
                }
                case INTERRUPT: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setApprProcInstId(null);
                    break;
                }
                case INVALID: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setApprProcInstId(null);
                    changePayload.setDeleteFlag(Integer.valueOf(1));
                    break;
                }
                case REJECTED: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    break;
                }
                case APPROVED: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    taskInfoPayload = (TaskInfoPayload)JSON.parseObject((String)comChangeVO.getChangeContent(), TaskInfoPayload.class);
                    TaskInfoVO taskInfoVO = this.taskInfoDAO.queryByKey(taskInfoPayload.getId());
                    BigDecimal addEqva = taskInfoPayload.getAdditionEqva();
                    taskInfoPayload.setAdditionEqva(taskInfoVO.getAdditionEqva().add(addEqva));
                    taskInfoPayload.setTotalEqva(taskInfoVO.getTotalEqva().add(addEqva));
                    break;
                }
                case APPROVING: {
                    changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                }
            }
            this.taskInfoDAO.updateByKeyDynamic(taskInfoPayload);
            this.changeService.updateWorkFlow(changePayload);
        }
    }

    @Transactional
    public long updateByKeyDynamic(TaskInfoPayload payload) {
        return this.taskInfoDAO.updateByKeyDynamic(payload);
    }

    @Transactional
    public void updateTaskProgress(Long key, BigDecimal progress) {
        if (progress.compareTo(BigDecimal.ZERO) < 0 || progress.compareTo(BigDecimal.valueOf(100L)) > 0) {
            throw TwException.error("", "\u8fdb\u5ea6\u5fc5\u987b\u57280\u548c100\u4e4b\u95f4");
        }
        TaskInfoPayload payload = new TaskInfoPayload();
        payload.setId(key);
        payload.setTaskProgress(progress);
        this.taskInfoDAO.updateByKeyDynamic(payload);
    }

    @Transactional
    public void updateSettledEqva(Long key, BigDecimal eqva) {
        if (ObjectUtils.isEmpty((Object)key)) {
            throw TwException.error("", "\u4efb\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)eqva) && eqva.compareTo(BigDecimal.ZERO) < 0) {
            throw TwException.error("", "\u7ed3\u7b97\u5f53\u91cf\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        TaskInfoVO taskInfoVO = this.taskInfoDAO.queryByKey(key);
        if (ObjectUtils.isEmpty((Object)taskInfoVO)) {
            throw TwException.error("", "\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        TaskInfoPayload payload = new TaskInfoPayload();
        payload.setId(key);
        BigDecimal settledEqva = taskInfoVO.getSettledEqva();
        payload.setSettledEqva(settledEqva == null ? eqva : settledEqva.add(eqva));
        if (PricingMethodEnum.SINGLE.getCode().equals(taskInfoVO.getPricingMethod()) && TaskStatusEnum.INPROCESS.getCode().equals(taskInfoVO.getTaskStatus()) && taskInfoVO.getTotalEqva().compareTo(payload.getSettledEqva()) == 0) {
            payload.setReleaseEqva(BigDecimal.ZERO);
            payload.setTaskProgress(new BigDecimal(100));
            payload.setTaskStatus(TaskStatusEnum.VALIDATING.getCode());
        }
        log.info("taskInfoVO::3");
        if (StringUtils.hasText((String)taskInfoVO.getSourceType()) && TaskSourceTypeEnum.REWARD.getCode().equals(taskInfoVO.getSourceType())) {
            log.info("taskInfoVO::4");
            payload.setReleaseEqva(BigDecimal.ZERO);
            payload.setTaskProgress(new BigDecimal(100));
            payload.setTaskStatus(TaskStatusEnum.CLOSED.getCode());
            payload.setUsedEqva(eqva);
            payload.setApprovedEqva(eqva);
        }
        this.taskInfoDAO.updateByKeyDynamic(payload);
    }

    void submitApplyProc(TaskInfoVO taskInfoVO) {
        TaskInfoPayload payload = new TaskInfoPayload();
        payload.setId(taskInfoVO.getId());
        if (!StringUtils.hasText((String)taskInfoVO.getTaskApplyProcessId())) {
            HashMap<String, Long> variables = new HashMap<String, Long>();
            variables.put("Activity_0os8qgd", taskInfoVO.getDisterResId());
            String procInstName = "T05." + taskInfoVO.getTaskName() + "-\u7533\u8bf7(" + this.cacheUtil.getUserName(taskInfoVO.getTaskResId()) + ")";
            ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)PmsProcDefKey.PMS_TASK_APPLY.name(), (String)procInstName, (String)("" + taskInfoVO.getId()), variables), new Long[0]);
            payload.setTaskApplyProcessId(processInfo.getProcInstId());
            if (ProcInstStatus.APPROVING.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
                payload.setTaskStatus(TaskStatusEnum.APPLYING.getCode());
            } else if (ProcInstStatus.APPROVED.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
                payload.setTaskStatus(TaskStatusEnum.INPROCESS.getCode());
            }
        } else {
            payload.setTaskApplyProcessId(taskInfoVO.getTaskApplyProcessId());
            payload.setTaskStatus(TaskStatusEnum.APPLYING.getCode());
        }
        this.taskInfoDAO.updateByKeyDynamic(payload);
    }

    void submitChangeProc(TaskInfoPayload payload, ComChangePayload changePayload, BigDecimal totalAdditionEqva) {
        HashMap<String, Long> variables = new HashMap<String, Long>();
        variables.put("Activity_1qxwk5g", payload.getTaskResId());
        String procInstName = "T03." + payload.getTaskName() + "-\u53d8\u66f4(" + this.cacheUtil.getUserName(payload.getCreateUserId()) + "-" + this.cacheUtil.getUserName(payload.getTaskResId()) + ")";
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)PmsProcDefKey.PMS_TASK_CHANGE.name(), (String)procInstName, (String)("" + changePayload.getId()), variables), new Long[0]);
        changePayload.setApprProcInstId(processInfo.getProcInstId());
        if (ProcInstStatus.APPROVING.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            TaskInfoPayload payload0 = new TaskInfoPayload();
            payload0.setId(payload.getId());
            payload0.setTaskStatus(TaskStatusEnum.PENDING.getCode());
            this.taskInfoDAO.updateByKeyDynamic(payload0);
            changePayload.setApprStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
            changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
        } else if (ProcInstStatus.APPROVED.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            payload.setTaskStatus(TaskStatusEnum.INPROCESS.getCode());
            payload.setAdditionEqva(totalAdditionEqva);
            payload.setTotalEqva(payload.getPlanEqva());
            this.taskInfoDAO.updateByKeyDynamic(payload);
            changePayload.setApprStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
            changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
        }
        this.changeService.updateByKeyDynamic(changePayload);
    }

    TaskInfoDO getData(TaskInfoPayload taskInfoPayload) {
        PrdOrgEmployeeVO employee;
        if (ObjectUtils.isEmpty((Object)taskInfoPayload.getTaskPackageId())) {
            throw TwException.error("", "\u4efb\u52a1\u5305ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        String reasonType = taskInfoPayload.getReasonType();
        if (ObjectUtils.isEmpty((Object)reasonType)) {
            throw TwException.error("", "\u4e8b\u7531\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        Long reasonId = taskInfoPayload.getReasonId();
        if (ObjectUtils.isEmpty((Object)reasonId)) {
            throw TwException.error("", "\u4e8b\u7531Id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)taskInfoPayload.getTaskResId())) {
            throw TwException.error("", "\u4efb\u52a1\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)taskInfoPayload.getPlanStartDate())) {
            throw TwException.error("", "\u9884\u8ba1\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)taskInfoPayload.getPlanEndDate())) {
            throw TwException.error("", "\u9884\u8ba1\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (taskInfoPayload.getPlanEqva() == null || taskInfoPayload.getPlanEqva().compareTo(BigDecimal.ZERO) <= 0) {
            throw TwException.error("", "\u6d3e\u53d1\u5f53\u91cf\u4e0d\u5408\u89c4\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!ObjectUtils.isEmpty((Object)taskInfoPayload.getRelatedActId()) && ObjectUtils.isEmpty((Object)taskInfoPayload.getRelatedAct())) {
            throw TwException.error("", "\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)taskInfoPayload.getId())) {
            taskInfoPayload.setTaskNo(this.generateSeqNum("TASK_NO", new String[0]));
        }
        if (!(employee = this.cacheUtil.getEmployee(taskInfoPayload.getTaskResId())).getResourceStatus().equals(SystemDefaultEnum.DefaultResourceStatus.getCode()) && !employee.getResourceStatus().equals(SystemDefaultEnum.LeaveIngResourceStatus.getCode())) {
            throw TwException.error("", "\u63a5\u5305\u8d44\u6e90\u72b6\u6001\u6682\u4e0d\u53ef\u63a5\u6536\u4efb\u52a1\u6d3e\u53d1");
        }
        if (!employee.getHrStatus().equals(SystemDefaultEnum.DefaultHrStatus.getCode())) {
            throw TwException.error("", "\u63a5\u5305\u8d44\u6e90\u72b6\u6001\u6682\u4e0d\u53ef\u63a5\u6536\u4efb\u52a1\u6d3e\u53d1");
        }
        taskInfoPayload.setOriginalEqva(taskInfoPayload.getPlanEqva());
        taskInfoPayload.setSettledEqva(BigDecimal.ZERO);
        taskInfoPayload.setAdditionEqva(BigDecimal.ZERO);
        taskInfoPayload.setSplitEqva(BigDecimal.ZERO);
        taskInfoPayload.setUsedEqva(BigDecimal.ZERO);
        taskInfoPayload.setReleaseEqva(BigDecimal.ZERO);
        taskInfoPayload.setApprovedEqva(BigDecimal.ZERO);
        taskInfoPayload.setValidEqva(BigDecimal.ZERO);
        taskInfoPayload.setEvaluationflag(Integer.valueOf(0));
        taskInfoPayload.setTaskProgress(BigDecimal.ZERO);
        taskInfoPayload.setTotalEqva(taskInfoPayload.getPlanEqva());
        return TaskInfoConvert.INSTANCE.toDo(taskInfoPayload);
    }

    public List<TaskInfoVO> queryTaskSettleList(TaskInfoQuery taskInfoQuery) {
        return this.taskInfoDAO.queryTaskSettleList(taskInfoQuery);
    }

    public void taskAssign(List<Long> keys) {
        if (CollectionUtils.isNotEmpty(keys)) {
            List pmsDistributeVOS;
            List<TaskInfoVO> taskInfoVOS = this.taskInfoDAO.queryByKeys(keys);
            if (CollectionUtils.isNotEmpty(taskInfoVOS)) {
                for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                    if (TaskStatusEnum.CREATE.getCode().equals(taskInfoVO.getTaskStatus())) continue;
                    throw TwException.error("", "\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u7684\u4efb\u52a1\u53ef\u4ee5\u6d3e\u53d1\uff01");
                }
            }
            if (!ObjectUtils.isEmpty((Object)(pmsDistributeVOS = this.pmsDistributeService.queryByReasons(keys, DistributeEnum.distType.TASK.getCode())))) {
                throw TwException.error("", "\u4efb\u52a1\u3010" + ((PmsDistributeVO)pmsDistributeVOS.get(0)).getReasonName() + "\u3011\u5df2\u521b\u5efa\u6d3e\u53d1\u6d41\u7a0b\uff0c\u8bf7\u5728\u201c\u6d41\u7a0b\u4ee3\u529e\u201d\u4e2d\u518d\u6b21\u6d3e\u53d1\u5904\u7406");
            }
            for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                this.startDistributeProcess(taskInfoVO.getId());
            }
        }
    }

    public void taskOpertionBySource(String sourceType, Long sourceId, ProcInstStatus procInstStatus) {
        if (!StringUtils.hasText((String)sourceType)) {
            throw TwException.error("", "\u4efb\u52a1\u6765\u6e90\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (sourceId == null) {
            throw TwException.error("", "\u6765\u6e90\u6570\u636eid\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (procInstStatus == null) {
            throw TwException.error("", "\u5ba1\u6279\u72b6\u6001\u4e0d\u53ef\u4e3a\u7a7a");
        }
        log.info("sourceType:" + sourceType + " /sourceId:" + sourceId + " /procInstStatus:" + procInstStatus.name());
        int operType = 0;
        switch (procInstStatus) {
            case NOTSUBMIT: {
                operType = 2;
                break;
            }
            case INTERRUPT: {
                operType = 2;
                break;
            }
            case INVALID: {
                operType = 2;
                break;
            }
            case REJECTED: {
                operType = 2;
                break;
            }
            case APPROVED: {
                operType = 1;
                break;
            }
        }
        if (operType > 0) {
            TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
            taskInfoQuery.setTaskStatus(TaskStatusEnum.PENDING.getCode());
            taskInfoQuery.setSourceType(sourceType);
            taskInfoQuery.setSourceId(sourceId);
            List<TaskInfoVO> taskInfoVOS = this.queryTaskSimpleList(taskInfoQuery);
            if (!ObjectUtils.isEmpty(taskInfoVOS) && operType == 2) {
                List<Long> collect = taskInfoVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList());
                this.deleteSoft(collect, false);
            }
        }
    }

    void startDistributeProcess(Long key) {
        PmsDistributePayload payload = new PmsDistributePayload();
        payload.setReasonType(DistributeEnum.distType.TASK.getCode());
        payload.setReasonId(key);
        TaskInfoVO taskInfoVO = this.taskInfoDAO.queryByKey(key);
        if (!StringUtils.hasText((String)taskInfoVO.getTaskPackageStatus()) || !TaskStatusEnum.INPROCESS.getCode().equals(taskInfoVO.getTaskPackageStatus())) {
            throw TwException.error("", "\u4ec5\u652f\u6301\u5904\u7406\u4e2d\u4efb\u52a1\u5305\u4e0b\u7684\u4efb\u52a1\u6d3e\u53d1");
        }
        BigDecimal eqvaRatio = this.prdOrgEmployeeEqvaRatioService.getEqvaRatio(taskInfoVO.getTaskResId(), LocalDate.now());
        if ((taskInfoVO.getEqvaRatio() == null ? BigDecimal.ZERO : taskInfoVO.getEqvaRatio()).compareTo(eqvaRatio) != 0) {
            throw TwException.error("", "\u5173\u8054\u4efb\u52a1\u5305\u5f53\u91cf\u7cfb\u6570:" + taskInfoVO.getEqvaRatio() + " \u548c\u5f53\u524d\u7cfb\u6570\u4e0d\u5339\u914d:" + eqvaRatio);
        }
        payload.setReasonName(taskInfoVO.getTaskName());
        payload.setDisterResId(taskInfoVO.getDisterResId());
        payload.setDisterResName(this.cacheUtil.getUserName(taskInfoVO.getDisterResId()));
        payload.setReceiverResId(taskInfoVO.getTaskResId());
        payload.setReceiverResName(this.cacheUtil.getUserName(taskInfoVO.getTaskResId()));
        payload.setDistMethod(DistributeEnum.distMethod.DESIGNATE.getCode());
        payload.setDistDesc(taskInfoVO.getTaskDes());
        payload.setPlanStartDate(taskInfoVO.getPlanStartDate());
        payload.setPlanEndDate(taskInfoVO.getPlanEndDate());
        this.pmsDistributeService.insertOrUpdate(payload);
    }

    public TaskInfoServiceImpl(TaskInfoDAO taskInfoDAO, TaskPackageDAO taskPackageDAO, ComChangeService changeService, WorkflowUtil workflowUtil, CacheUtil cacheUtil, PmsDistributeService pmsDistributeService, TaskCommonService taskCommonService, BudgetCommonService budgetCommonService, CalTaskSettleDetailService calTaskSettleDetailService, PmsProjectService pmsProjectService, BuProjectService buProjectService, CrmOpportunityService opportunityService, PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService) {
        this.taskInfoDAO = taskInfoDAO;
        this.taskPackageDAO = taskPackageDAO;
        this.changeService = changeService;
        this.workflowUtil = workflowUtil;
        this.cacheUtil = cacheUtil;
        this.pmsDistributeService = pmsDistributeService;
        this.taskCommonService = taskCommonService;
        this.budgetCommonService = budgetCommonService;
        this.calTaskSettleDetailService = calTaskSettleDetailService;
        this.pmsProjectService = pmsProjectService;
        this.buProjectService = buProjectService;
        this.opportunityService = opportunityService;
        this.prdOrgEmployeeEqvaRatioService = prdOrgEmployeeEqvaRatioService;
    }
}

