/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.purchase.payload.TPurchaseContractOverPayload;
import com.elitesland.tw.tw5.api.prd.purchase.service.TPurchaseContractOverService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.TPurchaseContractOverVO;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseContractManagerDAO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseContractStatusEnum;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/PUR_CON_OVER/callBack"})
@Transactional
public class PurchaseContractOverCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(PurchaseContractOverCallBackController.class);
    private final TPurchaseContractOverService service;
    private final PurchaseContractManagerDAO purchaseContractManagerDAO;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        TPurchaseContractOverPayload purchaseContractOverPayload = new TPurchaseContractOverPayload();
        purchaseContractOverPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        TPurchaseContractOverVO tPurchaseContractOverVO = this.service.queryByKey(Long.valueOf(businessKey));
        Long purchaseContractId = tPurchaseContractOverVO.getContractId();
        if (tPurchaseContractOverVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    purchaseContractOverPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    purchaseContractOverPayload.setOverStatus(PurchaseContractStatusEnum.CREATE.getCode());
                    break;
                }
                case INTERRUPT: {
                    purchaseContractOverPayload.setOverStatus(PurchaseContractStatusEnum.CREATE.getCode());
                    purchaseContractOverPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    this.purchaseContractManagerDAO.updateStatusByKeys(Collections.singletonList(purchaseContractId), PurchaseContractStatusEnum.ACTIVE.getCode());
                    break;
                }
                case INVALID: {
                    purchaseContractOverPayload.setDeleteFlag(Integer.valueOf(1));
                    purchaseContractOverPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    this.purchaseContractManagerDAO.updateStatusByKeys(Collections.singletonList(purchaseContractId), PurchaseContractStatusEnum.ACTIVE.getCode());
                    break;
                }
                case REJECTED: {
                    purchaseContractOverPayload.setOverStatus(PurchaseContractStatusEnum.CREATE.getCode());
                    purchaseContractOverPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    purchaseContractOverPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    purchaseContractOverPayload.setApprovedTime(LocalDateTime.now());
                    purchaseContractOverPayload.setOverStatus(PurchaseContractStatusEnum.NOT_ACTIVE.getCode());
                    this.purchaseContractManagerDAO.updateStatusByKeys(Collections.singletonList(purchaseContractId), PurchaseContractStatusEnum.BREAK.getCode());
                    break;
                }
                case APPROVING: {
                    purchaseContractOverPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    purchaseContractOverPayload.setOverStatus(PurchaseContractStatusEnum.APPROVING.getCode());
                    this.purchaseContractManagerDAO.updateStatusByKeys(Collections.singletonList(purchaseContractId), PurchaseContractStatusEnum.APPROVING.getCode());
                }
            }
            this.service.updateByKeyDynamic(purchaseContractOverPayload);
        }
        return WorkflowResult.success(null);
    }

    public PurchaseContractOverCallBackController(TPurchaseContractOverService service, PurchaseContractManagerDAO purchaseContractManagerDAO) {
        this.service = service;
        this.purchaseContractManagerDAO = purchaseContractManagerDAO;
    }
}

