/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.salecon.payload.SaleConExecConditionPayload;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConExecConditionService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConExecConditionVO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/SALE_CON_BUDGET/callBack"})
@Transactional
public class SaleConBudgetWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(SaleConBudgetWorkflowCallBackController.class);
    private final SaleConExecConditionService saleConExecConditionService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        String taskKey = payload.getTaskKey();
        String businessKey = payload.getBusinessKey();
        SaleConExecConditionPayload saleConExecConditionPayload = new SaleConExecConditionPayload();
        saleConExecConditionPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        if ("Activity_030x3nk".equals(taskKey)) {
            SaleConExecConditionVO saleConExecConditionVO = this.saleConExecConditionService.queryByKey(Long.valueOf(Long.parseLong(businessKey)));
            saleConExecConditionPayload.setWorkAgentFlag(Boolean.valueOf(true));
            this.saleConExecConditionService.updateByKeyDynamic(saleConExecConditionPayload);
        }
        if ("Activity_1klbasn".equals(taskKey)) {
            saleConExecConditionPayload.setWorkAgentFlag(Boolean.valueOf(false));
            this.saleConExecConditionService.updateByKeyDynamic(saleConExecConditionPayload);
        }
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        SaleConExecConditionPayload saleConExecConditionPayload = new SaleConExecConditionPayload();
        saleConExecConditionPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        SaleConExecConditionVO saleConExecConditionVO = this.saleConExecConditionService.queryByKey(Long.valueOf(businessKey));
        if (saleConExecConditionVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    saleConExecConditionPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    saleConExecConditionPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case INVALID: {
                    saleConExecConditionPayload.setDeleteFlag(Integer.valueOf(1));
                    saleConExecConditionPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    saleConExecConditionPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    saleConExecConditionPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    saleConExecConditionPayload.setApprovedTime(LocalDateTime.now());
                    break;
                }
                case APPROVING: {
                    saleConExecConditionPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                }
            }
            this.saleConExecConditionService.updateByKeyDynamic(saleConExecConditionPayload);
        }
        return WorkflowResult.success(null);
    }

    public SaleConBudgetWorkflowCallBackController(SaleConExecConditionService saleConExecConditionService) {
        this.saleConExecConditionService = saleConExecConditionService;
    }
}

