/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.provider.event.support;

import com.elitesland.tw.tw5.server.provider.event.BaseEvent;
import com.elitesland.tw.tw5.server.provider.event.BaseEventHandler;
import com.elitesland.tw.tw5.server.provider.event.support.EventProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationListener;
import org.springframework.util.StopWatch;

public class EventListener<E extends BaseEvent>
implements ApplicationListener<E> {
    private static final Logger log = LogManager.getLogger(EventListener.class);
    private final ObjectMapper objectMapper;
    private final EventProperties eventProperties;
    private final Map<Class<E>, List<BaseEventHandler<E>>> handlerMap = new HashMap<Class<E>, List<BaseEventHandler<E>>>();

    public EventListener(ObjectProvider<BaseEventHandler<?>> eventHandlers, EventProperties eventProperties, ObjectMapper objectMapper) {
        this.eventProperties = eventProperties;
        this.objectMapper = objectMapper;
        this.init(eventHandlers);
    }

    public void onApplicationEvent(E event) {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> event.getEvent();
        supplierArray[1] = () -> {
            try {
                return this.objectMapper.writeValueAsString((Object)event);
            }
            catch (JsonProcessingException e) {
                log.error("\u5e8f\u5217\u5316\u4e8b\u4ef6\u3010" + event.getEvent() + "\u3011\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
                return "";
            }
        };
        log.info("\u53d1\u751f\u4e8b\u4ef6\uff1a{}\uff0c\u4e8b\u4ef6\u8be6\u7ec6\u5185\u5bb9\uff1a{}", supplierArray);
        if (!Boolean.TRUE.equals(this.eventProperties.getEnabled())) {
            log.warn("\u672a\u542f\u7528\u4e8b\u4ef6\u5904\u7406\uff01");
            return;
        }
        StopWatch watch = new StopWatch();
        watch.start();
        this.handleEvent(event);
        watch.stop();
        log.info("\u4e8b\u4ef6{}\u5904\u7406\u5b8c\u6bd5\uff0c\u7528\u65f6{}s\uff01", (Object)((BaseEvent)((Object)event)).getEvent(), (Object)(watch.getTotalTimeMillis() / 1000L));
    }

    private void init(ObjectProvider<BaseEventHandler<?>> eventHandlers) {
        eventHandlers.orderedStream().forEach(e -> {
            Class<E> eventType = this.obtainParameterizedType((BaseEventHandler<?>)e);
            this.handlerMap.computeIfAbsent(eventType, t -> new ArrayList()).add(e);
        });
    }

    private Class<E> obtainParameterizedType(BaseEventHandler<?> handler) {
        Type[] interfaces = handler.getClass().getGenericInterfaces();
        if (interfaces.length > 0) {
            for (Type inter : interfaces) {
                ParameterizedType t;
                Type[] typeArguments;
                if (!(inter instanceof ParameterizedType) || (typeArguments = (t = (ParameterizedType)inter).getActualTypeArguments()).length <= 0) continue;
                for (Type typeArgument : typeArguments) {
                    if (!BaseEvent.class.isAssignableFrom((Class)typeArgument)) continue;
                    return (Class)typeArgument;
                }
            }
        }
        throw new IllegalStateException(handler.getClass().getName() + "\u7f3a\u5c11\u5fc5\u8981\u7684\u6cdb\u578b\u53c2\u6570");
    }

    private void handleEvent(E event) {
        List handlers = this.handlerMap.getOrDefault(event.getClass(), Collections.emptyList());
        if (handlers.isEmpty()) {
            log.warn("\u672a\u53d1\u73b0\u4e8b\u4ef6{}\u7684\u6709\u6548\u5904\u7406\u5668\uff01", (Object)((BaseEvent)((Object)event)).getEvent());
            return;
        }
        for (BaseEventHandler handler : handlers) {
            handler.handle(event);
        }
    }
}

