/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.yeedoc.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.yeedoc.service.FileUtilService;
import com.elitesland.tw.tw5.server.yeedoc.service.YeedocService;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class FileUtilServiceImpl
implements FileUtilService {
    private static final Logger log = LoggerFactory.getLogger(FileUtilServiceImpl.class);
    private final YeedocService yeedocService;

    @Override
    public String createYdkFolder(String libraryId, String itemId, List<String> pathArry, String authTokenByYdk) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.hasText((String)itemId)) {
            map.put("ItemId", itemId);
        }
        map.put("PathArry", pathArry);
        map.put("LibraryId", libraryId);
        log.info("[\u521b\u5efa\u6587\u4ef6\u5939-\u6613\u9053\u58f3\u5f00\u59cb]-map:{}", (Object)JSONObject.toJSONString(map));
        log.info("[\u521b\u5efa\u6587\u4ef6\u5939-\u6613\u9053\u58f3\u5f00\u59cb]-authToken:{}", (Object)authTokenByYdk);
        String resultStr = this.yeedocService.createFolder(map, authTokenByYdk);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)resultStr)) {
            log.info("[\u521b\u5efa\u6587\u4ef6\u5939-\u6613\u9053\u58f3]-map:{}", (Object)JSONObject.toJSONString(map));
            log.info("[\u521b\u5efa\u6587\u4ef6\u5939-\u6613\u9053\u58f3]-resultStr:{}", (Object)resultStr);
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25!result = {" + resultStr + "}");
        }
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        log.info("[\u521b\u5efa\u6587\u4ef6\u5939-\u6613\u9053\u58f3\u8fd4\u56de\u503c]-resultJson:{}", (Object)resultJson);
        Object data = resultJson.get((Object)"Data");
        if (ObjectUtils.isEmpty((Object)data)) {
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25!result = {" + resultJson + "}");
        }
        JSONArray dataArray = JSONArray.parseArray((String)data.toString());
        String folderId = (String)JSONObject.parseObject((String)String.valueOf(dataArray.get(0))).get((Object)"FolderId");
        if (!StringUtils.hasText((String)folderId)) {
            throw TwException.error("", "\u521b\u5efa\u6587\u4ef6\u5939\u8fd4\u56de\u503cfolderId\u4e3a\u7a7a!");
        }
        return folderId;
    }

    @Override
    public String reNameFolder(String itemId, String folderName, String authTokenByYdk) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ItemId", itemId);
        map.put("NewName", folderName);
        log.info("[\u6587\u4ef6\u5939\u91cd\u547d\u540d-\u6613\u9053\u58f3\u5f00\u59cb]-map:{}", (Object)JSONObject.toJSONString(map));
        log.info("[\u6587\u4ef6\u5939\u91cd\u547d\u540d-\u6613\u9053\u58f3\u5f00\u59cb]-authToken:{}", (Object)authTokenByYdk);
        String resultStr = this.yeedocService.reNameFolder(map, authTokenByYdk);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)resultStr)) {
            log.info("[\u6587\u4ef6\u5939\u91cd\u547d\u540d-\u6613\u9053\u58f3]-resultStr:{}", (Object)resultStr);
            throw TwException.error("", "\u6587\u4ef6\u5939\u91cd\u547d\u540d\u5931\u8d25!result = {" + resultStr + "}");
        }
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        log.info("[\u6587\u4ef6\u5939\u91cd\u547d\u540d-\u6613\u9053\u58f3\u8fd4\u56de\u503c]-resultJson:{}", (Object)resultJson);
        if (ObjectUtils.isEmpty((Object)resultJson)) {
            throw TwException.error("", "\u6587\u4ef6\u5939\u91cd\u547d\u540d\u5931\u8d25!result = {" + resultJson + "}");
        }
        JSONObject date = resultJson.getJSONObject("Data");
        if (ObjectUtils.isEmpty((Object)date)) {
            throw TwException.error("", "\u6587\u4ef6\u5939\u91cd\u547d\u540d\u5931\u8d25!result = {" + resultJson + "}");
        }
        String folderId = date.getString("Id");
        if (!StringUtils.hasText((String)folderId)) {
            throw TwException.error("", "\u6587\u4ef6\u5939\u91cd\u547d\u540d\u8fd4\u56de\u503cfolderId\u4e3a\u7a7a!");
        }
        return folderId;
    }

    @Override
    public Map<String, String> saveYdkFile(String libraryId, String ydkFolderId, Set<String> cacheKeys, String authTokenByYdk) {
        JSONObject itemIdResultJson;
        Object itemIdData;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(cacheKeys)) {
            return null;
        }
        map.put("FolderId", ydkFolderId);
        map.put("LibraryId", libraryId);
        map.put("CacheKey", cacheKeys);
        map.put("ItemList", Lists.newArrayList());
        map.put("AssociatedItemID", Lists.newArrayList());
        map.put("Description", "");
        log.info("[\u6700\u7ec8\u4fdd\u5b58\u9644\u4ef6-\u6613\u9053\u58f3\u5f00\u59cb]-map:{}", (Object)JSONObject.toJSONString(map));
        log.info("[\u6700\u7ec8\u4fdd\u5b58\u9644\u4ef6-\u6613\u9053\u58f3\u5f00\u59cb]-authToken:{}", (Object)authTokenByYdk);
        String resultStr = this.yeedocService.newUploadFilesSave(map, authTokenByYdk);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)resultStr)) {
            log.info("[\u6700\u7ec8\u4fdd\u5b58\u9644\u4ef6-\u6613\u9053\u58f3]-resultStr:{}", (Object)resultStr);
            throw TwException.error("", "\u6700\u7ec8\u4fdd\u5b58\u9644\u4ef6\u5931\u8d25!result = {" + resultStr + "}");
        }
        JSONObject resultJson = JSONObject.parseObject((String)resultStr);
        log.info("[\u6700\u7ec8\u4fdd\u5b58\u9644\u4ef6-\u6613\u9053\u58f3\u8fd4\u56de\u503c]-resultJson:{}", (Object)resultJson);
        Boolean isSuccess = resultJson.getBoolean("IsSuccess");
        String message = resultJson.getString("Message");
        if (!isSuccess.booleanValue() || !"\u4e0a\u4f20\u6210\u529f\uff01".equals(message)) {
            throw TwException.error("", "\u6700\u7ec8\u4fdd\u5b58\u9644\u4ef6\u5931\u8d25!result = {" + resultJson + "}");
        }
        HashMap<String, Object> getItemMap = new HashMap<String, Object>();
        getItemMap.put("CacheKeys", cacheKeys);
        log.info("[\u83b7\u53d6\u6613\u9053\u58f3\u9644\u4ef6id-\u6613\u9053\u58f3\u5f00\u59cb]-map:{}", (Object)JSONObject.toJSONString(getItemMap));
        log.info("[\u83b7\u53d6\u6613\u9053\u58f3\u9644\u4ef6id-\u6613\u9053\u58f3\u5f00\u59cb]-authTokenByYdk:{}", (Object)authTokenByYdk);
        String itemIdResult = this.yeedocService.getCaCheKeyItemId(getItemMap, authTokenByYdk);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)itemIdResult)) {
            log.info("[\u83b7\u53d6\u6613\u9053\u58f3\u9644\u4ef6id-\u6613\u9053\u58f3]-resultStr:{}", (Object)itemIdResult);
        }
        if (ObjectUtils.isEmpty((Object)(itemIdData = (itemIdResultJson = JSONObject.parseObject((String)itemIdResult)).get((Object)"Data")))) {
            throw TwException.error("", "\u83b7\u53d6\u6613\u9053\u58f3\u9644\u4ef6id\u5931\u8d25!result = {" + resultJson + "}");
        }
        List itemIdJsonObjectList = JSONArray.parseArray((String)itemIdData.toString()).toJavaList(JSONObject.class);
        Map<String, String> resultMap = itemIdJsonObjectList.stream().filter(Objects::nonNull).collect(Collectors.toMap(item -> item.getString("CacheKey"), item -> item.getString("ItemId")));
        return resultMap;
    }

    public FileUtilServiceImpl(YeedocService yeedocService) {
        this.yeedocService = yeedocService;
    }
}

