package com.elitesland.tw.tw5.server.common.QyWx.service;

import com.alibaba.cloud.commons.io.IOUtils;
import com.alibaba.fastjson.JSON;
import com.elitesland.tw.tw5.api.prd.schedule.payload.*;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdCalendarService;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdScheduleService;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdCalendarVO;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdScheduleVO;
import com.elitesland.tw.tw5.server.common.BeanMapTool;
import com.elitesland.tw.tw5.server.common.QyWx.QyWxUtil.CallBackEventEnum;
import com.elitesland.tw.tw5.server.common.QyWx.QyWxUtil.WXBizMsgCrypt;
import com.elitesland.tw.tw5.server.common.BeanConverterUtils;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.schedule.dao.PrdCalendarDAO;
import com.elitesland.tw.tw5.server.prd.schedule.dao.PrdScheduleDAO;
import lombok.RequiredArgsConstructor;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.*;

/**
 * @author zoey
 * @Description: 封装企业微信回调请求
 * @date 2022/5/7 - 15:47
 */
@Component
@RequiredArgsConstructor
public class WXPushService {
    private static final String sToken = "wIzBCTPJ";//计算签名()
    private static final String sEncodingAESKey = "IFxAxLOaqxfbYXW1U78KJy7x4pjfG4Fd5UKvjAdL1cx";//内容加密
    private static final String sCorpID = "wx7760085f07e6ac57";//企业id

    private final PrdCalendarService calendarService;
    private final PrdScheduleService scheduleService;
    private final PrdCalendarDAO calendarDAO;
    private final PrdScheduleDAO scheduleDAO;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final QyWxCommunicationService communicationService;

    public String autograph(String msgSignature,String timestamp,String nonce,String echostr){
        String sEchoStr; //需要返回的明文
        try {
            WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(sToken, sEncodingAESKey, sCorpID);
            sEchoStr = wxcpt.VerifyURL(msgSignature, timestamp,
                    nonce, echostr);
            System.out.println("verifyurl echostr: " + sEchoStr);
            // 验证URL成功，将sEchoStr返回
            return sEchoStr;
//            HttpUtils.SetResponse(sEchoStr);
        } catch (Exception e) {
            //验证URL失败，错误原因请查看异常
            e.printStackTrace();
        }
        return null;
    }


    public Map<String, String> decrypt(String msgSignature, String timestamp, String nonce, HttpServletRequest request){
        try {
            InputStream inputStream = request.getInputStream();
            String sReqData = IOUtils.toString(inputStream, Charset.forName("UTF-8"));
            WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(sToken, sEncodingAESKey, sCorpID);
            String sMsg = wxcpt.DecryptMsg(msgSignature, timestamp, nonce, sReqData);
            System.out.println("after decrypt msg: " + sMsg);

            Map<String, String> stringStringMap = parseXml(sMsg);
            return stringStringMap;
        }catch (Exception e){
            // TODO
            // 解密失败，失败原因请查看异常
            e.printStackTrace();
        }
        return null;
    }


    /**
     * //        <xml>
     * //            <ToUserName><![CDATA[mycreate]]></ToUserName>
     * //            <FromUserName><![CDATA[wx5823bf96d3bd56c7]]></FromUserName>
     * //            <CreateTime>1348831860</CreateTime>
     * //            <MsgType><![CDATA[text]]></MsgType>
     * //            <Content><![CDATA[this is a test]]></Content>
     * //            <MsgId>1234567890123456</MsgId>
     * //            <AgentID>128</AgentID>
     * //		</xml>
     * 组装xml并加密
     * @param timestamp
     * @param nonce
     * @param data
     * @param fromUserName
     * @param toUserName
     * @return
     */
    public String encrypt(String timestamp,String nonce,String data,String fromUserName,String toUserName) {
        //xml编辑
        String sRespData="<xml><ToUserName><![CDATA[" + toUserName + "]]></ToUserName>" +
                "<Content><![CDATA[" + data + "]]></Content>" +
                "<AgentID><![CDATA[" + 1000030 + "]]></AgentID>" +
                "<FromUserName><![CDATA["+fromUserName+"]]></FromUserName>" +
                "<FromUserName><![CDATA["+toUserName+"]]></FromUserName>" +
                "<CreateTime>"+timestamp+"</CreateTime>"+
                "<MsgType><![CDATA[text]]></MsgType>"+
                "</xml>";
        try {
            WXBizMsgCrypt wxcpt = new WXBizMsgCrypt(sToken, sEncodingAESKey, sCorpID);
            String sEncryptMsg = wxcpt.EncryptMsg(sRespData, timestamp, nonce);
            return sEncryptMsg;
        } catch (Exception e) {
            e.printStackTrace();
            // 加密失败
        }
        return null;
    }

    /**
     * 解析微信发来的请求（XML）.
     *
     * @param msg 消息
     * @return map
     */
    @SuppressWarnings("unchecked")
    public static Map<String, String> parseXml(final String msg) {
        // 将解析结果存储在HashMap中
        Map<String, String> map = new HashMap<String, String>();

        // 从request中取得输入流
        try (InputStream inputStream = new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8.name()))) {
            // 读取输入流
            SAXReader reader = new SAXReader();
            Document document = reader.read(inputStream);
            // 得到xml根元素
            Element root = document.getRootElement();
            // 得到根元素的所有子节点
            List<Element> elementList = root.elements();

            // 遍历所有子节点
            for (Element e : elementList) {
                map.put(e.getName(), e.getText());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }




    @Transactional
    public String doCallBack(Map<String, String> content,String timestamp,String nonce) {
        if(content!=null){
            String fromUserName = employeeDAO.queryByWeComeId(content.get("FromUserName")).getEmployeeName();
            CallBackEventEnum event = CallBackEventEnum.valueOf(content.get("Event").toUpperCase());
//            String instance = "";
            switch (event){
                case MODIFY_CALENDAR:
                    //查询企业微信端的结果
                    Map<String,Object> calendar= communicationService.getCalendar(content.get("CalId"));
                    //maptobean
                    QyWxCalendarPayload qyWxCalendarPayload = BeanMapTool.mapToBean(QyWxCalendarPayload.class, calendar);
                    PrdCalendarPayload prdCalendarPayload = calendarService.transferToPrdPayload(qyWxCalendarPayload);
                    PrdCalendarVO calendarVo = calendarDAO.queryByQyWxCalId(content.get("CalId"));
                    prdCalendarPayload.setDefaultFlag(calendarVo.getDefaultFlag());
                    prdCalendarPayload.setId(calendarVo.getId());
                    prdCalendarPayload.setFromQyWx(true);
                    calendarService.insertOrUpdate(prdCalendarPayload);
                    break;
                case DELETE_CALENDAR:
                    calendarVo = calendarDAO.queryByQyWxCalId(content.get("CalId"));
//                    instance = calendarVo.getTitle();
                    Long id = calendarVo.getId();
                    calendarService.deleteSoft(Collections.singletonList(id));
                    break;
                case ADD_SCHEDULE:
                case MODIFY_SCHEDULE:
                    //TODO: 待优化
                    //查询企业微信结果
                    Map<String,Object> schedule= communicationService.getSchedule(content.get("ScheduleId"));
                    QyWxSchedulePayload qyWxSchedulePayload = new QyWxSchedulePayload();
                    QyWxScheduleRepeatPayload repeatPayload = new QyWxScheduleRepeatPayload();
//                    QyWxScheduleAttendeesPayload attendeesPayload = new QyWxScheduleAttendeesPayload();
//                    List<Map<String,Object>> excludeTimeList = new ArrayList<>();
                    try {
                        Map reminders = (Map) JSON.parse(String.valueOf(schedule.get("reminders")));
                        List<Map<String,Object>> excludeListMapList = (List<Map<String,Object>>)reminders.get("exclude_time_list");
                        reminders.put("exclude_time_list",excludeListMapList);
                        BeanConverterUtils.map2Bean(reminders,repeatPayload);
                        List<Map<String, Object>> attendees = (List<Map<String, Object>>) schedule.get("attendees");
                        schedule.put("attendees",attendees);
                        schedule.put("reminders",repeatPayload);
                        BeanConverterUtils.map2Bean(schedule,qyWxSchedulePayload);
                    }catch (Exception e){
                        e.printStackTrace();
                    }
                    PrdSchedulePayload prdSchedulePayload = scheduleService.transferToPrdPayload(qyWxSchedulePayload);
                    calendarVo = calendarDAO.queryByQyWxCalId(content.get("CalId"));
                    PrdScheduleVO scheduleVo = scheduleDAO.queryByQyWxScheduleId(content.get("ScheduleId"));
                    prdSchedulePayload.setCalId(calendarVo.getId());
                    if(scheduleVo!=null){
                        prdSchedulePayload.setId(scheduleVo.getId());
                    }
                    prdSchedulePayload.setFromQyWx(true);
                    scheduleService.insertOrUpdate(prdSchedulePayload);
                    break;
                case DELETE_SCHEDULE:
                    scheduleVo = scheduleDAO.queryByQyWxScheduleId(content.get("ScheduleId"));
                    if(scheduleVo!=null){
                        Long scheduleVoId = scheduleVo.getId();
                        scheduleService.deleteSoft(Collections.singletonList(scheduleVoId));
                    }
                    break;
                    //TODO:有其他回调接着后面写
                default:
                    return null;
            }
            return null;
//            String resultMeg = fromUserName.concat(event.getAction()).concat("了").concat(event.getObject()).concat(instance);
//            //数据加密
//            String encrypt = encrypt(timestamp,nonce,resultMeg,content.get("FromUserName"),content.get("toUserName"));
//            return encrypt;
        }
        return null;
    }



}
