package com.elitesland.tw.tw5.server.common.crontask.payload;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author eason.shi
 * @since 2018/11/15
 */
@Data
public class TwContractRecvplanEntity implements Serializable {

    private Long id;

    /**
     * 合同ID
     */
    private Long contractId;

    private String contractName;

    /**
     * 行号
     */
    private String lineNo;

    /**
     * 收款阶段描述
     */
    private String phaseDesc;

    /**
     * 收款号
     */
    private String recvNo;

    /**
     * 收款状态
     */
    private String recvStatus;
    /**
     * 当期收款比例
     */
    private BigDecimal recvRatio;

    /**
     * 当期收款金额
     */
    private BigDecimal recvAmt;

    /**
     * 预计收款日期
     */
    private LocalDate expectRecvDate;

    /**
     * 已开票金额
     */
    private BigDecimal invAmt;

    /**
     * 预计开票日期
     */
    private LocalDate expectInvDate;

    /**
     * 开票日期
     */
    private LocalDate invDate;

    /**
     * 已收款金额
     */
    private BigDecimal actualRecvAmt;

    /**
     * 实际收款日期
     */
    private LocalDate actualRecvDate;

    /**
     * 已确认金额
     */
    private BigDecimal confirmedAmt;

    /**
     * 计划状态
     */
    private String planStatus;

    /**
     * 开票批次ID
     */
    private Long invbatchId;

    /**
     * 备注
     */
    private String remark;

    private LocalDate antiRecvDate;//预计到账日期

    /**
     * 客户请款单号
     */
    private String relApplyNo;

    /**
     * 收款计划ID v5版本
     */
    private Long recvplanIdV5;

    /**
     * 收款计划ID v4版本
     */
    private Long recvplanIdV4;

    /**
     * 删除标志
     */
    private Long delFlag;

    /**
     * 创建人
     */
    private Long createUserId;

    /**
     * 创建人
     */
    private Long modifyUserId;


    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private LocalDateTime modifyTime;
}
