package com.elitesland.tw.tw5.server.common.funConfig.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 易稻壳yeedoc通用文档类型配置与业务关系表
 *
 * @author duwh
 * @date 2023-12-08
 */
@Entity
@Table(name = "prd_business_doc_type_ref", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_business_doc_type_ref", comment = "易稻壳yeedoc通用文档类型配置与业务关系表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessDocTypeRefDO extends BaseModel implements Serializable  {
    /** libraryId -yeedoc返回 */
    @Comment("libraryId -yeedoc返回")
    @Column()
    private String libraryId;
    /** 文件夹id -yeedoc返回 */
    @Comment("文件夹id -yeedoc返回")
    @Column()
    private String folderId;
    /** 文件夹名称 LeafName -yeedoc返回 */
    @Comment("文件夹名称 LeafName -yeedoc返回")
    @Column(length = 500)
    private String folderName;
    /** 单据主键 */
    @Comment("单据主键")
    @Column()
    private Long docId;
    /** 单据类型 */
    @Comment("单据类型")
    @Column()
    private String docType;
    /** 文档类型配置主键 prd_business_doc_type_config.id */
    @Comment("文档类型配置主键 prd_business_doc_type_config.id")
    @Column()
    private Long configId;
    /** 文档类型名称（冗余）prd_business_doc_type_config.name */
    @Comment("文档类型名称（冗余）prd_business_doc_type_config.name")
    @Column()
    private String configName;
    /** prd_business_doc_type_config_rule.id */
    @Comment("prd_business_doc_type_config_rule.id")
    @Column()
    private Long configRuleId;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;

    public void copy(BusinessDocTypeRefDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
