
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpenseaPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpenseaQuery;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdTemporaryStoragePayload;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpenseaAdminDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpenseaDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpenseaMembersDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpenseaRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmPotentialCustomerRepo;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/20 - 9:17
 */
@Repository
@RequiredArgsConstructor
public class CrmOpenseaDAO {
    private final CrmOpenseaRepo repo;
    private final CrmPotentialCustomerRepo potentialCustomerRepo;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmOpenseaDO save(CrmOpenseaDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<CrmOpenseaDO> saveAll(List<CrmOpenseaDO> dos) {
        return repo.saveAll(dos);
    }





    public Specification<CrmOpenseaDO> getSpec(CrmOpenseaQuery query) {
        Specification<CrmOpenseaDO> querySpecifi = (root, criteriaQuery, cb) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (!StringUtils.isEmpty(query.getOpenseaName())) {
                predicates.add(cb.like(root.get("openseaName").as(String.class), SqlUtil.toSqlLikeString(query.getOpenseaName())));
            }
            Join<CrmOpenseaDO, CrmOpenseaAdminDO> adminJoin = root.join("openseaAdmins", JoinType.LEFT);
            if (!ObjectUtils.isEmpty(query.getOpenseaAdminId())) {
                predicates.add(cb.equal(adminJoin.get("userId").as(Long.class), query.getOpenseaAdminId()));
            }
            Join<CrmOpenseaDO, CrmOpenseaMembersDO> memberJoin = root.join("openseaMembers", JoinType.LEFT);
            if (!ObjectUtils.isEmpty(query.getOpenseaMemberId())){
                predicates.add(cb.equal(memberJoin.get("userId").as(Long.class),query.getOpenseaMemberId()));
            }
            criteriaQuery.distinct(true);
            return cb.and(predicates.toArray(new Predicate[predicates.size()]));
        };

        return querySpecifi;
    }

    public List<CrmOpenseaDO> findAll(Specification<CrmOpenseaDO> spec) {
        return repo.findAll(spec);
    }

    public Page<CrmOpenseaDO> findAll(Specification<CrmOpenseaDO> spec, Pageable pageable) {
        pageable= PageUtil.defaultSort(pageable);
        return repo.findAll(spec, pageable);
    }

    public CrmOpenseaDO queryById(Long id) {
        return repo.findById(id).orElse(null);
    }
    public CrmOpenseaDO queryByName(String openseaName) {
        return repo.findDistinctByOpenseaName(openseaName).orElse(null);
    }

    public void updateByKeyDynamic(CrmOpenseaPayload payload) {
        //查询出当前的do
        CrmOpenseaDO OpenseaDO = repo.findById(payload.getId()).orElse(null);
        if(OpenseaDO!=null){
            if (payload.getOpenseaName() != null) {
                OpenseaDO.setOpenseaName(payload.getOpenseaName());
            }
            if (payload.getCustomerNum() != null){
                OpenseaDO.setCustomerNum(payload.getCustomerNum());
            }
            if(payload.getDeleteFlag()!=null){
                OpenseaDO.setDeleteFlag(payload.getDeleteFlag());
            }
            repo.save(OpenseaDO);
        }
    }


    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public void deleteSoft(List<Long> keys) {
        for (Long key : keys) {
            CrmOpenseaPayload payload = new CrmOpenseaPayload();
            payload.setId(key);
            payload.setDeleteFlag(1);
            updateByKeyDynamic(payload);
        }
    }

    /**
     * 潜在客户数量
     * @param openseaId
     * @return
     */
    public Integer countPotentialCustomers(Long openseaId) {
        return potentialCustomerRepo.countByOpensea_Id(openseaId);
    }

}