package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Author carl.wang
 * @Description 市场活动表
 * @Date
 **/
@Entity
@Table(name = "crm_act_activity", indexes = {
        @Index(name = "project_index", columnList = "project_id"),
        @Index(name = "plan_index", columnList = "plan_id"),
        @Index(name = "detail_index", columnList = "detail_id")
})
@org.hibernate.annotations.Table(appliesTo = "crm_act_activity", comment = "市场活动表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmActActivityDO extends BaseModel {

    @Comment("项目id")
    @Column(name = "project_id", nullable = false)
    private Long projectId;

    @Comment("计划id")
    @Column(name = "plan_id", nullable = false)
    private Long planId;

    @Comment("计划明细id")
    @Column(name = "detail_id", nullable = false)
    private Long detailId;

    @Comment("活动规模")
    @Column()
    private String activityScale;

    @Comment("活动地址")
    @Column()
    private String activityAddr;

    @Comment("活动目标")
    @Column()
    private String activityTarget;

    @Comment("人力总人天")
    @Column()
    private Integer personNum;

    @Comment("人力费用")
    @Column()
    private BigDecimal personMoney;

    @Comment("人力资源")
    @Column()
    private String personSource;

    @Comment("报销费用")
    @Column()
    private BigDecimal claimMoney;

    @Comment("采购费用")
    @Column()
    private BigDecimal purchaseMoney;

    @Comment("杂项费用")
    @Column()
    private BigDecimal sundryMoney;

    @Comment("费用预算（除去人力费用）")
    @Column()
    private BigDecimal budgetMoney;

    @Comment("预算总额")
    @Column()
    private BigDecimal totalMoney;

    @Comment("潜在客户")
    @Column()
    private Integer potentialCustomer;

    @Comment("线索")
    @Column()
    private Integer leadNum;

    @Comment("商机")
    @Column()
    private Integer busOps;

    @Comment("产出预估总数")
    @Column()
    private BigDecimal pipeline;

    @Comment("流程定义的KEY")
    @Column()
    private String procDefKey;

    @Comment("流程实例ID")
    @Column()
    private String procInstId;

    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;

    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;

    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    /**
     * 是否发布了公告，未发布：0，不发布：1，已发布：2
     */
    @Comment("是否发布了公告")
    @Column()
    private Integer isRelease;

    /**
     * 是否发布了公告，未：0，已：1
     */
    @Comment("是否发送了逾期提醒")
    @Column()
    private Integer isEmailRemind = 0;

    @Comment("日程id")
    @Column()
    private Long scheduleId;
}
