package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;

/**
 * @author zoey
 * @Description:线索成员表
 * @date 2022/5/17 - 11:41
 */
@Entity
@Table(name = "crm_leads_members",
        indexes = {@Index(name = "user_index", columnList = "user_id"),
                @Index(name = "leads_index", columnList = "leadsId"),}
)
@org.hibernate.annotations.Table(appliesTo = "crm_leads_members", comment = "线索成员表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
//@NamedEntityGraphs({
//        @NamedEntityGraph(name = "leads.members", attributeNodes = {
//                @NamedAttributeNode(value = "leads")
//        }),
//})
public class CrmLeadsMembersDO extends BaseModel {

    @Comment("成员id")
    @Column(name = "user_id", nullable = false)
    private Long userId;

    @ManyToOne(fetch = FetchType.LAZY, cascade = CascadeType.REFRESH)
    @JoinColumn(name = "leadsId", referencedColumnName = "id", foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    private CrmLeadsDO leads;

}
