package com.elitesland.tw.tw5.server.prd.humanresources.ability.dao;

import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdAbilityLevelQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdAbilityLevelVO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.PrdAbilityLevelDO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.QPrdAbilityLevelDO;

import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-10-19
 * @desc : 能力级别定义RepoProc
 */

@Component
public class PrdAbilityLevelDao extends BaseRepoProc<PrdAbilityLevelDO> {

    private static final QPrdAbilityLevelDO qPrdAbilityLevelDO = QPrdAbilityLevelDO.prdAbilityLevelDO;


    protected PrdAbilityLevelDao() {

        super(qPrdAbilityLevelDO);

    }


    public PagingVO<PrdAbilityLevelVO> page(PrdAbilityLevelQuery prdAbilityLevelQuery) {

        JPAQuery<PrdAbilityLevelVO> query =
                select(PrdAbilityLevelVO.class)
                        .where(bulidPredicate(prdAbilityLevelQuery));
        prdAbilityLevelQuery.setPaging(query);
        prdAbilityLevelQuery.fillOrders(query, qPrdAbilityLevelDO);
        return PagingVO.<PrdAbilityLevelVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdAbilityLevelDO)
                .set(qPrdAbilityLevelDO.deleteFlag, 1)
                .where(qPrdAbilityLevelDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdAbilityLevelVO get(Long id) {

        PrdAbilityLevelVO prdAbilityLevelVO = select(PrdAbilityLevelVO.class)
                .where(qPrdAbilityLevelDO.id.eq(id))
                .fetchOne();

        return prdAbilityLevelVO;

    }


    public List<PrdAbilityLevelVO> getList(PrdAbilityLevelQuery prdAbilityLevelQuery) {

        List<PrdAbilityLevelVO> res =
                select(PrdAbilityLevelVO.class)
                        .where(bulidPredicate(prdAbilityLevelQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdAbilityLevelDO.abilityId,
                        qPrdAbilityLevelDO.levelDtlId,
                        qPrdAbilityLevelDO.levelDtlName,
                        qPrdAbilityLevelDO.type,
                        qPrdAbilityLevelDO.obtainType,
                        qPrdAbilityLevelDO.dlRatio,
                        qPrdAbilityLevelDO.abilityDesc,
                        qPrdAbilityLevelDO.auditorType,
                        qPrdAbilityLevelDO.auditorId,
                        qPrdAbilityLevelDO.auditorName,
                        qPrdAbilityLevelDO.id,
                        qPrdAbilityLevelDO.createTime,
                        qPrdAbilityLevelDO.remark

                )).from(qPrdAbilityLevelDO);

    }


    private Predicate bulidPredicate(PrdAbilityLevelQuery prdAbilityLevelQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != prdAbilityLevelQuery.getAbilityId(), qPrdAbilityLevelDO.abilityId, prdAbilityLevelQuery.getAbilityId())
                .andEq(null != prdAbilityLevelQuery.getLevelDtlId(), qPrdAbilityLevelDO.levelDtlId, prdAbilityLevelQuery.getLevelDtlId())
                .andEq(StringUtils.isNotBlank(prdAbilityLevelQuery.getLevelDtlName()), qPrdAbilityLevelDO.levelDtlName, prdAbilityLevelQuery.getLevelDtlName())
                .andEq(null != prdAbilityLevelQuery.getType(), qPrdAbilityLevelDO.type, prdAbilityLevelQuery.getType())
                .andEq(StringUtils.isNotBlank(prdAbilityLevelQuery.getObtainType()), qPrdAbilityLevelDO.obtainType, prdAbilityLevelQuery.getObtainType())
                .andEq(null != prdAbilityLevelQuery.getDlRatio(), qPrdAbilityLevelDO.dlRatio, prdAbilityLevelQuery.getDlRatio())
                .andEq(StringUtils.isNotBlank(prdAbilityLevelQuery.getAbilityDesc()), qPrdAbilityLevelDO.abilityDesc, prdAbilityLevelQuery.getAbilityDesc())
                .andEq(StringUtils.isNotBlank(prdAbilityLevelQuery.getAuditorType()), qPrdAbilityLevelDO.auditorType, prdAbilityLevelQuery.getAuditorType())
                .andEq(null != prdAbilityLevelQuery.getAuditorId(), qPrdAbilityLevelDO.auditorId, prdAbilityLevelQuery.getAuditorId())
                .andEq(StringUtils.isNotBlank(prdAbilityLevelQuery.getAuditorName()), qPrdAbilityLevelDO.auditorName, prdAbilityLevelQuery.getAuditorName())
                .andIn(!CollectionUtils.isEmpty(prdAbilityLevelQuery.getIds()), qPrdAbilityLevelDO.id, prdAbilityLevelQuery.getIds())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdAbilityLevelQuery prdAbilityLevelQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 能力id
        if (null != prdAbilityLevelQuery.getAbilityId()) {
            predicates.add(qPrdAbilityLevelDO.abilityId.eq(prdAbilityLevelQuery.getAbilityId()));
        }
        // 级别明细id
        if (null != prdAbilityLevelQuery.getLevelDtlId()) {
            predicates.add(qPrdAbilityLevelDO.levelDtlId.eq(prdAbilityLevelQuery.getLevelDtlId()));
        }
        // 级别明细名称
        if (StringUtils.isNotEmpty(prdAbilityLevelQuery.getLevelDtlName())) {
            predicates.add(qPrdAbilityLevelDO.levelDtlName.eq(prdAbilityLevelQuery.getLevelDtlName()));
        }
        // 类型 1单项能力2复合能力
        if (null != prdAbilityLevelQuery.getType()) {
            predicates.add(qPrdAbilityLevelDO.type.eq(prdAbilityLevelQuery.getType()));
        }
        // 获取方式
        if (StringUtils.isNotEmpty(prdAbilityLevelQuery.getObtainType())) {
            predicates.add(qPrdAbilityLevelDO.obtainType.eq(prdAbilityLevelQuery.getObtainType()));
        }
        // 当量系数
        if (null != prdAbilityLevelQuery.getDlRatio()) {
            predicates.add(qPrdAbilityLevelDO.dlRatio.eq(prdAbilityLevelQuery.getDlRatio()));
        }
        // 能力描述
        if (StringUtils.isNotEmpty(prdAbilityLevelQuery.getAbilityDesc())) {
            predicates.add(qPrdAbilityLevelDO.abilityDesc.eq(prdAbilityLevelQuery.getAbilityDesc()));
        }
        // 审核人类型
        if (StringUtils.isNotEmpty(prdAbilityLevelQuery.getAuditorType())) {
            predicates.add(qPrdAbilityLevelDO.auditorType.eq(prdAbilityLevelQuery.getAuditorType()));
        }
        // 审核人id
        if (null != prdAbilityLevelQuery.getAuditorId()) {
            predicates.add(qPrdAbilityLevelDO.auditorId.eq(prdAbilityLevelQuery.getAuditorId()));
        }
        // 审核人名称
        if (StringUtils.isNotEmpty(prdAbilityLevelQuery.getAuditorName())) {
            predicates.add(qPrdAbilityLevelDO.auditorName.eq(prdAbilityLevelQuery.getAuditorName()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long delByAbilitId(Long id) {
        long res = jpaQueryFactory.update(qPrdAbilityLevelDO)
                .set(qPrdAbilityLevelDO.deleteFlag, 1)
                .where(qPrdAbilityLevelDO.abilityId.eq(id))
                .execute();
        return res;
    }
}

