package com.elitesland.tw.tw5.server.prd.humanresources.examination.callback;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEmployeCompositeAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluatePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdInternalRecommPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdProbationExamPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEmployeCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdInternalRecommService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdProbationExamService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdProbationExamVO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;


@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "PROBATION_EXAM_LATE" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class PrdProbationExamLateCallback implements WorkflowCallBack {


    private final PrdProbationExamService prdProbationExamService;

    private final PrdEvaluateService prdEvaluateService;

    private final PrdInternalRecommService prdInternalRecommService;

    private final PrdEmployeCompositeAbilityService prdEmployeCompositeAbilityService;


    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {


        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        if (StringUtils.isBlank(businessKey)) {
            throw new BusinessException("获取的businessKey为空");
        }
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        //根据业务key查询当前业务对象
        Long id = Long.valueOf(businessKey);
        PrdProbationExamVO prdProbationExamVO = prdProbationExamService.get(id);

        PrdProbationExamPayload prdProbationExamPayload = new PrdProbationExamPayload();
        prdProbationExamPayload.setId(id);
        prdProbationExamPayload.setType(prdProbationExamVO.getType());
        if (prdProbationExamVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"激活",流程状态改为未提交
                    prdProbationExamPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）

                case INVALID://仅删除流程
                    prdProbationExamPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    //删除当前版本草稿状态的changeLog
//                    changeService.deleteCurrentVersionLog(ChangeTypeEnum.PERSONAL_INFO.getCode(), employeeId.toString());
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    prdProbationExamPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                case APPROVED:
                    prdProbationExamPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    prdProbationExamPayload.setApprovedTime(LocalDateTime.now());

                    // 修改该员工的资源能力状态为启用
                    // 根据 userId、fromId修改
                    PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload = new PrdEmployeCompositeAbilityPayload();
                    prdEmployeCompositeAbilityPayload.setUserId(prdProbationExamVO.getUserId());
                    prdEmployeCompositeAbilityPayload.setFormId(prdProbationExamVO.getId());
                    prdEmployeCompositeAbilityPayload.setState(1);
                    Boolean change = prdEmployeCompositeAbilityService.updateStateByFormId(prdEmployeCompositeAbilityPayload);

                    // 若是内推 1.奖励同步至相关推荐人的我的推荐中的转正奖励
                    if (prdProbationExamVO.getRecommendFlag() && null != prdProbationExamVO.getRecommendUserId()) {

                        PrdInternalRecommPayload prdInternalRecommPayload = new PrdInternalRecommPayload();
                        // 被推荐人
                        prdInternalRecommPayload.setRecommUserName(prdProbationExamVO.getUserName());
                        // 推荐人
                        prdInternalRecommPayload.setManagerUserId(prdProbationExamVO.getRecommendUserId());
                        // 推荐奖励
                        prdInternalRecommPayload.setFormalReward(prdProbationExamVO.getExamReward());
                        // 转正日期
                        prdInternalRecommPayload.setFormalDate(LocalDate.now());
                        // 是否转正
                        prdInternalRecommPayload.setFormalFlag(true);

                        prdInternalRecommService.updateFormalReward(prdInternalRecommPayload);
                    }
                    prdProbationExamPayload.setFinishFlag(true);
                    // 修改评价为可见状态
                    PrdEvaluatePayload prdEvaluatePayload = new PrdEvaluatePayload();
                    prdEvaluatePayload.setState(1);
                    prdEvaluatePayload.setFromId(prdProbationExamVO.getId());
                    Long res = prdEvaluateService.updateStateByFormId(prdEvaluatePayload);

                    break;
                case APPROVING:
                    prdProbationExamPayload.setProcInstStatus(ProcInstStatus.APPROVING);
            }
            prdProbationExamService.updateByCondition(prdProbationExamPayload);
        }
        return WorkflowResult.success(null);
    }


}
