package com.elitesland.tw.tw5.server.prd.humanresources.examination.dao;

import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdExamTempDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.QPrdExamTempDO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdExamTempPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdExamTempQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdExamTempVO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-11-13
 * @desc : 绩效考核模板RepoProc
 */

@Component
public class PrdExamTempDao extends BaseRepoProc<PrdExamTempDO> {

    private static final QPrdExamTempDO qPrdExamTempDO = QPrdExamTempDO.prdExamTempDO;


    protected PrdExamTempDao() {

        super(qPrdExamTempDO);

    }


    public PagingVO<PrdExamTempVO> page(PrdExamTempQuery prdExamTempQuery) {

        JPAQuery<PrdExamTempVO> query =
                select(PrdExamTempVO.class)
                        .where(bulidPredicate(prdExamTempQuery));
        prdExamTempQuery.setPaging(query);
        prdExamTempQuery.fillOrders(query, qPrdExamTempDO);
        return PagingVO.<PrdExamTempVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdExamTempDO)
                .set(qPrdExamTempDO.deleteFlag, 1)
                .where(qPrdExamTempDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdExamTempVO get(Long id) {

        PrdExamTempVO prdExamTempVO = select(PrdExamTempVO.class)
                .where(qPrdExamTempDO.id.eq(id))
                .fetchOne();

        return prdExamTempVO;

    }


    public List<PrdExamTempVO> getList(PrdExamTempQuery prdExamTempQuery) {

        List<PrdExamTempVO> res =
                select(PrdExamTempVO.class)
                        .where(bulidPredicate(prdExamTempQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdExamTempDO.name,
                        qPrdExamTempDO.scoreMax,
                        qPrdExamTempDO.scoreMin,
                        qPrdExamTempDO.enableFlag,
                        qPrdExamTempDO.id,
                        qPrdExamTempDO.createTime,
                        qPrdExamTempDO.remark

                )).from(qPrdExamTempDO);

    }


    private Predicate bulidPredicate(PrdExamTempQuery prdExamTempQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andLike(StringUtils.isNotBlank(prdExamTempQuery.getName()), qPrdExamTempDO.name, prdExamTempQuery.getName())
                .andEq(null != prdExamTempQuery.getScoreMax(), qPrdExamTempDO.scoreMax, prdExamTempQuery.getScoreMax())
                .andEq(null != prdExamTempQuery.getScoreMin(), qPrdExamTempDO.scoreMin, prdExamTempQuery.getScoreMin())
                .andEq(null != prdExamTempQuery.getEnableFlag(), qPrdExamTempDO.enableFlag, prdExamTempQuery.getEnableFlag())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdExamTempQuery prdExamTempQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 模板名称
        if (StringUtils.isNotEmpty(prdExamTempQuery.getName())) {
            predicates.add(qPrdExamTempDO.name.eq(prdExamTempQuery.getName()));
        }
        // 分数上限
        if (null != prdExamTempQuery.getScoreMax()) {
            predicates.add(qPrdExamTempDO.scoreMax.eq(prdExamTempQuery.getScoreMax()));
        }
        // 分数下限
        if (null != prdExamTempQuery.getScoreMin()) {
            predicates.add(qPrdExamTempDO.scoreMin.eq(prdExamTempQuery.getScoreMin()));
        }
        // 启用标志
        if (null != prdExamTempQuery.getEnableFlag()) {
            predicates.add(qPrdExamTempDO.enableFlag.eq(prdExamTempQuery.getEnableFlag()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long count(PrdExamTempQuery prdExamTempQuery) {

        long res = select(PrdExamTempVO.class)
                .where(bulidPredicate(prdExamTempQuery))
                .fetchCount();

        return res;


    }

    public Long update(PrdExamTempPayload prdExamTempPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdExamTempDO);

        // 模板名称
        if (StringUtils.isNotEmpty(prdExamTempPayload.getName())) {
            update.set(qPrdExamTempDO.name, prdExamTempPayload.getName());
        }
        // 分数上限
        if (null != prdExamTempPayload.getScoreMax()) {
            update.set(qPrdExamTempDO.scoreMax, prdExamTempPayload.getScoreMax());
        }
        // 分数下限
        if (null != prdExamTempPayload.getScoreMin()) {
            update.set(qPrdExamTempDO.scoreMin, prdExamTempPayload.getScoreMin());
        }
        // 启用标志
        if (null != prdExamTempPayload.getEnableFlag()) {
            update.set(qPrdExamTempDO.enableFlag, prdExamTempPayload.getEnableFlag());
        }
        long res = update.where(qPrdExamTempDO.id.eq(prdExamTempPayload.getId()))
                .execute();
        return res;

    }

    public Long updateState(PrdExamTempPayload prdExamTempPayload) {
        long res = jpaQueryFactory.update(qPrdExamTempDO)
                .set(qPrdExamTempDO.enableFlag, prdExamTempPayload.getEnableFlag())
                .where(qPrdExamTempDO.id.eq(prdExamTempPayload.getId()))
                .execute();
        return res;

    }
}

