package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.UserVacationApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.query.UserVacationApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PmsTimesheetService;
import com.elitesland.tw.tw5.api.prd.my.service.ProjectService;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationApplyService;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.*;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.server.common.GenerateSeqNumConstants;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.UserVacationIntervalEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.VacationTypeEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.UserVacationApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.UserVacationApplyDetailConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.UserVacationConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationApplyDetailDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.UserVacationDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.entity.UserVacationDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.UserVacationApplyDetailRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.UserVacationApplyRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskSourceTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author sunxw
 * @description 用户假期申请
 * @Date 2023/5/9
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class UserVacationApplyServiceImpl extends BaseServiceImpl implements UserVacationApplyService {

    private final PrdOrgEmployeeService employeeService;
    private final ProjectService projectService;
    private final PrdOrgOrganizationService orgService;

    private final UserVacationApplyDAO userVacationApplyDAO;
    private final UserVacationApplyRepo userVacationApplyRepo;
    private final UserVacationApplyDetailRepo userVacationApplyDetailRepo;
    private final PrdOrgSyncLogDAO daoLog;
    private final HttpUtil httpUtil;

    private final PmsProjectService pmsProjectService;

    private final PrdOrgEmployeeDAO employeeDAO;

    private final PrdSystemRoleDAO prdSystemRoleDAO;

    private final WorkflowUtil workflowUtil;

    private final TransactionUtilService transactionUtilService;

    private final UserVacationApplyDetailDAO userVacationApplyDetailDAO;

    private final UserVacationService userVacationService;

    private final UserVacationDAO userVacationDAO;

    private final FileUtil fileUtil;

    private final CacheUtil cacheUtil;

    private final TimesheetRepo timesheetRepo;

    private final PmsTimesheetService timesheetService;

    private final TaskInfoService taskInfoService;

    private final PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService;

    private final PrdSystemRoleService roleService;

    @Value("${tw4.vacation.apply}")
    private String syncVacationApplyUrl;

    @Value("${tw4.vacation.applyDetail}")
    private String syncVacationApplyDetailUrl;

    @Override
    public PagingVO<UserVacationApplyVO> paging(UserVacationApplyQuery query) {
        return userVacationApplyDetailDAO.page(query);
    }

    @Override
    public List<UserVacationApplyVO> list(UserVacationApplyQuery query) {
        return userVacationApplyDetailDAO.list(query);
    }

    @Override
    public List<UserVacationApplyVO> queryList(UserVacationApplyQuery query) {
        return userVacationApplyDAO.queryList(query);
    }


    @Transactional
    @Override
    public void syncVacationApplyData(String param) {
        String syncType = "vacation_apply";
        LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        if (localDateTime == null) {
            localDateTime = LocalDateTime.of(2023, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            localDateTime = localDateTime.minusSeconds(10);
        }
        XxlJobLogger.log("用户请假申请数据同步开始...");
        XxlJobLogger.log("syncVacationApply localDateTime：" + localDateTime);
        //TODO参数内容待确定
        //同步到5.0
        Map<String, Long> reqMap = new HashMap<>();
        final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        reqMap.put("asyncTime", asyncTimeLong);
        XxlJobLogger.log("syncVacationApply syncTime：" + asyncTimeLong);
//        String result = httpUtil.sendSyncGet(syncVacationApplyUrl, reqMap);
//        Map<String, Object> data = (Map) JSONObject.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if (("true".equals(data.get("ok") + ""))) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
                Map<Long, Long> v4AndV5ProjectIds = projectService.getV4AndV5ProjectIds();
                Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds();
                final Object datum = data.get("datum");
                List<Map<String, Object>> userVacationApplyData = (List<Map<String, Object>>) datum;
                //用户请假申请数据构建
                List<UserVacationApplyDO> userVacationApplyDOList = new ArrayList<>();
                //查询5.0已有的数据，对新旧数据进行对比，如有变动，进行更新操作
                List<Long> tw4UserVacationApplyIds = userVacationApplyData.stream()
                        .map(vacationApply -> ((Integer) (vacationApply.get("id") == null ? 0 : vacationApply.get("id"))).longValue())
                        .collect(Collectors.toList());
                //根据4.0id获取表中旧值，决定进行插入或更新
                List<UserVacationApplyDO> oldUserVacationApply4DOList = userVacationApplyRepo.selectByIdV4List(tw4UserVacationApplyIds);
                //idV4相等的进行更新操作
                for (UserVacationApplyDO applyDO : oldUserVacationApply4DOList) {
                    Long applyIdV4 = applyDO.getApplyIdV4();
                    for (Map applyData : userVacationApplyData) {
                        Long receiveApplyIdV4 = ((Integer) ((null == applyData.get("id") ? 0 : applyData.get("id")))).longValue();
                        if (applyIdV4.equals(receiveApplyIdV4)) {
                            //有则更新表中记录,并跳出内层循环
                            UserVacationApplyDO todoApplyDO = this.transApplyFromV4(applyData, v4AndV5UserIds, v4AndV5ProjectIds, v4AndV5OrgIds);
                            todoApplyDO.setId(applyDO.getId());
                            userVacationApplyDOList.add(todoApplyDO);
                            break;
                        }
                    }
                }
                userVacationApplyRepo.saveAll(userVacationApplyDOList);

                //筛选出不存在的，直接插入
                List<Map<String, Object>> newDatas = userVacationApplyData.stream().filter(applyData -> {
                    boolean flag = true;
                    Long applyId = ((Integer) (applyData.get("id") == null ? 0 : applyData.get("id"))).longValue();
                    for (UserVacationApplyDO applyDO : oldUserVacationApply4DOList) {
                        if (applyDO.getApplyIdV4().equals(applyId)) {
                            flag = false;
                        }
                    }
                    return flag;
                }).collect(Collectors.toList());
                List<UserVacationApplyDO> newApplyDOList = new ArrayList<>();
                //插入新数据
                for (Map<String, Object> newData : newDatas) {
                    UserVacationApplyDO todoApplyDO = this.transApplyFromV4(newData, v4AndV5UserIds, v4AndV5ProjectIds, v4AndV5OrgIds);
                    newApplyDOList.add(todoApplyDO);
                }
                userVacationApplyRepo.saveAll(newApplyDOList);
                syncData = "更新了用户请假申请" + userVacationApplyData.size() + "条数据";
            } else {
                syncData = "活动数据未变化";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        daoLog.save(logDO);
        log.info("【活动同步，同步日志：{}】", logDO);
        XxlJobLogger.log("用户请假申请同步活动结束..." + logDO);
    }

    @Transactional
    @Override
    public void syncVacationApplyDetailData(String param) {
        String syncType = "vacation_apply_detail";
        LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        if (localDateTime == null) {
            localDateTime = LocalDateTime.of(2023, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            localDateTime = localDateTime.minusSeconds(10);
        }
        XxlJobLogger.log("用户请假申请明细数据同步开始...");
        XxlJobLogger.log("syncVacationApplyDetail localDateTime：" + localDateTime);
        //TODO参数内容待确定
        //同步到5.0
        Map<String, Long> reqMap = new HashMap<>();
        final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        reqMap.put("asyncTime", asyncTimeLong);
        XxlJobLogger.log("syncVacationApplyDetail syncTime：" + asyncTimeLong);
//        String result = httpUtil.sendSyncGet(syncVacationApplyDetailUrl, reqMap);
//        Map<String, Object> data = (Map) JSONObject.parse(result);
        Map<String, Object> data = new HashMap<>();
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if (("true".equals(data.get("ok") + ""))) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                final Object datum = data.get("datum");
                List<Map<String, Object>> userVacationApplyDetailData = (List<Map<String, Object>>) datum;
                //用户请假申请明细数据构建
                List<UserVacationApplyDetailDO> applyDetailDOList = new ArrayList<>();
                //查询5.0已有的数据，对新旧数据进行对比，如有变动，进行更新操作
                List<Long> tw4ApplyDetailIds = userVacationApplyDetailData.stream()
                        .map(applyDetail -> ((Integer) (applyDetail.get("id") == null ? 0 : applyDetail.get("id"))).longValue())
                        .collect(Collectors.toList());
                //根据4.0id获取表中旧值，决定进行插入或更新
                List<UserVacationApplyDetailDO> oldUserVacationApplyDetail4DOList = userVacationApplyDetailRepo.selectByIdV4(tw4ApplyDetailIds);
                //idV4相等的进行更新操作
                for (UserVacationApplyDetailDO detailDO : oldUserVacationApplyDetail4DOList) {
                    Long detailIdV4 = detailDO.getDetailIdV4();
                    for (Map detailData : userVacationApplyDetailData) {
                        Long receiveDetailIdV4 = ((Integer) ((null == detailData.get("id") ? 0 : detailData.get("id")))).longValue();
                        if (detailIdV4.equals(receiveDetailIdV4)) {
                            //有则更新表中记录,并跳出内层循环
                            UserVacationApplyDetailDO todoDetailDO = this.transDetailFromV4(detailData);
                            todoDetailDO.setId(detailDO.getId());
                            applyDetailDOList.add(todoDetailDO);
                            break;
                        }
                    }
                }
                userVacationApplyDetailRepo.saveAll(applyDetailDOList);

                //筛选出不存在的，直接插入
                List<Map<String, Object>> newDatas = userVacationApplyDetailData.stream().filter(detailData -> {
                    boolean flag = true;
                    Long detailId = ((Integer) (detailData.get("id") == null ? 0 : detailData.get("id"))).longValue();
                    for (UserVacationApplyDetailDO detailDO : oldUserVacationApplyDetail4DOList) {
                        if (detailDO.getDetailIdV4().equals(detailId)) {
                            flag = false;
                        }
                    }
                    return flag;
                }).collect(Collectors.toList());
                List<UserVacationApplyDetailDO> newDetailDOList = new ArrayList<>();
                //插入新数据
                for (Map<String, Object> newData : newDatas) {
                    Long applyV4 = ((Integer) newData.get("applyId")).longValue();
                    UserVacationApplyDO applyDO = userVacationApplyRepo.selectByIdV4(applyV4);
                    UserVacationApplyDetailDO todoDetailDO = this.transDetailFromV4(newData);
                    if (null != applyDO) {
                        todoDetailDO.setApplyId(applyDO.getId());
                        todoDetailDO.setBelongOrgId(applyDO.getBelongOrgId());
                    }
                    newDetailDOList.add(todoDetailDO);
                }
                userVacationApplyDetailRepo.saveAll(newDetailDOList);
                syncData = "更新了用户请假申请明细" + userVacationApplyDetailData.size() + "条数据";
            } else {
                syncData = "活动数据未变化";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        daoLog.save(logDO);
        log.info("【活动同步，同步日志：{}】", logDO);
        XxlJobLogger.log("用户请假申请明细同步活动结束..." + logDO);
    }

    @Override
    public List<UserVacationApplyDetailVO> getDetailByApplyKey(Long applyId) {
        List<UserVacationApplyDetailDO> doList = userVacationApplyDetailRepo.selectDetailByApplyKey(applyId);
        List<UserVacationApplyDetailVO> voList = new ArrayList<>();
        for (UserVacationApplyDetailDO detailDO : doList) {
            UserVacationApplyDetailVO vo = new UserVacationApplyDetailVO();
            BeanUtils.copyProperties(detailDO, vo);
            voList.add(vo);
        }
        return voList;
    }

    /**
     * v4->v5的apply变更字段赋值
     *
     * @param applyData         v4的数据
     * @param v4AndV5UserIds    v4与v5对应的userId
     * @param v4AndV5ProjectIds v4与v5对应的projectId
     * @param v4AndV5OrgIds     v4与v5对应的orgId
     * @return
     */
    private UserVacationApplyDO transApplyFromV4(Map applyData, Map<Long, Long> v4AndV5UserIds, Map<Long, Long> v4AndV5ProjectIds, Map<Long, Long> v4AndV5OrgIds) {
        UserVacationApplyDO applyDO = BeanUtil.mapToBean(UserVacationApplyDO.class, applyData, Arrays.asList("id", "createTime", "createUserId"));
        if (null != applyData.get("id")) {
            applyDO.setApplyIdV4(((Integer) applyData.get("id")).longValue());
        }
        /*if (null != applyData.get("createUserId")) {
            Long createUserId = (Long) applyData.get("createUserId");
            applyDO.setCreateUserId(v4AndV5UserIds.get(createUserId));
        }*/
        if (StringUtils.isEmpty(applyData.get("projectId"))) {
            String projectId = (String) applyData.get("projectId");
            applyDO.setCreateUserId(v4AndV5ProjectIds.get(projectId));
        }
        if (null != applyData.get("buId")) {
            Long orgId = ((Integer) applyData.get("buId")).longValue();
            applyDO.setOrgId(v4AndV5OrgIds.get(orgId));
        }
        if (null != applyData.get("resId")) {
            Long userId = ((Integer) applyData.get("resId")).longValue();
            applyDO.setPUserId(v4AndV5UserIds.get(userId));
        }
        if (null != applyData.get("presId")) {
            Long pUserId = ((Integer) applyData.get("presId")).longValue();
            applyDO.setPUserId(v4AndV5UserIds.get(pUserId));
        }
        return applyDO;
    }

    /**
     * v4->v5的applyDetail变更字段赋值
     *
     * @param detailData 请假申请明细
     * @return
     */
    private UserVacationApplyDetailDO transDetailFromV4(Map detailData) {
        UserVacationApplyDetailDO detailDO = BeanUtil.mapToBean(UserVacationApplyDetailDO.class, detailData, Arrays.asList("id", "createTime", "createUserId"));
        if (null != detailData.get("id")) {
            detailDO.setDetailIdV4(((Integer) detailData.get("id")).longValue());
        }
        if (null != detailData.get("applyId")) {
            detailDO.setApplyIdV4(((Integer) detailData.get("applyId")).longValue());
        }
        if (null != detailData.get("vmonth")) {
            detailDO.setVMonth((String) detailData.get("vmonth"));
        }
        if (null != detailData.get("vdate")) {
            LocalDate vdate = TimeUtil.dateFromYmd((String) detailData.get("vdate"));
            detailDO.setVDate(vdate);
        }
        if (null != detailData.get("vdays")) {
            BigDecimal vdays = new BigDecimal((String) detailData.get("vdays"));
            detailDO.setVDays((vdays));
        }
        if (null != detailData.get("vinterval")) {
            detailDO.setVInterval((String) detailData.get("vinterval"));
        }
        return detailDO;
    }

    @Override
    @Transactional
    public void userVacationApply(UserVacationApplyPayload payload) {
        if (payload.getProcInstId() == null) {
            startProc(payload);
        } else {
            updateVacationApplyData(payload);
        }
    }

    @Transactional
    public void startProc(UserVacationApplyPayload payload) {
        UserVacationApplyVO applyVO;
        // 判断是直接提交还是保存后再提交
        if (payload.getId() == null) {
            //校验数据
            checkoutData(payload, true);
            String applyNo = payload.getApplyNo();
            if (payload.getId() == null) {
                applyNo = generateSeqNum(GenerateSeqNumConstants.VACATION_APPLY_NO);
            }
            UserVacationApplyDO pdo = UserVacationApplyConvert.INSTANCE.payloadToDo(payload);
            pdo.setApplyNo(applyNo);
            applyVO = UserVacationApplyConvert.INSTANCE.doToVo(userVacationApplyDAO.save(pdo));

        } else {
            UserVacationApplyDO userVacationApplyDO = UserVacationApplyConvert.INSTANCE.payloadToDo(payload);
            applyVO = UserVacationApplyConvert.INSTANCE.doToVo(userVacationApplyDAO.save(userVacationApplyDO));
            payload.setId(userVacationApplyDO.getId());
            List<UserVacationApplyDetailPayload> userVacationApplyDetailPayloadList = payload.getApplyDetailPayloadList();
            userVacationApplyDetailDAO.deleteAllByApplyId(payload.getId());
            // 删除明细后校验数据
            checkoutData(payload, true);
        }

        PrdOrgEmployeeVO employeeVO = employeeService.queryByUserId(payload.getUserId());

        HashMap<String, Object> variables;

        //参数设置
        variables = setWorkFlowVar(payload);

        String vacationTypeName = cacheUtil.transferSystemSelection(FunctionSelectionEnum.VacationType.getCode(), payload.getVacationType());
        //发起流程审批
        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                ProcDefKey.RES_VACATION.name(),
                "A35.请假流程-" + employeeVO.getEmployeeName() + "-" + vacationTypeName + "-" + applyVO.getStartDate() + "~" + applyVO.getEndDate(),
                applyVO.getId() + "",
                variables)
        );
        //流程启动成功后，回写业务表数据
        List<UserVacationApplyDetailPayload> userVacationApplyDetailPayloadList = payload.getApplyDetailPayloadList();
        userVacationApplyDetailPayloadList.forEach(userVacationApplyDetailPayload -> {
            userVacationApplyDetailPayload.setApplyId(applyVO.getId());
        });
        List<UserVacationApplyDetailDO> userVacationApplyDetailDOList = UserVacationApplyDetailConvert.INSTANCE.payloadsToDos(userVacationApplyDetailPayloadList);
        userVacationApplyDetailDOList.forEach(detailDO -> {
            detailDO.setExtVacationFlag(false);
        });
        List<UserVacationApplyDetailDO> userVacationApplyDetailDOS = userVacationApplyDetailDAO.saveAll(userVacationApplyDetailDOList);

        UserVacationApplyPayload userVacationApplyPayload = new UserVacationApplyPayload();
        userVacationApplyPayload.setId(applyVO.getId());
        userVacationApplyPayload.setProcInstId(processInfo.getProcInstId());
        userVacationApplyPayload.setProcInstStatus(processInfo.getProcInstStatus());
        //开启事务执行修改，主要是修改审批状态
        userVacationApplyDetailDOS.forEach(detailDO -> {
            detailDO.setProcInstId(processInfo.getProcInstId());
            detailDO.setProcInstStatus(processInfo.getProcInstStatus());
        });

        transactionUtilService.executeWithRunnable(() -> {
            userVacationApplyDAO.updateProcData(userVacationApplyPayload);
            for (UserVacationApplyDetailDO userVacationApplyDetailDO : userVacationApplyDetailDOS) {
                userVacationApplyDetailDAO.updateProcStatus(userVacationApplyDetailDO);
            }
        });
        // 提交流程的时候将重复的哺乳假删除


        List<UserVacationApplyDetailPayload> vacationApplyDetailPayloads = UserVacationApplyDetailConvert.INSTANCE.dosToPayloads(userVacationApplyDetailDOS);
        payload.setApplyDetailPayloadList(vacationApplyDetailPayloads);
        payload.setId(applyVO.getId());
        // 插入工时
        payload.setCreateTime(LocalDateTime.now());
        timesheetService.generateVacationPrivateTimesheet(payload);
    }

    public HashMap<String, Object> setWorkFlowVar(UserVacationApplyPayload payload) {

        HashMap<String, Object> variables = new HashMap<>();
        String vacationType = payload.getVacationType();

        //是否在项目上
        if (payload.getInProjectFlag() != null) {
            variables.put("inProjectFlag", payload.getInProjectFlag());
        }
//        //请假天数
//        if (payload.getVacationDays() != null) {
//            variables.put("applyDays", payload.getVacationDays());
//        }
        //是否需要补充附件
        if (payload.getAddFlag() != null) {
            variables.put("addFlag", payload.getAddFlag());
        }
        //是否延长假期
        if (payload.getExtVacationFlag() != null) {
            variables.put("extVacationFlag", payload.getExtVacationFlag());
        } else {
            variables.put("extVacationFlag", 0);
        }

        // 是否婚假/产假/丧假/陪产假/产前检查假/病假
        Boolean mmfppFlag = false;
        // 是否事假
        Boolean personalFlag = false;
        if (StringUtils.hasText(vacationType)) {
            if (VacationTypeEnum.MARRIAGE.getCode().equals(vacationType) || VacationTypeEnum.MATERNITY.getCode().equals(vacationType)
                    || VacationTypeEnum.FUNERAL.getCode().equals(vacationType) || VacationTypeEnum.PATERNITY.getCode().equals(vacationType)
                    || VacationTypeEnum.PRENATAL_EXA.getCode().equals(vacationType) || VacationTypeEnum.SICK.getCode().equals(vacationType)) {
                mmfppFlag = true;
            }
            // 事假
            if (VacationTypeEnum.PERSONAL.getCode().equals(vacationType)) {
                personalFlag = true;
            }
        }
        variables.put("mmfppFlag", mmfppFlag);
        variables.put("personalFlag", personalFlag);

        // 当年度累计病假/事假是否大于5天
        Boolean personalDaysFlag = false;
        Boolean sickDaysFlag = false;
        if (VacationTypeEnum.PERSONAL.getCode().equals(vacationType) || VacationTypeEnum.SICK.getCode().equals(vacationType)) {
            // 查询当前申请人的所有请假
            BigDecimal vacationDays = payload.getVacationDays();
            UserVacationApplyQuery query = new UserVacationApplyQuery();
            query.setUserId(payload.getUserId());
            query.setApprStatus(ProcInstStatus.APPROVED.name());
            query.setVacationType(payload.getVacationType());
            List<UserVacationApplyVO> userVacationApplyVOS = list(query);
            if (!CollectionUtils.isEmpty(userVacationApplyVOS)) {
                if (!CollectionUtils.isEmpty(userVacationApplyVOS)) {
                    BigDecimal days = userVacationApplyVOS.stream().filter(vo -> vo.getVacationDays() != null).map(p -> p.getVacationDays()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    vacationDays = vacationDays.add(days);
                }
            }
            if (vacationDays.compareTo(new BigDecimal(5)) > 0) {
                if (VacationTypeEnum.PERSONAL.getCode().equals(vacationType)) {
                    personalDaysFlag = true;
                } else {
                    sickDaysFlag = true;
                }
            }
        }
        variables.put("personalDaysFlag", personalDaysFlag);
        variables.put("sickDaysFlag", sickDaysFlag);


        //项目经理
        if (payload.getProjectId() != null) {
            PmsProjectVO projectVO = pmsProjectService.queryByKey(payload.getProjectId());
            Long pmUserId = projectVO.getPmResId();
            variables.put("Activity_1gt34xh", CollUtil.newArrayList(pmUserId));
            variables.put("Activity_0qq6cd7", CollUtil.newArrayList(pmUserId));
        }
        //直属领导
        Long userId = payload.getUserId();
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(userId);
        if (prdOrgEmployeeRefVO == null) {
            throw TwException.error("", "员工组织关系异常,请联系管理员");
        }
        if (prdOrgEmployeeRefVO.getParentId() == null) {
            throw TwException.error("", "员工上级不存在,请联系管理员");
        }
        variables.put("Activity_0x3r156", CollUtil.newArrayList(prdOrgEmployeeRefVO.getParentId()));

        //BU负责人
        if (prdOrgEmployeeRefVO.getManageId() == null) {
            throw TwException.error("", "员工BU负责人不存在,请联系管理员");
        }
        variables.put("Activity_1kg2f1v", CollUtil.newArrayList(prdOrgEmployeeRefVO.getManageId()));
        variables.put("Activity_1e310kk", CollUtil.newArrayList(prdOrgEmployeeRefVO.getManageId()));

        // 事业部负责人
        Long orgId = cacheUtil.getDefaultOrgIdByUserId(userId);
        PrdOrgOrganizationRefVO buLevel1ByOrg = cacheUtil.getBULevel1ByOrgId(orgId);
        if (buLevel1ByOrg == null) {
            throw TwException.error("", "事业部负责人不存在,请联系管理员");
        }
        variables.put("Activity_1gsq9yn", buLevel1ByOrg.getManageId());

        //休假管理员
        List<Long> vacationAdmin = prdSystemRoleDAO.queryUserIdByRoleCodes(CollUtil.newArrayList(RoleEnum.PLAT_SALARY_MANAGER.getCode(), RoleEnum.PLAT_SALARY_SPECIALIST.getCode()));
        variables.put("Activity_1ryb750", vacationAdmin);
        //休假管理员
        variables.put("Activity_0yyszxj", vacationAdmin);

        //直属领导
        variables.put("Activity_15e26sx", CollUtil.newArrayList(prdOrgEmployeeRefVO.getParentId()));
        //BU负责人
        variables.put("Activity_06oa2am", CollUtil.newArrayList(prdOrgEmployeeRefVO.getManageId()));
        // CHO审批
        variables.put("Activity_1mnj3y9", roleService.queryUserIdByRoleCode(RoleEnum.PLAT_HRD.getCode()));

        return variables;
    }


    public void updateWorkFlowVar(UserVacationApplyPayload payload) {
        HashMap<String, Object> variables = setWorkFlowVar(payload);
        SetVariablesPayload setVariablesPayload = new SetVariablesPayload();
        setVariablesPayload.setProcInstId(payload.getProcInstId());
        setVariablesPayload.setVariables(variables);
        workflowUtil.setVaribales(setVariablesPayload);
    }

    @Transactional
    public void updateVacationApplyData(UserVacationApplyPayload payload) {

        // 更新数据
        UserVacationApplyVO applyVO = userVacationUpdate(payload);
        // 更新工作流参数
        updateWorkFlowVar(payload);

        payload.setCreateTime(applyVO.getCreateTime());
//        // 重新插入工时
        timesheetService.generateVacationPrivateTimesheet(payload);
    }


    @Override
    public UserVacationApplyVO queryApply(String procId) {
        UserVacationApplyDO userVacationApplyDO = userVacationApplyDAO.findByProcId(procId);
        UserVacationApplyVO userVacationApplyVO = UserVacationApplyConvert.INSTANCE.doToVo(userVacationApplyDO);
        userVacationApplyVO.setAttachmentDatas(fileUtil.getFileDatas(userVacationApplyVO.getAttachmentCodes()));
        userVacationApplyVO.setVacationAddAttachDatas(fileUtil.getFileDatas(userVacationApplyVO.getVacationAddAttachCodes()));
        userVacationApplyVO.setExtVacationAttachDatas(fileUtil.getFileDatas(userVacationApplyVO.getExtVacationAttachCodes()));
        Long userId = userVacationApplyDO.getUserId();
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(userId);
        PrdOrgEmployeeDO employeeDO = employeeDAO.queryByUserId(userId);
        userVacationApplyVO.setOrgId(prdOrgEmployeeRefVO.getOrgId());
        userVacationApplyVO.setParentUserId(prdOrgEmployeeRefVO.getParentId());
        userVacationApplyVO.setExtString6(employeeDO.getExtString6());
        userVacationApplyVO.setExtString9(employeeDO.getExtString9());
        userVacationApplyVO.setExtString5(employeeDO.getExtString5());
        userVacationApplyVO.setBookId(employeeDO.getBookId());
        if (!ObjectUtils.isEmpty(employeeDO.getBookId())) {
            userVacationApplyVO.setCompanyName(cacheUtil.getCompanyNameByBookId(employeeDO.getBookId()));
        }
        userVacationApplyVO.setExtString6Name(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeType.getCode(), employeeDO.getExtString6()));
        if (Objects.equals(userVacationApplyVO.getExtString6(), "INTERNAL_RES")) {
            userVacationApplyVO.setExtString9Name(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeInternalType.getCode(), employeeDO.getExtString9()));
        } else if (Objects.equals(userVacationApplyVO.getExtString6(), "EXTERNAL_RES")) {
            userVacationApplyVO.setExtString9Name(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeExternalType.getCode(), employeeDO.getExtString9()));
        }
        List<UserVacationVO> availableVacationList = userVacationService.getAvailableVacation(userId, userVacationApplyVO.getVacationId());
        userVacationApplyVO.setAvailableVacationVOList(availableVacationList);
        List<UserVacationApplyDetailDO> detailDOList = userVacationApplyDetailDAO.findByProcIdAndExtFlag(procId, false);
        userVacationApplyVO.setDetailVOList(UserVacationApplyDetailConvert.INSTANCE.dosToVos(detailDOList));

        List<UserVacationApplyDetailDO> extDetailDOList = userVacationApplyDetailDAO.findByProcIdAndExtFlag(procId, true);
        if (extDetailDOList != null) {
            userVacationApplyVO.setExtDetailVOList(UserVacationApplyDetailConvert.INSTANCE.dosToVos(extDetailDOList));
        }

        userVacationApplyVO.setLastThreeMonthDetailVOList(null);
        return userVacationApplyVO;
    }

    @Override
    public UserVacationApplyVO queryApplyByKey(String businessKey) {
        Long applyId = Long.valueOf(businessKey);
        UserVacationApplyDO userVacationApplyDO = userVacationApplyDAO.findById(applyId);
        UserVacationApplyVO userVacationApplyVO = UserVacationApplyConvert.INSTANCE.doToVo(userVacationApplyDO);
        userVacationApplyVO.setAttachmentDatas(fileUtil.getFileDatas(userVacationApplyVO.getAttachmentCodes()));
        userVacationApplyVO.setVacationAddAttachDatas(fileUtil.getFileDatas(userVacationApplyVO.getVacationAddAttachCodes()));
        // 查询项目名称 app端需要
        if (userVacationApplyDO.getProjectId() != null) {
            PmsProjectVO pmsProjectVO = pmsProjectService.queryByKey(Long.valueOf(userVacationApplyDO.getProjectId()));
            userVacationApplyVO.setProjectName(pmsProjectVO.getProjName());
        }
        Long userId = userVacationApplyDO.getUserId();
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(userId);
        PrdOrgEmployeeDO employeeDO = employeeDAO.queryByUserId(userId);
        userVacationApplyVO.setOrgId(prdOrgEmployeeRefVO.getOrgId());
        userVacationApplyVO.setParentUserId(prdOrgEmployeeRefVO.getParentId());
        userVacationApplyVO.setExtString5(employeeDO.getExtString5());
        userVacationApplyVO.setExtString6(employeeDO.getExtString6());
        userVacationApplyVO.setExtString9(employeeDO.getExtString9());
        userVacationApplyVO.setBookId(employeeDO.getBookId());
        if (!ObjectUtils.isEmpty(employeeDO.getBookId())) {
            userVacationApplyVO.setCompanyName(cacheUtil.getCompanyNameByBookId(employeeDO.getBookId()));
        }
        userVacationApplyVO.setExtString6Name(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeType.getCode(), employeeDO.getExtString6()));
        if (Objects.equals(userVacationApplyVO.getExtString6(), "INTERNAL_RES")) {
            userVacationApplyVO.setExtString9Name(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeInternalType.getCode(), employeeDO.getExtString9()));
        } else if (Objects.equals(userVacationApplyVO.getExtString6(), "EXTERNAL_RES")) {
            userVacationApplyVO.setExtString9Name(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeExternalType.getCode(), employeeDO.getExtString9()));
        }
        String companyName = cacheUtil.getCompanyNameByBookId(employeeDO.getBookId());
        userVacationApplyVO.setCompanyName(companyName);
        List<UserVacationVO> availableVacationList = userVacationService.getAvailableVacation(userId, userVacationApplyVO.getVacationId());
        userVacationApplyVO.setAvailableVacationVOList(availableVacationList);
        List<UserVacationApplyDetailDO> detailDOList = userVacationApplyDetailDAO.findByApplyIdAndExtFlag(applyId, false);
        userVacationApplyVO.setDetailVOList(UserVacationApplyDetailConvert.INSTANCE.dosToVos(detailDOList));

        List<UserVacationApplyDetailDO> extDetailDOList = userVacationApplyDetailDAO.findByApplyIdAndExtFlag(applyId, true);
        if (extDetailDOList != null) {
            userVacationApplyVO.setExtDetailVOList(UserVacationApplyDetailConvert.INSTANCE.dosToVos(extDetailDOList));
        }
        List<UserRecentVacationApplyVO> recentVacationApplyVOList = getLastThreeMonthApplyDetailVOList(userId, userVacationApplyVO.getCreateTime().toLocalDate());
        userVacationApplyVO.setLastThreeMonthDetailVOList(recentVacationApplyVOList);
        return userVacationApplyVO;
    }

    @Override
    @Transactional
    public UserVacationApplyVO userVacationInsert(UserVacationApplyPayload payload) {
        //校验数据
        checkoutData(payload, false);
        String applyNo = payload.getApplyNo();
        if (payload.getId() == null) {
            applyNo = generateSeqNum(GenerateSeqNumConstants.VACATION_APPLY_NO);
        }
        payload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
        UserVacationApplyDO pdo = UserVacationApplyConvert.INSTANCE.payloadToDo(payload);
        pdo.setApplyNo(applyNo);
        UserVacationApplyVO applyVO = UserVacationApplyConvert.INSTANCE.doToVo(userVacationApplyDAO.save(pdo));
        List<UserVacationApplyDetailPayload> userVacationApplyDetailPayloadList = payload.getApplyDetailPayloadList();
        userVacationApplyDetailPayloadList.forEach(userVacationApplyDetailPayload -> {
            userVacationApplyDetailPayload.setApplyId(applyVO.getId());
        });
        List<UserVacationApplyDetailDO> userVacationApplyDetailDOList = UserVacationApplyDetailConvert.INSTANCE.payloadsToDos(userVacationApplyDetailPayloadList);
        userVacationApplyDetailDOList.forEach(detailDO -> {
            detailDO.setExtVacationFlag(false);
        });
        userVacationApplyDetailDAO.saveAll(userVacationApplyDetailDOList);
        return applyVO;
    }

    @Override
    @Transactional
    public UserVacationApplyVO userVacationUpdate(UserVacationApplyPayload payload) {
        // 有流程的时候先删除工时 然后再校验
        if (payload.getProcInstId() != null) {
            List<UserVacationApplyDetailDO> vacationApplyDetailDOS = userVacationApplyDetailDAO.findByApplyId(payload.getId());
            List<Long> detailIdList = vacationApplyDetailDOS.stream().map(e -> e.getId()).collect(Collectors.toList());
            // 删除原有工时
            timesheetService.deleteVacationPrivateTimesheet(detailIdList);
        }
        UserVacationApplyDO userVacationApplyDO = UserVacationApplyConvert.INSTANCE.payloadToDo(payload);
        UserVacationApplyVO applyVO = UserVacationApplyConvert.INSTANCE.doToVo(userVacationApplyDAO.save(userVacationApplyDO));
        payload.setId(userVacationApplyDO.getId());
        List<UserVacationApplyDetailPayload> userVacationApplyDetailPayloadList = payload.getApplyDetailPayloadList();
        userVacationApplyDetailDAO.deleteAllByApplyId(payload.getId());
        // 删除明细后校验数据
        checkoutData(payload, false);
        List<UserVacationApplyDetailDO> userVacationApplyDetailDOList = UserVacationApplyDetailConvert.INSTANCE.payloadsToDos(userVacationApplyDetailPayloadList);
        userVacationApplyDetailDOList.forEach(detailDO -> {
            detailDO.setId(null);
            detailDO.setApplyId(payload.getId());
            detailDO.setProcInstId(payload.getProcInstId());
            detailDO.setExtVacationFlag(false);
        });
        userVacationApplyDetailDOList = userVacationApplyDetailDAO.saveAll(userVacationApplyDetailDOList);
        List<UserVacationApplyDetailPayload> vacationApplyDetailPayloads = UserVacationApplyDetailConvert.INSTANCE.dosToPayloads(userVacationApplyDetailDOList);
        payload.setApplyDetailPayloadList(vacationApplyDetailPayloads);
        if (payload.getExtapplyDetailPayloadList() != null) {
            List<UserVacationApplyDetailPayload> extApplyDetailPayloadList = payload.getExtapplyDetailPayloadList();
            List<UserVacationApplyDetailDO> extUserVacationApplyDetailDOList = UserVacationApplyDetailConvert.INSTANCE.payloadsToDos(extApplyDetailPayloadList);
            extUserVacationApplyDetailDOList.forEach(detailDO -> {
                detailDO.setApplyId(payload.getId());
                detailDO.setProcInstId(payload.getProcInstId());
                detailDO.setProcInstStatus(payload.getProcInstStatus());
                detailDO.setExtVacationFlag(true);
            });

            extUserVacationApplyDetailDOList = userVacationApplyDetailDAO.saveAll(extUserVacationApplyDetailDOList);
            List<UserVacationApplyDetailPayload> extUserVacationApplyDetailPayloadList = UserVacationApplyDetailConvert.INSTANCE.dosToPayloads(extUserVacationApplyDetailDOList);
            payload.setExtapplyDetailPayloadList(extUserVacationApplyDetailPayloadList);
        }
        return applyVO;
    }

    // 请假申请保存 更新 提交前数据校验  20240617  如果请其他假期的时候 发现当天请假与哺乳假重复 就将哺乳假覆盖

    /**
     * @param payload                     请假数据
     * @param dealBreastfeedTimesheetFlag 提交时删除重复哺乳假标志
     **/
    private void checkoutData(UserVacationApplyPayload payload, Boolean dealBreastfeedTimesheetFlag) {
        if (ObjectUtils.isEmpty(payload.getApplyDetailPayloadList())) {
            throw TwException.error("", "请假明细不能为空");
        }
        //校验是否有填写的工时
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        List<LocalDate> workDateList = new ArrayList<>();
        workDateList.add(payload.getStartDate());
        workDateList.add(payload.getEndDate());
        timesheetQuery.setWorkDateBetween(workDateList);
        timesheetQuery.setTsUserId(payload.getUserId());
        List<TimesheetVO> timesheetVOList = TimesheetConvert.INSTANCE.toVoList(timesheetRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, timesheetQuery, criteriaBuilder)));
        if (!ObjectUtils.isEmpty(timesheetVOList)) {
            // 通过工时的请假明细id去查询请假明细 剔除哺乳假
            List<Long> vacationIdList = timesheetVOList.stream().filter(timesheetVO -> timesheetVO.getVacationApplyDetailId() != null).map(p -> p.getVacationApplyDetailId()).collect(Collectors.toList());
            UserVacationApplyQuery query = new UserVacationApplyQuery();
            query.setIds(vacationIdList);
            List<UserVacationApplyVO> userVacationApplyDetailVOS = list(query);
            Set<Long> breastfeedIdSet = new HashSet<>();
            if (!CollectionUtils.isEmpty(userVacationApplyDetailVOS)) {
                breastfeedIdSet = userVacationApplyDetailVOS.stream().filter(p -> StringUtils.hasText(p.getVacationType()) && VacationTypeEnum.BREASTFEED.getCode().equals(p.getVacationType())).map(s -> s.getId()).collect(Collectors.toSet());
            }
            final Set<Long> finalBreastfeedIdSet = breastfeedIdSet;
            if (dealBreastfeedTimesheetFlag && !CollectionUtils.isEmpty(finalBreastfeedIdSet)) {
                dealBreastfeedTimesheet(timesheetVOList, userVacationApplyDetailVOS, payload);
            }
            StringBuilder errorMsg = new StringBuilder();
            List<UserVacationApplyDetailPayload> vacationDetailList = payload.getApplyDetailPayloadList();
            Map<LocalDate, BigDecimal> result;
            if (!CollectionUtils.isEmpty(finalBreastfeedIdSet)) {
                // 存在哺乳假 然后将哺乳假剔除
                result = timesheetVOList.stream().filter(p -> !finalBreastfeedIdSet.contains(p.getVacationApplyDetailId()))
                        .collect(Collectors.toMap(
                                TimesheetVO::getWorkDate, // key的提取函数
                                TimesheetVO::getWorkHour, // value的提取函数
                                BigDecimal::add  // value的合并函数，当key重复时，将value相加
                        ));
            } else {
                result = timesheetVOList.stream()
                        .collect(Collectors.toMap(
                                TimesheetVO::getWorkDate, // key的提取函数
                                TimesheetVO::getWorkHour, // value的提取函数
                                BigDecimal::add  // value的合并函数，当key重复时，将value相加
                        ));
            }

            for (UserVacationApplyDetailPayload detailPayload : vacationDetailList) {
                if (!CollectionUtils.isEmpty(result) && result.containsKey(detailPayload.getVDate())) {
                    BigDecimal workHours = result.get(detailPayload.getVDate());
                    if (workHours.add(detailPayload.getVDays().multiply(BigDecimal.valueOf(8))).compareTo((BigDecimal.valueOf(8))) > 0) {
                        errorMsg.append(detailPayload.getVDate()).append(";");
                    }
                }
            }
            if (!errorMsg.isEmpty()) {
                errorMsg.append("已填写工时+当前请假时间已经超过8小时，请处理工时后再提交！");
                throw TwException.error("", errorMsg.toString());
            }
        }
        UserVacationVO userVacationVO = null;
        //福利年休法定年休校验可用天数
        if (VacationTypeEnum.ANNUAL_W.getCode().equals(payload.getVacationType()) || VacationTypeEnum.ANNUAL.getCode().equals(payload.getVacationType()) || VacationTypeEnum.IN_LIEU.getCode().equals(payload.getVacationType()) || VacationTypeEnum.REWARD.getCode().equals(payload.getVacationType())) {
            if (ObjectUtils.isEmpty(payload.getVacationId())) {
                throw TwException.error("", "请选择剩余假期");
            }
            BigDecimal approvingDays = userVacationApplyDAO.countApprovingDays(payload.getVacationId(), payload.getId());
            if (ObjectUtils.isEmpty(approvingDays)) {
                approvingDays = BigDecimal.ZERO;
            }
            UserVacationDO userVacationDO = userVacationDAO.queryById(payload.getVacationId());
            userVacationVO = UserVacationConvert.INSTANCE.doToVo(userVacationDO);
            List<UserVacationVO> userVacationVOList = Collections.singletonList(userVacationVO);
            userVacationService.calculateAvailableDay(userVacationVOList);
            userVacationVO = userVacationVOList.get(0);
            if (userVacationVO.getAvailableDays().compareTo(approvingDays.add(payload.getVacationDays())) < 0) {
                throw TwException.error("", "请假天数大于可用天数，其中可用假期" + userVacationVO.getAvailableDays() + "天，请假待审批" + approvingDays + "天,本次请假" + payload.getVacationDays().setScale(2) + "天");
            }
            //判断结束日期是否在有效期范围内
            if (payload.getEndDate().isAfter(userVacationVO.getExpirationDate())) {
                throw TwException.error("", "休假截止日期超过有效期【" + userVacationVO.getExpirationDate() + "】，请联系人事处理");
            }
            //福利假要判断项目是否关闭以及任务当量够不够
            if (VacationTypeEnum.REWARD.getCode().equals(payload.getVacationType())) {
                //处理奖励假任务问题
                handleVacationTask(payload, userVacationVO);
            }

        }
        //校验重复提交
        if (payload.getStartDate() != null) {
            List<UserVacationApplyDetailPayload> dayList = payload.getApplyDetailPayloadList();
            List<ProcInstStatus> procInstStatusList = Arrays.asList(ProcInstStatus.APPROVING, ProcInstStatus.APPROVED);
            List<UserRecentVacationApplyVO> userRecentVacationApplyVOList = userVacationApplyDetailDAO.queryByDateAndResId(payload.getStartDate(), payload.getEndDate(), payload.getUserId(), procInstStatusList);
            // 根据请假类型将哺乳假剔除出去
            userRecentVacationApplyVOList = userRecentVacationApplyVOList.stream().filter(p -> !VacationTypeEnum.BREASTFEED.getCode().equals(p.getVacationType())).collect(Collectors.toList());

            StringBuilder errorMsg = new StringBuilder();
            if (!ObjectUtils.isEmpty(userRecentVacationApplyVOList)) {
                for (UserVacationApplyDetailPayload detailPayload : dayList) {
                    for (UserRecentVacationApplyVO userRecentVacationApplyVO : userRecentVacationApplyVOList) {
                        //判断是否为同一天
                        if (!Objects.equals(payload.getVacationType(), VacationTypeEnum.BREASTFEED.getCode())) {
                            if (detailPayload.getVDate().isEqual(userRecentVacationApplyVO.getDetailVDate())) {
                                //判断当天是否为一天的请假申请
                                if (userRecentVacationApplyVO.getVacationDays().compareTo(new BigDecimal(1)) == 0) {
                                    errorMsg.append(detailPayload.getVDate()).append(";");
                                }
                                //判断是否是上下午重复
                                else if (detailPayload.getVDays().doubleValue() == 0.5 && Objects.equals(detailPayload.getVInterval(), userRecentVacationApplyVO.getDetailVInterval())) {
                                    errorMsg.append(detailPayload.getVDate()).append(" ").append(detailPayload.getVInterval()).append(";");
                                }
                            }
                        }
                    }
                }
            }
            if (!errorMsg.isEmpty()) {
                errorMsg.append("已经提交申请，请勿重复提交");
                throw TwException.error("", errorMsg.toString());
            }
        }
    }

    /**
     * 处理奖励假任务问题
     *
     * @param payload
     * @param userVacationVO
     */
    void handleVacationTask(UserVacationApplyPayload payload, UserVacationVO userVacationVO) {
        TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
        taskInfoQuery.setReasonType(userVacationVO.getReasonType());
        taskInfoQuery.setReasonId(userVacationVO.getReasonId());
        taskInfoQuery.setTaskResId(userVacationVO.getUserId());
        taskInfoQuery.setSourceType(TaskSourceTypeEnum.REWARD.getCode());
        taskInfoQuery.setTaskStatus(TaskStatusEnum.PENDING.getCode());
        List<TaskInfoVO> taskInfoVOS = taskInfoService.queryListCommon(taskInfoQuery);
        if (ObjectUtils.isEmpty(taskInfoVOS)) {
            throw TwException.error("", "奖励假对应任务不存在");
        }
        BigDecimal eqvaRatio = taskInfoVOS.get(0).getEqvaRatio();
        if (eqvaRatio == null) {
            eqvaRatio = prdOrgEmployeeEqvaRatioService.getEqvaRatio(userVacationVO.getUserId(), LocalDate.now());
            taskInfoVOS.get(0).setEqvaRatio(eqvaRatio);
        }
        if (eqvaRatio == null) {
            throw TwException.error("", "当量系数不可为空");
        }
        //  taskInfoVOS = taskInfoVOS.stream().filter(vo -> vo.getEffectiveEqva().compareTo(B) > 0).collect(Collectors.toList());
        // 计算总剩余当量
        BigDecimal effectiveEqva = taskInfoVOS.stream()
                .map(TaskInfoVO::getEffectiveEqva)
                .filter(Objects::nonNull)
                .reduce(BigDecimal::add)
                .orElse(BigDecimal.ZERO);
        if (effectiveEqva.compareTo(payload.getVacationDays().multiply(eqvaRatio)) < 0) {
            throw TwException.error("", "奖励假对应任务可用当量不足,剩余：" + effectiveEqva);
        }
    }

    public List<UserRecentVacationApplyVO> getLastThreeMonthApplyDetailVOList(Long userId, LocalDate applyDate) {
        UserVacationApplyQuery userVacationApplyQuery = new UserVacationApplyQuery();
        userVacationApplyQuery.setUserId(userId);
        userVacationApplyQuery.setVdateStart(String.valueOf(applyDate.minusMonths(3)));
        return userVacationApplyDetailDAO.getRecentVacation(userVacationApplyQuery);
    }


    // 判断工时之前的哺乳假和本次提交的事假是否有重复 如果有就将之前的哺乳假删除删除
    private void dealBreastfeedTimesheet(List<TimesheetVO> timesheetVOList, List<UserVacationApplyVO> userVacationApplyDetailVOS, UserVacationApplyPayload payload) {
        // 现获取所有哺乳假的请假明细
        List<UserVacationApplyVO> breastfeedVOS = userVacationApplyDetailVOS.stream().filter(p -> VacationTypeEnum.BREASTFEED.getCode().equals(p.getVacationType())).collect(Collectors.toList());
        List<Long> vacationDetailIds = new ArrayList<>();
        final Map<LocalDate, List<UserVacationApplyVO>> breastfeedMap = breastfeedVOS.stream().collect(Collectors.groupingBy(UserVacationApplyVO::getDetailVDate));
        payload.getApplyDetailPayloadList().stream().forEach(p -> {
            if (breastfeedMap.containsKey(p.getVDate())) {
                //判断当天是否为一天的请假申请
                if (p.getVDays().compareTo(new BigDecimal(1)) == 0) {
                    List<Long> collect = breastfeedMap.get(p.getVDate()).stream().map(UserVacationApplyVO::getId).collect(Collectors.toList());
                    vacationDetailIds.addAll(collect);
                }
                //判断是否是上下午重复
                else if (UserVacationIntervalEnum.AM.getCode().equals(p.getVInterval())) {
                    List<Long> collect = breastfeedMap.get(p.getVDate()).stream().filter(vo -> UserVacationIntervalEnum.AM.getCode().equals(vo.getDetailInterval())).map(UserVacationApplyVO::getId).collect(Collectors.toList());
                    vacationDetailIds.addAll(collect);
                } else if (UserVacationIntervalEnum.PM.getCode().equals(p.getVInterval())) {
                    List<Long> collect = breastfeedMap.get(p.getVDate()).stream().filter(vo -> UserVacationIntervalEnum.PM.getCode().equals(vo.getDetailInterval())).map(UserVacationApplyVO::getId).collect(Collectors.toList());
                    vacationDetailIds.addAll(collect);
                }
            }
        });
        // 删除对应的工时
        if (!CollectionUtils.isEmpty(vacationDetailIds)) {
            timesheetService.deleteVacationPrivateTimesheet(vacationDetailIds);
        }
    }
}
